/*
 * basic_wifi_application.c
 * 
 * Copyright (C) 2011 Texas Instruments Incorporated - http://www.ti.com/
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * 
 * Neither the name of the project's author nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#include "r_cg_macrodriver.h"
#include "r_cg_it.h"
#include "r_cg_port.h"
#include "r_cg_userdefine.h"

#define INTERVAL_TIMER_DURATION_MS         50
#define SYS_TICK_DURATION_MS		   500
#define SYS_TICK_IN_INTERVAL_TIMER         (SYS_TICK_DURATION_MS/INTERVAL_TIMER_DURATION_MS)
volatile uint16_t usSysTickCount = 0;
volatile uint16_t usIntervalTimerCount =0;
extern long hci_unsolicited_event_handler(void);

/*
**-----------------------------------------------------------------------------
**
**  Abstract:
**	This function is INTIT interrupt service routine.
**
**  Parameters:
**	None
**
**  Returns:
**	None
**
**-----------------------------------------------------------------------------
*/
#pragma vector = INTIT_vect
__interrupt void MD_INTIT(void)
{
	/* Start user code. Do not edit comment generated here */
	ITIF = 0U;	/* clear INTIT interrupt flag */
	usIntervalTimerCount++;
	if (usIntervalTimerCount >= SYS_TICK_IN_INTERVAL_TIMER)
	{
		LED03 ^= 1;		
		usIntervalTimerCount = 0;
		usSysTickCount++;
		hci_unsolicited_event_handler();	
                
	}
        
}
/*
**-----------------------------------------------------------------------------
**
**  Abstract:
**	This function provides a delay in miliseconds.
**
**  Parameters:
**	ulDealy: Delay in miliseconds
**
**  Returns:
**	None
**
**-----------------------------------------------------------------------------
*/
void CG_IT_UserDelayMs(uint16_t ulDelay)
{
	usSysTickCount =0;	
	uint16_t usLocalDelay = ulDelay/INTERVAL_TIMER_DURATION_MS;
      while( usSysTickCount <= usLocalDelay)
      {
              NOP();
      }
}
