/*
 * CG_port_user.c
 * 
 * Copyright (C) 2011 Texas Instruments Incorporated - http://www.ti.com/
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * 
 * Neither the name of the project's author nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/*
*******************************************************************************
** Include files
*******************************************************************************
*/
#include "r_cg_macrodriver.h"
#include "r_cg_port.h"
#include "r_cg_userdefine.h"

/*
**-----------------------------------------------------------------------------
**
**  Abstract:
**	This function reinitializes the spi interface. Ensuring that the IRQ pin 
**  is set to TTL and CS is Open Drain
**  Parameters:
**	None
**
**  Returns:
**	None
**
**-----------------------------------------------------------------------------
*/
void PORT_UserInit(void)
{
	/* Start user code. Do not edit comment generated here */
	/* Increase the priority of SPI over GPIO */
	/* Set IRQ on p16 for input to TTL*/
        PIM1 = _40_PIMn6_TTL_ON;
	/* IRQ pin is TTL input */	
        PIM1 = _40_PIMn6_TTL_ON;
	/* Set Chip Select (CS, P15) as open-drain output */	
	PU3 = _01_POMn0_NCH_ON;
	SPI_CS_PIN = TRUE;
	SPI_EN_PIN = FALSE;	
}
/*
**-----------------------------------------------------------------------------
**
**  Abstract:
**	This function toggles the state of LED2
**
**  Parameters:
**	ucTrueFalse: True to turn LED on and False to turn it off.
**
**  Returns:
**	None
**
**-----------------------------------------------------------------------------
*/
void CG_PortLedOn(uint8_t ucTrueFalse)
{
	if( ucTrueFalse)
	{
		LED02 = LEDON;
	}
	else
	{
		LED02 = LEDOFF;
	}
}

/*
**-----------------------------------------------------------------------------
**
**  Abstract:
**	This function toggles the state of LED2
**
**  Parameters:
**	None
**
**  Returns:
**	None
**
**-----------------------------------------------------------------------------
*/
void CG_PortLedToggle(void)
{
	LED02 ^= LEDOFF;
}
