/*
 * basic_wifi_application.c
 * 
 * Copyright (C) 2011 Texas Instruments Incorporated - http://www.ti.com/
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * 
 * Neither the name of the project's author nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef BASIC_WIFI_USER_DEF_
#define BASIC_WIFI_USER_DEF_

/* --------------------------------------------------------------------------*/
/* Logical Values                                                            */
/* --------------------------------------------------------------------------*/
#define TRUE  1u
#define FALSE 0u

/* --------------------------------------------------------------------------*/
/* Special Function Register Access                                          */
/* --------------------------------------------------------------------------*/
#define ClrIORBit(Reg, ClrBitMap) ((Reg) &= ~(ClrBitMap))
#define SetIORBit(Reg, SetBitMap) ((Reg) |=  (SetBitMap))

/* --------------------------------------------------------------------------*/
/* LEDs                                                                      */
/* --------------------------------------------------------------------------*/
#define LED02   P1_bit.no0
#define LED03   P1_bit.no1

#define WLANCONNECTED      P6_bit.no1
#define WLANDISCONNECTED   P6_bit.no0


#define CLIENTCONNECTED      P6_bit.no3
#define CLIENTDISCONNECTED   P6_bit.no2

#define LEDON   FALSE
#define LEDOFF  TRUE

/* --------------------------------------------------------------------------*/
/* SPI PORT                                                                   */
/* --------------------------------------------------------------------------*/
#define SPI_CLK_PIN    P7_bit.no0
#define SPI_MISO_PIN   P7_bit.no1
#define SPI_MOSI_PIN   P7_bit.no2
#define SPI_CS_PIN     P3_bit.no0

#define SPI_IRQ_PIN    P1_bit.no6
#define SPI_EN_PIN     P7_bit.no4

#define SPI_FLAG_TIMEOUT         ((uint32_t)0x1000)
#define SPI_LONG_TIMEOUT         ((uint32_t)(10 * SPI_FLAG_TIMEOUT)) 

#define HI(value)               (((value) & 0xFF00) >> 8)
#define LO(value)               ((value) & 0x00FF) 

#define FWT_DELAY               4000
/*It takes roughly 4 instruction to perform a delay*/
#define FIFTY_US_DELAY			((32*50)/15) // for 25 MHz clk  //changed to 32 
#define READ                    3
#define WRITE                   1

#define HEADERS_SIZE_EVNT       (SPI_HEADER_SIZE + 5)
#define SPI_TX_BUFFER_SIZE        4096 //1700 //1024u 
#define SPI_RX_BUFFER_SIZE        4096 //512 //512u

void CG_PortLedOn(uint8_t ucTrueFalse);
void PORT_UserInit(void);


#endif
