#include "r_cg_macrodriver.h"
#include "r_cg_cgc.h"
#include "r_cg_port.h"
#include "r_cg_intc.h"
#include "r_cg_serial.h"
#include "r_cg_it.h"

#include "r_cg_userdefine.h"
#include "r_cg_spi_user.h"

#include "wlan.h" 
#include "evnt_handler.h"    
#include "nvmem.h"
#include "socket.h"
#include "cc3000_common.h"
#include "netapp.h"
#include "spi.h"

#include "cc3000_api.h"
#include "string.h"
#include "httpserver.h"
#include "strlib.h"

extern void delayMilliSeconds(unsigned long delay);

/** \brief Socket used by server to listen and accept connections */
long httpServerSocket;
/** \brief Variable holding the server's port */
int port = 0;
/** \brief Pointer to the index HTML page */
//char * indexPage;
char indexPage[];
unsigned char dataPacket[5];
/** \brief Pointer to Dynamic HTML handler structure */
dyn_html_handler * htmlList;
/** \brief Pointer to Dynamic HTML handler structure */
http_server_event_handler * eventHandlers = NULL;
/** \brief Page view counter */
int viewCounter = 1;

const char index[] = "<html><head><meta content=\"text/html; charset=ISO-8859-1\" http-equiv=\"content-type\"><title>TESTBOARD</title></head><body><span style=\"font-weight: bold;\"></span><form><div style=\"text-align: center;\"><span style=\"font-weight: bold;\">HELLO FROM RL78 TESTBOARD VIEWS:%d  </span></form></body></html>";

//*****************************************************************************
//Initializes HTTP Server
//*****************************************************************************
char initHTTPServer() //, char * ipage)
{
    char result = -1;
    sockaddr serverSocketAddr;
    port = 80;
     
    eventHandlers->serverInitHandlerFunc = NULL;
    eventHandlers->clientAcceptedHandlerFunc = NULL;
    eventHandlers->httpRequestDoneHandlerFunc = NULL;
    
    httpServerSocket = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
 
    if (httpServerSocket == -1)
    {
         delayMilliSeconds(500);    
         httpServerSocket = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
         if (httpServerSocket == -1) { result = 1 ;}
    }
    else
    { 
        result = 0;
    }
    
    serverSocketAddr.sa_family = AF_INET;
    
    // Set the Port Number
    serverSocketAddr.sa_data[0] = (port & 0xFF00)>> 8;
    serverSocketAddr.sa_data[1] = (port & 0x00FF);
    
    memset(&serverSocketAddr.sa_data[2], 0, 4);
    
    bind(httpServerSocket, &serverSocketAddr, sizeof(sockaddr)) != 0;
    
    eventHandlers->serverInitHandlerFunc = NULL;
	
    hci_unsolicited_event_handler();

    return result;
}

//*****************************************************************************
// HTTP Server main
//*****************************************************************************
void serverMain()
{
    sockaddr clientaddr;  
    socklen_t addrlen;  
    
    int currentClient;
      
    if ( listen (httpServerSocket, MAX_CLIENTS) != 0 )
    {  
        __no_operation();
    }

    hci_unsolicited_event_handler();  // events
    
    while(1)
    {
        addrlen = sizeof(clientaddr);    
        
        CLIENTCONNECTED = LEDOFF;
        CLIENTDISCONNECTED = LEDON; 
        
        // accept blocks until we receive a connection
        currentClient = accept(httpServerSocket, (sockaddr *) &clientaddr, &addrlen);
       
        if(currentClient >= 0)
        {
            CLIENTCONNECTED = LEDOFF;
            CLIENTDISCONNECTED = LEDOFF;
            handleHTTPRequest(currentClient);
            closesocket(currentClient);
            delayMilliSeconds(1);
        }
        else if (currentClient == -57) 
        {
            // BUG: Socket inactive so reopen socket Inactive Socket, close and reopen it
            closesocket(httpServerSocket);
            httpServerSocket = 0xFFFFFFFF;               
            initHTTPServer();
            // Start Listening again
            if (listen (httpServerSocket, MAX_CLIENTS) != 0 )
            {  
                __no_operation();
            }
        }
        delayMilliSeconds(10);
        hci_unsolicited_event_handler();  // events       
        LED03 ^= 1;	
    }
}

//*****************************************************************************
void handleHTTPRequest(int cnum)
{
    int i = 0;
//    char requestBuffer[900];
//    char * reqline[3];
//    memset(requestBuffer,0,900);
//    int bytesRecvd;
//    bytesRecvd = recv(cnum, requestBuffer, sizeof(requestBuffer), 0);   //    <- I GET STUCK IN THIS RECV FUNCTION ? ? ? 
    
//    if(bytesRecvd > 0) 
//    {
//        // Received some data, check it and send data back
//        reqline[0] = strstr (requestBuffer, "GET");
//    }
   
 //   sprintf(indexPage,index, bytesRecvd);   
    
    sprintf(indexPage,index, viewCounter++); 

    sendHTTPData(cnum, HTTP_RESP, strlen(HTTP_RESP));   
    
    delayMilliSeconds(5);
    
    for(i = 0; i < strlen(indexPage); i += 300)   // "Send the specificied page in chunks of 300 bytes empirically proven to be sendable"       
    {
        if(strlen(indexPage) - i < 300)
        {
            sendHTTPData(cnum, &indexPage[i], strlen(indexPage)); // - i);
        }
        else
       {
            sendHTTPData(cnum, &indexPage[i], 300);
        } 
        
        delayMilliSeconds(5);  // "This delay is necessary, or else we run into issues"
        
        CLIENTCONNECTED = LEDON;
        CLIENTDISCONNECTED = LEDOFF;
    }  
}

//*****************************************************************************
void sendHTTPData(long sdesc, const void *buf, long len)
{
    int bytesSent = 0;
    bytesSent = send(sdesc, buf, len,0);
    
    if(bytesSent == -1)
    {
        // General Send Error
    }
    if (bytesSent != strlen(indexPage))
    {
        // ERROR: not all bytes sent
    }
}

//*****************************************************************************
//
//! \brief  Initializes HTTP Server Event Handler
//!
//! \param eh is a pointer to the array handling server events
//!
//! \return none
//!
//
//*****************************************************************************
void initEventHandlers(http_server_event_handler * eh)
{
	eventHandlers = eh;
}