/*****************************************************************************
*
*  httpserver.h - General HTTP Server definitions
*  Copyright (C) 2011 Texas Instruments Incorporated - http://www.ti.com/
*
*  Redistribution and use in source and binary forms, with or without
*  modification, are permitted provided that the following conditions
*  are met:
*
*    Redistributions of source code must retain the above copyright
*    notice, this list of conditions and the following disclaimer.
*
*    Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in the
*    documentation and/or other materials provided with the   
*    distribution.
*
*    Neither the name of Texas Instruments Incorporated nor the names of
*    its contributors may be used to endorse or promote products derived
*    from this software without specific prior written permission.
*
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
*  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
*****************************************************************************/
#define MAX_DYN_HTML_PARAMS 16
#define MAX_DYN_HTML_PARAM_SIZE 10
#define ROOT "/"

#define MAX_CLIENTS 1  // We currently only support 1 client

#define HTTP_RESP "HTTP/1.0 200 OK\n\n"

#define HTTP_DYN_HTML_ENABLED

#define MAX_REPLACE_CHAR 16

typedef struct
{
     char dynHtmlParamName[MAX_DYN_HTML_PARAMS][MAX_DYN_HTML_PARAM_SIZE];
     void (*dynHtmlFunc[16])(char *);
} dyn_html_handler;
// HTTP Server Related

/**
 *	A structure representing pointers to functions handling
 *  server events.
 *
 */
typedef struct
{
    // Array of functions that will handle server events
    void (*serverInitHandlerFunc)(char *);            /** Handler for Server Initialization Done */
    void (*clientAcceptedHandlerFunc)(char *);        /** Handler for Client Accepted */
    void (*httpRequestDoneHandlerFunc)(char *);       /** Handler for HTTP Request Done */
        
} http_server_event_handler;

char initHTTPServer();   //  int port, char * ipage);
void handleHTTPRequest(int cnum);
void serverMain();
//void pageReplace(char * page, char * ind, char * val);
void sendHTTPData(long sdesc, const void *buf, long len);
void initEventHandlers(http_server_event_handler * eh);
