#include "wlan.h" 
#include "r_cg_macrodriver.h"
#include "cc3000_common.h"
#include "socket.h"
#include "netapp.h"

#include "r_cg_userdefine.h"

unsigned long   uiEnable          = 1;
unsigned long   uiMinDwellTime    = 20; 
unsigned long   uiMaxDwellTime    = 30;
unsigned long   uiNumOfProbeResponces  = 2;  
unsigned long   uiChannelMask     = 0x7ff;
long            iRSSIThreshold    = -80;
unsigned long   uiSNRThreshold    = 0;
unsigned long   uiDefaultTxPower  = 205;
unsigned long * aiIntervalList    = 0x00;
long scanresult = 0x1;
long testval = 0x1;

unsigned char * ucResults;

// ssid : guest    grundfosguest08
char ssid[] = {'g', 'u', 'e', 's', 't'};
unsigned char pw[] = {'g', 'r', 'u', 'n', 'd', 'f', 'o', 's', 'g', 'u', 'e', 's', 't', '0', '8'};

// ssid : cisco tbkvxxxx
//char ssid[] = {'c', 'i', 's', 'c', 'o'};
//unsigned char pw[] = {'t', 'b', 'k', 'v', '2', '2', 'x', 'x'};

void wlanConnect(void);
void wlanscan(void);
void goDHCP(void);
Bool wlanstatus(void);

void wlanscan()
{
  testval = wlan_ioctl_set_scan_params(uiEnable,uiMinDwellTime,uiMaxDwellTime,uiNumOfProbeResponces,uiChannelMask,iRSSIThreshold,uiSNRThreshold,uiDefaultTxPower,aiIntervalList);   
  scanresult = wlan_ioctl_get_scan_results(0, ucResults);
}

Bool wlanstatus()
{
   Bool connected = 0;
   
   int status = wlan_ioctl_statusget();  

   if(status != 3)
   {
     WLANCONNECTED     = LEDOFF;
     WLANDISCONNECTED  = LEDON;
     connected = 0;
   }
   else
   {
     WLANCONNECTED     = LEDON;
     WLANDISCONNECTED  = LEDOFF;
     connected = 1;
   }
   
   return connected;
}

void wlanConnect()
{
    int status = wlan_ioctl_statusget();  

    if(status == 0)
    {
      wlan_ioctl_set_connection_policy(0,0,0);	
      long connectresult = wlan_connect(2, (char *)ssid, 5, NULL, (unsigned char *)pw, 15);   //cisco : 8; //guest: 15
      goDHCP();
    }
   
    if(status == 3)
    {
      goDHCP();
    }
} 

/* @brief  converts and decimal to char. */
uint16_t atoc(unsigned char data)
{
	unsigned char ucRes;
	if ((data >= 0x30) && (data <= 0x39))
	{
		ucRes = data - 0x30;
	}
	else
	{
		if (data == 'a')
		{
			ucRes = 0x0a;;
		}
		else if (data == 'b')
		{
			ucRes = 0x0b;
		}
		else if (data == 'c')
		{
			ucRes = 0x0c;
		}
		else if (data == 'd')
		{
			ucRes = 0x0d;
		}
		else if (data == 'e')
		{
			ucRes = 0x0e;
		}
		else if (data == 'f')
		{
			ucRes = 0x0f;
		}
	}
	return ucRes;
}

/* converts 2 nibbles into a 16-bit number
  * @param  char1
  * @param  char2
  * @retval number*/
uint16_t atoshort(uint8_t b1, uint8_t b2)
{
	uint16_t usRes;
	usRes = (atoc(b1)) * 16 | atoc(b2);
	return usRes;
}

/* @brief  Converts 2 bytes into an ascii character
  * @param  None
  * @retval None */
unsigned char ascii_to_char(uint8_t b1,uint8_t b2)
{
	unsigned char ucRes;
	ucRes = (atoc(b1)) << 4 | (atoc(b2));
	return ucRes;
}

void goDHCP()
{
  unsigned char pucIP_Addr[4];
  unsigned char pucIP_DefaultGWAddr[4];
  unsigned char pucSubnetMask[4];
  unsigned char pucDNS[4];
    // DHCP is used by default
    // Subnet mask is assumed to be 255.255.255.0
    pucSubnetMask[0] = 0;
    pucSubnetMask[1] = 0;
    pucSubnetMask[2] = 0;
    pucSubnetMask[3] = 0;
    
    // CC3000's IP
    pucIP_Addr[0] = 0;
    pucIP_Addr[1] = 0;
    pucIP_Addr[2] = 0;
    pucIP_Addr[3] = 0;
    
    // Default Gateway/Router IP
    // 192.168.1.1
    pucIP_DefaultGWAddr[0] = 0;
    pucIP_DefaultGWAddr[1] = 0;
    pucIP_DefaultGWAddr[2] = 0;
    pucIP_DefaultGWAddr[3] = 0;
    
    // We assume the router is also a DNS server
    pucDNS[0] = 0;
    pucDNS[1] = 0;
    pucDNS[2] = 0;
    pucDNS[3] = 0;
    
    // Force DHCP
    netapp_dhcp((unsigned long *)pucIP_Addr, (unsigned long *)pucSubnetMask, (unsigned long *)pucIP_DefaultGWAddr, (unsigned long *)pucDNS);
    
}
    
    

inline void SysCtlDelay(unsigned long Delay)
{
	/* Decrement nCount value */
  unsigned long ulDelay = Delay;	
  while (ulDelay != 0)
  {
    ulDelay--;
  } 
}


void delayMilliSeconds(unsigned long delay)
{
	
        delay = delay * 10;
        
	while (delay != 0 )
	{
		SysCtlDelay(FIFTY_US_DELAY);
		SysCtlDelay(FIFTY_US_DELAY);
		delay--;
	}
        
}