#include "r_cg_macrodriver.h"
#include "r_cg_cgc.h"
#include "r_cg_port.h"
#include "r_cg_intc.h"
#include "r_cg_serial.h"
#include "r_cg_it.h"

#include "r_cg_userdefine.h"
#include "r_cg_spi_user.h"

#include "wlan.h" 
#include "evnt_handler.h"    
#include "nvmem.h"
#include "socket.h"
#include "cc3000_common.h"
#include "netapp.h"
#include "spi.h"

#include "cc3000_api.h"

#include "httpserver.h"

/***********************************************************************************************************************
Global variables and functions
***********************************************************************************************************************/
/* Set option bytes */
#pragma location = "OPTBYTE"
__root const uint8_t opbyte0 = 0x6E;
#pragma location = "OPTBYTE"
__root const uint8_t opbyte1 = 0x7FU;
#pragma location = "OPTBYTE"
__root const uint8_t opbyte2 = 0xE8U;
#pragma location = "OPTBYTE"
__root const uint8_t opbyte3 = 0x84U;

/* Set security ID */
#pragma location = "SECUID" 
__root const unsigned char secuid[10] = {0x00U, 0x00U, 0x00U, 0x00U, 0x00U, 0x00U, 0x00U, 0x00U, 0x00U, 0x00U};

/***********************************************************************************************************************/

extern void wlanConnect(void);
extern void wlanscan(void);
extern Bool wlanstatus(void);
extern void delayMilliSeconds(unsigned long delay);
void systemInit(void);
void CC3000_UsynchCallback(long lEventType, char * data, unsigned char length);
tNetappIpconfigRetArgs ipconfig_info;

/*This function enables or disables CC3000*/
void WriteWlanPin( uint8_t val )
{
        if( val)
        {
               SPI_EN_PIN = TRUE;
        }
        else
        {
               SPI_EN_PIN = FALSE;
        }
}

void SmartConfigLedOn(uint8_t ulTrueFalse)
{
	if(ulTrueFalse)
	{
		CG_PortLedOn(TRUE);	  
	}
	else
	{
		CG_PortLedOn(FALSE);
	}
}

/*  @brief  This function handles asynchronous events that come from CC3000 device and operates to indicate exchange of data
  * @param  The type of event we just received. */
void CC3000_UsynchCallback(long lEventType, char * data, unsigned char length)
{
	//if (lEventType == HCI_EVNT_WLAN_ASYNC_SIMPLE_CONFIG_DONE)
	//{
		//ulSmartConfigFinished = 1;
	//}

	if (lEventType == HCI_EVNT_WLAN_UNSOL_CONNECT)
	{
		//CC3000 Connected
		SmartConfigLedOn(TRUE);
	}

	if (lEventType == HCI_EVNT_WLAN_UNSOL_DISCONNECT)
	{		
		//CC3000 Connected
		SmartConfigLedOn(FALSE);
	}
}

void systemInit(void)
{
        PORT_UserInit();        
	R_IT_Start();  
        R_CSI21_Start();
        R_INTC5_Start();   
        
        WLANCONNECTED = LEDOFF;  
        WLANDISCONNECTED = LEDON; 
        
        CLIENTDISCONNECTED = LEDOFF;  
        CLIENTCONNECTED = LEDOFF;  
        
        wlan_init((tWlanCB)CC3000_UsynchCallback, NULL, NULL, NULL, ReadWlanInterruptPin, WlanInterruptEnable, WlanInterruptDisable, WriteWlanPin);
	wlan_start(0);       
        wlan_set_event_mask(HCI_EVNT_WLAN_KEEPALIVE|HCI_EVNT_WLAN_UNSOL_INIT|HCI_EVNT_WLAN_UNSOL_DHCP|HCI_EVNT_WLAN_ASYNC_PING_REPORT);        
}

void main(void)
{       
        systemInit();              
        while (TRUE)
        {			
            if(wlanstatus())              
            {   
                R_IT_Stop();
                
                if(!initHTTPServer())
                {                   
                    serverMain(); 
                }                
            } 
            else            
            { 
                wlanConnect();                        
                delayMilliSeconds(2000);
                netapp_ipconfig(&ipconfig_info);        
            }      
            delayMilliSeconds(500);          
        }            
}
