/* START FILE DESCRIPTION *********************************************
(c)TinyLCD, 2012

This File contains higher level functions for 8051 based LCD_DEMO Board.

File name : 3_5_TFT_8051.c

Acknowledgement:
			This library contains code written for TINY LCD by:-
               
			   Nishant Singh.
			   Nilesh Tekale.
			   Komal Gavali.
			   Mrutyunjay Patel
			   
               www.tinylcd.com

// THIS SOFTWARE IS PROVIDED "AS IS" AND WITH ALL FAULTS.
// NO WARRANTIES, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT
// NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. Tiny LCD SHALL NOT, UNDER ANY
// CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
// DAMAGES, FOR ANY REASON WHATSOEVER.
// 
END DESCRIPTION *********************************************************/
/*
//   Rev. NO :: 1.0.0      28/08/13   15:44:50   Nishant singh.

*************************************************************************/

//#include<REG51F.H>

#ifdef  SPI_8051
	#include "spi_8051.h"
#else
	#include "bit_bagging_8051.h"
	#include "port_def.h"
#endif


#include "font16x31.h"

                     


#ifdef TFT_VERTICAL
#warning TFT_320_480_INITIALISED
#include "butterfly.h"
#else
#warning TFT_480_320_INITIALISED	
#endif


unsigned short gbHeight;
unsigned short gbWidth;


/*
 * This function will Set the Address on  GRAM of TFT.
 *
 * @param  Starting co-ordinate of  Address x .(unsigned short x)
 * @param  Starting co-ordinate of  Address y .(unsigned short y)
 * @param  End co-ordinate of  Address x .(unsigned short x1)
 * @param  End co-ordinate of  Address y .(unsigned short y1)
 *
 * @return NONE
 *
 */
void address_set(unsigned short postion_x,unsigned short postion_y,unsigned short postion_x1,unsigned short postion_y1)
{
	write_com(0x2A);	      		   //Column address set
	write_dat(postion_x>>8);
	write_dat(postion_x);	  	   //Starting co-ordinate of  x
	write_dat(postion_x1>>8);
	write_dat(postion_x1);	   //End co-ordinate of  x
	
	write_com(0x2B);		  			//Row address set
	write_dat(postion_y>>8);				
	write_dat(postion_y);	  		//Starting co-ordinate of   y
	write_dat(postion_y1>>8);
	write_dat(postion_y1);	  	 //End co-ordinate of  y
	
	write_com(0x2C);	
}


#ifdef TFT_VERTICAL
/*
 * This function will Display the image on  TFT
 *
 * @param  NONE
 *
 * @return NONE
 *
 */
void TFT_Putphoto(void)
{
	const unsigned char *img_byte;
	unsigned long img_size;

   address_set(100,310, 219,389);

   	RS_SET();
   	//TFT_RS = 1;
#ifdef SPI_BIT_BANG
   	CLK_SET();
#endif
	//TFT_SCK = 1;
	img_byte = gImage_butterfly;
	img_size =  0x4B00;		//19200bytes
	while(img_size--)
	{
		write_dat(*img_byte);
		img_byte++;
	}
}

#endif

/*
 * This function will initialize TFT
 *
 * @param  NONE
 *
 * @return NONE
 *
 */
void TFT_init(void)
{
 
	CS_CLR();
	//TFT_CS = 0;
	RST_SET();
	//TFT_RST=1;
	delay_ms(100);
	RST_CLR();
	//TFT_RST=0;
    delay_ms(150);
    RST_SET();
    //TFT_RST=1;
    delay_ms(200);

/************* Start Initial Sequence **********/ 
	write_com(0xB0); 
    write_dat(0x80); //serial DOUT enable control

    write_com(0xC0); 
    write_dat(0x0A);    // P-Gamma level 
    write_dat(0x0A);    // N-Gamma level 
     
    write_com(0xC1);      // BT & VC Setting 
    write_dat(0x45);   
    write_dat(0x07);    // VCI1 = 2.5V 
     
    write_com(0xC2);    // DC1.DC0 Setting 
    write_dat(0x33);      
    
    write_com(0xC5); 
    write_dat(0x00); 
    write_dat(0x42);     // VCM Setting VCOM voltage level for reduce the flicker issue
    write_dat(0x80);     // VCM Register Enable 
     
    write_com(0xB1); 
    write_dat(0xD0);     // Frame Rate Setting 
    write_dat(0x11); 
     
    write_com(0xB4); 
    write_dat(0x02);     // 00: Column inversion; 02: Dot2 inversion 
    
    write_com(0xB6);      // RM.DM Setting 
    write_dat(0x00);
#ifdef TFT_VERTICAL 
	write_dat(0x22);
#else
	write_dat(0x02);  
#endif

    write_dat(0x3B); 
     
    write_com(0xB7);      // Entry Mode 
    write_dat(0x07); 

    write_com(0x36);     // Color filter setting 
#ifdef TFT_VERTICAL
	write_dat(0x09);
#else
	write_dat(0x2B); //row/column exchange
#endif

     
    write_com(0xF0);      // Enter ENG , must be set before gamma setting 
    write_dat(0x36); 
    write_dat(0xA5); 
    write_dat(0xD3); 
    
    write_com(0xE5);      // Open gamma function , must be set before gamma setting 
    write_dat(0x80); 
    
    write_com(0xE5);  
    write_dat(0x01); 
    
    write_com(0xB3);  
    write_dat(0x00);     
     
    write_com(0xE5);  
    write_dat(0x00);     
     
    write_com(0xF0);     // Exit ENG , must be set before gamma setting 
    write_dat(0x36); 
    write_dat(0xA5); 
    write_dat(0x53); 
    
    write_com(0xE0);      // Gamma setting 
    write_dat(0x00); 
    write_dat(0x35); 
    write_dat(0x33); 
    write_dat(0x00); 
    write_dat(0x00); 
    write_dat(0x00); 
    write_dat(0x00); 
    write_dat(0x35); 
    write_dat(0x33); 
    write_dat(0x00); 
    write_dat(0x00); 
    write_dat(0x00); 
    
    write_com(0x3A);     // interface setting 
    write_dat(0x55); 
     
    write_com(0x11);    // Exit sleep mode 
    delay_ms(250);
    write_com(0x29);     // Display on
}

/*
 * This function will Drow the circle on  TFT .
 *
 * @param  center of circle co-ordinate of Rectangle x .(unsigned short x)
 * @param  center of circle co-ordinate of Rectangle y .(unsigned short y)
 * @param  radius (rad)
 * @param  color   (color)
 * @param  Background color.(unsigned short b_color)
 *
 * @return NONE
 *
 */
void TFT_circle(unsigned short postion_x,unsigned short postion_y,unsigned char rad ,unsigned short color,unsigned short b_clr)  
{
   unsigned short i,j;

   address_set(postion_x-rad, postion_y-rad, postion_x+rad, postion_y+rad);

   for(i= postion_x-rad;i<=(postion_x+rad);i++)
	{
		for(j =postion_y-rad;j<=(postion_y+rad);j++)
		{
			if((((unsigned short)(i-postion_x)*(i-postion_x))+(unsigned short)((j-postion_y)*(j-postion_y))) < (unsigned short)(rad*rad))
			{
				write_dat(color>>8);
				write_dat(color);
			}
			else
			{
				write_dat(b_clr>>8);
				write_dat(b_clr);
			}
		}
	} 
}

/*
 * This function will clear the Display .
 *
 * @param  Background color.(unsigned short color)
 *
 * @return NONE
 *
 */
void TFT_Clear_Screen(unsigned short color)
{
	unsigned short i,j;
	#ifdef TFT_VERTICAL									   //for Vertical Mode
			address_set(0,0,320,480);					   //Set area on GRAM
	#else												   //for Horizontal Mode
			address_set(0,0,480,320);						//Set area on GRAM
	#endif

 	for (i=0;i<320;i++)
    	for (j=0;j<480;j++)
		{
        	write_dat(color>>8);
			write_dat(color);
		}
}

/*
 * This function will Drow the Rectangle on  TFT .
 *
 * @param  Starting co-ordinate of Rectangle x .(unsigned short postion_x)
 * @param  Starting co-ordinate of Rectangle y .(unsigned short postion_y)
 * @param  Background color.(unsigned short color)
 *
 * @return NONE
 *
 */
void TFT_Rectangle( unsigned short postion_x, unsigned short postion_y, unsigned short color) 
{
	unsigned short i,j;

#ifdef TFT_VERTICAL
	i = 320/4;
	j = 480/4;
#else
	j = 320/4;
	i = 480/4;
#endif

    address_set(postion_x, postion_y, postion_x+i-1, postion_y+j-1);   

	for(postion_x=0;postion_x<j; postion_x++)
	{
		for(postion_y=0;postion_y<i;postion_y++)
		{
		  write_dat(color>>8);
		  write_dat(color);
		}
	} 
}

/*
 * This function will Write the one char on  TFT .
 *
 * @param  Starting address of string  (char Data_WR) 
 * @param  Starting co-ordinate of string  x .(unsigned short x)
 * @param  Starting co-ordinate of string  y .(unsigned short y)
 * @param  Color of fount.  (unsigned short color)
 * @param  Background color.(unsigned short b_clr)
 *
 * @return NONE
 *
 */
void TFT_PutChar(char Data_WR, unsigned short x, unsigned short y, unsigned short color,unsigned short b_clr)
{
	unsigned short i,j,k,l;
	unsigned short c;

	k = ((gbWidth*gbHeight)/8);//number of bytes per charater
	l = k*Data_WR;//byte location of character


	address_set( x, y, x+gbWidth-1, y+gbHeight-1);

	for(j=0; j<k; j++)
	{
		c=(Font16x31[l+j]);

		for(i=0; i<8; i++)
       		{
                if((c & 0x80)==0x80)
                {
                	write_dat(color>>8);
					write_dat(color);
                }
                else
                {
                 	write_dat(b_clr>>8);
					write_dat(b_clr);
                }
				c<<=1;
         	}
	}
}

/*
 * This function will Display the string on  TFT .
 *
 * @param  Starting address of string  (char *s) 
 * @param  Starting co-ordinate of string  x .(unsigned short x)
 * @param  Starting co-ordinate of string  y .(unsigned short y)
 * @param  Color of fount.  (unsigned short color)
 * @param  Background color.(unsigned short b_clr)
 *
 * @return NONE
 *
 */
void TFT_PutString(char *s, unsigned short x, unsigned short y, unsigned short color,unsigned short b_clr)
{
	while(*s)
  	{
	#ifdef TFT_VERTICAL
		if(x >=(319))
	#else
		if(x >=(479))
	#endif
		{
			x=5;
			y += (gbHeight+5);
		#ifdef TFT_VERTICAL
			if(y>=(479))
		#else
			if(y>=(319))
		#endif
			{
				y=5;
			}
		}

   		TFT_PutChar((*s), x, y, color, b_clr);
		x += gbWidth; 				
   		s++;
  	}
}
