#include "port_def.h"

#ifdef SPI_PERIPHERAL
#include "ssi.h"
#include "hw_memmap.h"
#endif

void delay(uint32_t time)
{
	volatile uint32_t ui32Loop2;
	volatile uint32_t ui32Loop1;

	for(ui32Loop1 = 0; ui32Loop1 < time; ui32Loop1++)
    	for(ui32Loop2 = 0; ui32Loop2 < 2000; ui32Loop2++);

}

void delay_ms(unsigned char ms)
{
	volatile uint32_t ui32Loop2;
	volatile uint32_t ui32Loop1;

	for (ui32Loop1=ms; ui32Loop1; --ui32Loop1)
		for (ui32Loop2=5000; ui32Loop2; --ui32Loop2);
}

/*
 * This function will transfer the data to TFT .
 *
 * @param data to be Transfer
 *
 * @return NONE
 *
 */
void write_dat(unsigned char data_WR)
{
	RS_SET();


#ifdef SPI_PERIPHERAL
    SSIDataPut(SSI0_BASE, data_WR);
    while(SSIBusy(SSI0_BASE));
#endif

#ifdef SPI_BIT_BANG
	CLK_SET();
//========================================
	if(data_WR & 0x80)
	{
		MOSI_SET();
	}
	else
	{
		MOSI_CLR();
	}
	CLK_CLR();
	CLK_SET();
//========================================
	if(data_WR & 0x40)
	{
		MOSI_SET();
	}
	else
	{
		MOSI_CLR();
	}
	CLK_CLR();
	CLK_SET();
//========================================
	if(data_WR & 0x20)
	{
		MOSI_SET();
	}
	else
	{
		MOSI_CLR();
	}
	CLK_CLR();
	CLK_SET();
//========================================
	if(data_WR & 0x10)
	{
		MOSI_SET();
	}
	else
	{
		MOSI_CLR();
	}
	CLK_CLR();
	CLK_SET();
//========================================
	if(data_WR & 0x08)
	{
		MOSI_SET();
	}
	else
	{
		MOSI_CLR();
	}
	CLK_CLR();
	CLK_SET();
//========================================
	if(data_WR & 0x04)
	{
		MOSI_SET();
	}
	else
	{
		MOSI_CLR();
	}
	CLK_CLR();
	CLK_SET();
//========================================
	if(data_WR & 0x02)
	{
		MOSI_SET();
	}
	else
	{
		MOSI_CLR();
	}
	CLK_CLR();
	CLK_SET();
//========================================
	if(data_WR & 0x01)
	{
		MOSI_SET();
	}
	else
	{
		MOSI_CLR();
	}
	CLK_CLR();
	CLK_SET();
#endif

}

/*
 * This function will transfer the command to TFT .
 *
 * @param data to be Transfer
 *
 * @return NONE
 *
 */
void write_com(unsigned char com_WR)
{
	RS_CLR();


#ifdef SPI_PERIPHERAL
    SSIDataPut(SSI0_BASE, com_WR);
    while(SSIBusy(SSI0_BASE));
#endif

#ifdef SPI_BIT_BANG
	CLK_SET();
//========================================
	if(com_WR & 0x80)
	{
		MOSI_SET();
	}
	else
	{
		MOSI_CLR();
	}
	CLK_CLR();
	CLK_SET();
//========================================
	if(com_WR & 0x40)
	{
		MOSI_SET();
	}
	else
	{
		MOSI_CLR();
	}
	CLK_CLR();
	CLK_SET();
//========================================
	if(com_WR & 0x20)
	{
		MOSI_SET();
	}
	else
	{
		MOSI_CLR();
	}
	CLK_CLR();
	CLK_SET();
//========================================
	if(com_WR & 0x10)
	{
		MOSI_SET();
	}
	else
	{
		MOSI_CLR();
	}
	CLK_CLR();
	CLK_SET();
//========================================
	if(com_WR & 0x08)
	{
		MOSI_SET();
	}
	else
	{
		MOSI_CLR();
	}
	CLK_CLR();
	CLK_SET();
//========================================
	if(com_WR & 0x04)
	{
		MOSI_SET();
	}
	else
	{
		MOSI_CLR();
	}
	CLK_CLR();
	CLK_SET();
//========================================
	if(com_WR & 0x02)
	{
		MOSI_SET();
	}
	else
	{
		MOSI_CLR();
	}
	CLK_CLR();
	CLK_SET();
//========================================
	if(com_WR & 0x01)
	{
		MOSI_SET();
	}
	else
	{
		MOSI_CLR();
	}
	CLK_CLR();
	CLK_SET();
#endif
}
