//*****************************************************************************
//
// blinky.c - Simple example to blink the on-board LED.
//
// Copyright (c) 2012-2013 Texas Instruments Incorporated.  All rights reserved.
// Software License Agreement
// 
// Texas Instruments (TI) is supplying this software for use solely and
// exclusively on TI's microcontroller products. The software is owned by
// TI and/or its suppliers, and is protected under applicable copyright
// laws. You may not combine this software with "viral" open-source
// software in order to form a larger program.
// 
// THIS SOFTWARE IS PROVIDED "AS IS" AND WITH ALL FAULTS.
// NO WARRANTIES, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT
// NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. TI SHALL NOT, UNDER ANY
// CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
// DAMAGES, FOR ANY REASON WHATSOEVER.
// 
// This is part of revision 2.0.1.11577 of the EK-TM4C123GXL Firmware Package.
//
//*****************************************************************************
#include "port_def.h"
#include "bit_bagging_8051.h"

#ifdef SPI_BIT_BANG
#include "hw_types.h"
#include "hw_gpio.h"
#include "hw_memmap.h"
#endif

#ifdef SPI_PERIPHERAL
#define TARGET_IS_BLIZZARD_RA1
#include <stdbool.h>
#include <stdint.h>
#include "rom.h"
#include "hw_memmap.h"
#include "hw_gpio.h"
#include "gpio.h"
#include "pin_map.h"
#include "ssi.h"
#include "sysctl.h"
#endif

//*****************************************************************************
//
//! \addtogroup example_list
//! <h1>Blinky (blinky)</h1>
//!
//! A very simple example that blinks the on-board LED using direct register
//! access.
//
//*****************************************************************************

//*****************************************************************************
//
// Blink the on-board LED.
//
//*****************************************************************************
int
main(void)
{
    volatile uint32_t ui32Loop;

#ifdef SPI_PERIPHERAL
    ROM_SysCtlClockSet(SYSCTL_SYSDIV_1 | SYSCTL_USE_OSC | SYSCTL_OSC_MAIN | SYSCTL_XTAL_16MHZ);
#endif

    for(ui32Loop=0; ui32Loop<=500000; ui32Loop++);


#ifdef SPI_BIT_BANG
    //
    // Enable the GPIO port that is used for the on-board LED.
    //
    SYSCTL_RCGC2_R = SYSCTL_RCGC2_GPIOF;

    //
    // Do a dummy read to insert a few cycles after enabling the peripheral.
    //
    ui32Loop = SYSCTL_RCGC2_R;

    //
    // Unlock PF0 so we can change it to a GPIO input
    // Once we have enabled (unlocked) the commit register then re-lock it
    // to prevent further changes. PF0 is muxed with NMI thus a special case.
    //
    HWREG(GPIO_PORTF_BASE + GPIO_O_LOCK) = GPIO_LOCK_KEY;
    HWREG(GPIO_PORTF_BASE + GPIO_O_CR) |= 0x1F;
    HWREG(GPIO_PORTF_BASE + GPIO_O_DIR) |= 0x1F;
    HWREG(GPIO_PORTF_BASE + GPIO_O_AFSEL) &= ~0x1F;
    HWREG(GPIO_PORTF_BASE + GPIO_O_DEN) |= 0x1F;
    HWREG(GPIO_PORTF_BASE + GPIO_O_LOCK) = 0;

    //INIT_BIT_BANG_SPI();

//    RST_SET();
//    MOSI_SET();
//    CS_SET();
//    RS_SET();
//    CLK_SET();
//
//    while(1);
#endif

#ifdef SPI_PERIPHERAL
    	ROM_GPIOPinTypeGPIOOutput(GPIO_PORTF_BASE, GPIO_PIN_3 | GPIO_PIN_1);
    	ROM_GPIOPinWrite(GPIO_PORTF_BASE, GPIO_PIN_3 | GPIO_PIN_2 | GPIO_PIN_1, GPIO_PIN_3 | GPIO_PIN_2 | GPIO_PIN_1);

        ROM_SysCtlPeripheralEnable(SYSCTL_PERIPH_SSI0);
        ROM_SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOA);
        ROM_GPIOPinConfigure(GPIO_PA2_SSI0CLK);
        ROM_GPIOPinConfigure(GPIO_PA5_SSI0TX);

        ROM_GPIOPinTypeSSI(GPIO_PORTA_BASE, GPIO_PIN_5 | GPIO_PIN_2);

        ROM_SSIConfigSetExpClk(SSI0_BASE, SysCtlClockGet(), SSI_FRF_MOTO_MODE_3,
                           SSI_MODE_MASTER, 1000000, 8);
#endif

    TFT_init();

    while(1)
	{
 	#ifdef TFT_VERTICAL
	  gbHeight = 31;
	  gbWidth = 16;
	  TFT_Clear_Screen(WHITE);
	  TFT_PutString("     WELCOME       ",5,100, BLACK, BLUE2);
	  TFT_PutString("       TO          ",5,131, BLACK, BLUE2);
	  TFT_PutString("  www.tinylcd.com  ",5,162, RED, BLUE2);
	  TFT_Putphoto();
	  delay(1000);

	  gbHeight = 31;
	  gbWidth = 16;
	  TFT_Clear_Screen(WHITE);
	  TFT_PutString(" Size:",5,25, BLACK, WHITE);
	  TFT_PutString("3.5'' TFT",85,65, RED, WHITE);
	  TFT_PutString(" Pixel:",5,100, BLACK, WHITE);
	  TFT_PutString("320x480 ",85,145, RED, WHITE);
	  TFT_PutString("   www.tinylcd.com",5,205, BLUE, WHITE);
	  TFT_Putphoto();
	  delay(1000);

	  TFT_Clear_Screen(WHITE);
	  TFT_Rectangle(0,0,BLUE);
	  TFT_Rectangle(30,30,RED);
	  TFT_Rectangle(60,60,YELLOW) ;
	  TFT_Rectangle(90,90,MAGENTA);
	  TFT_Rectangle(120,120,ORANGE);
	  TFT_Rectangle(150,150,GREEN);
	  TFT_Rectangle(180,180,CYAN);
	  TFT_Rectangle(210,210,BLUE2);
	  TFT_PutString("  www.tinylcd.com  ",5,430, BLUE, WHITE);
	  delay(1000);

	  TFT_Clear_Screen(WHITE);
	  TFT_circle(160,120,30,BLUE, WHITE);
	  TFT_circle(80,240,30,RED, WHITE);
	  TFT_circle(240,240,30,GREEN, WHITE);
	  TFT_circle(160,360,30,YELLOW, WHITE);
	  TFT_PutString("www.tinylcd.com",30,410, BLUE, WHITE);
	  delay(1000);

	  gbHeight = 31;
	  gbWidth = 16;
	  TFT_Clear_Screen(WHITE);
	  TFT_PutString("A B C D E F G H I J K L M N O P Q R S T U V W X Y Z", 5, 5, BLACK, WHITE);
	  TFT_PutString("a b c d e f g h i j k l m n o p q r s t u v w x y z", 5, 150, BLACK, WHITE);
	  TFT_PutString("0 1 2 3 4 5 6 7 8 9",5,280, BLACK, WHITE);
	  TFT_Putphoto();
	  delay(1000);
	#else
	  gbHeight = 31;
	  gbWidth = 16;
	  TFT_Clear_Screen(WHITE);
	  TFT_PutString("           WELCOME          ",5,90, BLACK, BLUE2);
	  TFT_PutString("             TO             ",5,121, BLACK, BLUE2);
	  TFT_PutString("        www.tinylcd.com     ",5,152, RED, BLUE2);
	  delay(1000);

	  gbHeight = 31;
	  gbWidth = 16;
	  TFT_Clear_Screen(WHITE);
	  TFT_PutString("   Size:",5,25, BLACK, WHITE);
	  TFT_PutString("   3.5'' TFT",115,65, RED, WHITE);
	  TFT_PutString("   Pixels:",5,100, BLACK, WHITE);
	  TFT_PutString("  480x320 ",115,145, RED, WHITE);
	  TFT_PutString("    www.tinylcd.com",55,205, BLUE, WHITE);
	  delay(1000);

	  TFT_Clear_Screen(WHITE);
	  TFT_Rectangle(0,0,BLUE) ;
	  TFT_Rectangle(30,30,RED);
	  TFT_Rectangle(60,60,YELLOW) ;
	  TFT_Rectangle(90,90,MAGENTA);
	  TFT_Rectangle(120,120,ORANGE);
	  TFT_Rectangle(150,150,GREEN);
	  TFT_Rectangle(180,180,CYAN);
	  TFT_Rectangle(210,210,BLUE2);
	  delay(1000);

	  TFT_Clear_Screen(WHITE);
	  TFT_circle(240,80,30,BLUE, WHITE);
	  TFT_circle(120,160,30,RED, WHITE);
	  TFT_circle(360,160,30,GREEN, WHITE);
	  TFT_circle(240,240,30,YELLOW, WHITE);
	  TFT_PutString("www.tinylcd.com",120,280, BLUE, WHITE);
	  delay(1000);

	  gbHeight = 31;
	  gbWidth = 16;
	  TFT_Clear_Screen(WHITE);
	  TFT_PutString("A B C D E F G H I J K L M N O P Q R S T U V W X Y Z", 5, 5, BLACK, WHITE);
	  TFT_PutString("a b c d e f g h i j k l m n o p q r s t u v w x y z", 5, 140, BLACK, WHITE);
	  TFT_PutString("0 1 2 3 4 5 6 7 8 9",5,250, BLACK, WHITE);
	  delay(1000);
	#endif
	TFT_Clear_Screen(WHITE);
	delay(1000);
	TFT_Clear_Screen(BLACK);
	delay(1000);
	TFT_Clear_Screen(BLUE);
	delay(1000);
	TFT_Clear_Screen(RED);
	delay(1000);
	TFT_Clear_Screen(YELLOW);
	delay(1000);
	TFT_Clear_Screen(BLUE2);
	delay(1000);
	TFT_Clear_Screen(CYAN);
	delay(1000);
	TFT_Clear_Screen(GREEN);
	delay(1000);
	TFT_Clear_Screen(ORANGE);
	delay(1000);
	TFT_Clear_Screen(MAGENTA);
	delay(1000);
    }

}
