#include <stdint.h>
#include <stdbool.h>
#include <time.h>
#include "inc/hw_memmap.h"
#include "driverlib/debug.h"
#include "driverlib/fpu.h"
#include "driverlib/gpio.h"
#include "driverlib/hibernate.h"
#include "driverlib/sysctl.h"
#include "driverlib/systick.h"
#include "driverlib/rom.h"
#include "driverlib/uart.h"
#include "grlib/grlib.h"
#include "utils/ustdlib.h"
#include "drivers/cfal96x64x16.h"
#include "drivers/buttons.h"
#include "inc/hw_hibernate.h"
#include "driverlib/pin_map.h"
#include "utils/uartstdio.h"

#define Col(c)                  ((c) * 6)
#define Row(r)                  ((r) * 8)

static volatile char g_pcBuf[40], g_pcBuf2[40];

static volatile uint32_t period;
static volatile uint32_t sMatch,
						 ssMatch;
static volatile bool led;

volatile tContext sContext;
volatile tRectangle sRect;

void HibernateHandler( void )
{
	HibernateIntClear( HIBERNATE_INT_RTC_MATCH_0 );
	ssMatch = (ssMatch + period) % 32768;
	if( ssMatch == 0 )
		++sMatch;
	HibernateRTCSSMatchSet( 0, ssMatch );
	HibernateRTCMatchSet( 0, sMatch );

	if( led )
		GPIOPinWrite( GPIO_PORTG_BASE, GPIO_PIN_2, GPIO_PIN_2 );
	else
		GPIOPinWrite( GPIO_PORTG_BASE, GPIO_PIN_2, 0 );
	led = !led;

}

int main(void)
{
    ROM_SysCtlClockSet(SYSCTL_SYSDIV_2_5 | SYSCTL_USE_PLL | SYSCTL_OSC_INT | SYSCTL_XTAL_16MHZ);

    //
   // Initialize the OLED display
   //
   CFAL96x64x16Init();

   //
   // Initialize the graphics context.
   //
   GrContextInit(&sContext, &g_sCFAL96x64x16);

   //
   // Fill the top 24 rows of the screen with blue to create the banner.
   //
   sRect.i16XMin = 0;
   sRect.i16YMin = 0;
   sRect.i16XMax = GrContextDpyWidthGet(&sContext) - 1;
   sRect.i16YMax = 9;
   GrContextForegroundSet(&sContext, ClrDarkBlue);
   GrRectFill(&sContext, &sRect);

   //
   // Change foreground for white text.
   //
   GrContextForegroundSet(&sContext, ClrWhite);

   //
   // Put the application name in the middle of the banner.
   //
   GrContextFontSet(&sContext, g_psFontFixed6x8);
   GrStringDrawCentered(&sContext, "hibernate", -1,
						GrContextDpyWidthGet(&sContext) / 2, 4, 0);

    SysCtlPeripheralEnable(SYSCTL_PERIPH_HIBERNATE);
    SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOG);
    HibernateEnableExpClk(SysCtlClockGet( ));
    GPIOPinTypeGPIOOutput( GPIO_PORTG_BASE, GPIO_PIN_2 );

    uint32_t Fs = 2;
    period = 32768 / Fs;
    sMatch = 5;
    ssMatch = 0;
    led = true;

    HibernateClockConfig(HIBERNATE_OSC_LOWDRIVE);
    SysCtlDelay( SysCtlClockGet() * 3 );


    HibernateRTCEnable();

    HibernateRTCSet(0);

    HibernateRTCMatchSet(0, sMatch);
    HibernateRTCSSMatchSet(0, ssMatch);

    HibernateIntEnable(HIBERNATE_INT_RTC_MATCH_0);
    HibernateIntClear(HIBERNATE_INT_PIN_WAKE | HIBERNATE_INT_LOW_BAT | HIBERNATE_INT_RTC_MATCH_0);
    HibernateIntRegister(HibernateHandler);



    while( 1 )
    {
    	usnprintf(g_pcBuf, sizeof(g_pcBuf), "%4u %4u", sMatch, HibernateRTCGet( ));
		GrStringDrawCentered(&sContext, g_pcBuf, -1,
							 GrContextDpyWidthGet(&sContext) / 2,
							 Row(1) + 4, true);
		/*usnprintf(g_pcBuf2, sizeof(g_pcBuf), "sValue=%4u", HibernateRTCGet( ) );
		GrStringDrawCentered(&sContext, g_pcBuf2, -1,
							 GrContextDpyWidthGet(&sContext) / 2,
							 Row(2) + 4, true);*/
    }

}
