/*
 * main.c
 */

#include <stdbool.h>
#include <stdint.h>

#include <inc/tm4c123gh6pm.h>

#define CLOCK_FREQ_80MHz_RCC2_DIVISORS     (2 << SYSCTL_RCC2_SYSDIV2_S)
#define CLOCK_FREQ_66_67MHz_RCC2_DIVISORS ((2 << SYSCTL_RCC2_SYSDIV2_S) | SYSCTL_RCC2_SYSDIV2LSB)
#define CLOCK_FREQ_50MHz_RCC2_DIVISORS    ((3 << SYSCTL_RCC2_SYSDIV2_S) | SYSCTL_RCC2_SYSDIV2LSB)
#define CLOCK_FREQ_44_44MHz_RCC2_DIVISORS  (4 << SYSCTL_RCC2_SYSDIV2_S)
#define CLOCK_FREQ_40MHz_RCC2_DIVISORS    ((4 << SYSCTL_RCC2_SYSDIV2_S) | SYSCTL_RCC2_SYSDIV2LSB)

#define RCC2_DIVISORS CLOCK_FREQ_80MHz_RCC2_DIVISORS

bool busy (void)
{
	return FLASH_FMC_R & FLASH_FMC_ERASE;
}

void erase_page (uint32_t address)
{
	while (busy())
	{

	}

	asm ("	mov r5, #5");
	asm ("	mov r6, #6");
	asm ("	mov r7, #7");
	asm ("	mov r8, #8");
	asm ("	mov r9, #9");
	asm ("	mov r10, #10");
	asm ("	mov r11, #11");
	asm ("	mov r12, sp");

    FLASH_FMA_R = address;
    FLASH_FMC_R = (FLASH_FMC_WRKEY | FLASH_FMC_ERASE);

    /* sacrificial instruction after flash erase */
    asm (" mov r0, #0");

    asm ("	sub sp, #4");
    asm ("	sub sp, #8");
    asm ("	sub sp, #16");
    asm ("	sub sp, #32");
    asm ("	sub sp, #64");
    asm ("	sub sp, #128");
    asm ("	sub sp, #256");
    asm ("	sub sp, #512");

    for (;;)
    {

    }
}

void SetupClock() {
  // Run using internal oscillator
  // Use RCC2 instead of RCC
  SYSCTL_RCC2_R |= SYSCTL_RCC2_USERCC2;
  // Disable PLL
  SYSCTL_RCC2_R |= SYSCTL_RCC2_BYPASS2;
  SYSCTL_RCC2_R |= SYSCTL_RCC2_OSCSRC2_IO;
  // Power on the 400 Mhz PLL
  SYSCTL_RCC2_R &= ~SYSCTL_RCC2_PWRDN2;
  SYSCTL_RCC2_R |= SYSCTL_RCC2_DIV400;

  // Set up system divider (2 * SYSDIV + 1 + LSB)
  SYSCTL_RCC2_R = (SYSCTL_RCC2_R &
                   ~(SYSCTL_RCC2_SYSDIV2_M | SYSCTL_RCC2_SYSDIV2LSB)) |
                		   RCC2_DIVISORS;

  // Wait for the PLL to lock by polling PLLLRIS
  while ((SYSCTL_RIS_R & SYSCTL_RIS_PLLLRIS) == 0) {}

  // Enable PLL
  SYSCTL_RCC2_R &= ~SYSCTL_RCC2_BYPASS2;
}

int main(void)
{
	SetupClock ();
	erase_page (73 * 1024);
	
	return 0;
}
