/**********************************************************************************************************************
 *  COPYRIGHT
 *  -------------------------------------------------------------------------------------------------------------------
 *  \verbatim
 *
 *                  Copyright 2009-2012 Texas Instruments Incorporated.  All rights reserved.
 *
 *  \endverbatim
 *  -------------------------------------------------------------------------------------------------------------------
 *  FILE DESCRIPTION
 *  -------------------------------------------------------------------------------------------------------------------
 *
 *      Project:  Hercules ARM Safety MCUs - F021 Flash API 
 *      Version:  v2.00.00 Build(000809) - Beta                                                                         
 *   Build Date:  2013-03-14                                                                                            
 *
 *         File:  FapiFunctions.h                                                                                       
 *
 *  Description:  All the FAPI function extern definitions.
 *---------------------------------------------------------------------------------------------------------------------
 * Author:  John R Hall
 *---------------------------------------------------------------------------------------------------------------------
 *
 *********************************************************************************************************************/


#ifndef FAPI_FUNCTIONS_H_
#define FAPI_FUNCTIONS_H_

#ifdef __cplusplus
extern "C" {
#endif

/* Flash C API functions*/

/* Flash State Machine commands */
/*SAFETYMCUSW 91 S MR:5.2,5.6,5.7 <INSPECTED> "LDRA is confused on this. %%TEF%%" */
extern Fapi_StatusType Fapi_enableMainBankSectors(uint16_t u16SectorsEnables);

/*SAFETYMCUSW 91 S MR:5.2,5.6,5.7 <INSPECTED> "LDRA is confused on this. %%TEF%%" */
extern Fapi_StatusType Fapi_enableEepromBankSectors(
                                                    uint32_t u32SectorsEnables_31_0, 
                                                    uint32_t u32SectorsEnables_63_32
                                                   );

/*SAFETYMCUSW 91 S MR:5.2,5.6,5.7 <INSPECTED> "LDRA is confused on this. %%TEF%%" */
extern Fapi_StatusType Fapi_enableFsmDoneEvent(void);

/*SAFETYMCUSW 91 S MR:5.2,5.6,5.7 <INSPECTED> "LDRA is confused on this. %%TEF%%" */
extern Fapi_StatusType Fapi_disableFsmDoneEvent(void);

/*SAFETYMCUSW 91 S MR:5.2,5.6,5.7 <INSPECTED> "LDRA is confused on this. %%TEF%%" */
extern Fapi_StatusType Fapi_initializeFlashBanks(uint32_t u32HclkFrequency);

/*SAFETYMCUSW 91 S MR:5.2,5.6,5.7 <INSPECTED> "LDRA is confused on this. %%TEF%%" */
extern Fapi_StatusType Fapi_setActiveFlashBank(Fapi_FlashBankType oNewFlashBank);

/*SAFETYMCUSW 91 S MR:5.2,5.6,5.7 <INSPECTED> "LDRA is confused on this. %%TEF%%" */
extern Fapi_StatusType Fapi_enableBanksForOtpWrite(uint8_t u8Banks);

/*SAFETYMCUSW 91 S MR:5.2,5.6,5.7 <INSPECTED> "LDRA is confused on this. %%TEF%%" */
extern Fapi_StatusType Fapi_disableBanksForOtpWrite(void);

/* Functions only available on devices with L2FMC Flash controllers */
#if defined(_L2FMC) 

/*SAFETYMCUSW 91 S MR:5.2,5.6,5.7 <INSPECTED> "LDRA is confused on this. %%TEF%%" */
extern Fapi_StatusType Fapi_enableAutoEccCalculation(void);
/*SAFETYMCUSW 91 S MR:5.2,5.6,5.7 <INSPECTED> "LDRA is confused on this. %%TEF%%" */
extern Fapi_StatusType Fapi_disableAutoEccCalculation(void);

#endif  /* defined(_L2FMC) */

/*SAFETYMCUSW 91 S MR:5.2,5.6,5.7 <INSPECTED> "LDRA is confused on this. %%TEF%%" */
extern void Fapi_flushPipeline(void);

/*SAFETYMCUSW 91 S MR:5.2,5.6,5.7 <INSPECTED> "LDRA is confused on this. %%TEF%%" */
extern uint32_t* Fapi_remapEccAddress(uint32_t u32EccAddress);

/*SAFETYMCUSW 91 S MR:5.2,5.6,5.7 <INSPECTED> "LDRA is confused on this. %%TEF%%" */
extern uint32_t Fapi_remapMainAddress(uint32_t u32MainAddress);

/*SAFETYMCUSW 91 S MR:5.2,5.6,5.7 <INSPECTED> "LDRA is confused on this. %%TEF%%" */
extern boolean_t Fapi_isAddressEcc(uint32_t u32Address);

/* Async Commands */
/*SAFETYMCUSW 91 S MR:5.2,5.6,5.7 <INSPECTED> "LDRA is confused on this. %%TEF%%" */
extern Fapi_StatusType Fapi_issueAsyncCommandWithAddress(
                                                         Fapi_FlashStateCommandsType oCommand,
                                                         uint32_t* pu32StartAddress
                                                        );

/*SAFETYMCUSW 91 S MR:5.2,5.6,5.7 <INSPECTED> "LDRA is confused on this. %%TEF%%" */
extern Fapi_StatusType Fapi_issueAsyncCommand(Fapi_FlashStateCommandsType oCommand);

/* Info Commands */
/*SAFETYMCUSW 91 S MR:5.2,5.6,5.7 <INSPECTED> "LDRA is confused on this. %%TEF%%" */
extern Fapi_LibraryInfoType Fapi_getLibraryInfo(void);
/*SAFETYMCUSW 91 S MR:5.2,5.6,5.7 <INSPECTED> "LDRA is confused on this. %%TEF%%" */
extern Fapi_DeviceInfoType Fapi_getDeviceInfo(void);
/*SAFETYMCUSW 91 S MR:5.2,5.6,5.7 <INSPECTED> "LDRA is confused on this. %%TEF%%" */
extern Fapi_StatusType Fapi_getBankSectors(
                                           Fapi_FlashBankType oBank, 
                                           Fapi_FlashBankSectorsType* poFlashBankSectors 
                                          );

/* Read commands */
/*SAFETYMCUSW 91 S MR:5.2,5.6,5.7 <INSPECTED> "LDRA is confused on this. %%TEF%%" */
extern Fapi_StatusType Fapi_doBlankCheck(
                                         uint32_t* pu32StartAddress,
                                         uint32_t u32Length,
                                         Fapi_FlashStatusWordType* poFlashStatusWord
                                        );

/*SAFETYMCUSW 91 S MR:5.2,5.6,5.7 <INSPECTED> "LDRA is confused on this. %%TEF%%" */
extern Fapi_StatusType Fapi_doMarginRead(
                                         uint32_t* pu32StartAddress,
                                         uint32_t* pu32ReadBuffer,
                                         uint32_t u32Length,
                                         Fapi_FlashReadMarginModeType oReadMode
                                        );

/*SAFETYMCUSW 91 S MR:5.2,5.6,5.7 <INSPECTED> "LDRA is confused on this. %%TEF%%" */
extern Fapi_StatusType Fapi_doVerify(
                                     uint32_t* pu32StartAddress,
                                     uint32_t u32Length,
                                     uint32_t* pu32CheckValueBuffer,
                                     Fapi_FlashStatusWordType* poFlashStatusWord
                                    );

/*SAFETYMCUSW 91 S MR:5.2,5.6,5.7 <INSPECTED> "LDRA is confused on this. %%TEF%%" */
extern uint32_t Fapi_calculatePsa(
                                uint32_t* pu32StartAddress,
                                uint32_t u32Length,
                                uint32_t u32PsaSeed,
                                Fapi_FlashReadMarginModeType oReadMode
                               );

/*SAFETYMCUSW 91 S MR:5.2,5.6,5.7 <INSPECTED> "LDRA is confused on this. %%TEF%%" */
extern Fapi_StatusType Fapi_doPsaVerify(
                                        uint32_t* pu32StartAddress,
                                        uint32_t u32Length,
                                        uint32_t u32PsaValue,
                                        Fapi_FlashStatusWordType* poFlashStatusWord
                                       );

/*SAFETYMCUSW 91 S MR:5.2,5.6,5.7 <INSPECTED> "LDRA is confused on this. %%TEF%%" */
extern Fapi_StatusType Fapi_doBlankCheckByByte(
                                               uint8_t* pu8StartAddress,
                                               uint32_t u32Length,
                                               Fapi_FlashStatusWordType* poFlashStatusWord
                                              );

/*SAFETYMCUSW 91 S MR:5.2,5.6,5.7 <INSPECTED> "LDRA is confused on this. %%TEF%%" */
extern Fapi_StatusType Fapi_doMarginReadByByte(
                                               uint8_t* pu8StartAddress,
                                               uint8_t* pu8ReadBuffer,
                                               uint32_t u32Length,
                                               Fapi_FlashReadMarginModeType oReadMode
                                              );

/*SAFETYMCUSW 91 S MR:5.2,5.6,5.7 <INSPECTED> "LDRA is confused on this. %%TEF%%" */
extern Fapi_StatusType Fapi_doVerifyByByte(
                                           uint8_t* pu8StartAddress,
                                           uint32_t u32Length,
                                           uint8_t* pu8CheckValueBuffer,
                                           Fapi_FlashStatusWordType* poFlashStatusWord
                                          );

/* Programming Commands */
/*SAFETYMCUSW 91 S MR:5.2,5.6,5.7 <INSPECTED> "LDRA is confused on this. %%TEF%%" */
extern Fapi_StatusType Fapi_issueProgrammingCommand(
                                                    uint32_t* pu32StartAddress,
                                                    uint8_t*  pu8DataBuffer,
                                                    uint8_t   u8DataBufferSizeInBytes,
                                                    uint8_t*  pu8EccBuffer,
                                                    uint8_t   u8EccBufferSizeInBytes,
                                                    Fapi_FlashProgrammingCommandsType oMode
                                                   );

/*SAFETYMCUSW 91 S MR:5.2,5.6,5.7 <INSPECTED> "LDRA is confused on this. %%TEF%%" */
extern Fapi_StatusType Fapi_issueProgrammingCommandForEccAddresses(
                                                                   uint32_t* pu32StartAddress,
                                                                   uint8_t*  pu8EccBuffer,
                                                                   uint8_t   u8EccBufferSizeInBytes
                                                                  );

/* Utility Commands */
/*SAFETYMCUSW 91 S MR:5.2,5.6,5.7 <INSPECTED> "LDRA is confused on this. %%TEF%%" */
extern Fapi_StatusType Fapi_waitDelay(volatile uint32_t u32WaitDelay);

/*SAFETYMCUSW 91 S MR:5.2,5.6,5.7 <INSPECTED> "LDRA is confused on this. %%TEF%%" */
extern uint32_t Fapi_calculateFletcherChecksum(
                                             uint32_t u32Address,
                                             uint32_t u32Length
                                            );

/*SAFETYMCUSW 91 S MR:5.2,5.6,5.7 <INSPECTED> "LDRA is confused on this. %%TEF%%" */
extern uint8_t Fapi_calculateEcc(
                               uint32_t u32Address,
                               uint64_t u64Data
                              );

/* User Defined Functions */
/*SAFETYMCUSW 91 S MR:5.2,5.6,5.7 <INSPECTED> "LDRA is confused on this. %%TEF%%" */
extern Fapi_StatusType Fapi_serviceWatchdogTimer(void);

#ifdef __cplusplus
}
#endif

#endif /*FAPI_FUNCTIONS_H_*/

/**********************************************************************************************************************
 *  END OF FILE: FapiFunctions.h
 *********************************************************************************************************************/
