/**********************************************************************************************************************
 *  COPYRIGHT
 *  -------------------------------------------------------------------------------------------------------------------
 *  \verbatim
 *
 *                  Copyright 2009-2012 Texas Instruments Incorporated.  All rights reserved.
 *
 *  \endverbatim
 *  -------------------------------------------------------------------------------------------------------------------
 *  FILE DESCRIPTION
 *  -------------------------------------------------------------------------------------------------------------------
 *
 *      Project:  Hercules ARM Safety MCUs - F021 Flash API 
 *      Version:  v2.00.00 Build(000809) - Beta                                                                         
 *   Build Date:  2013-03-14                                                                                            
 *
 *         File:  Helpers.h                                                                                             
 *
 *  Description:  These helper Macros are to facilitate common operations.
 *---------------------------------------------------------------------------------------------------------------------
 * Author:  John R Hall
 *---------------------------------------------------------------------------------------------------------------------
 *
 *********************************************************************************************************************/


#ifndef HELPERS_H_
#define HELPERS_H_

/* Quick Register referencing macro */
/*SAFETYMCUSW 340 S MR:19.7 <INSPECTED> "This is a simple macro expanding to an expression" */
#define REGISTER(mRegister) (* (volatile uint32_t* )(mRegister))

/* Macro allowing a write to a locked FSM register */
/*SAFETYMCUSW 79 S MR:19.4 <INSPECTED> "This is a do-while-zero construct" */
#define FAPI_WRITE_LOCKED_FSM_REGISTER(mRegister,mValue)                 \
	do {                                                                  \
		FLASH_CONTROL_REGISTER->FsmWrEna.FSM_WR_ENA_BITS.WR_ENA    = 0x5U; \
		(mRegister) = (mValue);                                            \
		FLASH_CONTROL_REGISTER->FsmWrEna.FSM_WR_ENA_BITS.WR_ENA    = 0x2U; \
    } while(0)

/* These are helper functions to handle generic Big Endian/Little Endian code bases */
#if defined(_LITTLE_ENDIAN)
/*SAFETYMCUSW 340 S MR:19.7 <INSPECTED> "This is a simple macro expanding to an expression" */
    #define EI16(idx)            ((idx) ^ 1)
/*SAFETYMCUSW 340 S MR:19.7 <INSPECTED> "This is a simple macro expanding to an expression" */
    #define EI8(idx)             ((idx) ^ 3)
#else
/*SAFETYMCUSW 340 S MR:19.7 <INSPECTED> "This is a simple macro expanding to an expression" */
	#define EI16(idx)            (idx)
/*SAFETYMCUSW 340 S MR:19.7 <INSPECTED> "This is a simple macro expanding to an expression" */
	#define EI8(idx)             (idx)
#endif

/* Macro that reads the FMSTAT register and indicates if the FSM is Ready or Busy */
/*SAFETYMCUSW 79 S MR:19.4 <INSPECTED> "This is a simple expression" */
#define FAPI_CHECK_FSM_READY_BUSY \
         (FLASH_CONTROL_REGISTER->FmStat.FMSTAT_BITS.BUSY ? Fapi_Status_FsmBusy : Fapi_Status_FsmReady)

/* Macro that clears the FSM_DONE event */
#define FAPI_CLEAR_FSM_DONE_EVENT (FLASH_CONTROL_REGISTER->FedAcStatus.FEDACSTATUS_BITS.FSM_DONE = 1U)

/* Macro that returns the value in the FMStat Register */
#define FAPI_GET_FSM_STATUS (FLASH_CONTROL_REGISTER->FmStat.u32Register)

/* Macro that issues a Suspend command to the FSM */
#define FAPI_SUSPEND_FSM \
         (FAPI_WRITE_LOCKED_FSM_REGISTER(FLASH_CONTROL_REGISTER->FsmExecute.FSM_EXECUTE_BITS.SUSPEND_NOW, 0x5U))

/* Macro to set the EWAIT value */
/*SAFETYMCUSW 340 S MR:19.7 <INSPECTED> "Simple register write to a locked register" */
#define FAPI_WRITE_EWAIT(_mEwait) \
         (FAPI_WRITE_LOCKED_FSM_REGISTER(FLASH_CONTROL_REGISTER->EepromConfig.EEPROM_CONFIG_BITS.EWAIT,(_mEwait)))

#endif /* HELPERS_H_ */

/**********************************************************************************************************************
 *  END OF FILE: Helpers.h
 *********************************************************************************************************************/
