  .syntax unified
  .text
  .code 32

  /*
   * STACK
   * high address
   *       spsr     ------------^                                    v s
   *       return addr (lr_irq) |                                    v a
   *       lr_usr (lr_sys)      |                                    v v
   *       r12/ip               |  IRQ / FIR / SVC                   v e
   *  |    r3                   |      content
   *  v    r2                   |
   *       r1                   |
   *       r0       ------------v
   *       r11      ------------^
   *       r10                  |                                    ^ r
   *  |    r9                   |                                    ^ e
   *  v    r8                   |  saved by context switch           ^ s
   *       r7                   |                                    ^ t
   *       r6                   |                                    ^ o
   *       r5                   |                                    ^ r
   *       r4       ------------v                                    ^ e
   * low address
   */

  .global	rtiCompare0Interrupt
  .extern   rtiCompare0InterruptUser
  .func     rtiCompare0Interrupt
rtiCompare0Interrupt:
	sub	lr, lr, #4
	srsdb	sp!, #0x1F             // 2*dw on stack
	cps		#0x1F
	stmdb	sp!, {r0-r3, ip, lr}   // 6*dw on stack

	bl		rtiCompare0InterruptUser // BLX by linker

	ldmia	sp!, {r0-r3, ip, lr}
	rfeia	sp!
	.endfunc
//=====================================================================

	.global svcEntry
	.extern 	proc_switchTo
	.func svcEntry
svcEntry:
	// sub	lr, lr, #4
	srsdb	sp!, #0x1F             // 2*dw on stack
	cps		#0x1F
	stmdb	sp!, {r0-r3, ip, lr}   // 6*dw on stack

	ldr		r2, [sp,#(7*4)]		   // SPCR
	ldr		r3, [sp,#(6*4)]		   // interrupt addr
	tst     r2, #0x20 // #T_bit    // Occurred in Thumb state?
 	.syntax divided
    ldrneh  r2, [r3,#-2]           // Yes: Load halfword and...
	 .syntax unified
    bicne   r2, r2, #0xFF00        // ...extract comment field
    ldreq   r2, [r3,#-4]           // No: Load word and...
    biceq   r2, r3, #0xFF000000    // ...extract comment field

    tst		r2, #0	// @ todo, tohle je jen test
    bne		.Lunknown
    blx		proc_switchTo		   // r0, r1 params


.Lunknown:
	ldmia	sp!, {r0-r3, ip, lr}
	rfeia	sp!
	.endfunc
//=====================================================================

	.thumb

	.global procInit
	.func	procInit
	// r0 = pdb *
	// r1 = user start *
	// r2 = SP
	.thumb_func
procInit:
	mov		r3, # (0x10 + 0x20 + 0x200)  // user content + thumb + bigE
   	stmdb   r2!,{r3} // spsr
    stmdb   r2!,{r1} // return addr (lr_irq)

	mov		r3, #0
	stmdb   r2!,{r3} // lr_usr
	stmdb	r2!,{r3} // r12/ip
	stmdb	r2!,{r3} // r3
	stmdb	r2!,{r3} // r2
	stmdb	r2!,{r3} // r1
	stmdb	r2!,{r3} // r0
	stmdb	r2!,{r3} // r11
	stmdb	r2!,{r3} // r10
	stmdb	r2!,{r3} // r9
	stmdb	r2!,{r3} // r8
	stmdb	r2!,{r3} // r7
	stmdb	r2!,{r3} // r6
	stmdb	r2!,{r3} // r5
	stmdb	r2!,{r3} // r4

	str		r2, [r0, #4] // store SP

	bx		lr		 // return

	.endfunc
//=====================================================================

	.global proc_switchTo
	.global proc_firstSwitch
	.func proc_switchTo
	// r0 = fromPdb
	// r1 = toPdb
	.thumb_func
proc_firstSwitch:
	cps		#0x1F
	b		.Lpst001

	.thumb_func
proc_switchTo:
	// save context
	stmdb	sp!,{r4-r11}
	str		sp, [r0, #4]   // save SP
.Lpst001:
	ldr     sp, [r1, #4]   // restore SP of target context
	ldmia	sp!, {r4-r11}
	ldmia	sp!, {r0-r3, ip, lr}
	rfeia	sp!

	.endfunc

