/*
 * proces.c

 *
 *  Created on: 28.5.2013
 *      Author: jiri.dobry
 */
#include <stdint.h>

#include "../flash_api/TI_F021.h"
#include "process.h"

__attribute__((always_inline))
inline void svcProcSwitchTo(void * from, void * to) {
  register void * r0 __asm__("r0") = from;
  register void * r1 __asm__("r1") = to;
  __asm__ __volatile__ ("svc #0"  : : "r" (r0), "r" (r1));
}

struct PDB pdbs[2];

volatile uint32_t counter [2];

void proc0 (void)
{
  Fapi_FlashStatusWordType statusWords;  
  
  Fapi_initializeFlashBanks(180u);
  
  while (1)
  {
    // muj kod
    
    Fapi_setActiveFlashBank(Fapi_FlashBank1);
    Fapi_enableMainBankSectors(0xffff);
    Fapi_enableEepromBankSectors(0xffffffff, 0x00000000);
    Fapi_issueAsyncCommandWithAddress(Fapi_EraseSector, 0x00180000);
    Fapi_flushPipeline();
    Fapi_issueProgrammingCommand((uint32_t*) 0x00180000, 0x08008000, 1, NULL, 0x00, Fapi_DataOnly);
    Fapi_doVerifyByByte(0x00180000, 1, 0x08008000, &statusWords);
    Fapi_flushPipeline();

    counter[0]++;
    svcProcSwitchTo ( &(pdbs[0]), &(pdbs[1]));
  }
}

void proc1 (void)
{
  while (1)
  {
    // muj kod
    counter[1]++;
    svcProcSwitchTo ( &(pdbs[1]), &(pdbs[0]) );
  }
}


