//-------------------------------------------------------------------------------
// sys_core.S
// GNU GCC
// (c) Texas Instruments 2009-2012, All rights reserved.
//

   .text
   .code 32

//-------------------------------------------------------------------------------
// Initialize CPU Registers

    .global     _coreInitRegisters_
    .func       _coreInitRegisters_


_coreInitRegisters_:


    // After reset, the CPU is in the Supervisor mode (M = 10011)
        mov r0, lr
        mov r1, #0x0000
        mov r2, #0x0000
        mov r3, #0x0000
        mov r4, #0x0000
        mov r5, #0x0000
        mov r6, #0x0000
        mov r7, #0x0000
        mov r8, #0x0000
        mov r9, #0x0000
        mov r10, #0x0000
        mov r11, #0x0000
        mov r12, #0x0000
        mov r13, #0x0000
        mrs r1, cpsr
        msr spsr_cxsf, r1
        // Switch to FIQ mode (M = 10001)
        cps #17
        mov lr, r0
        mov r8, #0x0000
        mov r9, #0x0000
        mov r10, #0x0000
        mov r11, #0x0000
        mov r12, #0x0000
        mrs r1, cpsr
        msr spsr_cxsf, r1
        // Switch to IRQ mode (M = 10010)
        cps #18
        mov lr, r0
        mrs r1,cpsr
        msr spsr_cxsf, r1
        // Switch to Abort mode (M = 10111)
        cps #23
        mov lr, r0
        mrs r1,cpsr
        msr spsr_cxsf, r1
        // Switch to Undefined Instruction Mode (M = 11011)
        cps #27
        mov lr, r0
        mrs r1,cpsr
        msr spsr_cxsf, r1
        // Switch back to Supervisor Mode (M = 10011)
        cps #19


        mrc   p15,     #0x00,      r2,       c1, c0, #0x02
        orr   r2,      r2,         #0xF00000
        mcr   p15,     #0x00,      r2,       c1, c0, #0x02
        mov   r2,      #0x40000000
        fmxr  fpexc,   r2

        fmdrr d0,         r1,     r1
        fmdrr d1,         r1,     r1
        fmdrr d2,         r1,     r1
        fmdrr d3,         r1,     r1
        fmdrr d4,         r1,     r1
        fmdrr d5,         r1,     r1
        fmdrr d6,         r1,     r1
        fmdrr d7,         r1,     r1
        fmdrr d8,         r1,     r1
        fmdrr d9,         r1,     r1
        fmdrr d10,        r1,     r1
        fmdrr d11,        r1,     r1
        fmdrr d12,        r1,     r1
        fmdrr d13,        r1,     r1
        fmdrr d14,        r1,     r1
        fmdrr d15,        r1,     r1
        bl    next1
next1:
        bl    next2
next2:
        bl    next3
next3:
        bl    next4
next4:
        bx    r0

        .endfunc



//-------------------------------------------------------------------------------
// Initialize Stack Pointers

    .global     _coreInitStackPointer_
    .func       _coreInitStackPointer_

_coreInitStackPointer_:
//@todo ukazujeme na blby konec stacku!

        cps   #17
        ldr   sp,       fiqSp

        cps   #18
        ldr   sp,       irqSp

        cps   #23
        ldr   sp,       abortSp

        cps   #27
        ldr   sp,       undefSp

        cps   #31
        ldr   sp,       systemSp

#        cps   #16      // tohle nejde, nedokazu prepnout zpatky
#        ldr   sp,       userSp

        cps   #19
        ldr   sp,       svcSp

        bx    lr

userSp:   .word 0x08000000+0x00001000
svcSp:    .word 0x08000000+0x00001000+0x00000100
fiqSp:    .word 0x08000000+0x00001000+0x00000100+0x00000100
irqSp:    .word 0x08000000+0x00001000+0x00000100+0x00000100+0x00000100
abortSp:  .word 0x08000000+0x00001000+0x00000100+0x00000100+0x00000100+0x00000100
systemSp: .word 0x08000000+0x00001000+0x00000100+0x00000100+0x00000100+0x00000100+0x00000100
undefSp:  .word 0x08000000+0x00001000+0x00000100+0x00000100+0x00000100+0x00000100+0x00000100+0x00000100

    .endfunc

//-------------------------------------------------------------------------------
// Get CPSR Value

    .global     _getCPSRValue_
    .func       _getCPSRValue_

_getCPSRValue_:

        mrs   r0, CPSR
        bx    lr

    .endfunc

//-------------------------------------------------------------------------------
// Take CPU to IDLE state

    .global     _gotoCPUIdle_
    .func       _gotoCPUIdle_

_gotoCPUIdle_:

        WFI
        nop
        nop
        nop
        nop
        bx    lr

    .endfunc

//-------------------------------------------------------------------------------
// Enable VFP Unit

    .global     _coreEnableVfp_
    .func       _coreEnableVfp_

_coreEnableVfp_:

        mrc   p15,     #0x00,      r0,       c1, c0, #0x02
        orr   r0,      r0,         #0xF00000
        mcr   p15,     #0x00,      r0,       c1, c0, #0x02
        mov   r0,      #0x40000000
        fmxr  fpexc,   r0
        bx    lr

    .endfunc

//-------------------------------------------------------------------------------
// Enable Event Bus Export

    .global     _coreEnableEventBusExport_
    .func       _coreEnableEventBusExport_

_coreEnableEventBusExport_:

        stmfd sp!, {r0}
        mrc   p15, #0x00, r0,         c9, c12, #0x00
        orr   r0,  r0,    #0x10
        mcr   p15, #0x00, r0,         c9, c12, #0x00
        ldmfd sp!, {r0}
        bx    lr

    .endfunc


//-------------------------------------------------------------------------------
// Disable Event Bus Export

    .global     _coreDisableEventBusExport_
    .func       _coreDisableEventBusExport_

_coreDisableEventBusExport_:

        stmfd sp!, {r0}
        mrc   p15, #0x00, r0,         c9, c12, #0x00
        bic   r0,  r0,    #0x10
        mcr   p15, #0x00, r0,         c9, c12, #0x00
        ldmfd sp!, {r0}
        bx    lr

    .endfunc


//-------------------------------------------------------------------------------
// Enable RAM ECC Support

    .global     _coreEnableRamEcc_
    .func       _coreEnableRamEcc_

_coreEnableRamEcc_:

        stmfd sp!, {r0}
        mrc   p15, #0x00, r0,         c1, c0,  #0x01
        orr   r0,  r0,    #0x0C000000
        mcr   p15, #0x00, r0,         c1, c0,  #0x01
        ldmfd sp!, {r0}
        bx    lr

    .endfunc


//-------------------------------------------------------------------------------
// Disable RAM ECC Support

    .global     _coreDisableRamEcc_
    .func       _coreDisableRamEcc_

_coreDisableRamEcc_:

        stmfd sp!, {r0}
        mrc   p15, #0x00, r0,         c1, c0,  #0x01
        bic   r0,  r0,    #0x0C000000
        mcr   p15, #0x00, r0,         c1, c0,  #0x01
        ldmfd sp!, {r0}
        bx    lr

    .endfunc


//-------------------------------------------------------------------------------
// Enable Flash ECC Support

    .global     _coreEnableFlashEcc_
    .func       _coreEnableFlashEcc_

_coreEnableFlashEcc_:

        stmfd sp!, {r0}
        mrc   p15, #0x00, r0,         c1, c0,  #0x01
        orr   r0,  r0,    #0x02000000
        dmb
        mcr   p15, #0x00, r0,         c1, c0,  #0x01
        ldmfd sp!, {r0}
        bx    lr

    .endfunc


//-------------------------------------------------------------------------------
// Disable Flash ECC Support

    .global     _coreDisableFlashEcc_
    .func       _coreDisableFlashEcc_

_coreDisableFlashEcc_:

        stmfd sp!, {r0}
        mrc   p15, #0x00, r0,         c1, c0,  #0x01
        bic   r0,  r0,    #0x02000000
        mcr   p15, #0x00, r0,         c1, c0,  #0x01
        ldmfd sp!, {r0}
        bx    lr

    .endfunc


//-------------------------------------------------------------------------------
// Enable Offset via Vic controller

    .global     _coreEnableIrqVicOffset_
    .func       _coreEnableIrqVicOffset_

_coreEnableIrqVicOffset_:

        stmfd sp!, {r0}
        mrc   p15, #0, r0,         c1, c0,  #0
        orr   r0,  r0,    #0x01000000
        mcr   p15, #0, r0,         c1, c0,  #0
        ldmfd sp!, {r0}
        bx    lr

    .endfunc


//-------------------------------------------------------------------------------
// Get data fault status register

    .global     _coreGetDataFault_
    .func       _coreGetDataFault_

_coreGetDataFault_:

        mrc   p15, #0, r0, c5, c0,  #0
        bx    lr

    .endfunc


//-------------------------------------------------------------------------------
// Clear data fault status register

    .global     _coreClearDataFault_
    .func       _coreClearDataFault_

_coreClearDataFault_:

        stmfd sp!, {r0}
        mov   r0,  #0
        mcr   p15, #0, r0, c5, c0,  #0
        ldmfd sp!, {r0}
        bx    lr

    .endfunc


//-------------------------------------------------------------------------------
// Get instruction fault status register

    .global     _coreGetInstructionFault_
    .func       _coreGetInstructionFault_

_coreGetInstructionFault_:

        mrc   p15, #0, r0, c5, c0, #1
        bx    lr

    .endfunc


//-------------------------------------------------------------------------------
// Clear instruction fault status register

    .global     _coreClearInstructionFault_
    .func       _coreClearInstructionFault_

_coreClearInstructionFault_:

        stmfd sp!, {r0}
        mov   r0,  #0
        mcr   p15, #0, r0, c5, c0, #1
        ldmfd sp!, {r0}
        bx    lr

    .endfunc


//-------------------------------------------------------------------------------
// Get data fault address register

    .global     _coreGetDataFaultAddress_
    .func       _coreGetDataFaultAddress_

_coreGetDataFaultAddress_:

        mrc   p15, #0, r0, c6, c0,  #0
        bx    lr

    .endfunc


//-------------------------------------------------------------------------------
// Clear data fault address register

    .global     _coreClearDataFaultAddress_
    .func       _coreClearDataFaultAddress_

_coreClearDataFaultAddress_:

        stmfd sp!, {r0}
        mov   r0,  #0
        mcr   p15, #0, r0, c6, c0,  #0
        ldmfd sp!, {r0}
        bx    lr

    .endfunc


//-------------------------------------------------------------------------------
// Get instruction fault address register

    .global     _coreGetInstructionFaultAddress_
    .func       _coreGetInstructionFaultAddress_

_coreGetInstructionFaultAddress_:

        mrc   p15, #0, r0, c6, c0, #2
        bx    lr

    .endfunc


//-------------------------------------------------------------------------------
// Clear instruction fault address register

    .global     _coreClearInstructionFaultAddress_
    .func       _coreClearInstructionFaultAddress_

_coreClearInstructionFaultAddress_:

        stmfd sp!, {r0}
        mov   r0,  #0
        mcr   p15, #0, r0, c6, c0, #2
        ldmfd sp!, {r0}
        bx    lr

    .endfunc


//-------------------------------------------------------------------------------
// Get auxiliary data fault status register

    .global     _coreGetAuxiliaryDataFault_
    .func       _coreGetAuxiliaryDataFault_

_coreGetAuxiliaryDataFault_:

        mrc   p15, #0, r0, c5, c1, #0
        bx    lr

    .endfunc


//-------------------------------------------------------------------------------
// Clear auxiliary data fault status register

    .global     _coreClearAuxiliaryDataFault_
    .func       _coreClearAuxiliaryDataFault_

_coreClearAuxiliaryDataFault_:

        stmfd sp!, {r0}
        mov   r0,  #0
        mcr   p15, #0, r0, c5, c1, #0
        ldmfd sp!, {r0}
        bx    lr

    .endfunc


//-------------------------------------------------------------------------------
// Get auxiliary instruction fault status register

    .global     _coreGetAuxiliaryInstructionFault_
    .func       _coreGetAuxiliaryInstructionFault_

_coreGetAuxiliaryInstructionFault_:

        mrc   p15, #0, r0, c5, c1, #1
        bx    lr

    .endfunc

//-------------------------------------------------------------------------------
// Clear auxiliary instruction fault status register

    .global     _coreClearAuxiliaryInstructionFault_
    .func       _coreClearAuxiliaryInstructionFault_

_coreClearAuxiliaryInstructionFault_:

        stmfd sp!, {r0}
        mov   r0,  #0
        mrc   p15, #0, r0, c5, c1, #1
        ldmfd sp!, {r0}
        bx    lr

    .endfunc

//-------------------------------------------------------------------------------
// Disable interrupts - R4 IRQ & FIQ

        .global _disable_interrupt_
        .func       _disable_interrupt_

_disable_interrupt_:

        cpsid if
        bx    lr

        .endfunc

//-------------------------------------------------------------------------------
// Disable FIQ interrupt

        .global _disable_FIQ_interrupt_
        .func       _disable_FIQ_interrupt_

_disable_FIQ_interrupt_:

        cpsid f
        bx    lr

        .endfunc

//-------------------------------------------------------------------------------
// Disable FIQ interrupt

        .global _disable_IRQ_interrupt_
        .func       _disable_IRQ_interrupt_

_disable_IRQ_interrupt_:

        cpsid i
        bx    lr

        .endfunc

//-------------------------------------------------------------------------------
// Enable interrupts - R4 IRQ & FIQ

       .global _enable_interrupt_
       .func        _enable_interrupt_

_enable_interrupt_:

        cpsie if
        bx    lr

        .endfunc


//-------------------------------------------------------------------------------
// Clear ESM CCM errorss

       .global _esmCcmErrorsClear_
       .func        _esmCcmErrorsClear_

_esmCcmErrorsClear_:

        stmfd sp!, {r0-r2}
        ldr   r0, ESMSR1_REG    // load the ESMSR1 status register address
        ldr   r2, ESMSR1_ERR_CLR
        str   r2, [r0]      // clear the ESMSR1 register

        ldr   r0, ESMSR2_REG    // load the ESMSR2 status register address
        ldr   r2, ESMSR2_ERR_CLR
        str   r2, [r0]      // clear the ESMSR2 register

        ldr   r0, ESMSSR2_REG   // load the ESMSSR2 status register address
        ldr   r2, ESMSSR2_ERR_CLR
        str   r2, [r0]          // clear the ESMSSR2 register

        ldr   r0, ESMKEY_REG    // load the ESMKEY register address
        mov   r2, #0x5             // load R2 with 0x5
        str   r2, [r0]          // clear the ESMKEY register

        ldr   r0, VIM_INTREQ    // load the INTREQ register address
        ldr   r2, VIM_INT_CLR
        str   r2, [r0]      // clear the INTREQ register
        ldr   r0, CCMR4_STAT_REG    // load the CCMR4 status register address
        ldr   r2, CCMR4_ERR_CLR
        str   r2, [r0]      // clear the CCMR4 status register
        ldmfd sp!, {r0-r2}
        bx    lr

ESMSR1_REG:        .word 0xFFFFF518
ESMSR2_REG:        .word 0xFFFFF51C
ESMSR3_REG:        .word 0xFFFFF520
ESMKEY_REG:        .word 0xFFFFF538
ESMSSR2_REG:       .word 0xFFFFF53C
CCMR4_STAT_REG:    .word 0xFFFFF600
ERR_CLR_WRD:       .word 0xFFFFFFFF
CCMR4_ERR_CLR:     .word 0x00010000
ESMSR1_ERR_CLR:    .word 0x80000000
ESMSR2_ERR_CLR:    .word 0x00000004
ESMSSR2_ERR_CLR:   .word 0x00000004
VIM_INT_CLR:       .word 0x00000001
VIM_INTREQ:        .word 0xFFFFFE20

        .endfunc

//-------------------------------------------------------------------------------
// Work Around for Errata CORTEX-R4#57:
//
// Errata Description:
//            Conditional VMRS APSR_Nzcv, FPSCR May Evaluate With Incorrect Flags
// Workaround:
//            Disable out-of-order single-precision floating point
//            multiply-accumulate instruction completion

        .global     _errata_CORTEXR4_57_
        .func       _errata_CORTEXR4_57_

_errata_CORTEXR4_57_:

        push {r0}
        mrc p15, #0, r0, c15, c0, #0 // Read Secondary Auxiliary Control Register
        orr r0, r0, #0x10000         // Set BIT 16 (Set DOOFMACS)
        mcr p15, #0, r0, c15, c0, #0 // Write Secondary Auxiliary Control Register
        pop {r0}
        bx    lr

        .endfunc
//-------------------------------------------------------------------------------
// Work Around for Errata CORTEX-R4#66:
//
// Errata Description:
//            Register Corruption During A Load-Multiple Instruction At
//            an Exception Vector
// Workaround:
//            Disable out-of-order completion for divide instructions in
//            Auxiliary Control register

        .global     _errata_CORTEXR4_66_
        .func       _errata_CORTEXR4_66_

_errata_CORTEXR4_66_:

        push {r0}
        mrc p15, #0, r0, c1, c0, #1 // Read Auxiliary Control register
        orr r0, r0, #0x80           // Set BIT 7 (Disable out-of-order completion
                                    // for divide instructions.)
        mcr p15, #0, r0, c1, c0, #1 // Write Auxiliary Control register
        pop {r0}
        bx    lr
        .endfunc
//-------------------------------------------------------------------------------

    .end

//-------------------------------------------------------------------------------

