//-------------------------------------------------------------------------------
// sys_intvecs.S
// GNU GCC
// (c) Texas Instruments 2009-2012, All rights reserved.
//

    .section .intvecs
    .code 32

//-------------------------------------------------------------------------------
// import reference for interrupt routines

    .extern _c_int00
    .extern _dabort
    .extern svcEntry


//-------------------------------------------------------------------------------
// interrupt vectors
    .globl _intvecs
_intvecs:

        blx   _c_int00        // Reset
undefEntry:
        b   undefEntry        // Undefined Instruction
        b   svcEntry          // Supervisor Call
prefetchEntry:
        b   prefetchEntry     // Prefetch Abort
        b   _dabort           // Data Abort
reservedEntry:
        b   reservedEntry     // Not used
        ldr pc,[pc,#-0x1b0]   // IRQ interrupt
        ldr pc,[pc,#-0x1b0]   // FIQ interrupt
/*
Program Counter (PC) always pointers two instructions beyond the current executed
instruction. In this case, PC equals to 0x18 or 0x1C + 0x08. The LDR instruction load the
memory at PC - 0x1B0, which is 0x18 or 0x1C + 0x08 - 0x1B0 = 0xFFFFFE70 or
0xFFFFFE74. These are the address of IRQVECREG and FIQVECREG, which store the
pending ISR address.
*/

    .end
//-------------------------------------------------------------------------------
