/** @file sys_main.c 
*   @brief Application main file
*   @date 15.Aug.2012
*   @version 03.02.00
*
*   This file contains an empty main function,
*   which can be used for the application.
*/

/* (c) Texas Instruments 2009-2012, All rights reserved. */

/* USER CODE BEGIN (0) */
#include "rti.h"
#include "het.h"
#include "gio.h"
/* USER CODE END */

/* Include Files */

#include "sys_common.h"
#include "system.h"
#include "sys_core.h"
#include "../rtos/process.h"


/* USER CODE BEGIN (1) */
/* USER CODE END */

/** @fn void main(void)
*   @brief Application main function
*   @note This function is empty by default.
*
*   This function is called after startup.
*   The user can use this function to implement the application.
*/

/* USER CODE BEGIN (2) */
/* USER CODE END */

extern struct PDB pdbs[];
void procInit (struct PDB *, void *, void *);
void proc_firstSwitch(struct PDB *, struct PDB *);
void proc0(void);
void proc1(void);

int main(void)
{
/* USER CODE BEGIN (3) */
/* call the application */
/* !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
** Missing C environment (initialization of static-located data --- RAM variables)
** commented __cmain() function call - specific for IAR
** !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
*/
    rtiInit();
	gioSetDirection(hetPORT1, 0xFFFFFFFF); /* all output */
	gioSetPort(hetPORT1,0x08110034); // switch tri-colored LEDs OFF
	/* Enable RTI Compare 0 interrupt notification */
	rtiEnableNotification(rtiNOTIFICATION_COMPARE0);
	//_enable_IRQ();
    _enable_interrupt_();
	rtiStartCounter(rtiCOUNTER_BLOCK0);
  procInit(&(pdbs[0]), proc0 ,(void *) (0x08000000+0x00003000));
  procInit(&(pdbs[1]), proc1 ,(void *) (0x08000000+0x00004000));
  proc_firstSwitch(0, &(pdbs[0]));


	while(1)
		;

/* USER CODE END */
}

/* USER CODE BEGIN (4) */
/* USER CODE END */
