//-------------------------------------------------------------------------------
// sys_pmu.S
// GNU GCC
// (c) Texas Instruments 2012, All rights reserved.
//

    .text
    .code 32


//-------------------------------------------------------------------------------
// Initialize Pmu
// Note: It will reset all counters

    .global     _pmuInit_
    .func       _pmuInit_

_pmuInit_:

        stmfd sp!, {r0}
        // set control register
        mrc   p15, #0, r0, c9, c12, #0 
        orr   r0,  r0, #(1 << 4) + 6 + 1
        mcr   p15, #0, r0, c9, c12, #0
        // clear flags
		mov   r0,  #0
		mcr   p15, #0, r0, c9, c12, #3 
        // select counter 0 event
        mcr   p15, #0, r0, c9, c12, #5 // select counter
        mov   r0,  #0x11
        mcr   p15, #0, r0, c9, c13, #1 // select event
        // select counter 1 event
		mov   r0,  #1
        mcr   p15, #0, r0, c9, c12, #5 // select counter
        mov   r0,  #0x11
        mcr   p15, #0, r0, c9, c13, #1 // select event
        // select counter 2 event
		mov   r0,  #2
        mcr   p15, #0, r0, c9, c12, #5 // select counter
        mov   r0,  #0x11
        mcr   p15, #0, r0, c9, c13, #1 // select event
        ldmfd sp!, {r0}
        bx    lr

    .endfunc


//-------------------------------------------------------------------------------
// Enable Counters Global [Cycle, Event [0..2]]
// Note: It will reset all counters

    .global     _pmuEnableCountersGlobal_
    .func       _pmuEnableCountersGlobal_

_pmuEnableCountersGlobal_:

        stmfd sp!, {r0}
        mrc   p15, #0, r0, c9, c12, #0 
        orr   r0,  r0, #7
        mcr   p15, #0, r0, c9, c12, #0
        ldmfd sp!, {r0}		
        bx    lr

    .endfunc

//-------------------------------------------------------------------------------
// Disable Counters Global [Cycle, Event [0..2]]

    .global     _pmuDisableCountersGlobal_
    .func       _pmuDisableCountersGlobal_

_pmuDisableCountersGlobal_:

        stmfd sp!, {r0}
        mrc   p15, #0, r0, c9, c12, #0 
        bic   r0,  r0, #1
        mcr   p15, #0, r0, c9, c12, #0
        ldmfd sp!, {r0}		
        bx    lr

    .endfunc

//-------------------------------------------------------------------------------
// Reset Cycle Counter

    .global     _pmuResetCycleCounter_
    .func       _pmuResetCycleCounter_

_pmuResetCycleCounter_:

        stmfd sp!, {r0}
        mrc   p15, #0, r0, c9, c12, #0 
        orr   r0,  r0, #4
        mcr   p15, #0, r0, c9, c12, #0
        ldmfd sp!, {r0}		
        bx    lr

    .endfunc
//-------------------------------------------------------------------------------
// Reset Event Counters [0..2]

    .global     _pmuResetEventCounters_
    .func       _pmuResetEventCounters_

_pmuResetEventCounters_:

        stmfd sp!, {r0}
        mrc   p15, #0, r0, c9, c12, #0 
        orr   r0,  r0, #2
        mcr   p15, #0, r0, c9, c12, #0
        ldmfd sp!, {r0}		
        bx    lr

    .endfunc

//-------------------------------------------------------------------------------
// Reset Cycle Counter abd Event Counters [0..2]

    .global     _pmuResetCounters_
    .func       _pmuResetCounters_

_pmuResetCounters_:

        stmfd sp!, {r0}
        mrc   p15, #0, r0, c9, c12, #0 
        orr   r0,  r0, #6
        mcr   p15, #0, r0, c9, c12, #0
        ldmfd sp!, {r0}		
        bx    lr

    .endfunc

//-------------------------------------------------------------------------------
// Start Counters [Cycle, 0..2]

    .global     _pmuStartCounters_
    .func       _pmuStartCounters_

_pmuStartCounters_:

        mcr   p15, #0, r0, c9, c12, #1
        bx    lr

    .endfunc

//-------------------------------------------------------------------------------
// Stop Counters [Cycle, 0..2]

    .global     _pmuStopCounters_
    .func       _pmuStopCounters_

_pmuStopCounters_:

        mcr   p15, #0, r0, c9, c12, #2
        bx    lr

    .endfunc

//-------------------------------------------------------------------------------
// Set Count event

    .global     _pmuSetCountEvent_
    .func       _pmuSetCountEvent_

_pmuSetCountEvent_:
 
        lsr   r0,  r0, #1
        mcr   p15, #0, r0, c9, c12, #5 // select counter
        mcr   p15, #0, r1, c9, c13, #1 // select event
        bx    lr

    .endfunc

//-------------------------------------------------------------------------------
// Get Cycle Count

    .global     _pmuGetCycleCount_
    .func       _pmuGetCycleCount_

_pmuGetCycleCount_:

        mrc   p15, #0, r0, c9, c13, #0
        bx    lr

    .endfunc

//-------------------------------------------------------------------------------
// Get Event Counter Count Value

    .global     _pmuGetEventCount_
    .func       _pmuGetEventCount_

_pmuGetEventCount_:

        lsr   r0,  r0, #1
        mcr   p15, #0, r0, c9, c12, #5 // select counter
        mrc   p15, #0, r0, c9, c13, #2 // read event counter
        bx    lr

    .endfunc

//-------------------------------------------------------------------------------
// Get Overflow Flags

    .global     _pmuGetOverflow_
    .func       _pmuGetOverflow_

_pmuGetOverflow_:

        mrc   p15, #0, r0, c9, c12, #3 // read overflow
		mov   r1,  #0
		mcr   p15, #0, r1, c9, c12, #3 // clear flags
        bx    lr

    .endfunc

    .end

//-------------------------------------------------------------------------------

