BSS_FW = "C:\\ti\\mmwave_dfp_01_02_00_01\\rf_eval\\rf_eval_firmware\\radarss\\xwr18xx_radarss_rprc.bin"
MSS_FW = "C:\\ti\\mmwave_dfp_01_02_00_01\\rf_eval\\rf_eval_firmware\\masterss\\xwr18xx_masterss_rprc.bin"


file_path = "C:\\ti\\raw_data_capture"

adc_data_path1 = file_path.."\\AOP_adc_data_profile_bf.bin"
raw_data_path1 = file_path.."\\AOP_adc_data_profile_bf_Raw_0.bin"
pkt_log_path1  = file_path.."\\AOP_profile_bf_pktlogfile.txt"

COM_PORT = 6

--reset and connect
ar1.FullReset()
ar1.SOPControl(2)
ar1.Connect(COM_PORT,921600,1000)

--download BSS FW
if (ar1.DownloadBSSFw(BSS_FW) == 0) then
    WriteToLog("BSS FW Download Success\n", "green")
else
    WriteToLog("BSS FW Download failure\n", "red")
end
RSTD.Sleep(500)

-- Download MSS FW
if (ar1.DownloadMSSFw(MSS_FW) == 0) then
    WriteToLog("MSS FW Download Success\n", "green")
else
    WriteToLog("MSS FW Download failure\n", "red")
end
RSTD.Sleep(500)

-- SPI Connect
if (ar1.PowerOn(1, 1000, 0, 0) == 0) then
    WriteToLog("Power On Success\n", "green")
else
   WriteToLog("Power On failure\n", "red")
end
RSTD.Sleep(500)

-- RF Power UP
if (ar1.RfEnable() == 0) then
    WriteToLog("RF Enable Success\n", "green")
else
    WriteToLog("RF Enable failure\n", "red")
end
RSTD.Sleep(500)

-- Channel Config
if (ar1.ChanNAdcConfig(1, 1, 1, 1, 1, 1, 1, 2, 1, 0) == 0) then
    WriteToLog("ChanNAdcConfig Success\n", "green")
else
    WriteToLog("ChanNAdcConfig failure\n", "red")
end
RSTD.Sleep(500)

-- LDO Bypass Enable
ar1.RfLdoBypassConfig(0x3)

-- ADC Config
if (ar1.LPModConfig(0, 0) == 0) then
	WriteToLog("Regualar mode Cfg Success\n", "green")
else
	WriteToLog("Regualar mode Cfg failure\n", "red")
end
RSTD.Sleep(500)

-- Enable Per Chirp Phase Shifter
if (ar1.SetMiscConfig(1) == 0) then
	WriteToLog("Per Chirp Phase Shifter Enable Success\n", "green")
else
	WriteToLog("Per Chirp Phase Shifter Enable failure\n", "red")
end
RSTD.Sleep(500)

-- RF Init
if (ar1.RfInit() == 0) then
    WriteToLog("RfInit Success\n", "green")
else
    WriteToLog("RfInit failure\n", "red")
end
RSTD.Sleep(1000)

-- Data Path Config
if (ar1.DataPathConfig(513, 1216644097, 0) == 0) then
    WriteToLog("DataPathConfig Success\n", "green")
else
    WriteToLog("DataPathConfig failure\n", "red")
end
if (ar1.LvdsClkConfig(1, 1) == 0) then
    WriteToLog("LvdsClkConfig Success\n", "green")
else
    WriteToLog("LvdsClkConfig failure\n", "red")
end
if (ar1.LVDSLaneConfig(0, 1, 1, 0, 0, 1, 0, 0) == 0) then
    WriteToLog("LVDSLaneConfig Success\n", "green")
else
    WriteToLog("LVDSLaneConfig failure\n", "red")
end
RSTD.Sleep(500)

-- Profile Config
if (ar1.ProfileConfig(0, 77, 100, 6, 60, 0, 6, 0, 0, 0, 0, 29.982, 0, 256, 10000, 0, 0, 30) == 0) then
    WriteToLog("ProfileConfig Success\n", "green")
else
    WriteToLog("ProfileConfig failure\n", "red")
end
if (ar1.ChirpConfig(0, 0, 0, 0, 0, 0, 0, 1, 1, 1) == 0) then
    WriteToLog("ChirpConfig Success\n", "green")
else
    WriteToLog("ChirpConfig failure\n", "red")
end
if (ar1.FrameConfig(0, 0, 8, 128, 40, 0, 1) == 0) then
    WriteToLog("FrameConfig Success\n", "green")
else
    WriteToLog("FrameConfig failure\n", "red")
end
RSTD.Sleep(500)

-- Configure Chirp Based Phase Shifter
if (ar1.SetPerChirpPhaseShifterConfig(0, 0, 0, 23, 45) == 0) then
    WriteToLog("Chirp Based Phase Shifter Configuration Success\n", "green")
else
    WriteToLog("Chirp Based Phase Shifter Configuration failure\n", "red")
end
RSTD.Sleep(500)

-- Connect DCA1000
if (ar1.SelectCaptureDevice("DCA1000") == 0) then
    WriteToLog("SelectCaptureDevice Success\n", "green")
else
    WriteToLog("SelectCaptureDevice failure\n", "red")
end
if (ar1.CaptureCardConfig_EthInit("192.168.33.30", "192.168.33.180", "12:34:56:78:90:12", 4096, 4098) == 0) then
    WriteToLog("CaptureCardConfig_EthInit Success\n", "green")
else
    WriteToLog("CaptureCardConfig_EthInit failure\n", "red")
end
if (ar1.CaptureCardConfig_Mode(1, 2, 1, 2, 3, 30) == 0) then
    WriteToLog("CaptureCardConfig_Mode Success\n", "green")
else
    WriteToLog("CaptureCardConfig_Mode failure\n", "red")
end
if (ar1.CaptureCardConfig_PacketDelay(100) == 0) then
    WriteToLog("CaptureCardConfig_PacketDelay Success\n", "green")
else
    WriteToLog("CaptureCardConfig_PacketDelay failure\n", "red")
end
RSTD.Sleep(1000)

----------------------------- Capture 1 -----------------------------
--Start Record ADC data
ar1.CaptureCardConfig_StartRecord(adc_data_path1, 1)
RSTD.Sleep(1000)

--Trigger frame
ar1.StartFrame()
RSTD.Sleep(15000)

--Packet reorder utility processing the Raw_ADC_data
WriteToLog("Please wait for a few seconds for Packet reorder utility processing .....!!!! \n", "green")
ar1.PacketReorderZeroFill(raw_data_path1, adc_data_path1, pkt_log_path1)
RSTD.Sleep(10000)
WriteToLog("Packet reorder utility processing done.....!!!! \n", "green")
