startFreq = 77; % start frequency in GHz
numAntennas = 3; % number of TX antennas
d = 0.00389341/2; % antenna spacing in meters
theta = 45; % desired phase shift
lamda = (3*10^8)/(startFreq*10^9);
antennaPhase = zeros(1, numAntennas);

for i = 1:numAntennas
    antennaPhase(1, i) = rad2deg((2*pi/lamda)*(i-1)*d*sin(deg2rad(theta)));
end

antennaPhaseBits = antennaPhase/5.625


