clc;
close all;
clear all;

%% Config parameters of radarCube
numRbins = 32;
numChirps = 104;
numTx = 2;
numRx = 3;

%% Open file and read it contents
fid = fopen('./PP_RC_F5_AF_SC', 'rb');
raw = fread(fid,'int16');
fclose(fid);

%% Convert into complex data
Rcuberaw = reshape(raw,[2 , length(raw)/2]);
Rcuberaw = Rcuberaw(1,:) + j* Rcuberaw(2,:);

%% Change the dimensions according to RCube format used in mmw_demo.c
Rcube = reshape(Rcuberaw,[numRbins numRx*numTx numChirps]);

%% Change Radarcube dimensions for easy accesssing
Rcube = permute(Rcube,[1 3 2]);


%% create hanning window as pre processing step
preproc = hanning(numChirps);
preproc = repmat(preproc,[1 numRbins numRx*numTx]);
preproc = permute(preproc,[2 1 3]);

%% Do FFT in chirp dimensions
Dfftwhole = fft(Rcube.*preproc,128,2);

% plot linear det-matrix
Lineardem_mat = squeeze(sum(abs(Dfftwhole),3));
figure,
mesh(fftshift(Lineardem_mat,2)')
title('Doppler FFT  performed in Matlab Linear scale');
ylabel('Doppler bins')
xlabel('Range bins')
zlabel('freq magnitude') 

%plot log2 det-matrix 
Log2det_mat = log2(squeeze(sum(abs(Dfftwhole),3)));
figure,
mesh(fftshift(Log2det_mat,2)')
title('Doppler FFT performed in Matlab Log2 scale');
ylabel('Doppler bins')
xlabel('Range bins')
zlabel('freq magnitude') 
