/* 
	PGA450-Q1 UART DEMO Command Overview
	Command 0 - Test UART communication.
	Command 1 - Trigger a short or long distance burst and capture with predefined drive/filter settings, burst, capture, and compare. Returns calculcated datapoint (ref Command2).
	Command 2 - Read the latest instance of threshold comparison results.
	Command 3 - Update an EEPROM value.
	Command 4 - Read all FIFO data.
	Command 5 - Burst, capture, and compare based on EEPROM configuration.
	Command 6 - Threshold Values Report.
	Command 7 - Not Used. Reserved for custom function.
*/

#include "PGA450.h"     		// Register Definitions
#include "PGA450_vars.h"     	// Variable Definitions

#define uartEnabled
//#define linEnabled

// Unused Interrupts //
void external0_ISR (void) interrupt 0 using 1  {}
void external1_ISR (void) interrupt 2 using 1  {}
void timer0_ISR (void) interrupt 1 using 2 {}
void timer1_ISR (void) interrupt 3 using 2 {}
void linSync_ISR (void) interrupt 8 using 3 {}
///////////////////////

	void serial_ISR (void) interrupt 4 	using 3 {
	#ifdef uartEnabled
	UART_data[UART_byte_count] = SBUF;
	UART_byte_count++ ;
	
	RI = 0;

	if ((SBUF != 0x00 & UART_byte_count == 1) | (SBUF != 0x55 & UART_byte_count == 2) | ((UART_data[2] & 0x0F) != data_EEPROM[31] & UART_byte_count == 3))
	{
		if (SBUF == 0x00 & UART_byte_count == 2) UART_byte_count--;		// Fix for a bug where the Checksum is 0x00
		else
		{
			UART_byte_count = 0;
			return;
		}
	}
	
	/* Command 0 - Test UART communication.
	*/
	if (((UART_data[2] & 0x70) == 0x00) & (UART_byte_count == 4))
	{
		EA = 0;
		command0(0);
		UART_byte_count = 0;
		EA = 1;
		return;		
	}
	
	/* Command 1 - Trigger a short or long distance burst and capture with predefined drive/filter settings. Also, read first instance of threshold crossing.
	*/
	else if (((UART_data[2] & 0x70) == 0x10) & (UART_byte_count == 5))
	{
		EA = 0;
		command1(0);
		UART_byte_count = 0;
		EA = 1;
		return;
	}
	
	/* Command 2 - Read first instance of threshold crossing.
	*/
	else if (((UART_data[2] & 0x70) == 0x20) & (UART_byte_count == 4))
	{
		EA = 0;
		command2(0);
		UART_byte_count = 0;
		EA = 1;
		return;
	}
	
	/* Command 3 - Update EEPROM values.
	*/
	else if (((UART_data[2] & 0x70) == 0x30) & (UART_byte_count == 6)) // else if (((UART_data[2] & 0x70) == 0x30) & (UART_byte_count == 36))
	{
		EA = 0;
		command3(0);
		UART_byte_count = 0;
		EA = 1;
		return;
	}	

	/* Command 4 - Read all FIFO data.
	default hex entry: 0x00, 0x55, 0x41, 0x00
	*/
	else if (((UART_data[2] & 0x70) == 0x40) & (UART_byte_count == 4))
	{
		EA = 0;
		command4(0);
		UART_byte_count = 0;
		EA = 1;
		return;
	}
	
	/* Command 5 - Burst/Capture using EEPROM drive/receive configuration.
	*/
	else if (((UART_data[2] & 0x70) == 0x50) & (UART_byte_count == 5))
	{
		EA = 0;
		command5(0);
		UART_byte_count = 0;
		EA = 1;
		return;
	}
	
	/* Command 6 - Threshold Values Report for selected mode of operation (short or long).
	*/	
	else if (((UART_data[2] & 0x70) == 0x60) & (UART_byte_count == 5))
	{
		EA = 0;
		command6(0);
		UART_byte_count = 0;
		EA = 1;
		return;
	}
	
	/* Command 7 - Not used.
	*/
	else if (((UART_data[2] & 0x70) == 0x70) & (UART_byte_count == 4))
	{
		EA = 0;
		command7(0);
		UART_byte_count = 0;
		EA = 1;
		return;
	}
	
	/*Invalid UART COMMAND
	*/
	else
	{
		return;
		// do nothing
	}
	
	#endif
}
	// * LIN SLAVE COMMAND ISR using Timer 0 *
void linPID_ISR (void) interrupt 5 	using 3{
	#ifdef linEnabled
	/*The LIN ID is transmitted over the LIN us as one protected (PID) byte, 
	with the lower six bits containing the raw ID 
	and the upper two bits containing the parity.*/
	
	pid = LIN_PID&0x3F; // The acceptable range of values is 00 to 3F hex (0 to 63 decimal)
	switch (pid){
   	
		// command 0
		case 0x00:
		case 0x21: 							// Transmit 2 bytes to Master			
			DATA_CNT = 2; 				// Number of bytes to be transmitted
			command0(1);
			LIN_CTRL = 1; 				// Tx
			EI7 = 1; 							// Enable Tx Interrupt		
		break;
		
		// command 1
		case 0x01:
		case 0x11:  						// Start Distance Measurement	(1 -> long (0.5 to 5 meters, else short (< 1meter))
			DATA_CNT = 1; 				// Number of bytes to be received
			LIN_CTRL = 0; 				// Rx
			EI6 = 1; 							// Enable LIN Rx Interrupt
		break;

		// command 2
		case 0x02:
		case 0x22: 							// Transmit 2 bytes to Master  (Echo)
			DATA_CNT = 2; 				// Number of bytes to be transmitted
			command2(1);
			LIN_CTRL = 1; 				// Tx
			EI7 = 1; 							// Enable Tx Interrupt
		break;

		// command 3
		case 0x03:
		case 0x31:							// Write single byte of EEPROM to address
			DATA_CNT = 2;					// LIN message will have 2 bytes
			LIN_CTRL = 0; 				// Setup for LIN receive
			EI6 = 1; 							// Enable LIN Rx Interrupt						
		break;

		// command 4
		case 0x04: 							// Transmit FIFO 768 bytes to Master 
			DATA_CNT = 8; 			// Number of bytes to be transmitted
			command4(1);
		break;
		
		// command 5
		case 0x05:  						// Start Custom Distance Measurement based on EEPROM settings
			DATA_CNT = 1; 				// Number of bytes to be received
			LIN_CTRL = 0; 				// Rx
			EI6 = 1; 							// Enable LIN Rx Interrupt
		break;
		
		// command 6	//TODO
		case 0x06: 							// Transmit threhsold FIFO times	
			DATA_CNT = 8; 				// Number of bytes to be transmitted
			command6(1);
			LIN_CTRL = 1; 				// Tx
			EI7 = 1; 							// Enable Tx Interrupt
		break;
		
		// command 7
		/*case 0x07: 							// Transmit 2 bytes to Master			
			DATA_CNT = 2; 				// Number of bytes to be transmitted
			command7(1);
			LIN_CTRL = 1; 				// Tx
			EI7 = 1; 							// Enable Tx Interrupt		
		break;*/
		
		default:		 								// Un-Defined LIN Command
			break;
  }
	#endif	
}	

// * LIN/SCI RECEIVE DATA ISR using Timer0 *
void linSciRxData_ISR (void) interrupt 6 	using 3{
	#ifdef linEnabled
  	EI6 = 0; 									// Disable Rx Interrupt
  	switch (pid){  						// Switch to different tasks based on LIN_PID received 
			case 0x01:
			case 0x11:	 							// Fixed Short or Long Distance Measurement
				command1(1);
				break;	   
			 
			case 0x03:
			case 0x31:			  				// Write Threshold Table to EEPROM (7 bytes)
				//EA = 0;
				command3(1);
				//EA = 1;
				break;

			case 0x05:	 							// Custom EEPROM Distance Measurement
				command5(1);
				break;	 
					
			default:
				break;
  	}
		#endif
}

void linSciTxData_ISR (void) interrupt 7 	using 3{
	#ifdef linEnabled
  //if (linLoop == 0)
	//{
		LIN_CTRL = 0; // Rx
		
	#ifndef keilTrialVer
		//Clear all LIN eight Tx Data registers
		TX_DATA0 = 0x00;
		TX_DATA1 = 0x00;
		TX_DATA2 = 0x00;
		TX_DATA3 = 0x00;
		TX_DATA4 = 0x00;
		TX_DATA5 = 0x00;
		TX_DATA6 = 0x00;
		TX_DATA7 = 0x00;
	#endif

		EI7 = 0; // Disable Tx Interrupt
	//}
	//else
	//{
	//	EI7 = 0; // Disable Tx Interrupt
	//}
	#endif
}