      
#include "PGA450.h"     		// Register Definitions
#include "PGA450_vars.h"     	// Variable Definitions
#include <stdio.h>

#define keilTrialVer // disables commands 4,6,7 to meet Keil uVision Trial Version 2k memory limitation

//#define BurstCaptureComparePrint; //when enabled: combines burst, capture, compare, and printing results to terminal on single command. Compatible with UART mode only.

union {unsigned short u16; unsigned char u8[2];} FifoWritePointer;
union {unsigned short u16; unsigned char u8[2];} FRT_T1;
union {unsigned short u16; unsigned char u8[2];} FRT_T2;
volatile unsigned short lcv;									// temporary loop count variable
volatile unsigned short lcvTemp;							// temporary loop count variable
volatile unsigned char MaskEcho;							// Counter for masking data after an echo has been found
volatile unsigned char DetectionThreshold;
volatile unsigned char DetectionThresholdTemp;
volatile unsigned char DetectIndex; 
volatile unsigned char echo_data;
volatile unsigned short thrEndLevel = 0;
volatile unsigned short thrLvlModInterval = 0;
volatile unsigned short thrIgnore = 0;
volatile unsigned short thrEndStart = 0;
volatile unsigned char range = 0;
volatile unsigned char address = 0;
volatile unsigned char value = 0;
volatile unsigned short linLoop;									// temporary loop count variable
volatile unsigned char thrTime[8];

void main (void){
  Initialization();
	
  while (1){} /* Loop forever */
}

void UART_send_data (unsigned char data_packet){
		
		ES = 0;
		SBUF = data_packet;
		while(~TI) {}; 
		TI = 0;
		ES = 1;
	}
void setThreshold(int mode){
	if (mode == 0){		//short mode
				EE_Data_Threshold[0] = data_EEPROM[0] & 0x0F;
				EE_Data_Threshold[1] = data_EEPROM[1] & 0x0F;
				EE_Data_Threshold[2] = data_EEPROM[2] & 0x0F;
				EE_Data_Threshold[3] = data_EEPROM[3] & 0x0F;
				EE_Data_Threshold[4] = data_EEPROM[4] & 0x0F;
				EE_Data_Threshold[5] = data_EEPROM[5] & 0x0F;
				EE_Data_Threshold[6] = data_EEPROM[6] & 0x0F;
				thrEndStart = data_EEPROM[7] & 0x0F;
				thrEndLevel = data_EEPROM[8] & 0x0F; 					// Fixed threshold until end of FIFO
				thrIgnore = data_EEPROM[9] & 0x0F; 						// Initialize threshold with offset from beginnning of FIFO
				thrLvlModInterval = data_EEPROM[10] & 0x0F; 	// threshold level change interval accross FIFO
	}
	else 							//long mode
	{
				EE_Data_Threshold[0] = data_EEPROM[0] >> 4;
				EE_Data_Threshold[1] = data_EEPROM[1] >> 4;
				EE_Data_Threshold[2] = data_EEPROM[2] >> 4;
				EE_Data_Threshold[3] = data_EEPROM[3] >> 4;
				EE_Data_Threshold[4] = data_EEPROM[4] >> 4;
				EE_Data_Threshold[5] = data_EEPROM[5] >> 4;
				EE_Data_Threshold[6] = data_EEPROM[6] >> 4;
				thrEndStart = data_EEPROM[7] >> 4;
				thrEndLevel = data_EEPROM[8] >> 4; 				// Fixed threshold until end of FIFO
				thrIgnore = data_EEPROM[9] >> 4; 					// Initialize threshold with offset from beginnning of FIFO
				thrLvlModInterval = data_EEPROM[10] >> 4; // threshold level change interval accross FIFO
	}		
}

char checksum_add_cary (char param1, char param2){
		union {unsigned short u16; unsigned char u8[2];} Sum;
		Sum.u16 = param1+param2;
		return ((Sum.u8[0] != 0) ? (Sum.u8[1] + 1) : Sum.u8[1]);
	}

	/* Command 0 - Test UART communication.
	default hex entry: 0x00, 0x55, 0x01, 0x00
	where 
				[0] 0x00: break field
				[1] 0x55: synchronization field
				[2] 0x01: '0'= command 0. '1'= sensor address set in EEPROM Addr 0x31
				[3] 0x00: ignored but required checksum
	*/
	void command0 (int comm){		// Transmit 2 bytes to Master	
		switch (comm)
		{
			case 0: //UART
				UART_send_data (0x12);
				UART_send_data (0x34);
				UART_send_data (~(checksum_add_cary (0x12, 0x34)));
			break;
			
			case 1: //LIN
				TX_DATA0 = 0x12;
				TX_DATA1 = 0x34;
			break;
			
			/*default:
			break;*/
		}
	}
									
	/* Command 1 - Trigger a short or long distance burst and capture with predefined drive/filter settings. Also, read first instance of threshold crossing.
	default hex entry: 0x00, 0x55, 0x11, 0x02, 0x00
	where 
				[0] 0x00: break field
				[1] 0x55: synchronization field
				[2] 0x11: '1'= command 1. '1'= sensor address set in EEPROM Addr 0x31
				[3] 0x02: '00'= listen. '01'= short. '02'= long.
				[4] 0x00: ignored but required checksum
	*/
	void command1 (int comm){		// Do distance Measurment with predefined driver/receive settings or UART entered
		switch (comm)
		{
			case 0: //UART				
				range = UART_data[3];
			break;
			
			case 1: //LIN
				range = RX_DATA0;
			break;
			
			/*default:
			break;*/
		}
		
			if (range > 2)	return;		// Valid data for command1 is only 0 - Liten mode ; 1 - Short Distance Detection; 2 - Long Distance Detection;

			// Default settings for Murata MA58MF14-7N transducer
			BPF_B1_MSB = 0x03;
			BPF_B1_LSB = 0x2D;
			BPF_A2_MSB = 0xEC;
			BPF_A2_LSB = 0x3D;
			BPF_A3_MSB = 0xF9;		
			BPF_A3_LSB = 0xA5;
			LPF_B1_MSB = 0x35;
			LPF_B1_LSB = 0xDD;
			LPF_A2_MSB = 0x14;
			LPF_A2_LSB = 0x46;	
			BURST_MODE = 0x00;     				// Push Pull mode
			BURST_ONA_MSB = 0x00;
			BURST_ONA_LSB = 0x8A;  				// ON Time = 8.6us 16MHz/58KHz/2
			BURST_OFFA_MSB = 0x00;
			BURST_OFFA_LSB = 0x8A;		 		// OFF Time = 8.6us
			DEADTIME = 0x05;							// Dead time between burst phases to limit shoot through current
			SAT_DEGLITCH = 0x09;   				// 2us per count || 1/58kHz (17.2uS)
		
			if (range == 2) 				// Long Distance Measurement
				{			
					PULSE_CNTA = 0x12; 				// # pulses during burst
					BLANKING_TIMER = 0xFF; 		// Waits #*16 uS after ECHO_EN = 1 to fill up FIFO (Ignores very close range data)
					FIFO_CTRL = 0x06;					// NO FIFO Rollover, 8 LSB
					CONTROL_1 = 0x01; 				// SAT threshold 300mV
					setThreshold(1); 					// set long threshold levels													
				}

				else if (range == 1) // Short Distance Measurment
				{	   					
					PULSE_CNTA = 0x01;				// # pulses during burst
					BLANKING_TIMER = 0x37;		// Waits #*16 uS after ECHO_EN = 1 to fill up FIFO (Ignores very close range data)
					FIFO_CTRL = 0x05;					// NO FIFO Rollover, 8 MSB mode
					CONTROL_1 = 0x01; 				// SAT threshold 300mV		
					setThreshold(0); 					// set short threshold levels
				}
				
				else 								// Listen Mode
				{
					setThreshold(1); 	//set long threshold levels
				}
											
		burst_cap_comp(range); 			// Burst,Capture,Compare	

		#ifdef BurstCaptureComparePrint
				if (comm == 0)
				{
					command2(range); 					// Enabled: send and receive data on single command.	
				}
		#endif
	}
							
	/* Command 2 - Read first instance of threshold crossing.
	default hex entry: 0x00, 0x55, 0x21, 0x00
	where 
				[0] 0x00: break field
				[1] 0x55: synchronization field
				[2] 0x21: '2'= command 2. '1'= sensor address set in EEPROM Addr 0x31
				[3] 0x00: ignored but required checksum
	*/
	void command2 (int comm){		// Transmit Results (2 bytes) to Master
		switch (comm)
		{
			case 0: //UART				
				UART_send_data (TimeOfFlight.u8[0]);
				UART_send_data (TimeOfFlight.u8[1]);
				UART_send_data (~(checksum_add_cary (TimeOfFlight.u8[0], TimeOfFlight.u8[1])));
			break;
			
			case 1: //LIN
				TX_DATA0 = TimeOfFlight.u8[0];
				TX_DATA1 = TimeOfFlight.u8[1];
			break;
			
			default:
				range = RX_DATA0;
				break;
		}
	}		
							
	/* Command 3 - Update EEPROM values.
	[SINGLE MODE- ENABLED] default hex entry: 0x00, 0x55, 0x31, 0x00, 0xFF, 0x00
	
	whre (SINGLE)
				[0] 0x00: break field
				[1] 0x55: synchronization field
				[2] 0x31: '3'= command 3. '1'= sensor address set in EEPROM Addr 0x31
				[3] 0x00: '00'= EEPROM Addr
				[4] 0xFF: 'FF'= EEPROM Data
				[5] 0x00: ignored but required checksum
	
	*/
	void command3 (int comm){		// Write EEPROM
		switch (comm)
		{
			case 0: //UART				
				address = UART_data[3];
				value = UART_data[4];
			break;
			
			case 1: //LIN
				address = RX_DATA0;
				value = RX_DATA1;
			break;
			
			/*default:
			break;*/
		}
		
		EA = 0;
		data_EEPROM[address] = value;
		
		EE_CTRL = 0x01;
		while (EE_CTRL == 0x01){}
			
		EA = 1;
		/*switch (comm)
		{
			case 0: //UART				
				UART_send_data(data_EEPROM[UART_data[3]]);
			break;
			
			case 1: //LIN
				TX_DATA0 = data_EEPROM[address];
			break;
		}*/
	}

	/* Command 4 - Read all FIFO data.
	default hex entry: 0x00, 0x55, 0x41, 0x00
	where 
				[0] 0x00: break field
				[1] 0x55: synchronization field
				[2] 0x41: '4'= command 4. '1'= sensor address set in EEPROM Addr 0x31
				[3] 0x00: ignored but required checksum
	*/
	void command4 (int comm){		// Transmit all FIFO data (768 bytes) to Master
		#ifndef keilTrialVer	
		switch (comm)
			{
				case 0: //UART			
					for (lcv = 0; lcv<768; lcv++)
					{					
						UART_send_data (data_FIFO[lcv]);
					}
				break;
				
				case 1: //LIN																			
						TX_DATA0 = data_FIFO[linLoop];
						TX_DATA1 = data_FIFO[linLoop+1];
						TX_DATA2 = data_FIFO[linLoop+2];
						TX_DATA3 = data_FIFO[linLoop+3];
						TX_DATA4 = data_FIFO[linLoop+4];
						TX_DATA5 = data_FIFO[linLoop+5];
						TX_DATA6 = data_FIFO[linLoop+6];
						TX_DATA7 = data_FIFO[linLoop+7];
						linLoop += 8;
				
						LIN_CTRL = 1; 				// Tx
						EI7 = 1; 							// Enable Tx Interrupt
						
						if (linLoop >= 96)
						{
							linLoop = 0; //[768 FIFO bytes] / [8 LIN TX bytes] = 96 loops
						}
				break;		

			/*default:
			break;*/				
		}
		#endif
	}

	/* Command 5 - Burst/Capture using EEPROM drive/receive configuration.
	default hex entry (long mode): 0x00, 0x55, 0x51, 0x02, 0x00
	where 
				[0] 0x00: break field
				[1] 0x55: synchronization field
				[2] 0x51: '5'= command 5. '1'= sensor address set in EEPROM Addr 0x31
				[3] 0x02: Use '0'=Listen, '1'=Short, '2'=Long
				[4] 0x00: ignored but required checksum		
	*/
	void command5 (int comm){		// Burst and capture based on EEPROM values
		
		switch (comm)
		{
			case 0: //UART				
				range = UART_data[3];
			break;
			
			case 1: //LIN
				range = RX_DATA0;
			break;
		}
		
		PULSE_CNTA = data_EEPROM[11];							  	
		BLANKING_TIMER = data_EEPROM[12];
		FIFO_CTRL = data_EEPROM[13];
		DOWNSAMPLE = data_EEPROM[14];
		CONTROL_1 = data_EEPROM[15];
		BURST_MODE = data_EEPROM[16];
		BURST_ONA_LSB = data_EEPROM[17];
		BURST_OFFA_LSB = data_EEPROM[18];
		DEADTIME = data_EEPROM[19];
		SAT_DEGLITCH = data_EEPROM[20];
		BPF_B1_MSB = data_EEPROM[21];
		BPF_B1_LSB = data_EEPROM[22];
		BPF_A2_MSB = data_EEPROM[23];
		BPF_A2_LSB = data_EEPROM[24];
		BPF_A3_MSB = data_EEPROM[25];
		BPF_A3_LSB = data_EEPROM[26];
		LPF_B1_MSB = data_EEPROM[27];
		LPF_B1_LSB = data_EEPROM[28];
		LPF_A2_MSB = data_EEPROM[29];
		LPF_A2_LSB = data_EEPROM[30];
		
		if (range == 1)
			{
				setThreshold(0); //set short threshold levels.	
			}		
		else
			{
				setThreshold(1); //set long threshold levels.	
			}
			
			burst_cap_comp(range); // burst, capture, compare
		
		#ifdef BurstCaptureComparePrint
				if (comm == 0)
				{
					command2(range); 					// Enabled: send and receive data on single command.	
				}
		#endif
	}

	/* Command 6 - Threshold Values Report for selected mode of operation (short or long).
	default hex entry: 0x00, 0x55, 0x61, 0x02, 0x00
	where 
				[0] 0x00: break field
				[1] 0x55: synchronization field
				[2] 0x61: '6'= command 2. '1'= sensor address set in EEPROM Addr 0x31
				[3] 0x02: Use '0'=Listen, '1'=Short, '2'=Long
				[4] 0x00: ignored but required checksum
	*/
	void command6 (int comm){		// Threshold Values Report
		#ifndef keilTrialVer
		switch (comm)
		{
			case 0: //UART				
				range = UART_data[3];
			break;
			
			case 1: //LIN
				range = RX_DATA0;
			break;
			
			/*default:
			break;*/
		}	
		
		
		MaskEcho = 0;
		DetectIndex = 1;
		linLoop=0;

		if (range == 1)
			{
				setThreshold(0); //set short threshold levels.	
			}		
		else
			{
				range = 2; //force to long mode
				setThreshold(1); //set long threshold levels.	
			}
		
			DetectionThreshold = 255;
		
			for(lcv=thrIgnore;lcv<767;lcv++)
				{			 			

				if ((range == 2)) 
					{	// long distance  - threshold assignment  
					if (lcv > (thrEndStart*40)) 
						{					
							DetectionThreshold = thrEndLevel*5; // modify to adjust last threshold level value based on noise floor
						}
					else if (lcv == ((thrLvlModInterval*8)*(DetectIndex)))
					{
							if (DetectIndex < 8)
							{
								DetectionThreshold = 12 + (EE_Data_Threshold[DetectIndex-1]<<3);
								DetectIndex++;
							}
					}					
					else
						{
						}			
					}					
					
				else if ((range == 1)) 
					{	// short distance  - threshold assignment  
					if (lcv > (thrEndStart*8)) {					
						DetectionThreshold = thrEndLevel*2; // modify to adjust last threshold level value based on noise floor	
						}				
					else if (lcv == ((thrLvlModInterval*2)*(DetectIndex)))
						{ 
							if (DetectIndex < 8)
							{
								DetectionThreshold = 4 + (EE_Data_Threshold[DetectIndex]<<4);
								DetectIndex++;
							}
						}
					else 
						{	
						}
					}
					
				else
					{
						//do nothing
					}
					
					if(DetectionThreshold != DetectionThresholdTemp)
						{
							if(lcv>255)
							{
								if(lcv>511)
								{
									lcvTemp = lcv-511;
								}
								else
								{
								lcvTemp = lcv-256;
								}
							}
							else
							{
								lcvTemp = lcv;
							}
							
							switch (comm)
							{
								case 0: //UART				
									UART_send_data (lcvTemp);
									UART_send_data (DetectionThreshold);	
								break;
								
								/*case 1: //LIN
									thrTime[linLoop] = lcvTemp;
									linLoop++;
								break;*/
							}	
												
						}
					DetectionThresholdTemp = DetectionThreshold;
				}
				
				/*switch (comm)
				{
					case 1: //LIN
						TX_DATA0 = thrTime[0];
						TX_DATA1 = thrTime[1];
						TX_DATA2 = thrTime[2];
						TX_DATA3 = thrTime[3];
						TX_DATA4 = thrTime[4];
						TX_DATA5 = thrTime[5];
						TX_DATA6 = thrTime[6];
						TX_DATA7 = thrTime[7];	
				}*/		
		#endif				
	}

	/* Command 7 - Not used.
	default hex entry: 0x00, 0x55, 0x71, 0x00
	where 
				[0] 0x00: break field
				[1] 0x55: synchronization field
				[2] 0x71: '7'= command 2. '1'= sensor address set in EEPROM Addr 0x31
				[3] 0x00: ignored but required checksum
	*/	
	
	void command7 (int comm){		// Not Used
	#ifndef keilTrialVer
		//Do nothing
		switch (comm)
		{
			case 0: //UART
				UART_send_data (0x9A);
				UART_send_data (0xBC);
				UART_send_data (~(checksum_add_cary (0x9A, 0xBC)));
			break;
			
			case 1: //LIN
				TX_DATA0 = 0x9A;
				TX_DATA1 = 0xBC;
			break;
			
			default:
			break;
		}
		#endif
	}
	
void burst_cap_comp (int comm){		// Burst, Capture, Compare
		
		switch (comm)
		{
			case 0: //UART				
				range = UART_data[3];
			break;
			
			case 1: //LIN
				range = RX_DATA0;
			break;
		
			/*default:
			break;*/
		}		
		
		FifoWritePointer.u16 = 0;
		FRT_T1.u16 = 0;
		FRT_T2.u16 = 0;
		TimeOfFlight.u16 = 0;
		MaskEcho = 0;
		DetectIndex = 1;
			
		PWR_MODE = 0x03; 								// VREG_EN (D1)=1, ACTIVE_EN (D0)=1, ready for ultrasonic burst	  
		EN_CTRL = 0x00;  								// Clear FIFO memory before burst     

		
		if (range != 0) 
		{
				while(STATUS2 & 0x01 == 0) {}		// Wait for VREG to be ready
				EN_CTRL = 0x85;       					// Enable Burst and saturation check, as well as log Free Running Timer
					
				//Record time
				FRT_T1.u8[0]=FRT_MSB;
				FRT_T1.u8[1]=FRT_LSB;
										
				while(STATUS2 & 0x02 == 0){}		// wait for decay done to be set			
				// If needed, user can check for the decay time capture here to check for an effective burst as a diagnostic
		}
		else	EN_CTRL = 0x80;						// Log Free Running Timer only. Used for Listen only mode, or triangulation.	
				
		PWR_MODE = 0x01;								// VREG disabled for better noise, ACTIVE mode remains enabled	
		EN_CTRL = 0x0C;									// Enable Echo Capture
		//EA = 0;													// Disable interrupts during echo processing			
		
			DetectionThreshold = 255;
		
			for(lcv=thrIgnore;lcv<767;lcv++)
				{
					// Read FIFO Pointer coherently
					while ( lcv >= FifoWritePointer.u16 )
						{	     			
							FifoWritePointer.u8[0] = FIFO_POINTER_MSB;
							FifoWritePointer.u8[1] = FIFO_POINTER_LSB;
							if ( FifoWritePointer.u8[0] != FIFO_POINTER_MSB ) // Check if coherent
								{ 	     	
									FifoWritePointer.u8[0] = FIFO_POINTER_MSB;
									FifoWritePointer.u8[1] = FIFO_POINTER_LSB;
								}		 
						}  			 			

				if ((range == 2)) 
					{	// long distance  - threshold assignment  
					if (lcv > (thrEndStart*40)) 
						{					
							DetectionThreshold = thrEndLevel*5; // modify to adjust last threshold level value based on noise floor average
						}
					else if (lcv == ((thrLvlModInterval*8)*(DetectIndex)) && (DetectIndex < 7))
					{
							if (DetectIndex < 8)
							{
								DetectionThreshold = 12 + (EE_Data_Threshold[DetectIndex-1]<<3);
								DetectIndex++;
							}
					}					
					else
						{
						}			
					}					
					
				else if ((range == 1)) 
					{			 		 // short distance  - threshold assignment  
					if (lcv > (thrEndStart*8)) {					
						DetectionThreshold = thrEndLevel*2; // modify to adjust last threshold level value based on noise floor average	
						}				
					else if (lcv == ((thrLvlModInterval*2)*(DetectIndex)) && (DetectIndex < 7)) 
						{ 
							if (DetectIndex < 8)
							{
								DetectionThreshold = 4 + (EE_Data_Threshold[DetectIndex]<<4);
								DetectIndex++;
							}
						}
					else 
						{	
						}
					}
					
				else
					{
						//do nothing
					}				
					
				if ( MaskEcho == 0){									
					if ( data_FIFO[lcv] > DetectionThreshold) {
					
						EN_CTRL = 0x8C;			//log free running timer						
						FRT_T2.u8[0]=FRT_MSB;
						FRT_T2.u8[1]=FRT_LSB;
						if (FRT_T1.u16 > FRT_T2.u16) {
							TimeOfFlight.u16 = 65535+FRT_T2.u16-FRT_T1.u16;
						}
						else {
							TimeOfFlight.u16 = FRT_T2.u16-FRT_T1.u16;	
						}
						MaskEcho = 1;
						//break;	// when enabled, break for loop as soon as an object is found, and not all FIFO will be filled	
					}		
				}	 					
			}			
			if (MaskEcho == 0)  TimeOfFlight.u16 = 65535;
																			
			PWR_MODE = 0x02; 		// VREG_EN (D1)=1, ACTIVE_EN (D0)=0, ready for ultrasonic burst
			EN_CTRL = 0x00;			// Clear all enables
			//EA = 1;
}