###################################################################################
# CLI Library Makefile
###################################################################################
.PHONY: cliLib cliLibClean

###################################################################################
# Setup the VPATH:
###################################################################################
vpath %.c src

###################################################################################
# Source Files:
###################################################################################
CLI_UTIL_SOURCES = cli.c	\
				   cli_mmwave.c

###################################################################################
# Additional include paths required
###################################################################################
STD_INCL = -i$(XDC_INSTALL_PATH)/packages -i$(BIOS_INSTALL_PATH)

###################################################################################
# CLI Library:
# - This is valid only for the R4F because the library uses the UART and the MSS
#   UART is the only available UART which can send/receive data.
###################################################################################
CLI_UTIL_R4F_LIB_OBJECTS  = $(addprefix $(PLATFORM_OBJDIR)/, $(CLI_UTIL_SOURCES:.c=.$(R4F_OBJ_EXT)))

###################################################################################
# Library Dependency:
###################################################################################
CLI_UTIL_R4F_DEPENDS  = $(addprefix $(PLATFORM_OBJDIR)/, $(CLI_UTIL_SOURCES:.c=.$(R4F_DEP_EXT)))

###################################################################################
# Library Names:
###################################################################################
CLI_UTIL_R4F_DRV_LIB  = lib/libcli_$(MMWAVE_SDK_DEVICE_TYPE).$(R4F_LIB_EXT)

###################################################################################
# CLI Library:
###################################################################################
cliLib: buildDirectories $(CLI_UTIL_R4F_LIB_OBJECTS)
	if [ ! -d "lib" ]; then mkdir lib; fi
	echo "Archiving $@"
	$(R4F_AR) $(R4F_AR_OPTS) $(CLI_UTIL_R4F_DRV_LIB) $(CLI_UTIL_R4F_LIB_OBJECTS)

###################################################################################
# Clean the mmWave Library
###################################################################################
cliLibClean:
	@echo 'Cleaning the CLI Library Objects'
	$(DEL) $(CLI_UTIL_R4F_LIB_OBJECTS) $(CLI_UTIL_R4F_DRV_LIB)
	$(DEL) $(CLI_UTIL_R4F_DEPENDS)

###################################################################################
# Dependency handling
###################################################################################
-include $(CLI_UTIL_R4F_DEPENDS)

