/*
 *  ======== main.c ========
 */

#include <xdc/std.h>

#include <xdc/runtime/Error.h>
#include <xdc/runtime/System.h>

#include <ti/sysbios/BIOS.h>

#include <ti/sysbios/knl/Task.h>
#include <uart/UART.h>
#include <osal/DebugP.h>
#include <osal/HwiP.h>
//#include <gpio/gpio.h>


UART_Handle      handle;
UART_Params      params;

/*
 *  ======== taskFxn ========
 */
Void taskFxn(UArg a0, UArg a1)
{
    System_printf("enter taskFxn()\n");

    UART_init();
   //GPIO_init();

    UART_Params_init(&params);

    handle = UART_open(0, &params);


    Task_sleep(10);

    System_printf("exit taskFxn()\n");
    while(1){
        System_printf("Run...\n");
        System_flush(); /* force SysMin output to console */
        Task_sleep(500);
    }

}

/*
 *  ======== main ========
 */
Int main()
{ 
    Task_Handle task;
    Error_Block eb;

    System_printf("enter main()\n");
///*

//*/
    Error_init(&eb);
    task = Task_create(taskFxn, NULL, &eb);
    if (task == NULL) {
        System_printf("Task_create() failed!\n");
        BIOS_exit(0);
    }

    BIOS_start();    /* does not return */
    return(0);
}
