"""
  Copyright 2018 Texas Instruments Incorporated. All rights reserved.

  IMPORTANT: Your use of this Software is limited to those specific rights
  granted under the terms of a software license agreement between the user who
  downloaded the software, his/her employer (which must be your employer) and
  Texas Instruments Incorporated (the "License"). You may not use this Software
  unless you agree to abide by the terms of the License. The License limits your
  use, and you acknowledge, that the Software may not be modified, copied or
  distributed unless embedded on a Texas Instruments microcontroller which is
  integrated into your product. Other than for the foregoing purpose, you may
  not use, reproduce, copy, prepare derivative works of, modify, distribute,
  perform, display or sell this Software and/or its documentation for any
  purpose.

  YOU FURTHER ACKNOWLEDGE AND AGREE THAT THE SOFTWARE AND DOCUMENTATION ARE
  PROVIDED AS IS WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED,
  INCLUDING WITHOUT LIMITATION, ANY WARRANTY OF MERCHANTABILITY, TITLE,
  NON-INFRINGEMENT AND FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL TEXAS
  INSTRUMENTS OR ITS LICENSORS BE LIABLE OR OBLIGATED UNDER CONTRACT,
  NEGLIGENCE, STRICT LIABILITY, CONTRIBUTION, BREACH OF WARRANTY, OR OTHER LEGAL
  EQUITABLE THEORY ANY DIRECT OR INDIRECT DAMAGES OR EXPENSES INCLUDING BUT NOT
  LIMITED TO ANY INCIDENTAL, SPECIAL, INDIRECT, PUNITIVE OR CONSEQUENTIAL
  DAMAGES, LOST PROFITS OR LOST DATA, COST OF PROCUREMENT OF SUBSTITUTE GOODS,
  TECHNOLOGY, SERVICES, OR ANY CLAIMS BY THIRD PARTIES (INCLUDING BUT NOT
  LIMITED TO ANY DEFENSE THEREOF), OR OTHER SIMILAR COSTS.

  Should you have any questions regarding your right to use this Software,
  contact Texas Instruments Incorporated at www.TI.com.

"""
# Patgen RGB888 ColorBar 1920x1080p30 on 954
# Version 0.91

import time

# 953 config
runTime = 3

Alias953 = 0x18

# # CSI sel and CSI enable
# ID954 = 0x7A
# 
# board.WriteI2C(ID954, 0x32, 0x01)
# time.sleep(0.5)
# board.WriteI2C(ID954, 0x33, 0x01)
# time.sleep(0.5)

# enable pat gen
board.WriteI2C(Alias953, 0xB0, 0x00)
board.WriteI2C(Alias953, 0xB1, 0x01)
board.WriteI2C(Alias953, 0xB2, 0x01) #enable pattern generator

board.WriteI2C(Alias953, 0xB1, 0x02)
board.WriteI2C(Alias953, 0xB2, 0xB3) #fixed color pattern, 8 color bars, block size of 5

board.WriteI2C(Alias953, 0xB1, 0x03)
board.WriteI2C(Alias953, 0xB2, 0x24) #CSI Data Identifier (0x24 = RGB888, 0x2C = RAW12, 0x2B = RAW10)

board.WriteI2C(Alias953, 0xB1, 0x04)
board.WriteI2C(Alias953, 0xB2, 0x16) #line size (15:8)

board.WriteI2C(Alias953, 0xB1, 0x05)
board.WriteI2C(Alias953, 0xB2, 0x80) #line size (7:0)

board.WriteI2C(Alias953, 0xB1, 0x06)
board.WriteI2C(Alias953, 0xB2, 0x02) #bar size (15:8)

board.WriteI2C(Alias953, 0xB1, 0x07)
board.WriteI2C(Alias953, 0xB2, 0xd0) #bar size (7:0)

board.WriteI2C(Alias953, 0xB1, 0x08)
board.WriteI2C(Alias953, 0xB2, 0x04) #active lines per frame (15:8)

board.WriteI2C(Alias953, 0xB1, 0x09)
board.WriteI2C(Alias953, 0xB2, 0x38) #active lines per frame (7:0)

board.WriteI2C(Alias953, 0xB1, 0x0a)
board.WriteI2C(Alias953, 0xB2, 0x04) #total lines per frame (15:8)

board.WriteI2C(Alias953, 0xB1, 0x0b)
board.WriteI2C(Alias953, 0xB2, 0x65) #total lines per frame (7:0)

board.WriteI2C(Alias953, 0xB1, 0x0c)
board.WriteI2C(Alias953, 0xB2, 0x0B) #line period (15:8)

board.WriteI2C(Alias953, 0xB1, 0x0d)
board.WriteI2C(Alias953, 0xB2, 0x93) #line period (7:0)

board.WriteI2C(Alias953, 0xB1, 0x0e)
board.WriteI2C(Alias953, 0xB2, 0x21) #vertical back porch

board.WriteI2C(Alias953, 0xB1, 0x0f)
board.WriteI2C(Alias953, 0xB2, 0x0a) #vertical front porch

board.WriteI2C(Alias953, 0xB1, 0x10) 
board.WriteI2C(Alias953, 0xB2, 0x00) #1st byte of fixed color

board.WriteI2C(Alias953, 0xB1, 0x11)
board.WriteI2C(Alias953, 0xB2, 0x00) #2nd byte of fixed color

board.WriteI2C(Alias953, 0xB1, 0x12)
board.WriteI2C(Alias953, 0xB2, 0xFF) #3rd byte of fixed color

# board.WriteI2C(0xB1, 0x13)
# board.WriteI2C(0xB2, 0xff) #4th byte of fixed color

# board.WriteI2C(0xB1, 0x14)
# board.WriteI2C(0xB2, 0xff) #5th byte of fixed color

# board.WriteI2C(0xB1, 0x15)
# board.WriteI2C(0xB2, 0x00) #6th byte of fixed color

# board.WriteI2C(0xB1, 0x16)
# board.WriteI2C(0xB2, 0x00) #7th byte of fixed color

# board.WriteI2C(0xB1, 0x17)
# board.WriteI2C(0xB2, 0x0f) #8th byte of fixed color

# board.WriteI2C(0xB1, 0x18)
# board.WriteI2C(0xB2, 0xf0) #9th byte of fixed color

# board.WriteI2C(0xB1, 0x19)
# board.WriteI2C(0xB2, 0x00) #10th byte of fixed color

# board.WriteI2C(0xB1, 0x1A)
# board.WriteI2C(0xB2, 0x00) #11th byte of fixed color

# board.WriteI2C(0xB1, 0x1B)
# board.WriteI2C(0xB1, 0x3f) #12th byte of fixed color

# board.WriteI2C(0xB1, 0x1C)
# board.WriteI2C(0xB2, 0xc0) #13th byte of fixed color

# board.WriteI2C(0xB1, 0x1D)
# board.WriteI2C(0xB2, 0x00) #14th byte of fixed color

# board.WriteI2C(0xB1, 0x1E)
# board.WriteI2C(0xB2, 0x00) #15th byte of fixed color

# board.WriteI2C(0xB1, 0x1F)
# board.WriteI2C(0xB2, 0x00) #16th byte of fixed color





