"""
DS90UB914A_GUI.py

<Insert GUI module description>

Copyright (c) 2016 Texas Instruments Incorporated.
All Rights Reserved.
"""

import os
import sys
from Utils import *
import wx
from ScriptingGUI import *
from RegistersGUI import *
from RemoteRegistersGUI import *
import DS90UB914A_Lib
STATUS_TIMER        = 1000  # milliseconds

ValidAddressList = ["0xC0", \
                    "0xC2", \
                    "0xC4", \
                    "0xC6", \
                    "0xC8", \
                    "0xCA", \
                    "0xCC", \
                    "0xCE", \
                    "0xD0", \
                    "0xD2", \
                    "0xD4", \
                    "0xD6", \
                    "0xD8", \
                    "0xDA", \
                    "0xDC", \
                    "0xDE"]

class DS90UB914A_GUI:

    def __init__( s, auiMgr, panel, alpBoards, boardObj):
        s.auiMgr = auiMgr
        s.mainPanel = panel
        s.alpBoards = alpBoards
        s.board = boardObj
        s.linkSts = 'No'
        
        
        # These are the tabbed panels we support for this device
        #s.deviceTabNames = ('Status','Settings','BIST','Pin-out','Registers','Scripting')
        s.deviceTabNames = ('Information','Slave Address', 'Registers','Scripting', 'Remote Registers')

        # This is the tab dispatch table
        s.tabDispatch = { s.deviceTabNames[0]: s.UpdateInformationTab,
                          s.deviceTabNames[1]: s.UpdateSlaveAddressTab,
                          s.deviceTabNames[2]: s.UpdateRegistersTab,
                          s.deviceTabNames[3]: s.UpdateScriptingTab,
                          s.deviceTabNames[4]: s.UpdateRemoteRegistersTab
                          }

        # Build our main notebook with the tabbed panels we want
        s.nb = wx.Notebook( s.mainPanel, -1)
        s.nb.Bind( wx.EVT_NOTEBOOK_PAGE_CHANGED, s.OnTabSelect)

        s.nbPanels = {}
        s.nbInitialized = {}
        for nbPage in s.deviceTabNames:
            nbPanel = wx.Panel( s.nb, -1, style=wx.TAB_TRAVERSAL)
            s.nbPanels[nbPage] = nbPanel
            s.nbInitialized[nbPage] = False
            s.nb.AddPage( nbPanel, nbPage)

        s.tabSizer = wx.BoxSizer( wx.VERTICAL)
        s.topSpacerWin = wx.Window( s.mainPanel, -1, size=(-1,5))
        s.topSpacerWin.SetBackgroundColour( s.nb.GetBackgroundColour())
        s.tabSizer.Add( s.topSpacerWin, 0.5, flag=wx.EXPAND)
        s.tabSizer.Add( s.nb, 1, flag=wx.EXPAND)
        s.mainPanel.SetSizer( s.tabSizer)
        s.mainPanel.Layout()
        s.nb.Show( True)

    def OnTabSelect( s, nbEvent):
        # This dispatches to the tabbed panel handler when that tab has been selected
        # by the user.
        
        s.currTabIdx = nbEvent.GetSelection()
        s.currTabTxt = s.nb.GetPageText( s.currTabIdx)
        s.panel = s.nbPanels[s.currTabTxt]
        
        if not s.nbInitialized[s.currTabTxt] and s.currTabTxt in s.tabDispatch:
            s.tabDispatch[s.currTabTxt]()
            s.nbInitialized[s.currTabTxt] = True
            
        nbEvent.Skip()
        
    def UpdateRegistersTab( s):
        s.regGUI = RegistersGUI( s.panel, s.board)
    
    def UpdateScriptingTab( s):
        s.scriptingGUI = ScriptingGUI( s.panel, s.alpBoards, s.board)
        try:
            loadFile = open( os.path.join( os.path.dirname( __file__), 'UserScriptButtons.nsb'))
            s.scriptingGUI.userScriptButtons = pickle.load( loadFile)
            loadFile.close()
            s.scriptingGUI.RefreshUserScriptButtons()
        except:
            pass

    def UpdateSlaveAddressTab(s):
        tab = wx.BoxSizer(wx.VERTICAL)
        txt = WriteText(s.panel, "10-100MHz 10/12 Bits FPD-Link III Chipset - Receiver", bold=True)
        tx2 = WriteText(s.panel, " ", bold=True)
        s.deviceEntryBs = wx.BoxSizer(wx.HORIZONTAL)
        s.txtLbl = WriteText(s.panel, "Device Slave Address", bold=True)
        s.txtCtrl = wx.ListBox(s.panel, choices = ValidAddressList, style=wx.LB_SINGLE )
        s.txtCtrl.SetSelection(0)
        devaddr = int(s.txtCtrl.GetStringSelection(), 16)
        s.board.SetDeviceSlaveAddr(devaddr)
        s.deviceEntryBs.Add(s.txtLbl, flag= wx.ALL | wx.ALIGN_CENTER_HORIZONTAL | wx.ALIGN_CENTER_VERTICAL, border = 10)
        s.deviceEntryBs.Add(s.txtCtrl, flag= wx.ALL | wx.ALIGN_CENTER_HORIZONTAL | wx.ALIGN_CENTER_VERTICAL, border = 10)
        #s.txtCtrl = BuildHexEditBox(s.panel, "MB201 Slave Address in Hex", numDigits=2)
        wx.EVT_LISTBOX(s.txtCtrl, s.txtCtrl.GetId(), s.txtEvt)
        
        tab.Add(txt, flag= wx.ALL | wx.ALIGN_CENTER_HORIZONTAL | wx.ALIGN_CENTER_VERTICAL, border = 15)
        tab.Add(tx2, flag= wx.ALL | wx.ALIGN_CENTER_HORIZONTAL | wx.ALIGN_CENTER_VERTICAL, border = 15)
        tab.Add(s.deviceEntryBs, flag= wx.ALL | wx.ALIGN_CENTER_HORIZONTAL | wx.ALIGN_CENTER_VERTICAL, border = 15)
        
        s.panel.SetSizer(tab)
        s.panel.Layout()
        s.nb.GetParent().FitInside()
        
    def UpdateInformationTab(s):
        # Panel heading
        #s.headingTxt = WriteText( s.panel, s.board.longDescription, position=None, bold=True)
        
        # Build the status boxes
        s.BuildDevStsBox()
        
        # Build the link status box
        s.BuildLinkStsBox()
        
        # Adjust the local/partner boxes to be the same horiz. width
        ResizeStaticGroupBoxesToMax([s.devStsBoxSz, s.linkStsBoxSz, s.partStsBoxSz])
 
 
        # Add the boxes to the panel sizer
        DEF_SPACE = 15
        s.mainSizer = wx.GridBagSizer( DEF_SPACE, DEF_SPACE)
        #s.mainSizer.Add( s.headingTxt,   (0,0), border=DEF_SPACE, flag=wx.TOP|wx.LEFT|wx.RIGHT)
        s.mainSizer.Add( s.devStsPanel,  (0,0), border=DEF_SPACE, flag=wx.TOP|wx.LEFT|wx.RIGHT)
        s.mainSizer.Add( s.partStsPanel, (1,0), border=DEF_SPACE, flag=wx.LEFT|wx.RIGHT)
        s.mainSizer.Add( s.linkStsPanel, (2,0), border=DEF_SPACE, flag=wx.LEFT|wx.RIGHT)

        # Lay it all out
        s.panel.SetAutoLayout( True)
        s.panel.SetSizer( s.mainSizer)
        s.mainSizer.Layout()
        
        # Polling timer
        s.timer = wx.Timer( s.panel)
        wx.EVT_TIMER( s.panel, s.timer.GetId(), s.OnTimer)
        s.timer.Start(STATUS_TIMER)
        
    def OnTimer( s, event):
        if s.currTabTxt == 'Information':
            s.RefreshInformationTab()
        
    def RefreshInformationTab(s):
        s.UpdateLinkInfo()
        s.UpdateDevInfo()
        
    def UpdateRemoteRegistersTab(s):
        if s.board.ReadReg(0x07) == 0x00:    # If the slaveAlias has not been set, sets it to the SlaveID
            s.board.WriteReg(0x07, s.board.ReadReg(0x06)) 
            MyPopup(s.panel ,"SlaveAlias(0x07) was set to 0x00. It has been set to SlaveID(0x06) to connect to remote device", "Register Change")
        s.remregGUI = RemoteRegistersGUI(s.panel,s.board)

    def txtEvt(s, evt):
        devaddr = int(s.txtCtrl.GetStringSelection(), 16)
        s.board.SetDeviceSlaveAddr(devaddr)

    def BuildDevStsBox(s):
        # Build local device status box
        s.devStsPanel = wx.Panel( s.panel, style=wx.TAB_TRAVERSAL|wx.CLIP_CHILDREN)
        s.devStsLabel = "Device Information"
        s.devStsBox = wx.StaticBox( s.devStsPanel, -1, s.devStsLabel)
        s.devStsBoxSz = wx.StaticBoxSizer( s.devStsBox, wx.VERTICAL)
        s.devStsPanel.SetSizer( s.devStsBoxSz)
        
        s.devStsCol0Sz = wx.BoxSizer( wx.VERTICAL)
        s.devStsCol1Sz = wx.BoxSizer( wx.VERTICAL)
        s.devStsCol0TxtCtrls = []
        s.devStsCol1TxtCtrls = []
            
        minLabelField = s.panel.GetTextExtent( "Linked to Video Source:")
        minStsField = s.panel.GetTextExtent( "DS90UB914A 00000000000000000000")#DeviceDescriptions[DEV_DS90UH914A][1])
        for row in ('Device:','Revision:','I2C Address:','Mode:', 'Serial Link Mode:', 'Errors LSB(0x1A):', 'Errors MSB(0x1B):' ):
            txt = WriteText( s.devStsPanel, row, None, False)
            s.devStsCol0Sz.Add( txt)
            s.devStsCol0Sz.SetItemMinSize( txt, *minLabelField)
            s.devStsCol0TxtCtrls.append( txt)
            txt = WriteText( s.devStsPanel, "", None, False)
            s.devStsCol1Sz.Add( txt, flag=wx.LEFT|wx.RIGHT, border=10)
            s.devStsCol1Sz.SetItemMinSize( txt, *minStsField)
            s.devStsCol1TxtCtrls.append( txt)
            
        s.devStsColSz = wx.BoxSizer( wx.HORIZONTAL)
        s.devStsColSz.Add( s.devStsCol0Sz)
        s.devStsColSz.Add( s.devStsCol1Sz)       
        s.devStsBoxSz.Add( s.devStsColSz, flag=wx.ALL, border=5)
        
        #Build partner device status box
        s.partStsPanel = wx.Panel( s.panel, style=wx.TAB_TRAVERSAL|wx.CLIP_CHILDREN)
        s.partStsLabel = "Partner Information"
        s.partStsBox = wx.StaticBox( s.partStsPanel, -1, s.partStsLabel)
        s.partStsBoxSz = wx.StaticBoxSizer( s.partStsBox, wx.VERTICAL)
        s.partStsPanel.SetSizer( s.partStsBoxSz)
        
        s.partStsCol0Sz = wx.BoxSizer( wx.VERTICAL)
        s.partStsCol1Sz = wx.BoxSizer( wx.VERTICAL)
        s.partStsCol0TxtCtrls = []
        s.partStsCol1TxtCtrls = []
            
        minLabelField = s.panel.GetTextExtent( "Linked to Video Source:")
        minStsField = s.panel.GetTextExtent( "DS90UB914A 0000000000000000")#s.panel.GetTextExtent( DeviceDescriptions[DEV_DS90UB914A][1])
        for row in ('Device:','Revision:','I2C Address:','PLL CLK Mode:', 'Serial Link Mode:', 'Errors LSB(0x0A):', 'Errors MSB(0x0B):', 'PCLK Status:' ):
            txt = WriteText( s.partStsPanel, row, None, False)
            s.partStsCol0Sz.Add( txt)
            s.partStsCol0Sz.SetItemMinSize( txt, *minLabelField)
            s.partStsCol0TxtCtrls.append( txt)
            txt = WriteText( s.partStsPanel, "", None, False)
            s.partStsCol1Sz.Add( txt, flag=wx.LEFT|wx.RIGHT, border=10)
            s.partStsCol1Sz.SetItemMinSize( txt, *minStsField)
            s.partStsCol1TxtCtrls.append( txt)
            
        s.partStsColSz = wx.BoxSizer( wx.HORIZONTAL)
        s.partStsColSz.Add( s.partStsCol0Sz)
        s.partStsColSz.Add( s.partStsCol1Sz)       
        s.partStsBoxSz.Add( s.partStsColSz, flag=wx.ALL, border=5)
    
        # Update both boxes
        s.UpdateDevInfo()    
    def UpdateLinkInfo(s):
        s.linkSts = 'No'
        if s.board.GetLinkStatus():
            s.linkSts = 'Yes'
        s.linkStsCol1TxtCtrls[0].SetLabel(s.linkSts)
            
    def BuildLinkStsBox(s):
        s.linkStsPanel = wx.Panel( s.panel, style=wx.TAB_TRAVERSAL|wx.CLIP_CHILDREN)
        s.linkStsLabel = "Current Link Status"
        s.linkStsBox = wx.StaticBox( s.linkStsPanel, -1, s.linkStsLabel)
        s.linkStsBoxSz = wx.StaticBoxSizer( s.linkStsBox, wx.VERTICAL)
        s.linkStsPanel.SetSizer( s.linkStsBoxSz)
        
        s.linkStsCol0Sz = wx.BoxSizer( wx.VERTICAL)
        s.linkStsCol1Sz = wx.BoxSizer( wx.VERTICAL)
        s.linkStsCol0TxtCtrls = []
        s.linkStsCol1TxtCtrls = []

        
        minLabelField = s.panel.GetTextExtent( "Linked to Serializer:")
        minStsField = s.panel.GetTextExtent( "000000")

        row = 'Linked to Serializer:'
       # for row in rows:
        txt = WriteText( s.linkStsPanel, row, None, False)
        

        s.linkStsCol0Sz.Add( txt)
        s.linkStsCol0Sz.SetItemMinSize( txt, *minLabelField)
        s.linkStsCol0TxtCtrls.append( txt)

        s.linkStsCol0Sz.SetItemMinSize( txt, *minLabelField)
        s.linkStsCol0TxtCtrls.append( txt)
        txt = WriteText( s.linkStsPanel, "", None, False)
        s.linkStsCol1Sz.Add( txt, flag=wx.LEFT|wx.RIGHT, border=10)
        s.linkStsCol1Sz.SetItemMinSize( txt, *minStsField)
        s.linkStsCol1TxtCtrls.append( txt)
            
        s.linkStsColSz = wx.BoxSizer( wx.HORIZONTAL)
        s.linkStsColSz.Add( s.linkStsCol0Sz)
        s.linkStsColSz.Add( s.linkStsCol1Sz)       
        s.linkStsBoxSz.Add( s.linkStsColSz, flag=wx.ALL, border=5)
        
        s.UpdateLinkInfo()
        

    def GetDevInfo(s):
        BoardInfo = s.board.GetBoardInfo()
        s.board.shortDescription = 'DS90UB14'
        s.board.longDescription = 'DS90UB914A FPD-Link III Deserializer'
       

        s.board.partnerLongDescription = 'DS90UB913A FPD-Link III Serializer'
        
        return 1
        
        
    def UpdateDevInfo(s):
        s.GetDevInfo()
        
        if s.linkSts == 'No':
            s.partStsPanel.Disable()
        else:
            s.partStsPanel.Enable()
      #DS90UB14  
        #Checking Revision Number
        RevID = s.board.ReadReg(0x1C)
        RevID = RevID & 0x70
        RevID = RevID >> 4
        
        #Checking I2C Address 
        ItwoCAddr = s.board.ReadReg(0x00)
        if ((ItwoCAddr & 0x01) == 0x01):  #checking the override bit
            ItwoCAddr = (ItwoCAddr & 0xFE)  
                
        #Checking Mode         
        Mode = s.board.ReadReg(0x1F)
        if (((Mode & 0x02) == 0x02) or ((Mode & 0x08) == 0x08)):
            ModeSts = '12-bit High-Frequency Mode'
        elif (((Mode & 0x01) == 0x01) or ((Mode & 0x04) == 0x04)):
            ModeSts = '10-bit High-Frequency Mode'
        else:
            ModeSts = '12-bit Low-Frequency Mode'
        
        rxInfo = (s.board.longDescription, RevID, hex(ItwoCAddr), ModeSts, 'FPD-Link III', hex(s.board.ReadReg(0x1A)), hex(s.board.ReadReg(0x1B)))

        devInfo  = rxInfo
        
        s.linkSts = s.board.GetLinkStatus()
        
        i=0
        for row in devInfo:
            txt = "%s" % row
            s.devStsCol1TxtCtrls[i].SetLabel( txt)
            i+=1
        
        
      #DS90UB13  
        #Checking Revision Number
        RevID = s.board.ReadRXReg(0x0C)
        RevID = RevID & 0x70
        RevID = RevID >> 5
        
        #Checking I2C Address 
        ItwoCAddr = s.board.ReadRXReg(0x00)
        if ((ItwoCAddr & 0x01) == 0x01):  #checking the override bit
            ItwoCAddr = (s.board.ReadRXReg(0x00) & 0xFE)  
            
        pclkMode = s.board.ReadRXReg(0x0C)
        if ((pclkMode & 0x04) == 0x04): 
            pclkStatus = 'Detected'
        else:
            pclkStatus = 'Not Detected'
            
        #Checking Mode         
        Mode = s.board.ReadRXReg(0x35)
        if ((Mode & 0x09) == 0x09):
            ModeSts = 'External Oscillator Mode'
        elif ((Mode & 0x04) == 0x04):
            ModeSts = 'Internal Oscillator Mode'
        elif ((Mode & 0x01) == 0x01):
            ModeSts = 'PCLK Mode'
        else:
            ModeSts = ''   
            
        txInfo = (s.board.partnerLongDescription, RevID, hex(ItwoCAddr), ModeSts, 'FPD-Link III', hex(s.board.ReadRXReg(0x0A)), hex(s.board.ReadRXReg(0x0B)),pclkStatus)
            
        partInfo = txInfo
        i=0
        for row in partInfo:
            txt = "%s" % row
            s.partStsCol1TxtCtrls[i].SetLabel( txt)
            i+=1
                    
    def DestroyPane( s):
        # Called by the framework when we're exiting the app or reenumerating
        # devices. We need to clean up async processes, etc.
        pass