"""
DS90UB914A_Lib.py

<Insert library module description>

Copyright (c) 2016 Texas Instruments Incorporated.
All Rights Reserved.
"""

import os
import sys
import NanoALP
from array import array
from ALPExtensionModule import ALPExtensionModule
from Utils import MyPopup
from Utils import WriteText


# List of register lists that specify the default value and access type for the reg.
# When WriteReg is called below the access type is checked and applied to the operation.
READ_WRITE = 0x1
READ_ONLY  = 0x0

DS90UB914ARegDefaults = {0x00: [0x00, READ_WRITE],  # /reg 00
                        0x01: [0x01, READ_WRITE],  # /reg 01
                        0x02: [0x02, READ_WRITE],  # /reg 02
                        0x03: [0x03, READ_WRITE],  # /reg 03
                        0x04: [0x04, READ_WRITE],  # /reg 04
                        0x05: [0x05, READ_WRITE],  # /reg 05
                        0x06: [0x06, READ_WRITE],  # /reg 06
                        0x07: [0x07, READ_WRITE],  # /reg 07
                        0x08: [0x08, READ_WRITE],  # /reg 08
                        0x09: [0x09, READ_WRITE],  # /reg 09
                        0x0A: [0x0A, READ_WRITE],  # /reg 0A
                        0x0B: [0x0B, READ_WRITE],  # /reg 0B
                        0x0C: [0x0C, READ_WRITE],  # /reg 0C
                        0x0D: [0x0D, READ_WRITE],  # /reg 0D
                        0x0E: [0x0E, READ_WRITE],  # /reg 0E
                        0x0F: [0x0F, READ_WRITE],  # /reg 0F
                        0x10: [0x10, READ_WRITE],  # /reg 10
                        0x11: [0x11, READ_WRITE],  # /reg 11
                        0x12: [0x12, READ_WRITE],  # /reg 12
                        0x13: [0x13, READ_WRITE],  # /reg 13
                        0x14: [0x14, READ_WRITE],  # /reg 14
                        0x15: [0x15, READ_WRITE],  # /reg 15
                        0x16: [0x16, READ_WRITE],  # /reg 16
                        0x17: [0x17, READ_WRITE],  # /reg 17
                        0x18: [0x18, READ_WRITE],  # /reg 18
                        0x19: [0x19, READ_WRITE],  # /reg 19
                        0x1A: [0x1A, READ_WRITE],  # /reg 1A
                        0x1B: [0x1B, READ_WRITE],  # /reg 1B
                        0x1C: [0x1C, READ_WRITE],  # /reg 1C
                        0x1D: [0x1D, READ_WRITE],  # /reg 1D
                        0x1E: [0x1E, READ_WRITE],  # /reg 1E
                        0x1F: [0x1F, READ_WRITE],  # /reg 1F
                        0x20: [0x20, READ_WRITE],  # /reg 20
                        0x21: [0x21, READ_WRITE],  # /reg 21
                        0x22: [0x22, READ_WRITE],  # /reg 22
                        0x23: [0x23, READ_WRITE],  # /reg 23
                        0x24: [0x24, READ_WRITE],  # /reg 24
                        0x25: [0x25, READ_WRITE],  # /reg 25
                        0x26: [0x26, READ_WRITE],  # /reg 26
                        0x27: [0x27, READ_WRITE],  # /reg 27
                        0x28: [0x28, READ_WRITE],  # /reg 28
                        0x29: [0x29, READ_WRITE],  # /reg 29
                        0x2A: [0x2A, READ_WRITE],  # /reg 2A
                        0x2B: [0x2B, READ_WRITE],  # /reg 2B
                        0x2C: [0x2C, READ_WRITE],  # /reg 2C
                        0x2D: [0x2D, READ_WRITE],  # /reg 2D
                        0x2E: [0x2E, READ_WRITE],  # /reg 2E
                        0x2F: [0x2F, READ_WRITE],  # /reg 2F
                        0x30: [0x30, READ_WRITE],  # /reg 30
                        0x31: [0x31, READ_WRITE],  # /reg 31
                        0x32: [0x32, READ_WRITE],  # /reg 32
                        0x33: [0x33, READ_WRITE],  # /reg 33
                        0x34: [0x34, READ_WRITE],  # /reg 34
                        0x35: [0x35, READ_WRITE],  # /reg 35
                        0x36: [0x36, READ_WRITE],  # /reg 36
                        0x37: [0x37, READ_WRITE],  # /reg 37
                        0x38: [0x38, READ_WRITE],  # /reg 38
                        0x39: [0x39, READ_WRITE],  # /reg 39
                        0x3A: [0x3A, READ_WRITE],  # /reg 3A
                        0x3B: [0x3B, READ_WRITE],  # /reg 3B
                        0x3C: [0x3C, READ_WRITE],  # /reg 3C
                        0x3D: [0x3D, READ_WRITE],  # /reg 3D
                        0x3E: [0x3E, READ_WRITE],  # /reg 3E
                        0x3F: [0x3F, READ_WRITE],  # /reg 3F
                        0x40: [0x40, READ_WRITE],  # /reg 40
                        0x41: [0x41, READ_WRITE],  # /reg 41
                        0x42: [0x42, READ_WRITE],  # /reg 42
                        0x43: [0x43, READ_WRITE],  # /reg 43
                        0x44: [0x44, READ_WRITE],  # /reg 44
                        0x45: [0x45, READ_WRITE],  # /reg 45
                        0x46: [0x46, READ_WRITE],  # /reg 46
                        0x47: [0x47, READ_WRITE],  # /reg 47
                        0x48: [0x48, READ_WRITE],  # /reg 48
                        0x49: [0x49, READ_WRITE],  # /reg 49
                        0x4A: [0x4A, READ_WRITE],  # /reg 4A
                        0x4B: [0x4B, READ_WRITE],  # /reg 4B
                        0x4C: [0x4C, READ_WRITE],  # /reg 4C
                        0x4D: [0x4D, READ_WRITE],  # /reg 4D
                        0x4E: [0x4E, READ_WRITE],  # /reg 4E
                        0x4F: [0x4F, READ_WRITE],  # /reg 4F
                        0x50: [0x50, READ_WRITE],  # /reg 50
                        0x51: [0x51, READ_WRITE],  # /reg 51
                        0x52: [0x52, READ_WRITE]}  # /reg 52
                        

    
class DS90UB914A( ALPExtensionModule):
    shortDescription = 'DS90UB914A'
    partnerShortDescription = 'DS90UB913A'

    def __init__( s, *args, **argd):
        ALPExtensionModule.__init__( s, *args, **argd)
        s.devAddr = s.txAddr = 0xC0
        s.rxAddr = 0xB0
        #s.txAddr = []
        #s.txAddr[0] = 0xb0
        s.emulRegs = s.emulRxRegs = s.emulTxRegs = DS90UB914ARegDefaults
       # s.panel = s.mainpanel
	#	FPDLink3_LIB.__init__( s, auiMgr, panel, alpBoards, boardObj)
	#	FPDLink3_GUI.__init__( s, auiMgr, panel, alpBoards, boardObj)    

    def SetDeviceSlaveAddr(s, slaveAddr):
        s.devAddr = slaveAddr

    def ReadReg( s, regIndex):

        if s.demoMode:
            try:
                return s.emulRegs[regIndex][0]
            except IndexError:
                return 0

        if hasattr(s.alpBaseBoard,'shortName'):
            if s.alpBaseBoard.shortName == 'USB2ANY':
                readStatus = s.alpBaseBoard.USB2ANY.i2c_readByteMult(s.devAddr>>1,regIndex,1)
            elif s.alpBaseBoard.shortName == 'Aardvark':
                readValue = s.alpBaseBoard.Aardvark.readI2C(s.devAddr>>1,regIndex,1)
                readStatus = []
                if not readValue:
                    readStatus.append(0)
                else:
                    readStatus.insert(0,1)
                    readStatus.append(readValue.tolist())
            else:
                readStatus = NanoALP.ReadI2C( s.GetALPInterface(), s.devAddr, regIndex, 1)
        else:
            readStatus = NanoALP.ReadI2C( s.GetALPInterface(), s.devAddr, regIndex, 1)

        return int(array( 'B', readStatus[1]).tolist()[0])

    def WriteReg( s, regIndex, regVal):
        if s.demoMode:
            try:
                s.emulRegs[regIndex][0]= regVal
            except IndexError:
                pass
            return

        if hasattr(s.alpBaseBoard,'shortName'):
            if s.alpBaseBoard.shortName == 'USB2ANY':
                s.alpBaseBoard.USB2ANY.i2c_writeByteMult(s.devAddr>>1,regIndex,regVal)
            elif s.alpBaseBoard.shortName == 'Aardvark':
                s.alpBaseBoard.Aardvark.writeI2C(s.devAddr>>1,regIndex,regVal)
            else:
                NanoALP.WriteI2C( s.GetALPInterface(), s.devAddr, regIndex, array( 'B', regVal).tostring())
        else:
            NanoALP.WriteI2C( s.GetALPInterface(), s.devAddr, regIndex, array( 'B', [regVal,]).tostring())

    def ReadI2C( s, devAddr, regIndex, regLength=1):
        if s.demoMode:
            s.rc = 1
            if (regLength == 1):
                if (devAddr == s.devAddr):
                    return s.emulRegs[regIndex][0]
                elif (devAddr == s.rxAddr):
                    return s.emulRxRegs[regIndex][0]
                elif (devAddr == s.txAddr):  #s.txAddr[0]
                    return s.emulTxRegs[regIndex][0]
                else:   # emulate read from missing device
                    s.rc = 0
		    return regIndex
            else:
                readStatus = []
                for i in range(regLength):
                    if (devAddr == s.devAddr):
                        readStatus += [s.emulRegs[regIndex+i][0]]
                    elif (devAddr == s.rxAddr):
                        readStatus += [s.emulRxRegs[regIndex+i][0]]
                    elif (devAddr == s.txAddr):  #s.txAddr[0]
                        readStatus += [s.emulTxRegs[regIndex+i][0]]
                    else:   # emulate read from missing device
		        s.rc = 0
                        readStatus += [regIndex+i]
                return readStatus
         
        if hasattr(s.alpBaseBoard,'shortName'):
            if s.alpBaseBoard.shortName == 'USB2ANY':
                readStatus = s.alpBaseBoard.USB2ANY.i2c_readByteMult(devAddr>>1,regIndex,1)
            elif s.alpBaseBoard.shortName == 'Aardvark':
                readValue = s.alpBaseBoard.Aardvark.readI2C(devAddr>>1,regIndex,1)
                readStatus = []
                if not readValue:
                    readStatus.append(0)
                else:
                    readStatus.insert(0,1)
                    readStatus.append(readValue.tolist())
            else:
                readStatus = NanoALP.ReadI2C( s.GetALPInterface(), devAddr, regIndex, 1)
        else:
            readStatus = NanoALP.ReadI2C( s.GetALPInterface(), devAddr, regIndex, 1)
         
        #readStatus = NanoALP.ReadI2C( s.GetALPInterface(), devAddr, regIndex, regLength)
        s.rc = readStatus[0]
        if (regLength == 1):
            return int(array( 'B', readStatus[1]).tolist()[0])
        else:
            return array( 'B', readStatus[1]).tolist()
            
    # WriteI2C writes to the specified I2C address
    def WriteI2C( s, devAddr, regIndex, regVal):
        if s.demoMode:
            s.rc = 1
	    if (devAddr == s.devAddr):  # Only write if address matches
                try:    # Multi-byte write
                    for i in range(len( regVal)):
                        s.emulRegs[regIndex+i][0]= regVal[i]
                except:
                    s.emulRegs[regIndex][0]= regVal
            elif (devAddr == s.rxAddr):
                try:    # Multi-byte write
                    for i in range(len( regVal)):
                        s.emulRxRegs[regIndex+i][0]= regVal[i]
                except:
                    s.emulRxRegs[regIndex][0]= regVal
            elif (devAddr == s.txAddr[0]):
                try:    # Multi-byte write
                    for i in range(len( regVal)):
                        s.emulTxRegs[regIndex+i][0]= regVal[i]
                except:
                    s.emulTxRegs[regIndex][0]= regVal
	    else:
		s.rc = 0
            return
        try:    # Do multi-byte write
            len(regVal)
            reg_list = regVal
        except:
            reg_list = [regVal,]
        
        if hasattr(s.alpBaseBoard,'shortName'):
            if s.alpBaseBoard.shortName == 'USB2ANY':
                s.alpBaseBoard.USB2ANY.i2c_writeByteMult(devAddr>>1,regIndex,regVal)
            elif s.alpBaseBoard.shortName == 'Aardvark':
                s.alpBaseBoard.Aardvark.writeI2C(devAddr>>1,regIndex,regVal)
            else:
                NanoALP.WriteI2C( s.GetALPInterface(), devAddr, regIndex, array( 'B', regVal).tostring())
        else:
            NanoALP.WriteI2C( s.GetALPInterface(), devAddr, regIndex, array( 'B', [regVal,]).tostring())



    def Deinit( s):
        """Called to cleanup state and resources when we're being unloaded."""
        pass
        
    def GetLinkStatus(s):
        # Cable link detect
        if s.demoMode:
            return 1
        # link = s.ReadRXReg(0x00) #Check if the slave's DES ID is the same as the local Device ID
         #Check bit 0 of register 0x1C
        elif ((s.ReadReg(0x1C) & 0x01) == 0x01):
            return s.ReadReg(0x06)
        else:
            return 0x00

     # ReadRXReg reads from the I2C address specified in register 0x07
    def ReadRXReg( s, regIndex, regLength=1):
        readVal = s.ReadI2C(s.rxAddr, regIndex, regLength)
        return readVal
        
