"""
DS90UB953_ENG_Lib.py


Copyright (c) Texas Instruments Incorporated.
All Rights Reserved.
"""

import os
import sys
import time
import NanoALP
from array import array
from ALPExtensionModule import ALPExtensionModule

# List of register lists that specify the default value and access type for the reg.
# When WriteReg is called below the access type is checked and applied to the operation.
READ_WRITE = 0x1
READ_ONLY  = 0x0

# ID Code Strings
UB953_ID_CODE    = [0x5F, 0x55, 0x42, 0x39, 0x35, 0x33]   # "_UB953"
UB934_ID_CODE    = [0x5F, 0x55, 0x42, 0x39, 0x33, 0x34]   # "_UB934"
UB954_ID_CODE    = [0x5F, 0x55, 0x42, 0x39, 0x35, 0x34]   # "_UB954"
UB964_ID_CODE    = [0x5F, 0x55, 0x42, 0x39, 0x36, 0x34]   # "_UB964"
UB960_ID_CODE    = [0x5F, 0x55, 0x42, 0x39, 0x36, 0x30]   # "_UB960"

DS90UB953_RegDefaults = {0x00: [0x00, READ_WRITE],  # /reg 0
                        0x01: [0x01, READ_WRITE],  # /reg 01
                        0x02: [0x02, READ_WRITE],  # /reg 02
                        0x03: [0x03, READ_WRITE],  # /reg 03
                        0x04: [0x04, READ_WRITE],  # /reg 04
                        0x05: [0x05, READ_WRITE],  # /reg 05
                        0x06: [0x06, READ_WRITE],  # /reg 06
                        0x07: [0x07, READ_WRITE],  # /reg 07
                        0x08: [0x08, READ_WRITE],  # /reg 08
                        0x09: [0x09, READ_WRITE],  # /reg 09
                        0x0A: [0x0A, READ_WRITE],  # /reg 0A
                        0x0B: [0x0B, READ_WRITE],  # /reg 0B
                        0x0C: [0x0C, READ_WRITE],  # /reg 0C
                        0x0D: [0x0D, READ_WRITE],  # /reg 0D
                        0x0E: [0x0E, READ_WRITE],  # /reg 0E
                        0x0F: [0x0F, READ_WRITE],  # /reg 0F
                        0x10: [0x10, READ_WRITE],  # /reg 10
                        0x11: [0x11, READ_WRITE],  # /reg 11
                        0x12: [0x12, READ_WRITE],  # /reg 12
                        0x13: [0x13, READ_WRITE],  # /reg 13
                        0x14: [0x14, READ_WRITE],  # /reg 14
                        0x15: [0x15, READ_WRITE],  # /reg 15
                        0x16: [0x16, READ_WRITE],  # /reg 16
                        0x17: [0x17, READ_WRITE],  # /reg 17
                        0x18: [0x18, READ_WRITE],  # /reg 18
                        0x19: [0x19, READ_WRITE],  # /reg 19
                        0x1A: [0x1A, READ_WRITE],  # /reg 1A
                        0x1B: [0x1B, READ_WRITE],  # /reg 1B
                        0x1C: [0x1C, READ_WRITE],  # /reg 1C
                        0x1D: [0x1D, READ_WRITE],  # /reg 1D
                        0x1E: [0x1E, READ_WRITE],  # /reg 1E
                        0x1F: [0x1F, READ_WRITE],  # /reg 1F
                        0x20: [0x20, READ_WRITE],  # /reg 20
                        0x21: [0x21, READ_WRITE],  # /reg 21
                        0x22: [0x22, READ_WRITE],  # /reg 22
                        0x23: [0x23, READ_WRITE],  # /reg 23
                        0x24: [0x24, READ_WRITE],  # /reg 24
                        0x25: [0x25, READ_WRITE],  # /reg 25
                        0x26: [0x26, READ_WRITE],  # /reg 26
                        0x27: [0x27, READ_WRITE],  # /reg 27
                        0x28: [0x28, READ_WRITE],  # /reg 28
                        0x29: [0x29, READ_WRITE],  # /reg 29
                        0x2A: [0x2A, READ_WRITE],  # /reg 2A
                        0x2B: [0x2B, READ_WRITE],  # /reg 2B
                        0x2C: [0x2C, READ_WRITE],  # /reg 2C
                        0x2D: [0x2D, READ_WRITE],  # /reg 2D
                        0x2E: [0x2E, READ_WRITE],  # /reg 2E
                        0x2F: [0x2F, READ_WRITE],  # /reg 2F
                        0x30: [0x30, READ_WRITE],  # /reg 30
                        0x31: [0x31, READ_WRITE],  # /reg 31
                        0x32: [0x32, READ_WRITE],  # /reg 32
                        0x33: [0x33, READ_WRITE],  # /reg 33
                        0x34: [0x34, READ_WRITE],  # /reg 34
                        0x35: [0x35, READ_WRITE],  # /reg 35
                        0x36: [0x36, READ_WRITE],  # /reg 36
                        0x37: [0x37, READ_WRITE],  # /reg 37
                        0x38: [0x38, READ_WRITE],  # /reg 38
                        0x39: [0x39, READ_WRITE],  # /reg 39
                        0x3A: [0x3A, READ_WRITE],  # /reg 3A
                        0x3B: [0x3B, READ_WRITE],  # /reg 3B
                        0x3C: [0x3C, READ_WRITE],  # /reg 3C
                        0x3D: [0x3D, READ_WRITE],  # /reg 3D
                        0x3E: [0x3E, READ_WRITE],  # /reg 3E
                        0x3F: [0x3F, READ_WRITE],  # /reg 3F
                        0x40: [0x40, READ_WRITE],  # /reg 40
                        0x41: [0x41, READ_WRITE],  # /reg 41
                        0x42: [0x42, READ_WRITE],  # /reg 42
                        0x43: [0x43, READ_WRITE],  # /reg 43
                        0x44: [0x44, READ_WRITE],  # /reg 44
                        0x45: [0x45, READ_WRITE],  # /reg 45
                        0x46: [0x46, READ_WRITE],  # /reg 46
                        0x47: [0x47, READ_WRITE],  # /reg 47
                        0x48: [0x48, READ_WRITE],  # /reg 48
                        0x49: [0x49, READ_WRITE],  # /reg 49
                        0x4A: [0x4A, READ_WRITE],  # /reg 4A
                        0x4B: [0x4B, READ_WRITE],  # /reg 4B
                        0x4C: [0x4C, READ_WRITE],  # /reg 4C
                        0x4D: [0x4D, READ_WRITE],  # /reg 4D
                        0x4E: [0x4E, READ_WRITE],  # /reg 4E
                        0x4F: [0x4F, READ_WRITE],  # /reg 4F
                        0x50: [0x50, READ_WRITE],  # /reg 50
                        0x51: [0x51, READ_WRITE],  # /reg 51
                        0x52: [0x52, READ_WRITE],  # /reg 52
                        0x53: [0x53, READ_WRITE],  # /reg 53
                        0x54: [0x54, READ_WRITE],  # /reg 54
                        0x55: [0x55, READ_WRITE],  # /reg 55
                        0x56: [0x56, READ_WRITE],  # /reg 56
                        0x57: [0x57, READ_WRITE],  # /reg 57
                        0x58: [0x58, READ_WRITE],  # /reg 58
                        0x59: [0x59, READ_WRITE],  # /reg 59
                        0x5A: [0x5A, READ_WRITE],  # /reg 5A
                        0x5B: [0x5B, READ_WRITE],  # /reg 5B
                        0x5C: [0x5C, READ_WRITE],  # /reg 5C
                        0x5D: [0x5D, READ_WRITE],  # /reg 5D
                        0x5E: [0x5E, READ_WRITE],  # /reg 5E
                        0x5F: [0x5F, READ_WRITE],  # /reg 5F
                        0x60: [0x60, READ_WRITE],  # /reg 60
                        0x61: [0x61, READ_WRITE],  # /reg 61
                        0x62: [0x62, READ_WRITE],  # /reg 62
                        0x63: [0x63, READ_WRITE],  # /reg 63
                        0x64: [0x64, READ_WRITE],  # /reg 64
                        0x65: [0x65, READ_WRITE],  # /reg 65
                        0x66: [0x66, READ_WRITE],  # /reg 66
                        0x67: [0x67, READ_WRITE],  # /reg 67
                        0x68: [0x68, READ_WRITE],  # /reg 68
                        0x69: [0x69, READ_WRITE],  # /reg 69
                        0x6A: [0x6A, READ_WRITE],  # /reg 6A
                        0x6B: [0x6B, READ_WRITE],  # /reg 6B
                        0x6C: [0x6C, READ_WRITE],  # /reg 6C
                        0x6D: [0x6D, READ_WRITE],  # /reg 6D
                        0x6E: [0x6E, READ_WRITE],  # /reg 6E
                        0x6F: [0x6F, READ_WRITE],  # /reg 6F
                        0x70: [0x70, READ_WRITE],  # /reg 70
                        0x71: [0x71, READ_WRITE],  # /reg 71
                        0x72: [0x72, READ_WRITE],  # /reg 72
                        0x73: [0x73, READ_WRITE],  # /reg 73
                        0x74: [0x74, READ_WRITE],  # /reg 74
                        0x75: [0x75, READ_WRITE],  # /reg 75
                        0x76: [0x76, READ_WRITE],  # /reg 76
                        0x77: [0x77, READ_WRITE],  # /reg 77
                        0x78: [0x78, READ_WRITE],  # /reg 78
                        0x79: [0x79, READ_WRITE],  # /reg 79
                        0x7A: [0x7A, READ_WRITE],  # /reg 7A
                        0x7B: [0x7B, READ_WRITE],  # /reg 7B
                        0x7C: [0x7C, READ_WRITE],  # /reg 7C
                        0x7D: [0x7D, READ_WRITE],  # /reg 7D
                        0x7E: [0x7E, READ_WRITE],  # /reg 7E
                        0x7F: [0x7F, READ_WRITE],  # /reg 7F
                        0x80: [0x80, READ_WRITE],  # /reg 80
                        0x81: [0x81, READ_WRITE],  # /reg 81
                        0x82: [0x82, READ_WRITE],  # /reg 82
                        0x83: [0x83, READ_WRITE],  # /reg 83
                        0x84: [0x84, READ_WRITE],  # /reg 84
                        0x85: [0x85, READ_WRITE],  # /reg 85
                        0x86: [0x86, READ_WRITE],  # /reg 86
                        0x87: [0x87, READ_WRITE],  # /reg 87
                        0x88: [0x88, READ_WRITE],  # /reg 88
                        0x89: [0x89, READ_WRITE],  # /reg 89
                        0x8A: [0x8A, READ_WRITE],  # /reg 8A
                        0x8B: [0x8B, READ_WRITE],  # /reg 8B
                        0x8C: [0x8C, READ_WRITE],  # /reg 8C
                        0x8D: [0x8D, READ_WRITE],  # /reg 8D
                        0x8E: [0x8E, READ_WRITE],  # /reg 8E
                        0x8F: [0x8F, READ_WRITE],  # /reg 8F
                        0x90: [0x90, READ_WRITE],  # /reg 90
                        0x91: [0x91, READ_WRITE],  # /reg 91
                        0x92: [0x92, READ_WRITE],  # /reg 92
                        0x93: [0x93, READ_WRITE],  # /reg 93
                        0x94: [0x94, READ_WRITE],  # /reg 94
                        0x95: [0x95, READ_WRITE],  # /reg 95
                        0x96: [0x96, READ_WRITE],  # /reg 96
                        0x97: [0x97, READ_WRITE],  # /reg 97
                        0x98: [0x98, READ_WRITE],  # /reg 98
                        0x99: [0x99, READ_WRITE],  # /reg 99
                        0x9A: [0x9A, READ_WRITE],  # /reg 9A
                        0x9B: [0x9B, READ_WRITE],  # /reg 9B
                        0x9C: [0x9C, READ_WRITE],  # /reg 9C
                        0x9D: [0x9D, READ_WRITE],  # /reg 9D
                        0x9E: [0x9E, READ_WRITE],  # /reg 9E
                        0x9F: [0x9F, READ_WRITE],  # /reg 9F
                        0xA0: [0xA0, READ_WRITE],  # /reg A0
                        0xA1: [0xA1, READ_WRITE],  # /reg A1
                        0xA2: [0xA2, READ_WRITE],  # /reg A2
                        0xA3: [0xA3, READ_WRITE],  # /reg A3
                        0xA4: [0xA4, READ_WRITE],  # /reg A4
                        0xA5: [0xA5, READ_WRITE],  # /reg A5
                        0xA6: [0xA6, READ_WRITE],  # /reg A6
                        0xA7: [0xA7, READ_WRITE],  # /reg A7
                        0xA8: [0xA8, READ_WRITE],  # /reg A8
                        0xA9: [0xA9, READ_WRITE],  # /reg A9
                        0xAA: [0xAA, READ_WRITE],  # /reg AA
                        0xAB: [0xAB, READ_WRITE],  # /reg AB
                        0xAC: [0xAC, READ_WRITE],  # /reg AC
                        0xAD: [0xAD, READ_WRITE],  # /reg AD
                        0xAE: [0xAE, READ_WRITE],  # /reg AE
                        0xAF: [0xAF, READ_WRITE],  # /reg AF
                        0xB0: [0xB0, READ_WRITE],  # /reg B0
                        0xB1: [0xB1, READ_WRITE],  # /reg B1
                        0xB2: [0xB2, READ_WRITE],  # /reg B2
                        0xB3: [0xB3, READ_WRITE],  # /reg B3
                        0xB4: [0xB4, READ_WRITE],  # /reg B4
                        0xB5: [0xB5, READ_WRITE],  # /reg B5
                        0xB6: [0xB6, READ_WRITE],  # /reg B6
                        0xB7: [0xB7, READ_WRITE],  # /reg B7
                        0xB8: [0xB8, READ_WRITE],  # /reg B8
                        0xB9: [0xB9, READ_WRITE],  # /reg B9
                        0xBA: [0xBA, READ_WRITE],  # /reg BA
                        0xBB: [0xBB, READ_WRITE],  # /reg BB
                        0xBC: [0xBC, READ_WRITE],  # /reg BC
                        0xBD: [0xBD, READ_WRITE],  # /reg BD
                        0xBE: [0xBE, READ_WRITE],  # /reg BE
                        0xBF: [0xBF, READ_WRITE],  # /reg BF
                        0xC0: [0xC0, READ_WRITE],  # /reg C0
                        0xC1: [0xC1, READ_WRITE],  # /reg C1
                        0xC2: [0xC2, READ_WRITE],  # /reg C2
                        0xC3: [0xC3, READ_WRITE],  # /reg C3
                        0xC4: [0xC4, READ_WRITE],  # /reg C4
                        0xC5: [0xC5, READ_WRITE],  # /reg C5
                        0xC6: [0xC6, READ_WRITE],  # /reg C6
                        0xC7: [0xC7, READ_WRITE],  # /reg C7
                        0xC8: [0xC8, READ_WRITE],  # /reg C8
                        0xC9: [0xC9, READ_WRITE],  # /reg C9
                        0xCA: [0xCA, READ_WRITE],  # /reg CA
                        0xCB: [0xCB, READ_WRITE],  # /reg CB
                        0xCC: [0xCC, READ_WRITE],  # /reg CC
                        0xCD: [0xCD, READ_WRITE],  # /reg CD
                        0xCE: [0xCE, READ_WRITE],  # /reg CE
                        0xCF: [0xCF, READ_WRITE],  # /reg CF
                        0xD0: [0xD0, READ_WRITE],  # /reg D0
                        0xD1: [0xD1, READ_WRITE],  # /reg D1
                        0xD2: [0xD2, READ_WRITE],  # /reg D2
                        0xD3: [0xD3, READ_WRITE],  # /reg D3
                        0xD4: [0xD4, READ_WRITE],  # /reg D4
                        0xD5: [0xD5, READ_WRITE],  # /reg D5
                        0xD6: [0xD6, READ_WRITE],  # /reg D6
                        0xD7: [0xD7, READ_WRITE],  # /reg D7
                        0xD8: [0xD8, READ_WRITE],  # /reg D8
                        0xD9: [0xD9, READ_WRITE],  # /reg D9
                        0xDA: [0xDA, READ_WRITE],  # /reg DA
                        0xDB: [0xDB, READ_WRITE],  # /reg DB
                        0xDC: [0xDC, READ_WRITE],  # /reg DC
                        0xDD: [0xDD, READ_WRITE],  # /reg DD
                        0xDE: [0xDE, READ_WRITE],  # /reg DE
                        0xDF: [0xDF, READ_WRITE],  # /reg DF
                        0xE0: [0xE0, READ_WRITE],  # /reg E0
                        0xE1: [0xE1, READ_WRITE],  # /reg E1
                        0xE2: [0xE2, READ_WRITE],  # /reg E2
                        0xE3: [0xE3, READ_WRITE],  # /reg E3
                        0xE4: [0xE4, READ_WRITE],  # /reg E4
                        0xE5: [0xE5, READ_WRITE],  # /reg E5
                        0xE6: [0xE6, READ_WRITE],  # /reg E6
                        0xE7: [0xE7, READ_WRITE],  # /reg E7
                        0xE8: [0xE8, READ_WRITE],  # /reg E8
                        0xE9: [0xE9, READ_WRITE],  # /reg E9
                        0xEA: [0xEA, READ_WRITE],  # /reg EA
                        0xEB: [0xEB, READ_WRITE],  # /reg EB
                        0xEC: [0xEC, READ_WRITE],  # /reg EC
                        0xED: [0xED, READ_WRITE],  # /reg ED
                        0xEE: [0xEE, READ_WRITE],  # /reg EE
                        0xEF: [0xEF, READ_WRITE],  # /reg EF
                        0xF0: [0xF0, READ_WRITE],  # /reg F0
                        0xF1: [0xF1, READ_WRITE],  # /reg F1
                        0xF2: [0xF2, READ_WRITE],  # /reg F2
                        0xF3: [0xF3, READ_WRITE],  # /reg F3
                        0xF4: [0xF4, READ_WRITE],  # /reg F4
                        0xF5: [0xF5, READ_WRITE],  # /reg F5
                        0xF6: [0xF6, READ_WRITE],  # /reg F6
                        0xF7: [0xF7, READ_WRITE],  # /reg F7
                        0xF8: [0xF8, READ_WRITE],  # /reg F8
                        0xF9: [0xF9, READ_WRITE],  # /reg F9
                        0xFA: [0xFA, READ_WRITE],  # /reg FA
                        0xFB: [0xFB, READ_WRITE],  # /reg FB
                        0xFC: [0xFC, READ_WRITE],  # /reg FC
                        0xFD: [0xFD, READ_WRITE],  # /reg FD
                        0xFE: [0xFE, READ_WRITE],  # /reg FE
                        0xFF: [0xFF, READ_WRITE],  # /reg FF
}

class DS90UB953_Const:
    def __init__( s):
        # ----- REGISTERS
        s.I2C_DEVICE_ID     = 0x00
        s.DEVICE_ID                 = 0xFE
        s.SER_ID_OVERRIDE           = 0x01
        s.RESET_CTL         = 0x01
        s.RESTART_AUTOLOAD          = 0x04
        s.DIGITAL_RESET1            = 0x02
        s.DIGITAL_RESET0            = 0x01
        s.GENERAL_CFG       = 0x02
        s.CONTS_CLK                 = 0x40
        s.CSI_LANE_SEL              = 0x30
        s.CRC_TX_GEN_EN             = 0x02
        s.SEL_1P8                   = 0x01
        s.MODE_SEL          = 0x03
        s.FPD_COAX_MODE_OV          = 0x80
        s.FPD_COAX_MODE             = 0x40
        s.MODE_OV                   = 0x10
        s.MODE_DONE                 = 0x08
        s.MODE                      = 0x07
        s.MODE_CSI0                 = 0x00  # CSI sync mode
        s.MODE_CSI1                 = 0x01  # CSI w/ CSI clk mode
        s.MODE_CSI2                 = 0x02  # CSI async mode ext clk
        s.MODE_CSI3                 = 0x03  # CSI async mode AON clk
        s.MODE_DVP4                 = 0x04  # DVP CSI clk mode
        s.MODE_DVP5                 = 0x05  # DVP ext clk mode
        s.MODE_MASK                 = 0x07  # Bit mask for mode
        s.BC_MODE_SELECT    = 0x04
        s.MODE_OVERWRITE_100m       = 0x03
        s.MODE_OVERWRITE_75m        = 0x02
        s.MODE_913_OVERWRITE        = 0x01
        s.PLLCLK_CTRL       = 0x05
        s.CLKIN_DIVIDER             = 0x70
        s.OSCCLK_SEL                = 0x08
        s.CSI0_CLK_DIV_SEL          = 0x07
        s.CLKOUT_CTRL0      = 0x06
        s.HSPLL_VCOCLK_DIV         = 0xE0
        s.DIV_M_VAL                 = 0x1F
        s.CLKOUT_CTRL1      = 0x07
        s.DIV_N_VAL                 = 0xFF
        s.BCC_WATCHDOG      = 0x08
        s.BCC_WD_TIMER              = 0xFE
        s.BCC_WD_TIMER_DISABLE      = 0x01
        s.I2C_CONTROL1      = 0x09
        s.LCL_WRITE_DISABLE         = 0x04
        s.I2C_SDA_HOLD         = 0x70
        s.I2C_FILTER_DEPTH         = 0x0F
        s.I2C_CONTROL2       = 0x0A
        s.SDA_Output_Setup         = 0xF0
        s.SDA_Output_Delay         = 0x0C
        s.I2C_BUS_TIMER_SPEEDUP         = 0x02
        s.I2C_BUS_TIMER_DISABLE         = 0x01
        s.SCL_HIGH_TIME     = 0x0B
        s.SCL_HIGH_TIME         = 0xFF
        s.SCL_LOW_TIME      = 0x0C
        s.SCL_LOW_TIME             = 0xFF
        s.LOCAL_GPIO_DATA    = 0x0D
        s.GPIO_RMTEN                = 0xF0
        s.GPIO_STS                  = 0x0F
        s.GPIO_INPUT_CTL     = 0x0E
        s.GPIO3_OUT_EN            = 0x80
        s.GPIO2_OUT_EN            = 0x40
        s.GPIO1_OUT_EN           = 0x20
        s.GPIO0_OUT_EN           = 0x10
        s.GPIO3_INPUT_EN         = 0x08
        s.GPIO2_INPUT_EN         = 0x03
        s.GPIO1_INPUT_EN         = 0x02
        s.GPIO0_INPUT_EN         = 0x01
        s.GPIO_ATP_CTL         = 0x0F
        s.GPIO3_ATP_EN         = 0x08
        s.GPIO2_ATP_EN         = 0x03
        s.GPIO1_ATP_EN         = 0x02
        s.GPIO0_ATP_EN         = 0x01
        s.DVP_CFG         = 0x10
        s.dvp_dt_any_en         = 0x10
        s.dvp_dt_match_en         = 0x08
        s.dvp_dt_yuv_en         = 0x03
        s.dvp_fv_in         = 0x02
        s.dvp_lv_inv         = 0x01
        s.DVP_DT         = 0x11
        s.dvp_dt_match_val         = 0x3F
        s.ENCODER_SELECT         = 0x12
        s.BYP_FIFO         = 0x40
        s.BYP_PLLCLOCK         = 0x20
        s.DIS_130COUNTER         = 0x10
        s.DIS_DCA         = 0x08
        s.DIS_DCB         = 0x03
        s.DIS_RANDOMIZE         = 0x02
        s.DIS_SCRAMBLE         = 0x01
        s.FORCE_BIST_ERR         = 0x13
        s.FORCE_FC_ERR         = 0x80
        s.FORCE_ERR_CNT         = 0x7F
        s.REMOTE_BIST_CTRL         = 0x14
        s.LOCAL_BIST_EN         = 0x08
        s.BIST_CLOCK         = 0x06
        s.REMOTE_BIST_EN         = 0x01
        s.SENSOR_VGAIN         = 0x15
        s.VOLT_GAIN         = 0x7F
        s.SENSOR_TGAIN         = 0x16
        s.TEMP_GAIN         = 0x7F
        s.SENSOR_CTRL0         = 0x17
        s.SENSE_RSTN_OV         = 0x80
        s.SENSE_RSTN         = 0x40
        s.SENSE_IBIAS_EN         = 0x20
        s.SENSE_PTAT_EN         = 0x10
        s.SENSE_T_EN         = 0x08
        s.SENSE_V_EN         = 0x03
        s.SENSE_V_GPIO         = 0x03
        s.SENSOR_CTRL1         = 0x18
        s.SENSE_GAIN_EN         = 0x80
        s.SENSE_VSEL_OV         = 0x40
        s.SENSE_VSEL         = 0x20
        s.SENSE_V_INPUT_OV         = 0x10
        s.SENSE_V_INPUT         = 0x0F
        s.SENSOR_V0_THRESH         = 0x19
        s.SENSE_V0_HI         = 0x70
        s.SENSE_V0_LO         = 0x07
        s.SENSOR_V1_THRESH         = 0x1A
        s.SENSE_V1_HI         = 0x70
        s.SENSE_V1_LO         = 0x07
        s.SENSOR_T_THRESH         = 0x1B
        s.SENSE_T_HI         = 0x70
        s.SENSE_T_LO         = 0x07
        s.ALARM_CSI_EN         = 0x1C
        s.CSI_NO_FV_EN         = 0x20
        s.DPHY_SYNC_ERR_EN         = 0x10
        s.DPHY_CTRL_ERR_EN         = 0x08
        s.CSI_ECC_2_EN         = 0x03
        s.CSI_CHKSUM_ERR_EN         = 0x02
        s.CSI_LENGTH_ERR_EN         = 0x01
        s.ALARM_SENSE_EN         = 0x1D
        s.T_OVER         = 0x20
        s.T_UNDER         = 0x10
        s.V1_OVER         = 0x08
        s.V1_UNDER         = 0x03
        s.V0_OVER         = 0x02
        s.V0_UNDER         = 0x01
        s.ALARM_BC_EN         = 0x1E
        s.BCC_SLAVE_TO_ERROR_EN         = 0x40
        s.BCC_SLAVE_ERROR_EN         = 0x20
        s.BCC_MSTR_TO_ERROR_EN         = 0x10
        s.BCC_MSTR_ERROR_EN         = 0x08
        s.BCC_DATA_ERROR_EN         = 0x03
        s.CRC_ERR_EN         = 0x02
        s.LINK_DETECT_EN         = 0x01
        s.CSI_POL_SEL         = 0x20
        s.STRB_RST_N         = 0x20
        s.POLARITY_CLK0         = 0x10
        s.POLARITY_D3         = 0x08
        s.POLARITY_D2         = 0x03
        s.POLARITY_D1         = 0x02
        s.POLARITY_D0         = 0x01
        s.CSI_LP_POLARITY         = 0x21
        s.POL_LP_CLK0         = 0x10
        s.POL_LP_DATA         = 0x0F
        s.CSI_EN_HSRX         = 0x22
        s.EN_HSRX_OV         = 0x40
        s.EN_HSRX_CLK0         = 0x10
        s.EN_HSRX_D3         = 0x08
        s.EN_HSRX_D2         = 0x03
        s.EN_HSRX_D1         = 0x02
        s.EN_HSRX_D0         = 0x01
        s.CSI_EN_LPRX_         = 0x23
        s.EN_LPRX_OV         = 0x40
        s.EN_LPRX_CLK0         = 0x10
        s.EN_LPRX_D3         = 0x08
        s.EN_LPRX_D2         = 0x03
        s.EN_LPRX_D1         = 0x02
        s.EN_LPRX_D0         = 0x01
        s.CSI_EN_RXTERM_         = 0x24
        s.EN_RXTERM_OV         = 0x40
        s.EN_RXTERM_CLK0         = 0x10
        s.EN_RXTERM_D3         = 0x08
        s.EN_RXTERM_D2         = 0x03
        s.EN_RXTERM_D1         = 0x02
        s.EN_RXTERM_D0         = 0x01
        s.CSI_CLK_DLY_STAGE01         = 0x25
        s.CSI_CLK_DLY_STAGE23         = 0x26
        s.CSI_CLK_DLY_STAGE4         = 0x27
        s.CSI_STG0_DATA_DLY_L01         = 0x28
        s.CSI_STG0_DATA_DLY_L23         = 0x29
        s.CSI_STG1_DATA_DLY_L01         = 0x2A
        s.CSI_STG1_DATA_DLY_L23         = 0x2B
        s.CSI_STG2_DATA_DLY_L01         = 0x2C
        s.CSI_STG2_DATA_DLY_L23         = 0x2D
        s.CSI_TERM_TIMING         = 0x2E
        s.CSI_TERM_CLK_OV         = 0x80
        s.CSI_TERM_CLK_TIMING         = 0x70
        s.CSI_TERM_DATA_OV         = 0x08
        s.CSI_TERM_DATA_TIMING         = 0x07
        s.CSI_CLK_SETTLE_TIMING         = 0x2F
        s.OV         = 0x80
        s.TCLK_SETTLE_CNT         = 0x7F
        s.CSI_D_SETTLE_TIMING         = 0x30
        s.OV         = 0x80
        s.TD_SETTLE_CNT         = 0x1F
        s.CSI_PKT_HDR_TINIT_CTRL         = 0x31
        s.PKT_HDR_SEL_VC         = 0xC0
        s.PKT_HDR_CORRECTED         = 0x20
        s.PKT_HDR_VCI_ENABLE         = 0x10
        s.SPARE         = 0x08
        s.TINIT_TIME         = 0x07
        s.BCC_CONFIG         = 0x32
        s.I2C_PASS_THROUGH_ALL         = 0x80
        s.I2C_PASS_THROUGH         = 0x40
        s.AUTO_ACK_ALL         = 0x20
        s.BCC_TERM_ON_ERR         = 0x10
        s.RX_PARITY_CHECKER_ENABLE         = 0x08
        s.BCC_ACK_REMOTE_READ         = 0x03
        s.BCC_EN_DATA_CHK         = 0x02
        s.BCC_EN_ENH_ERROR         = 0x01
        s.DATAPATH_CTL1         = 0x33
        s.DCA_CRC_EN         = 0x03
        s.FC_GPIO_EN         = 0x03
        s.DATAPATH_CTL2         = 0x34
        s.FC_ECC_BCC_ONLY         = 0x08
        s.FC_ECC_GPIO         = 0x03
        s.FC_ECC         = 0x03
        s.REMOTE_PAR_CAP1         = 0x35
        s.FREEZE_DES_CAP         = 0x80
        s.ECC_CAP         = 0x40
        s.BIST_EN         = 0x20
        s.MPORT         = 0x10
        s.PORT_NUM         = 0x0F
        s.REMOTE_PAR_CAP2         = 0x36
        s.ECC_GPIO_CAP         = 0x02
        s.ECC_CAP         = 0x01
        s.DES_ID         = 0x37
        s.SER_ID         = 0xFE
        s.FREEZE_DEVICE_ID         = 0x01
        s.DES_ALIAS_ID         = 0x38
        s.DES_ALIAS_ID         = 0xFE
        s.DES_AUTO_ACK         = 0x01
        s.SLAVE_ID_0         = 0x39
        s.SLAVE_ID_1         = 0x3A
        s.SLAVE_ID_2         = 0x3B
        s.SLAVE_ID_3         = 0x3C
        s.SLAVE_ID_4         = 0x3D
        s.SLAVE_ID_5         = 0x3E
        s.SLAVE_ID_6         = 0x3F
        s.SLAVE_ID_7         = 0x40
        s.SLAVE_ID_ALIAS_0         = 0x41
        s.SLAVE_AUTO_ACK_0         = 0x01
        s.SLAVE_ID_ALIAS_1         = 0x42
        s.SLAVE_AUTO_ACK_1         = 0x01
        s.SLAVE_ID_ALIAS_2         = 0x43
        s.SLAVE_AUTO_ACK_2         = 0x01
        s.SLAVE_ID_ALIAS_3         = 0x44
        s.SLAVE_AUTO_ACK_3         = 0x01
        s.SLAVE_ID_ALIAS_4         = 0x45
        s.SLAVE_AUTO_ACK_4         = 0x01
        s.SLAVE_ID_ALIAS_5         = 0x46
        s.SLAVE_AUTO_ACK_5         = 0x01
        s.SLAVE_ID_ALIAS_6         = 0x47
        s.SLAVE_AUTO_ACK_6         = 0x01
        s.SLAVE_ID_ALIAS_7         = 0x48
        s.SLAVE_AUTO_ACK_7         = 0x01
        s.BC_CTRL         = 0x49
        s.BIST_CRC_ERR_CLR         = 0x20
        s.AUTO_CRC_ERR_CLR_DIS         = 0x10
        s.CRC_ERR_CLR         = 0x08
        s.LINK_DET_TIMER         = 0x07
        s.REV_MASK_ID         = 0xF0
        s.REVISION_ID         = 0x50
        s.MASK_ID         = 0x0F
        s.DEVICE_STS         = 0x51
        s.CFG_CKSUM_STS         = 0x80
        s.CFG_INIT_DONE         = 0x40
        s.DEV1_BOND_OPTION         = 0x02
        s.DEV0_BOND_OPTION         = 0x01
        s.GENERAL_STATUS         = 0x52
        s.RX_LOCK_DETECT         = 0x40
        s.BCC_ERROR         = 0x20
        s.LINK_LOST_FLAG         = 0x10
        s.BIST_CRC_ERR         = 0x08
        s.HS_PLL_LOCK         = 0x03
        s.CRC_ERR         = 0x02
        s.LINK_DET         = 0x01
        s.GPIO_PIN_STS         = 0x53
        s.GPIO_STS         = 0x0F
        s.BIST_ERR_CNT         = 0x54
        s.bist_bc_errcnt         = 0xFF
        s.CRC_ERR_CNT1         = 0x55
        s.crc_errcnt1         = 0xFF
        s.CRC_ERR_CNT2         = 0x56
        s.crc_errcnt2         = 0xFF
        s.SENSOR_STATUS         = 0x57
        s.SENSOR_STATUS         = 0xC0
        s.TEMP_SENSOR_HI_         = 0x20
        s.TEMP_SENSOR_LOW         = 0x10
        s.V1_SENSOR_HI_         = 0x08
        s.V1_SENSOR_LOW         = 0x03
        s.V0_SENSOR_HI_         = 0x02
        s.V0_SENSOR_LOW         = 0x01
        s.SENSOR_V0         = 0x58
        s.VOLTAGE_SENSOR_V0_MAX         = 0x70
        s.VOLTAGE_SENSOR_V0_MIN         = 0x07
        s.SENSOR_V1         = 0x59
        s.VOLTAGE_SENSOR_V1_MAX         = 0x70
        s.VOLTAGE_SENSOR_V1_MIN         = 0x07
        s.SENSOR_T         = 0x5A
        s.TEMP_MAX         = 0x70
        s.TEMP_MIN         = 0x07
        s.DVP_ERR         = 0x5B
        s.dvp_bad_dt         = 0x02
        s.dvp_fifo_under         = 0x01
        s.CSI_ERR_CNT         = 0x5C
        s.CSI_ERR_CNT         = 0xFF
        s.CSI_ERR_STATUS         = 0x5D
        s.LINE_LEN_MISMATCH         = 0x08
        s.CHKSUM_ERR         = 0x03
        s.ECC_2BIT_ERR         = 0x02
        s.ECC_1BIT_ERR         = 0x01
        s.CSI_ERR_DLANE01         = 0x5E
        s.SOT_ERROR_1         = 0x80
        s.SOT_SYNC_ERROR_1         = 0x40
        s.CNTRL_ERR_HSRQST_1         = 0x20
        s.LP_INVALID_ERR_1         = 0x10
        s.SOT_ERROR_0         = 0x08
        s.SOT_SYNC_ERROR_0         = 0x03
        s.CNTRL_ERR_HSRQST_0         = 0x02
        s.LP_INVALID_ERR_0         = 0x01
        s.CSI_ERR_DLANE23         = 0x5F
        s.SOT_ERROR_3         = 0x80
        s.SOT_SYNC_ERROR_3         = 0x40
        s.CNTRL_ERR_HSRQST_3         = 0x20
        s.LP_INVALID_ERR_3         = 0x10
        s.SOT_ERROR_2         = 0x08
        s.SOT_SYNC_ERROR_2         = 0x03
        s.CNTRL_ERR_HSRQST_2         = 0x02
        s.LP_INVALID_ERR_2         = 0x01
        s.CSI_ERR_CLK_LANE         = 0x60
        s.CNTRL_ERR_HSRQST_CK0         = 0x02
        s.LP_INVALID_ERR_CK0         = 0x01
        s.CSI_PKT_HDR_VC_ID         = 0x61
        s.LONG_PKT_VCHNL_ID         = 0xC0
        s.LONG_PKT_DATA_ID         = 0x3F
        s.PKT_HDR_WC_LSB         = 0x62
        s.LONG_PKT_WRD_CNT_LSB         = 0xFF
        s.PKT_HDR_WC_MSB         = 0x63
        s.LONG_PKT_WRD_CNT_MSB         = 0xFF
        s.CSI_ECC         = 0x64
        s.LINE_LENGTH_CHANGE         = 0x80
        s.CSI_ECC         = 0x3F
        s.MODE_CAD_RAW         = 0x65
        s.I2C_DONE         = 0x80
        s.I2C_ADDR_RAW         = 0x70
        s.MODE_DONE         = 0x08
        s.MODE_RAW         = 0x07
        s.SENSE_CAD_RAW         = 0x66
        s.SENSE_DONE         = 0x08
        s.SENSE_RAW         = 0x07
        s.FREQ_CNTR         = 0x67
        s.FREQ_COUNTER         = 0xFF
        s.DIGITAL_TEST1         = 0x70
        s.FORCE_DCA_ERR         = 0x80
        s.READ_DBG_MUX         = 0x20
        s.TST_DRBC         = 0x10
        s.DBG_SRC         = 0x0F
        s.DIGITAL_TEST2         = 0x71
        s.DBG_SEL         = 0xFF
        s.BC_START         = 0x72
        s.START_SEQUENCE         = 0x3F
        s.MISC_TEST         = 0x73
        s.FC_DRIVER_TEST         = 0x80
        s.DOPL_         = 0x20
        s.FC_TEST_PATTERN         = 0x74
        s.ENABLE_EQ_PATTERN         = 0x08
        s.CLOCK_PATTERN_SEL         = 0x06
        s.Enable_CLOCK_PATTERN         = 0x01
        s.FPD_PRBS         = 0x75
        s.FPD_PRBS_SEED         = 0xF0
        s.FPD_PRBS_EN         = 0x08
        s.FPD_PRBS_PATT         = 0x06
        s.unused         = 0x01
        s.FPD3_ECC_TEST1         = 0x76
        s.ECC_OVERRIDE         = 0x80
        s.FORCE_CONT_ECC_ERR         = 0x08
        s.FORCE_ALL_ECC_ERR         = 0x03
        s.FORCE_2_ECC_ERR         = 0x02
        s.FORCE_1_ECC_ERR         = 0x01
        s.FPD3_ECC_TEST2         = 0x77
        s.ECC_ERR_SEL         = 0x7F
        s.FC_BCC_TEST         = 0x78
        s.FORCE_BCC_ERROR         = 0x40
        s.BCC_ERROR_SEL         = 0x38
        s.BCC_FRAME_SEL         = 0x07
        s.BCC_STATUS         = 0x79
        s.BCC_MASTER_ERR         = 0x10
        s.BCC_MASTER_TO         = 0x08
        s.BCC_SLAVE_ERR         = 0x03
        s.BCC_SLAVE_TO         = 0x02
        s.BCC_RESP_ERR         = 0x01
        s.CSI_LANESEL_P0         = 0x7A
        s.LANESEL_0         = 0xFF
        s.CSI_STROBE         = 0x7B
        s.CSI_BYPASS_TIMING         = 0x7C
        s.BYPASS_TINIT         = 0x20
        s.BYPASS_TCK_MISS         = 0x10
        s.BYPASS_TSETTLE_CLK         = 0x08
        s.BYPASS_TSETTLE_DATA         = 0x03
        s.BYPASS_TERMEN_CLK         = 0x02
        s.BYPASS_TERMEN_DATA         = 0x01
        s.CSI_BYPASS         = 0x7D
        s.CSI_FWD_SYNC_ERR         = 0x80
        s.CSI_FWD_ECC         = 0x40
        s.BYPASS_ULPS_CK0         = 0x20
        s.BYPASS_LP         = 0x1F
        s.CSI_COMP_TEST         = 0x7E
        s.L0_ATEST_SEL         = 0x08
        s.SEL_FORM_0         = 0x07
        s.CSI_SPARE0         = 0x7F
        s.CSI_SPARE0         = 0xFC
        s.EN_CLK_INV         = 0x02
        s.CSI_SPARE0         = 0x01
        s.CSI_SPARE1         = 0x80
        s.CSI_SPARE1         = 0xFF
        s.SPARE0         = 0x81
        s.SPARE0         = 0xFF
        s.SPARE1         = 0x82
        s.SPARE1         = 0xFF
        s.SPARE2         = 0x83
        s.SPARE2         = 0xFF
        s.DEBUG_CLANE         = 0x84
        s.CLANE_OV         = 0x80
        s.C_LANE_STATE         = 0x07
        s.DEBUG_DLANES         = 0x85
        s.DLANE_OV         = 0x80
        s.D_LANE_STATE         = 0x07
        s.CSI_BIAS         = 0x86
        s.CSI_EN_BIAS_PORT         = 0x80
        s.CSI_EN_BIASCALIB         = 0x40
        s.TEST_BIAS_0_EN         = 0x20
        s.RTRIM_BIAS_0         = 0x1F
        s.CSI_EN_CALIB         = 0x87
        s.CSI_ANA_PD_OV         = 0x40
        s.CSI_ANA_PD_OV         = 0x20
        s.EN_CALIB_CLK0         = 0x10
        s.EN_CALIB_D3         = 0x08
        s.EN_CALIB_D2         = 0x03
        s.EN_CALIB_D1         = 0x02
        s.EN_CALIB_D0         = 0x01
        s.PFD_TEST_CTRL         = 0x88
        s.PFD_COUNTER_START         = 0x04
        s.PFD_COUNTER_SELECT         = 0x04
        s.PFD_LANE_SEL_TEST         = 0x03
        s.PFD_COUNTERS_STATUS         = 0x89
        s.PFD_COUNTER_DONE         = 0xF0
        s.PFD_STATUS         = 0x0F
        s.PFD_COUNTERS_MSB         = 0x8A
        s.PFD_COUNTERS         = 0x0F
        s.PFD_COUNTERS_LSB         = 0x8B
        s.PFD_COUNTERS         = 0xFF
        s.FPD_LDO_CTRL         = 0x8C
        s.REG_LDO_ATP         = 0xE0
        s.REG_LDO_DAC         = 0x1F
        s.POWERDOWN_CTRL         = 0x8D
        s.SER_EN         = 0x10
        s.SBPLL_PD_OV         = 0x08
        s.SBPLL_PD_         = 0x03
        s.CML_PD         = 0x02
        s.BCRX_PD         = 0x01
        s.WRFIFOCLK_CTRL         = 0x8E
        s.SEL_PLLCLK_OV         = 0x03
        s.SEL_PLLCLK         = 0x03
        s.FREQ_DETECTOR         = 0x8F
        s.FORCE_CLK_DET         = 0x20
        s.FREQ_STABLE_THR         = 0x18
        s.FREQ_HYST         = 0x07
        s.FREQ_LO_THR_DVP         = 0x90
        s.BYP_PLLFREQ_CHECK         = 0x40
        s.FREQ_LO_THR_DVP         = 0x3F
        s.FREQ_LO_THR_CSI         = 0x91
        s.FREQ_DET_TIMER         = 0xC0
        s.FREQ_LO_THR_CSI         = 0x3F
        s.FREQ_HI_THR         = 0x92
        s.FREQ_HI_THR         = 0x7F
        s.PLL_CTRL         = 0x93
        s.VCO_OPENLOOP_OV         = 0x40
        s.VCO_OPENLOOP_         = 0x20
        s.SBPLL_CHARGE_OV         = 0x10
        s.CHARGE_PULSE_WIDTH_VALUE         = 0x07
        s.RESET_SM_CTRL         = 0x94
        s.BYPASS_BAD_FRAME         = 0x40
        s.BYPASS_SM         = 0x20
        s.RESET_SM_OV         = 0x10
        s.RESET_SM         = 0x0F
        s.FPD_CLOCK_MODE         = 0x95
        s.DVP_MODE_EN_OV         = 0x20
        s.DVP_MODE_EN         = 0x10
        s.PLL_MODE_EN_SBPLL_OV         = 0x08
        s.PLL_MODE_EN_SBPLL__         = 0x03
        s.BC__SAMPLING_MODE_OV         = 0x02
        s.BC__SAMPLING_MODE_         = 0x01
        s.SENSOR_ATP0         = 0x96
        s.SEL_IBIAS_ATP         = 0x80
        s.SEL_VBE_ATP         = 0x40
        s.SEL_VBG_ATP         = 0x20
        s.SEL_VSOUT_ATP         = 0x10
        s.SEL_VSREF_ATP         = 0x08
        s.SEL_VCADREF_ATP         = 0x03
        s.SEL_VMUX_ATP         = 0x02
        s.SEL_VBGFLT_ATP         = 0x01
        s.SENSOR_ATP1         = 0x97
        s.SENSE_ATP1         = 0x07
        s.ATP_CDRTRIM         = 0x98
        s.ATP_CDRTrim_EN         = 0xFF
        s.CSI_OFFSET_TRIM_CLK0         = 0x9A
        s.OFFSETTRIM_CLK0         = 0x3F
        s.CSI_OFFSET_TRIM_D0         = 0x9B
        s.OFFSETTRIM_D0         = 0x3F
        s.CSI_OFFSET_TRIM_D1         = 0x9C
        s.OFFSETTRIM_D1         = 0x3F
        s.CSI_OFFSET_TRIM_D2         = 0x9D
        s.OFFSETTRIM_D2         = 0x3F
        s.CSI_OFFSET_TRIM_D3         = 0x9E
        s.OFFSETTRIM_D3         = 0x3F
        s.CSI_RTRIM_CLK0         = 0x9F
        s.CSI_TRIM_I         = 0x1F
        s.CSI_RTRIM_D0         = 0xA1
        s.RTRIM_D0         = 0x1F
        s.CSI_RTRIM_D1         = 0xA2
        s.RTRIM_D1         = 0x1F
        s.CSI_RTRIM_D2         = 0xA3
        s.RTRIM_D2         = 0x1F
        s.CSI_RTRIM_D3         = 0xA4
        s.unused         = 0x1F
        s.CSI_TRIM_I         = 0xA5
        s.ITRIM         = 0x1F
        s.TRIM0         = 0xA6
        s.TRIM0         = 0x7F
        s.TRIM1         = 0xA7
        s.TRIM1         = 0xFF
        s.TRIM2         = 0xA8
        s.TRIM2         = 0x1F
        s.TRIM3         = 0xA9
        s.TRIM3         = 0x1F
        s.TRIM4         = 0xAA
        s.PGEnDly         = 0xE0
        s.ClkDly         = 0x1F
        s.TRIM5         = 0xAB
        s.CDR_StrobeTrim         = 0x1F
        s.ANA_IA_CTL         = 0xB0
        s.ANA_IA_SEL         = 0x1C
        s.ANA_AUTO_INC         = 0x02
        s.ANA_IA_READ         = 0x01
        s.ANA_IA_ADDR         = 0xB1
        s.ANA_IA_ADDR         = 0xFF
        s.ANA_IA_DATA         = 0xB2
        s.ANA_IA_DATA         = 0xFF
        s.FPD3_TX_ID          = 0xF0
        s.FPD3_TX_ID0         = 0xFF
        s.FPD3_ID1         = 0xF1
        s.FPD3_TX_ID1         = 0xFF
        s.FPD3_ID2         = 0xF2
        s.FPD3_TX_ID2         = 0xFF
        s.FPD3_ID3         = 0xF3
        s.FPD3_TX_ID3         = 0xFF
        s.FPD3_ID4         = 0xF4
        s.FPD3_TX_ID4         = 0xFF
        s.FPD3_ID5         = 0xF5
        s.FPD3_TX_ID5         = 0xFF
        s.FPD3_RX_ID      = 0xF0         # ID String location

class DS90UB953_ENG( ALPExtensionModule):
    def __init__( s, *args, **argd):
        ALPExtensionModule.__init__( s, *args, **argd)
        # s.emulRegs = DS90UB953_RegDefaults
        s.emulRegs = s.emulTxRegs = s.emulRxRegs = DS90UB953_RegDefaults
        s.Initialize()

    def Initialize( s):
        s.modelName = "UNKNOWN"
        s.devAddr = s.txAddr = 0x30
        s.gpioPinCnt = 7    # Number of GPIO pins
        s.txRevId = 0x1
        s.txValid = False
        s.txTestdie = False
        s.txValid = False
        s.txModeTxt = ["CSI-2 Synchronous Mode",     \
                       "CSI-2 with CSI Clock Mode",  \
                       "CSI-2 Non-synchronous Mode Ext Clk", \
                       "Reserved", \
                       "Reserved", \
                       "Reserved", \
                       "Reserved", \
                       "Reserved"]
        s.CablingTxt = ["TP", "Coax"]
        s.shortDescription = "N/A"
        s.longDescription  = "N/A"
        # Registers
        s.tx = DS90UB953_Const()
        # partner
        s.rxmodelName = "UNKNOWN DESERIALIZER"
        s.rxAddr = 0x00
        s.rxAliasAddr = s.ReadReg(s.tx.DES_ID)
        s.rxPortModeTxt = ["CSI", "RAW12/LF", "RAW12/HF", "RAW10"]
        # GPIO Pin control
        s.gpio0_pin_ctl = 0
        s.gpio1_pin_ctl = 0
        s.gpio2_pin_ctl = 0
        s.gpio3_pin_ctl = 0
        s.gpio4_pin_ctl = 0
        s.gpio5_pin_ctl = 0
        s.gpio6_pin_ctl = 0
        s.gpio7_pin_ctl = 0
        # BC GPIO control
        s.bc_gpio_ctl0 = [0, 0, 0, 0]
        s.bc_gpio_ctl1 = [0, 0, 0, 0]
        s.passthru_en = False
        
    def SetDeviceSlaveAddr(s, slaveAddr):
        s.devAddr = slaveAddr

    # ReadI2C reads from the specified I2C address
    def ReadI2C( s, devAddr, regIndex, regLength=1):
        if s.demoMode:
            s.rc = 1
            if (regLength == 1):
                if (devAddr == s.devAddr):
                    return s.emulRegs[regIndex][0]
                elif (devAddr == s.rxAddr):
                    return s.emulRegs[regIndex][0]
                elif (devAddr == s.txAddr):
                    return s.emulRegs[regIndex][0]
                else:   # emulate read from missing device
                    s.rc = 0
		    return regIndex
            else:
                readStatus = []
                for i in range(regLength):
                    if (devAddr == s.devAddr):
                        readStatus += [s.emulRegs[regIndex+i][0]]
                    elif (devAddr == s.rxAddr):
                        readStatus += [s.emulRegs[regIndex+i][0]]
                    elif (devAddr == s.txAddr):
                        readStatus += [s.emulRegs[regIndex+i][0]]
                    else:   # emulate read from missing device
		        s.rc = 0
                        readStatus += [regIndex+i]
                return readStatus
            
        if hasattr(s.alpBaseBoard,'shortName'):
            if s.alpBaseBoard.shortName == 'USB2ANY':
                readStatus = s.alpBaseBoard.USB2ANY.i2c_readByteMult(devAddr>>1,regIndex,regLength)
            elif s.alpBaseBoard.shortName == 'Aardvark':
                readValue = s.alpBaseBoard.Aardvark.readI2C(devAddr>>1,regIndex,regLength)
                readStatus = []
                if not readValue:
                    readStatus.append(0)
                    tempList = []
                    for x in range(0,regLength):
                        tempList.append(0)
                    readStatus.append(tempList)
                else:
                    readStatus.insert(0,1)
                    readStatus.append(readValue.tolist())
            else:
                readStatus = NanoALP.ReadI2C( s.GetALPInterface(), devAddr, regIndex, regLength)
        else:
            readStatus = NanoALP.ReadI2C( s.GetALPInterface(), devAddr, regIndex, regLength)
         
        #readStatus = NanoALP.ReadI2C( s.GetALPInterface(), devAddr, regIndex, regLength)
        s.rc = readStatus[0]
        if (regLength == 1):
            return int(array( 'B', readStatus[1]).tolist()[0])
        else:
            return array( 'B', readStatus[1]).tolist()
            
    # WriteI2C writes to the specified I2C address
    def WriteI2C( s, devAddr, regIndex, regVal):
        if s.demoMode:
            s.rc = 1
	    if (devAddr == s.devAddr):  # Only write if address matches
                try:    # Multi-byte write
                    for i in range(len( regVal)):
                        s.emulRegs[regIndex+i][0]= regVal[i]
                except:
                    s.emulRegs[regIndex][0]= regVal
            elif (devAddr == s.rxAddr):
                try:    # Multi-byte write
                    for i in range(len( regVal)):
                        s.emulRegs[regIndex+i][0]= regVal[i]
                except:
                    s.emulRegs[regIndex][0]= regVal
            elif (devAddr == s.txAddr):
                try:    # Multi-byte write
                    for i in range(len( regVal)):
                        s.emulRegs[regIndex+i][0]= regVal[i]
                except:
                    s.emulRegs[regIndex][0]= regVal
	    else:
		s.rc = 0
            return
        try:    # Do multi-byte write
            len(regVal)
            reg_list = regVal
        except:
            reg_list = [regVal,]
        
        if hasattr(s.alpBaseBoard,'shortName'):
            if s.alpBaseBoard.shortName == 'USB2ANY':
                s.alpBaseBoard.USB2ANY.i2c_writeByteMult(devAddr>>1,regIndex,regVal)
            elif s.alpBaseBoard.shortName == 'Aardvark':
                s.alpBaseBoard.Aardvark.writeI2C(devAddr>>1,regIndex,regVal)
            else:
                NanoALP.WriteI2C( s.GetALPInterface(), devAddr, regIndex, array( 'B', regVal).tostring())
        else:
            NanoALP.WriteI2C( s.GetALPInterface(), devAddr, regIndex, array( 'B', [regVal,]).tostring())
        
        #s.rc = NanoALP.WriteI2C( s.GetALPInterface(), devAddr, regIndex, array( 'B', reg_list).tostring())

    # ReadReg reads from the current I2C address specified in "devAddr"
    def ReadReg( s, regIndex, regLength=1):       
        readVal = s.ReadI2C(s.devAddr, regIndex, regLength)
        return readVal
             
    # WriteReg writes to the current I2C address specified in "devAddr"
    def WriteReg( s, regIndex, regVal):
        s.WriteI2C(s.devAddr, regIndex, regVal)

    # ReadTXReg reads from the I2C address specified in "txAddr"
    # Device address is based on port number and the txAliasAddr setting for that port
        # ReadRXReg reads from the I2C address specified in register 0x07
    def ReadTXReg( s, regIndex, regLength=1):
        readVal = s.ReadI2C(s.txAddr, regIndex, regLength)
        return readVal        
    
    # WriteTXReg writes to the I2C address specified in "txAddr"
    def WriteTXReg( s, regIndex, regVal):
        s.WriteI2C(s.txAddr, regIndex, regVal)

    # ReadRXReg reads from the I2C address specified in "rxAddr"
    def ReadRXReg( s, regIndex, regLength=1):
        readVal = s.ReadI2C(s.rxAliasAddr, regIndex, regLength)
        return readVal

    # WriteRXReg writes to the I2C address specified in "rxAddr"
    def WriteRXReg( s, regIndex, regVal):
        s.WriteI2C(s.rxAliasAddr, regIndex, regVal)
        
    def Deinit( s):
        """Called to cleanup state and resources when we're being unloaded."""
        pass
        
    def PollTxDevices(s, remote=0, silent = 0):
        if s.demoMode:
            s.txValid = True
            s.modelName = "DS90UB953"
            return -1

        if s.txValid:
            # For local device, first try previous valid address, if it exists
            sts = s.ReadI2C(s.txAddr, s.tx.I2C_DEVICE_ID, 1)
            if (s.rc and (sts == s.txAddr)):
                s.txValid = True
            else:
                s.txValid = False
                   
        # Otherwise poll full range; s.txValid is already False
        for addr in range (128):
            sts = s.ReadI2C(addr<<1, 0x0, 1)
            if (s.rc and (sts == addr<<1)):
                s.txAddr = (addr<<1)
                # Check read ID at 0xF0-0xF5
                id_val = s.ReadTXReg(s.tx.FPD3_TX_ID, 6)
                if (id_val == UB953_ID_CODE):
                    s.modelName = "DS90UB953"
                    s.txValid = True
                    break
                else:
                    s.modelName = "UNKNOWN"
        if s.txValid:                
            if (not remote):
                s.devAddr = s.txAddr
            if not silent:
                print "Found serializer %s, at address 0x%x" % (s.modelName, s.txAddr)
            return 0
        else:
            if not silent:
                print "FAILED polling for I2C address"
            return 1

    def PollRxDevices(s, remote=1, silent = 0):
        if s.demoMode:
            s.rxValid = True
            s.rxmodelName = "DS90UB954"
            return -1

        # Check for RX Lock.  If not locked, assume not valid TX
        locked = s.GetLinkStatus()
        if locked:
            # Enable control channel
            s.rxAddr = s.ReadTXReg(s.tx.DES_ID)
            s.rxAddr &= 0xFE
            # if (s.rxAddr != 0):
                # enable back channel
                # sts = [ord('_'), ord('U'), ord('B'), ord('9'), ord('5'), ord('4')]
            s.rxValid = True
            # else:
                # s.rxValid = False
        else:
            s.rxValid = False

        if s.rxValid:
            # Enable access to Deserializer
            temp_reg32 = s.ReadTXReg(s.tx.BCC_CONFIG)
            s.WriteTXReg(s.tx.BCC_CONFIG, (temp_reg32 | 0x40))
            temp_alias = s.ReadTXReg(s.tx.DES_ID)
            s.rxAliasAddr = temp_alias
            if (temp_alias !=0):
                s.WriteTXReg(s.tx.SLAVE_ID_0, temp_alias)
                s.WriteTXReg(s.tx.SLAVE_ID_ALIAS_0, temp_alias)
            # else:    
                # pass

        if s.rxValid:
            # Check read ID at 0xF0-0xF5
            id_val = s.ReadRXReg(s.tx.FPD3_RX_ID, 6)
            rx_val = ''.join(chr(i) for i in id_val)
 
            if (id_val == UB934_ID_CODE):
                s.rxmodelName = "DS90UB934"
            elif (id_val == UB954_ID_CODE):
                s.rxmodelName = "DS90UB954"
            elif (id_val == UB964_ID_CODE):
                s.rxmodelName = "DS90UB964"
            elif (id_val == UB960_ID_CODE):
                s.rxmodelName = "DS90UB960"
            else:
                s.rxmodelName = "UNKNOWN DESERIALIZER"

            if (not remote):
                s.devAddr = s.rxAddr
            if not silent:
                # print "Found deserializer at address 0x%x" % (s.rxAddr)
                print "Found deserializer %s, at address 0x%x" % (s.rxmodelName, s.rxAddr)
            return 0
        else:
            if not silent:
                print "FAILED polling for Receiver I2C address"
            return 1

    def GetDevInfo(s):
        # Local actual serializer
        s.PollTxDevices(silent=1)

        # s.ShortDescription = s.modelName
        # s.longDescription  = s.modelName + " FPD-Link III Serializer"

        if (s.modelName != "UNKNOWN"):
            s.longDescription  = s.modelName + " FPD-Link III Serializer"
        else:
            s.longDescription = s.modelName
        
        # Remote deserializer
        s.PollRxDevices(remote=1,silent=1)

        # s.partnerShortDescription = s.rxmodelName
        # s.partnerlongDescription  = s.rxmodelName + " FPD-Link III Deserializer"

        if (s.rxmodelName != "UNKNOWN DESERIALIZER"):
            s.partnerShortDescription = s.rxmodelName
        else:
            s.partnerlongDescription  = s.rxmodelName + " FPD-Link III Deserializer"

            

    def GetLinkStatus(s):
        # Cable link detect

        # Set pass-through if necessary
        rdata = s.ReadReg(s.tx.BCC_CONFIG)
        s.WriteReg(s.tx.BCC_CONFIG, (rdata | 0x40))

        s.WriteReg(s.tx.SLAVE_ID_0, s.ReadReg(s.tx.DES_ID)) #SlaveID set to DES_ID
        s.WriteReg(s.tx.SLAVE_ID_ALIAS_0, s.ReadReg(s.tx.DES_ID)) #SlaveAlias
      
        if s.demoMode:
            s.tx.rxAliasAddr = 0x0
            return 1
        # link = s.ReadRXReg(0x00) #Check if the slave's DES ID is the same as the local Device ID
        elif ((s.ReadReg(s.tx.GENERAL_STATUS) & s.tx.RX_LOCK_DETECT) >> 6):
            return 1
        else:
            return 0

    def GetParityErrors(s):
        #Disable checking
        # temp_val = s.ReadReg(s.tx.GENERAL_CFG)
        # s.WriteReg(s.tx.GENERAL_CFG, (temp_val & 0xFD))
        # Read parity error count
        parity_err_list = s.ReadTXReg(s.tx.CRC_ERR_CNT1, 2)
        # Convert to integer
        parity_err_cnt = parity_err_list[0] + (parity_err_list[1] << 8)
        # parity_err_cnt = parity_err_list[1] + (parity_err_list[0] << 8)
        # Reneable Parity checking
        # s.WriteReg(s.rx.GENERAL_CFG, (temp_val  | s.rx.RX_PAR_CHK_ENABLE))        
        return(parity_err_cnt)
        
    def GetTxLineLen(s):
        # Read Line Length (2 bytes)
        line_len = s.ReadTXReg(s.tx.PKT_HDR_WC_LSB, 2)
        line_len_bytes = (line_len[0] << 8) | line_len[1]
        return(line_len_bytes)
        
    def GetTxMode(s):    
        txMode = s.ReadReg(s.tx.MODE_SEL) & s.tx.MODE_MASK
        txModeSts = s.txModeTxt[txMode]
        return(txModeSts)
        
    def GetTxCableMode(s):        
        txCablingMode = (s.ReadReg(s.tx.MODE_SEL) & s.tx.FPD_COAX_MODE) >> 6
        txCablingModeSts = s.CablingTxt[txCablingMode]
        return(txCablingModeSts)
        
    def GetRxMode(s):
        rxMode = s.ReadRXReg(0x6D) & 0x3
        rxModeSts = s.rxPortModeTxt[rxMode]
        return(rxModeSts)
        
    def GetRxCableMode(s):
        rxCablingMode = s.ReadRXReg(0x6D) & 0x4 
        rxCablingMode = (s.ReadRXReg(0x6D) & 0x4) >> 2
        rxCablingModeSts = s.CablingTxt[rxCablingMode]
        return(rxCablingModeSts)