"""
DS90UB960_ENG_Lib.py

<Insert library module description>

Copyright (c) Texas Instruments
All Rights Reserved.
"""

import os
import sys
import time
import NanoALP
from array import array
from ALPExtensionModule import ALPExtensionModule

# List of register lists that specify the default value and access type for the reg.
# When WriteReg is called below the access type is checked and applied to the operation.
READ_WRITE = 0x1
READ_ONLY  = 0x0

# ID Code Strings
UB960_ID_CODE    = [0x5F, 0x55, 0x42, 0x39, 0x36, 0x30]   # "_UB960"
# UB962_ID_CODE    = [0x5F, 0x55, 0x42, 0x39, 0x36, 0x30]   # "_UB962"
# UB964_ID_CODE    = [0x5F, 0x55, 0x42, 0x39, 0x36, 0x30]   # "_UB964"
# UB966_ID_CODE    = [0x5F, 0x55, 0x42, 0x39, 0x36, 0x30]   # "_UB966"


DS90UB960RegDefaults = {0x00: [0x00, READ_WRITE],  # /reg 00
                        0x01: [0x01, READ_WRITE],  # /reg 01
                        0x02: [0x02, READ_WRITE],  # /reg 02
                        0x03: [0x03, READ_WRITE],  # /reg 03
                        0x04: [0x04, READ_WRITE],  # /reg 04
                        0x05: [0x05, READ_WRITE],  # /reg 05
                        0x06: [0x06, READ_WRITE],  # /reg 06
                        0x07: [0x07, READ_WRITE],  # /reg 07
                        0x08: [0x08, READ_WRITE],  # /reg 08
                        0x09: [0x09, READ_WRITE],  # /reg 09
                        0x0A: [0x0A, READ_WRITE],  # /reg 0A
                        0x0B: [0x0B, READ_WRITE],  # /reg 0B
                        0x0C: [0x0C, READ_WRITE],  # /reg 0C
                        0x0D: [0x0D, READ_WRITE],  # /reg 0D
                        0x0E: [0x0E, READ_WRITE],  # /reg 0E
                        0x0F: [0x0F, READ_WRITE],  # /reg 0F
                        0x10: [0x10, READ_WRITE],  # /reg 10
                        0x11: [0x11, READ_WRITE],  # /reg 11
                        0x12: [0x12, READ_WRITE],  # /reg 12
                        0x13: [0x13, READ_WRITE],  # /reg 13
                        0x14: [0x14, READ_WRITE],  # /reg 14
                        0x15: [0x15, READ_WRITE],  # /reg 15
                        0x16: [0x16, READ_WRITE],  # /reg 16
                        0x17: [0x17, READ_WRITE],  # /reg 17
                        0x18: [0x18, READ_WRITE],  # /reg 18
                        0x19: [0x19, READ_WRITE],  # /reg 19
                        0x1A: [0x1A, READ_WRITE],  # /reg 1A
                        0x1B: [0x1B, READ_WRITE],  # /reg 1B
                        0x1C: [0x1C, READ_WRITE],  # /reg 1C
                        0x1D: [0x1D, READ_WRITE],  # /reg 1D
                        0x1E: [0x1E, READ_WRITE],  # /reg 1E
                        0x1F: [0x1F, READ_WRITE],  # /reg 1F
                        0x20: [0x20, READ_WRITE],  # /reg 20
                        0x21: [0x21, READ_WRITE],  # /reg 21
                        0x22: [0x22, READ_WRITE],  # /reg 22
                        0x23: [0x23, READ_WRITE],  # /reg 23
                        0x24: [0x24, READ_WRITE],  # /reg 24
                        0x25: [0x25, READ_WRITE],  # /reg 25
                        0x26: [0x26, READ_WRITE],  # /reg 26
                        0x27: [0x27, READ_WRITE],  # /reg 27
                        0x28: [0x28, READ_WRITE],  # /reg 28
                        0x29: [0x29, READ_WRITE],  # /reg 29
                        0x2A: [0x2A, READ_WRITE],  # /reg 2A
                        0x2B: [0x2B, READ_WRITE],  # /reg 2B
                        0x2C: [0x2C, READ_WRITE],  # /reg 2C
                        0x2D: [0x2D, READ_WRITE],  # /reg 2D
                        0x2E: [0x2E, READ_WRITE],  # /reg 2E
                        0x2F: [0x2F, READ_WRITE],  # /reg 2F
                        0x30: [0x30, READ_WRITE],  # /reg 30
                        0x31: [0x31, READ_WRITE],  # /reg 31
                        0x32: [0x32, READ_WRITE],  # /reg 32
                        0x33: [0x33, READ_WRITE],  # /reg 33
                        0x34: [0x34, READ_WRITE],  # /reg 34
                        0x35: [0x35, READ_WRITE],  # /reg 35
                        0x36: [0x36, READ_WRITE],  # /reg 36
                        0x37: [0x37, READ_WRITE],  # /reg 37
                        0x38: [0x38, READ_WRITE],  # /reg 38
                        0x39: [0x39, READ_WRITE],  # /reg 39
                        0x3A: [0x3A, READ_WRITE],  # /reg 3A
                        0x3B: [0x3B, READ_WRITE],  # /reg 3B
                        0x3C: [0x3C, READ_WRITE],  # /reg 3C
                        0x3D: [0x3D, READ_WRITE],  # /reg 3D
                        0x3E: [0x3E, READ_WRITE],  # /reg 3E
                        0x3F: [0x3F, READ_WRITE],  # /reg 3F
                        0x40: [0x40, READ_WRITE],  # /reg 40
                        0x41: [0x41, READ_WRITE],  # /reg 41
                        0x42: [0x42, READ_WRITE],  # /reg 42
                        0x43: [0x43, READ_WRITE],  # /reg 43
                        0x44: [0x44, READ_WRITE],  # /reg 44
                        0x45: [0x45, READ_WRITE],  # /reg 45
                        0x46: [0x46, READ_WRITE],  # /reg 46
                        0x47: [0x47, READ_WRITE],  # /reg 47
                        0x48: [0x48, READ_WRITE],  # /reg 48
                        0x49: [0x49, READ_WRITE],  # /reg 49
                        0x4A: [0x4A, READ_WRITE],  # /reg 4A
                        0x4B: [0x4B, READ_WRITE],  # /reg 4B
                        0x4C: [0x4C, READ_WRITE],  # /reg 4C
                        0x4D: [0x4D, READ_WRITE],  # /reg 4D
                        0x4E: [0x4E, READ_WRITE],  # /reg 4E
                        0x4F: [0x4F, READ_WRITE],  # /reg 4F
                        0x50: [0x50, READ_WRITE],  # /reg 50
                        0x51: [0x51, READ_WRITE],  # /reg 51
                        0x52: [0x52, READ_WRITE],  # /reg 52
                        0x53: [0x53, READ_WRITE],  # /reg 53
                        0x54: [0x54, READ_WRITE],  # /reg 54
                        0x55: [0x55, READ_WRITE],  # /reg 55
                        0x56: [0x56, READ_WRITE],  # /reg 56
                        0x57: [0x57, READ_WRITE],  # /reg 57
                        0x58: [0x58, READ_WRITE],  # /reg 58
                        0x59: [0x59, READ_WRITE],  # /reg 59
                        0x5A: [0x5A, READ_WRITE],  # /reg 5A
                        0x5B: [0x5B, READ_WRITE],  # /reg 5B
                        0x5C: [0x5C, READ_WRITE],  # /reg 5C
                        0x5D: [0x5D, READ_WRITE],  # /reg 5D
                        0x5E: [0x5E, READ_WRITE],  # /reg 5E
                        0x5F: [0x5F, READ_WRITE],  # /reg 5F
                        0x60: [0x60, READ_WRITE],  # /reg 60
                        0x61: [0x61, READ_WRITE],  # /reg 61
                        0x62: [0x62, READ_WRITE],  # /reg 62
                        0x63: [0x63, READ_WRITE],  # /reg 63
                        0x64: [0x64, READ_WRITE],  # /reg 64
                        0x65: [0x65, READ_WRITE],  # /reg 65
                        0x66: [0x66, READ_WRITE],  # /reg 66
                        0x67: [0x67, READ_WRITE],  # /reg 67
                        0x68: [0x68, READ_WRITE],  # /reg 68
                        0x69: [0x69, READ_WRITE],  # /reg 69
                        0x6A: [0x6A, READ_WRITE],  # /reg 6A
                        0x6B: [0x6B, READ_WRITE],  # /reg 6B
                        0x6C: [0x6C, READ_WRITE],  # /reg 6C
                        0x6D: [0x6D, READ_WRITE],  # /reg 6D
                        0x6E: [0x6E, READ_WRITE],  # /reg 6E
                        0x6F: [0x6F, READ_WRITE],  # /reg 6F
                        0x70: [0x70, READ_WRITE],  # /reg 70
                        0x71: [0x71, READ_WRITE],  # /reg 71
                        0x72: [0x72, READ_WRITE],  # /reg 72
                        0x73: [0x73, READ_WRITE],  # /reg 73
                        0x74: [0x74, READ_WRITE],  # /reg 74
                        0x75: [0x75, READ_WRITE],  # /reg 75
                        0x76: [0x76, READ_WRITE],  # /reg 76
                        0x77: [0x77, READ_WRITE],  # /reg 77
                        0x78: [0x78, READ_WRITE],  # /reg 78
                        0x79: [0x79, READ_WRITE],  # /reg 79
                        0x7A: [0x7A, READ_WRITE],  # /reg 7A
                        0x7B: [0x7B, READ_WRITE],  # /reg 7B
                        0x7C: [0x7C, READ_WRITE],  # /reg 7C
                        0x7D: [0x7D, READ_WRITE],  # /reg 7D
                        0x7E: [0x7E, READ_WRITE],  # /reg 7E
                        0x7F: [0x7F, READ_WRITE],  # /reg 7F
                        0x80: [0x80, READ_WRITE],  # /reg 80
                        0x81: [0x81, READ_WRITE],  # /reg 81
                        0x82: [0x82, READ_WRITE],  # /reg 82
                        0x83: [0x83, READ_WRITE],  # /reg 83
                        0x84: [0x84, READ_WRITE],  # /reg 84
                        0x85: [0x85, READ_WRITE],  # /reg 85
                        0x86: [0x86, READ_WRITE],  # /reg 86
                        0x87: [0x87, READ_WRITE],  # /reg 87
                        0x88: [0x88, READ_WRITE],  # /reg 88
                        0x89: [0x89, READ_WRITE],  # /reg 89
                        0x8A: [0x8A, READ_WRITE],  # /reg 8A
                        0x8B: [0x8B, READ_WRITE],  # /reg 8B
                        0x8C: [0x8C, READ_WRITE],  # /reg 8C
                        0x8D: [0x8D, READ_WRITE],  # /reg 8D
                        0x8E: [0x8E, READ_WRITE],  # /reg 8E
                        0x8F: [0x8F, READ_WRITE],  # /reg 8F
                        0x90: [0x90, READ_WRITE],  # /reg 90
                        0x91: [0x91, READ_WRITE],  # /reg 91
                        0x92: [0x92, READ_WRITE],  # /reg 92
                        0x93: [0x93, READ_WRITE],  # /reg 93
                        0x94: [0x94, READ_WRITE],  # /reg 94
                        0x95: [0x95, READ_WRITE],  # /reg 95
                        0x96: [0x96, READ_WRITE],  # /reg 96
                        0x97: [0x97, READ_WRITE],  # /reg 97
                        0x98: [0x98, READ_WRITE],  # /reg 98
                        0x99: [0x99, READ_WRITE],  # /reg 99
                        0x9A: [0x9A, READ_WRITE],  # /reg 9A
                        0x9B: [0x9B, READ_WRITE],  # /reg 9B
                        0x9C: [0x9C, READ_WRITE],  # /reg 9C
                        0x9D: [0x9D, READ_WRITE],  # /reg 9D
                        0x9E: [0x9E, READ_WRITE],  # /reg 9E
                        0x9F: [0x9F, READ_WRITE],  # /reg 9F
                        0xA0: [0xA0, READ_WRITE],  # /reg A0
                        0xA1: [0xA1, READ_WRITE],  # /reg A1
                        0xA2: [0xA2, READ_WRITE],  # /reg A2
                        0xA3: [0xA3, READ_WRITE],  # /reg A3
                        0xA4: [0xA4, READ_WRITE],  # /reg A4
                        0xA5: [0xA5, READ_WRITE],  # /reg A5
                        0xA6: [0xA6, READ_WRITE],  # /reg A6
                        0xA7: [0xA7, READ_WRITE],  # /reg A7
                        0xA8: [0xA8, READ_WRITE],  # /reg A8
                        0xA9: [0xA9, READ_WRITE],  # /reg A9
                        0xAA: [0xAA, READ_WRITE],  # /reg AA
                        0xAB: [0xAB, READ_WRITE],  # /reg AB
                        0xAC: [0xAC, READ_WRITE],  # /reg AC
                        0xAD: [0xAD, READ_WRITE],  # /reg AD
                        0xAE: [0xAE, READ_WRITE],  # /reg AE
                        0xAF: [0xAF, READ_WRITE],  # /reg AF
                        0xB0: [0xB0, READ_WRITE],  # /reg B0
                        0xB1: [0xB1, READ_WRITE],  # /reg B1
                        0xB2: [0xB2, READ_WRITE],  # /reg B2
                        0xB3: [0xB3, READ_WRITE],  # /reg B3
                        0xB4: [0xB4, READ_WRITE],  # /reg B4
                        0xB5: [0xB5, READ_WRITE],  # /reg B5
                        0xB6: [0xB6, READ_WRITE],  # /reg B6
                        0xB7: [0xB7, READ_WRITE],  # /reg B7
                        0xB8: [0xB8, READ_WRITE],  # /reg B8
                        0xB9: [0xB9, READ_WRITE],  # /reg B9
                        0xBA: [0xBA, READ_WRITE],  # /reg BA
                        0xBB: [0xBB, READ_WRITE],  # /reg BB
                        0xBC: [0xBC, READ_WRITE],  # /reg BC
                        0xBD: [0xBD, READ_WRITE],  # /reg BD
                        0xBE: [0xBE, READ_WRITE],  # /reg BE
                        0xBF: [0xBF, READ_WRITE],  # /reg BF
                        0xC0: [0xC0, READ_WRITE],  # /reg C0
                        0xC1: [0xC1, READ_WRITE],  # /reg C1
                        0xC2: [0xC2, READ_WRITE],  # /reg C2
                        0xC3: [0xC3, READ_WRITE],  # /reg C3
                        0xC4: [0xC4, READ_WRITE],  # /reg C4
                        0xC5: [0xC5, READ_WRITE],  # /reg C5
                        0xC6: [0xC6, READ_WRITE],  # /reg C6
                        0xC7: [0xC7, READ_WRITE],  # /reg C7
                        0xC8: [0xC8, READ_WRITE],  # /reg C8
                        0xC9: [0xC9, READ_WRITE],  # /reg C9
                        0xCA: [0xCA, READ_WRITE],  # /reg CA
                        0xCB: [0xCB, READ_WRITE],  # /reg CB
                        0xCC: [0xCC, READ_WRITE],  # /reg CC
                        0xCD: [0xCD, READ_WRITE],  # /reg CD
                        0xCE: [0xCE, READ_WRITE],  # /reg CE
                        0xCF: [0xCF, READ_WRITE],  # /reg CF
                        0xD0: [0xD0, READ_WRITE],  # /reg D0
                        0xD1: [0xD1, READ_WRITE],  # /reg D1
                        0xD2: [0xD2, READ_WRITE],  # /reg D2
                        0xD3: [0xD3, READ_WRITE],  # /reg D3
                        0xD4: [0xD4, READ_WRITE],  # /reg D4
                        0xD5: [0xD5, READ_WRITE],  # /reg D5
                        0xD6: [0xD6, READ_WRITE],  # /reg D6
                        0xD7: [0xD7, READ_WRITE],  # /reg D7
                        0xD8: [0xD8, READ_WRITE],  # /reg D8
                        0xD9: [0xD9, READ_WRITE],  # /reg D9
                        0xDA: [0xDA, READ_WRITE],  # /reg DA
                        0xDB: [0xDB, READ_WRITE],  # /reg DB
                        0xDC: [0xDC, READ_WRITE],  # /reg DC
                        0xDD: [0xDD, READ_WRITE],  # /reg DD
                        0xDE: [0xDE, READ_WRITE],  # /reg DE
                        0xDF: [0xDF, READ_WRITE],  # /reg DF
                        0xE0: [0xE0, READ_WRITE],  # /reg E0
                        0xE1: [0xE1, READ_WRITE],  # /reg E1
                        0xE2: [0xE2, READ_WRITE],  # /reg E2
                        0xE3: [0xE3, READ_WRITE],  # /reg E3
                        0xE4: [0xE4, READ_WRITE],  # /reg E4
                        0xE5: [0xE5, READ_WRITE],  # /reg E5
                        0xE6: [0xE6, READ_WRITE],  # /reg E6
                        0xE7: [0xE7, READ_WRITE],  # /reg E7
                        0xE8: [0xE8, READ_WRITE],  # /reg E8
                        0xE9: [0xE9, READ_WRITE],  # /reg E9
                        0xEA: [0xEA, READ_WRITE],  # /reg EA
                        0xEB: [0xEB, READ_WRITE],  # /reg EB
                        0xEC: [0xEC, READ_WRITE],  # /reg EC
                        0xED: [0xED, READ_WRITE],  # /reg ED
                        0xEE: [0xEE, READ_WRITE],  # /reg EE
                        0xEF: [0xEF, READ_WRITE],  # /reg EF
                        0xF0: [0xF0, READ_WRITE],  # /reg F0
                        0xF1: [0xF1, READ_WRITE],  # /reg F1
                        0xF2: [0xF2, READ_WRITE],  # /reg F2
                        0xF3: [0xF3, READ_WRITE],  # /reg F3
                        0xF4: [0xF4, READ_WRITE],  # /reg F4
                        0xF5: [0xF5, READ_WRITE],  # /reg F5
                        0xF6: [0xF6, READ_WRITE],  # /reg F6
                        0xF7: [0xF7, READ_WRITE],  # /reg F7
                        0xF8: [0xF8, READ_WRITE],  # /reg F8
                        0xF9: [0xF9, READ_WRITE],  # /reg F9
                        0xFA: [0xFA, READ_WRITE],  # /reg FA
                        0xFB: [0xFB, READ_WRITE],  # /reg FB
                        0xFC: [0xFC, READ_WRITE],  # /reg FC
                        0xFD: [0xFD, READ_WRITE],  # /reg FD
                        0xFE: [0xFE, READ_WRITE],  # /reg FE
                        0xFF: [0xFF, READ_WRITE],  # /reg FF
}          

class DS90UB960_Const:
    def __init__( s):
        # ----- RX SHARED REGISTERS
        s.I2C_DEVICE_ID      = 0x00  # I2C Device ID
        s.DES_ID_OVERRIDE         = 0x01  # 1 = override CAD address with reg
        s.RESET_CTL          = 0x01  # Reset control
        s.ANAPWDN                 = 0x20  # Analog power-down
        s.RESTART_AUTOLOAD        = 0x04  # Restart ROM Auto-load
        s.DIGITAL_RESET1          = 0x02  # Reset digital
        s.DIGITAL_RESET0          = 0x01  # Reset digital  retain registers
        s.GENERAL_CFG        = 0x02  # General configuration
        s.GENERAL_CFG0       = 0x02  # General configuration
        s.GENERAL_CFG1       = 0x02  # General configuration
        s.OUTPUT_EN_MODE          = 0x10  # Output enable Mode
        s.OUTPUT_EN              = 0x08  # Output enable control
        s.OSS_SEL                = 0x04  # OSS sel 
        s.RX_CRC_CHK_ENABLE      = 0x02  # Enable RX CRC (parity) checking
        s.RX_PAR_CHK_ENABLE      = 0x02  # Enable RX parity checking
        s.FORCE_REFCLK_DET       = 0x01  # Force indication of external refclk
        s.REV_MASK_ID        = 0x03 
        s.BOND_STS           = 0x04 
        s.DEVICE_STS         = 0x04 
        s.CFG_CKSUM_STS          = 0x80  # Config Checksum status
        s.CFG_INIT_DONE          = 0x40  # Config Initialization done status
        s.REFCLK_VALID       = 0x10      # Refclk valid frequency
        s.PAR_ERR_THRESH1    = 0x05 
        s.PAR_ERR_THRESH0    = 0x06 
        s.RX_BCC_WDOG        = 0x07  # BCC Watchdog Control
        s.BCC_TIMER_DISABLE        = 0x01  # Disable BCC watchdog timer
        s.I2C_CONTROL1       = 0x08  # I2C control register
        s.LCL_WRITE_DIS_REG  = 0x08 
        s.LCL_WRITE_DIS            = 0x80  # Disable remote writes to local registers
        s.I2C_CONTROL2       = 0x09  # I2C control register
        s.BUS_TIMEOUT_SPDUP        = 0x02 # Speedup I2C Bus Free watchdog timer
        s.BUS_TIMEOUT_DIS          = 0x01 # Disable I2C Bus Free watchdog timer
        s.SCL_HIGH           = 0x0A     # BCC SCL High Time Register
        s.SCL_LOW            = 0x0B     # BCC SCL Low Time Register
        s.RX_PORT_CTL        = 0x0C 
        s.BCC_SLAVE_MAP      = 0x0C 
        s.BCC3_MAP                 = 0x80  # Map control channel 3 I2C slave port
        s.BCC2_MAP                 = 0x40  # Map control channel 2 I2C slave port
        s.BCC1_MAP                 = 0x20  # Map control channel 1 I2C slave port
        s.BCC0_MAP                 = 0x10  # Map control channel 0 I2C slave port
        s.PORT_EN3                 = 0x08  # Enable RX port 3
        s.PORT_EN2                 = 0x04  # Enable RX port 2
        s.PORT_EN1                 = 0x02  # Enable RX port 1
        s.PORT_EN0                 = 0x01  # Enable RX port 0
        s.IO_CTL             = 0x0D 
        s.SEL3P3V                 = 0x80  # 3.3V I/O select
        s.SUPPLY_OV               = 0x40  # 3.3V I/O supply override
        s.IO_SUPPLY_00           = 0x00  # 3.3V I/O supply mode 00
        s.IO_SUPPLY_11           = 0x30  # 3.3V I/O supply mode 11
        s.GPIO_PIN_STS       = 0x0E  # GPIO input values
        s.GPIO_INPUT_CTL     = 0x0F  # GPIO input control
        s.GPIO7_INPUT_EN         = 0x80 # Enable GPIO input
        s.GPIO6_INPUT_EN         = 0x40 # Enable GPIO input
        s.GPIO5_INPUT_EN         = 0x20 # Enable GPIO input
        s.GPIO4_INPUT_EN         = 0x10 # Enable GPIO input
        s.GPIO3_INPUT_EN         = 0x08 # Enable GPIO input
        s.GPIO2_INPUT_EN         = 0x04 # Enable GPIO input
        s.GPIO1_INPUT_EN         = 0x02 # Enable GPIO input
        s.GPIO0_INPUT_EN         = 0x01 # Enable GPIO input
        s.GPIO0_PIN_CTL     = 0x10  # GPIO0 config register
        s.GPIO1_PIN_CTL     = 0x11  # GPIO1 config register
        s.GPIO2_PIN_CTL     = 0x12  # GPIO2 config register
        s.GPIO3_PIN_CTL     = 0x13  # GPIO3 config register
        s.GPIO4_PIN_CTL     = 0x14  # GPIO4 config register
        s.GPIO5_PIN_CTL     = 0x15  # GPIO5 config register
        s.GPIO6_PIN_CTL     = 0x16  # GPIO6 config register
        s.GPIO7_PIN_CTL     = 0x17  # GPIO7 config register
        # The following are used when GPIO_OUT_SRC is 0xx (one RX port)
        s.GPIO_OUT_SEL_PORT_GPIO0    = 0x00 # Output Port Forward GPIO0
        s.GPIO_OUT_SEL_PORT_GPIO1    = 0x20 # Output Port Forward GPIO1
        s.GPIO_OUT_SEL_PORT_GPIO2    = 0x40 # Output Port Forward GPIO2
        s.GPIO_OUT_SEL_PORT_GPIO3    = 0x60 # Output Port Forward GPIO3
        s.GPIO_OUT_SEL_PORT_LOCK     = 0x80 # Output Port LOCK
        s.GPIO_OUT_SEL_PORT_PASS     = 0xA0 # Output Port PASS
        s.GPIO_OUT_SEL_PORT_FRAMEVALID = 0xC0 # Output Port Frame Valid
        s.GPIO_OUT_SEL_PORT_LINEVALID = 0xE0 # Output Port Line Valid
        # The following are used when GPIO_OUT_SRC is DEVICE_STS
        s.GPIO_OUT_SEL_OUT_VAL     = 0x00 # Output GPIO_OUT_VAL
        s.GPIO_OUT_SEL_ANY_LOCK    = 0x20 # OR of all port LOCK signals
        s.GPIO_OUT_SEL_ALL_LOCK    = 0x40 # AND of all port LOCK signals
        s.GPIO_OUT_SEL_ALL_PASS    = 0x60 # AND of all port PASS signals
        s.GPIO_OUT_SEL_FRAMESYNC   = 0x80 # FrameSync signal
        # The following are used when GPIO_OUT_SRC is 11x (one TX port)
        s.GPIO_OUT_SEL_TX_ALL_PASS    = 0x00 # AND of all port PASS signals
        s.GPIO_OUT_SEL_TX_ANY_PASS    = 0x20 # OR of all port PASS signals
        s.GPIO_OUT_SEL_TX_FRAMEVALID  = 0x40 # Output Port Frame Valid
        s.GPIO_OUT_SEL_TX_LINEVALID   = 0x60 # Output Port Line Valid
        s.GPIO_OUT_SEL_TX_SYNC        = 0x80 # Multi-port synchronized
        s.GPIO_OUT_SEL_TX_INT         = 0xA0 # Output Port interrupt
        # The following select which RX port outputs PASS  LOCK  GPIO  and
        # FrameStart
        s.GPIO_OUT_SRC_RX_PORT0    = 0x00 # Select RX Port 0
        s.GPIO_OUT_SRC_RX_PORT1    = 0x04 # Select RX Port 1
        s.GPIO_OUT_SRC_RX_PORT2    = 0x08 # Select RX Port 2
        s.GPIO_OUT_SRC_RX_PORT3    = 0x0C # Select RX Port 3
        # Device Status
        s.GPIO_OUT_SRC_DEVICE_STS    = 0x10 # Select Device Status
        # The following select which TX port outputs PASS  Frame Valid 
        # Line Valid  Synchronized  and Interrupt
        s.GPIO_OUT_SRC_TX_PORT0    = 0x18 # Select TX Port 0
        s.GPIO_OUT_SRC_TX_PORT1    = 0x1C # Select TX Port 1
        #
        s.GPIO_OUT_VAL            = 0x02 # Local output value
        s.GPIO_OUT_EN             = 0x01 # Enable GPIO output
        s.FS_CTL            = 0x18 
        s.FS_INT_BC0            = 0x00 # Internal FrameSync  BC 0
        s.FS_INT_BC1            = 0x10 # Internal FrameSync  BC 1
        s.FS_INT_BC2            = 0x20 # Internal FrameSync  BC 2
        s.FS_INT_BC3            = 0x30 # Internal FrameSync  BC 3
        s.FS_INT_25MHZ          = 0x40 # Internal FrameSync using 25M
        s.FS_EXT_GPIO0          = 0x80 # External FrameSync from GPIO0
        s.FS_EXT_GPIO1          = 0x90 # External FrameSync from GPIO1
        s.FS_EXT_GPIO2          = 0xA0 # External FrameSync from GPIO2
        s.FS_EXT_GPIO3          = 0xB0 # External FrameSync from GPIO3
        s.FS_EXT_GPIO4          = 0xC0 # External FrameSync from GPIO4
        s.FS_EXT_GPIO5          = 0xD0 # External FrameSync from GPIO5
        s.FS_EXT_GPIO6          = 0xE0 # External FrameSync from GPIO6
        s.FS_EXT_GPIO7          = 0xF0 # External FrameSync from GPIO7
        s.FS_EXTERNAL           = 0x80 # 1 = External FrameSync
        s.FS_SINGLE             = 0x08 # 0 = Hi/Lo  1 = 50/50
        s.FS_GEN_MODE           = 0x02 # 0 = Hi/Lo  1 = 50/50
        s.FS_GEN_ENABLE         = 0x01 # Enable FrameSync generation
        s.FS_HI_TIMER1      = 0x19 
        s.UNUSED_REG0       = 0x19  # can be used as a test write register
        s.FS_HI_TIMER0      = 0x1A 
        s.UNUSED_REG1       = 0x1A  # can be used as a test write register
        s.FS_LO_TIMER1      = 0x1B 
        s.FS_LO_TIMER0      = 0x1C 
        s.MAX_FRM0          = 0x1D 
        s.MAX_FRM_HI        = 0x1D 
        s.MAX_FRM1          = 0x1E 
        s.MAX_FRM_LO        = 0x1E 
        s.CSI_PLL_CTL       = 0x1F 
        s.REF_CLK_TST           = 0x04  # Non-200MHz Reference clock (100 or 400)
        s.CSITX_200M            = 0x00  # 200 MHz CSI TX byte clock (1.6G serial)
        s.CSITX_100M_TST        = 0x01  # 100 MHz CSI TX byte clock (VCO=400)
        s.CSITX_100M            = 0x02  # 100 MHz CSI TX byte clock (VCO=800)
        s.CSITX_50M             = 0x03  # 50 MHz CSI TX byte clock (400M serial)
        s.CSITX_MASK            = 0x03  # Mask for CSITX read-modify-write
        s.FWD_CTL1          = 0x20 
        s.FWD_PORT3_DIS         = 0x80  # Disable RX port 3 forwarding
        s.FWD_PORT2_DIS         = 0x40  # Disable RX port 2 forwarding
        s.FWD_PORT1_DIS         = 0x20  # Disable RX port 1 forwarding
        s.FWD_PORT0_DIS         = 0x10  # Disable RX port 0 forwarding
        s.VC3_MAP               = 0x08  # Map virtual channel 3 to CSI-2 port
        s.VC2_MAP               = 0x04  # Map virtual channel 2 to CSI-2 port
        s.VC1_MAP               = 0x02  # Map virtual channel 1 to CSI-2 port
        s.VC0_MAP               = 0x01  # Map virtual channel 0 to CSI-2 port
        s.FWD_CTL2          = 0x21 
        s.CSI_REPLICATE_MODE       = 0x80  # CSI TX outputs replicated
        s.FWD_SYNC_AS_AVAIL        = 0x40  # Sync forwarding as available
        s.CSI1_SYNC_FWD_BASIC      = 0x10  # Basic sync forwarding
        s.CSI1_SYNC_LINE_INTERLEAVE = 0x20  # Sync with line interleaving
        s.CSI1_SYNC_LINE_CONCAT    = 0x30  # Sync with line concatenation
        s.CSI0_SYNC_FWD_BASIC      = 0x04  # Basic sync forwarding
        s.CSI0_SYNC_LINE_INTERLEAVE = 0x08  # Sync with line interleaving
        s.CSI0_SYNC_LINE_CONCAT    = 0x0C  # Sync with line concatenation
        s.CSI1_RR_FWD              = 0x02  # Round robin pkt forwarding
        s.CSI0_RR_FWD              = 0x01  # Round robin pkt forwarding
        s.FWD_STS           = 0x22 
        s.FWD_SYNC_FAIL1        = 0x08  # Forwarding sync failed
        s.FWD_SYNC_FAIL0        = 0x04  # Forwarding sync failed
        s.FWD_SYNC1             = 0x02  # Forwarding synchronized
        s.FWD_SYNC0             = 0x01  # Forwarding synchronized
        s.INTERRUPT_CTL     = 0x23  # Interrupt control
        s.INT_EN                = 0x80  # Global Interrupt Enable
        s.IE_CSI_TX1            = 0x20  # CSI TX port 1 interrupt enable
        s.IE_CSI_TX0            = 0x10  # CSI TX port 0 interrupt enable
        s.IE_RX3                = 0x08  # RX port 3 interrupt enable
        s.IE_RX2                = 0x04  # RX port 2 interrupt enable
        s.IE_RX1                = 0x02  # RX port 1 interrupt enable
        s.IE_RX0                = 0x01  # RX port 0 interrupt enable
        s.INTERRUPT_STS     = 0x24  # Interrupt status
        s.TS_CONFIG         = 0x25  # Timestamp configuration
        s.FS_POLARITY            = 0x40  # FrameSync polarity
        s.TS_AS_AVAIL            = 0x08  # Timestamp ready control
        s.TS_FREERUN             = 0x02  # Freerun mode
        s.TS_MODE                = 0x01  # Timestamp mode
        s.TS_CONTROL        = 0x26  # Timestamp control
        s.TS_FREEZE              = 0x10  # Freeze timestamps
        s.TS_ENABLE3             = 0x08  # Timestamp enable
        s.TS_ENABLE2             = 0x04  # Timestamp enable
        s.TS_ENABLE1             = 0x02  # Timestamp enable
        s.TS_ENABLE0             = 0x01  # Timestamp enable
        s.TS_LINE           = 0x27  # Timestamp line
        s.TS_LINE_HI        = 0x27  # Timestamp line  hi byte
        s.TS_LINE_LO        = 0x28  # Timestamp line  lo byte
        s.TS_STATUS         = 0x29  # Timestamp status
        s.TS_READY               = 0x10  # Timestamp ready
        s.TS_VALID3              = 0x08  # Timestamp valid
        s.TS_VALID2              = 0x04  # Timestamp valid
        s.TS_VALID1              = 0x02  # Timestamp valid
        s.TS_VALID0              = 0x01  # Timestamp valid
        s.TIMESTAMP_P0      = 0x2A  # Timestamp  port 0
        s.TIMESTAMP_P0_HI   = 0x2A  # Timestamp  port 0  hi byte
        s.TIMESTAMP_P0_LO   = 0x2B  # Timestamp  port 0  lo byte
        s.TIMESTAMP_P1      = 0x2C  # Timestamp  port 1
        s.TIMESTAMP_P1_HI   = 0x2C  # Timestamp  port 1  hi byte
        s.TIMESTAMP_P1_LO   = 0x2D  # Timestamp  port 1  lo byte
        s.TIMESTAMP_P2      = 0x2E  # Timestamp  port 2
        s.TIMESTAMP_P2_HI   = 0x2E  # Timestamp  port 2  hi byte
        s.TIMESTAMP_P2_LO   = 0x2F  # Timestamp  port 2  lo byte
        s.TIMESTAMP_P3      = 0x30  # Timestamp  port 3
        s.TIMESTAMP_P3_HI   = 0x30  # Timestamp  port 3  hi byte
        s.TIMESTAMP_P3_LO   = 0x31  # Timestamp  port 3  lo byte
        s.SFILTER_CTL       = 0x40  # Dynamic Filter control
        s.SFIL_ALWAYS_ON          = 0x80  # Enable SFILTER always
        s.SFIL_MEAS_ONLY          = 0x40  # Enable SFILTER measurement only
        s.SFIL_THRESH_CTL_MASK    = 0x30  # SFILTER threshold control mask
        s.SFIL_SMPL_SIZE_MASK     = 0x0C  # SFILTER sample size mask
        s.SFIL_ADAPT_MODE         = 0x02  # Enable SFILTER adapt mode
        s.SFIL_EN           = 0x01  # Enable SFILTER
        s.SFILTER_CFG       = 0x41  # SFILTER Configuration
        s.SFIL_MAX_MASK           = 0xF0  # SFILTER maximum setting mask
        s.SFIL_MIN_MASK           = 0x0F  # SFILTER minimum setting mask
        s.AEQ_CTL           = 0x42  # AEQ control
        s.AEQ_ERR_CTL_MASK        = 0x70  # AEQ error control mask
        s.AEQ_CLK1CLK0_EN         = 0x40  # AEQ clk1clk1 error enable
        s.AEQ_DCA_EN              = 0x20  # AEQ DCA error enable
        s.AEQ_PARITY_EN           = 0x10  # AEQ Parity error enable
        s.AEQ_SFIL_ORDER          = 0x08  # AEQ SFILTER Order
        s.AEQ_2STEP_EN            = 0x04  # AEQ 2-step enable
        s.AEQ_OUTER_LOOP          = 0x02  # AEQ outer loop control
        s.AEQ_SFILTER_EN          = 0x01  # AEQ SFILTER adaption enable
        s.AEQ_ERR_THRESH    = 0x43  # AEQ Error threshold
        s.SFIL_THRESHOLD_HI = 0x44  # SFILTER threshold
        s.SFIL_THRESHOLD_LO = 0x45  # SFILTER threshold

        s.REFCLK_FREQ       = 0xA5  # REFCLK frequency measurement in MHz
        s.ANA_IA_CTL        = 0xB0
        s.IND_ACC_CTL       = 0xB0
        s.IA_REGSEL_PATGEN        = 0x00  # Pattern Generator register Select
        s.IA_REGSEL_FPD_PORT0     = 0x04  # FPD Port0 Analog register Select
        s.IA_REGSEL_FPD_PORT1     = 0x08  # FPD Port0 Analog register Select
        s.IA_REGSEL_FPD_PORT2     = 0x0C  # FPD Port0 Analog register Select
        s.IA_REGSEL_FPD_PORT3     = 0x10  # FPD Port0 Analog register Select
        s.IA_REGSEL_FPD_ALLPORT   = 0x18  # FPD All port Analog register Select
        s.IA_REGSEL_FPD_SHARED    = 0x14  # FPD Shared Analog register Select
        s.IA_REGSEL_CSI           = 0x1C  # CSI Analog register Select 
        s.IA_REGSEL_CONFIG        = 0x20  # eFuse Config data register Select 
        s.IA_REGSEL_DIE_ID        = 0x24  # eFuse DIE ID register Select 
        s.ANA_AUTO_INC            = 0x02  # Analog register auto-increment
        s.IA_AUTO_INC             = 0x02  # Analog register auto-increment
        s.ANA_IA_READ             = 0x01  # Start analog register read
        s.ANA_IA_ADDR       = 0xB1 
        s.IND_ACC_ADDR      = 0xB1 
        s.ANA_IA_DATA       = 0xB2 
        s.IND_ACC_DATA      = 0xB2 
        s.BIST_CTL          = 0xB3 
        s.BIST_PIN_CFG            = 0x08  # BIST configured through pin
        s.BIST_EN                 = 0x01  # BIST control
        s.BC_START_SEQ      = 0xB4 
        s.DIG_DBG1          = 0xB5 
        s.DIGITAL_DEBUG_1   = 0xB5 
        s.DBG_SEL_RX_PORT0        = 0x00  # RX Port 0 debug select
        s.DBG_SEL_RX_PORT1        = 0x04  # RX Port 1 debug select
        s.DBG_SEL_RX_PORT2        = 0x08  # RX Port 2 debug select
        s.DBG_SEL_RX_PORT3        = 0x0C  # RX Port 3 debug select
        s.DBG_SRC_BC_SM           = 0x10  # Back channel state machine
        s.DBG_SEL_BC_DISPLAY      = 0x00 
        s.DBG_SEL_BC_TEST_01      = 0x01 
        s.DBG_SEL_BC_CAMERA       = 0x02 
        s.DBG_SEL_BC_TEST_03      = 0x03 
        s.DBG_SRC_I2C_MASTER        = 0x20  # I2C Master
        s.DBG_SRC_BC_REMOTE_SLAVE    = 0x30  # Back channel remote slave
        s.DBG_SEL_BC_REMOTE0      = 0x00 
        s.DBG_SEL_BC_REMOTE1      = 0x01 
        s.DBG_SEL_BC_REMOTE2      = 0x02 
        s.DBG_SEL_BC_REMOTE3      = 0x03 
        s.DBG_SRC_I2C_SLAVE        = 0x40  # I2C local slave
        s.DBG_SEL_I2C_SLAVE_P0      = 0x00  # Select I2C slave 0
        s.DBG_SEL_I2C_SLAVE_P1      = 0x08  # Select I2C slave 1
        s.DBG_SEL_I2C_SLAVE_SEL1      = 0x01 
        s.DBG_SEL_I2C_SLAVE_SEL2      = 0x02 
        s.DBG_SEL_I2C_SLAVE_SEL3      = 0x03 
        s.DBG_SEL_I2C_SLAVE_SEL4      = 0x04 
        s.DBG_SEL_I2C_SLAVE_SEL5      = 0x05 
        s.DBG_SEL_I2C_SLAVE_SEL6      = 0x06 
        s.DBG_SEL_I2C_SLAVE_SEL7      = 0x07 
        s.DBG_SRC_CSI_TX        = 0x50  # CSI TX
        s.DBG_SEL_CSI_DPHY_SM1      = 0x00 
        s.DBG_SEL_CSI_DPHY_SM2      = 0x01 
        s.DBG_SEL_CSI_DPHY_SM3      = 0x02 
        s.DBG_SEL_CSI_DPHY_SM4      = 0x03 
        s.DBG_SEL_CSI_DPHY_SMCLK      = 0x04 
        s.DBG_SEL_CSI_CTRL_SM      = 0x05 
        s.DBG_SRC_RX_PORT        = 0x60  # RX Port
        s.DBG_SEL_RX_VC_IF          = 0x00 
        s.DBG_SEL_RX_28BIT          = 0x01 
        s.DBG_SEL_RX_40BIT_0      = 0x02 
        s.DBG_SEL_RX_40BIT_1      = 0x03 
        s.DBG_SRC_ANALOG_TEST_POINT    = 0x70  # Analog test point
        s.DBG_SEL_ATP_AC_CH0      = 0x00 
        s.DBG_SEL_ATP_AC_CH1      = 0x01 
        s.DBG_SEL_ATP_AC_CH2      = 0x02 
        s.DBG_SEL_ATP_AC_CH3      = 0x03 
        s.DBG_SRC_CLOCK_OBSERVE    = 0x80  # Clock observe
        s.DIG_DBG2          = 0xB6 
        s.DIGITAL_DEBUG_2   = 0xB6 
        s.CSI_CLK_POL_1           = 0x80  # CSI TX clock 1 polarity
        s.CSI_CLK_POL_0           = 0x40  # CSI TX clock 0 polarity
        s.PAR_ERR_CNTR_MODE       = 0x20  # Keep parity error count through loss of lock
        s.DIS_LINK_PAR            = 0x10  # Disable parity checking for link
        s.DIS_LINKLOSS_PAR        = 0x08  # Disable parity checking for loss of link
        s.CLK_1_0_DIS             = 0x04  # Disable CLK1/CLK0 detection
        s.DCA_DIS                 = 0x02  # Disable DCA
        s.SCRAMBLE_DIS            = 0x01  # Disable Scrambling
        s.DFT_TST_MODES     = 0xB7 
        s.BC_TEST_EN              = 0x80  # Enable all port back channel driver
        s.AON_BYP                 = 0x04  # Bypass always on oscillator
        s.DBG_MUX_MODE            = 0x02  # Debug mux mode
        s.ATP_EN                  = 0x01  # Enable ATP pins
        s.MODE_CAD_STS      = 0xB8 
        s.CAD_DONE                = 0x80 
        s.MODE_DONE               = 0x08 
        s.LINK_ERR_CNT      = 0xB9 
        s.LINK_SFIL_WAIT          = 0x20  # Lock ignore errors during SFILTER wait period
        s.LINK_ERR_CNT_EN         = 0x10  # Enable serial link data integrity error count
        s.LINK_ERR_THRESH         = 0x0F  #Serial link data integrity error count mask
        s.DCA_STS_WAIT_TIME = 0xBA  
        s.VCO_WDOG_DIS        = 0x10  # Disable VCO watch dog
        s.CSI_PLL_CTL2        = 0xBB 
        s.FORCE_CHARGE        = 0x80  # Force charge pulse
        s.PLL_DISABLE            = 0x08  # TX PLL Disable
        s.FV_MIN_TIME        = 0xBC  # Frame Valid Minimum Time
        s.TESTEN_STS        = 0xBD  # TESTEN pin status
        s.TESTEN_3P3_VAL        = 0x20 
        s.TESTEN_VAL            = 0x10 
        s.GPIO_PD_CTL        = 0xBE  # GPIO pulldown control
        s.GPIO7_PD_DIS        = 0x80 
        s.GPIO6_PD_DIS        = 0x40 
        s.GPIO5_PD_DIS        = 0x20 
        s.GPIO4_PD_DIS        = 0x10 
        s.GPIO3_PD_DIS        = 0x08 
        s.GPIO2_PD_DIS        = 0x04 
        s.GPIO1_PD_DIS        = 0x02 
        s.GPIO0_PD_DIS        = 0x01 
        s.FPD3_RX_ID         = 0xF0  # FPD3 RX ID registers
        s.FPD3_RX_ID0         = 0xF0 
        s.FPD3_RX_ID1         = 0xF1 
        s.FPD3_RX_ID2         = 0xF2 
        s.FPD3_RX_ID3         = 0xF3 
        s.FPD3_RX_ID4         = 0xF4 
        s.FPD3_RX_ID5         = 0xF5 
        s.I2C_RX0_ID        = 0xF8  # Port I2C Addresses
        s.I2C_RX1_ID        = 0xF9  
        s.I2C_RX2_ID        = 0xFA  
        s.I2C_RX3_ID        = 0xFB  
        # ----- CSI REGISTERS
        s.CSI_PORT_SEL         = 0x32 
        s.TX_READ_PORT1        = 0x10  # Select TX port 1 for register read
        s.TX_READ_PORT0        = 0x00  # Select TX port 0 for register read
        s.TX_WRITE_PORT1        = 0x02  # Write enable for TX port 1 registers
        s.TX_WRITE_PORT0        = 0x01  # Write enable for TX port 0 registers
        s.TX_WRITE_ALL        = 0x03 
        s.CSI_CTL         = 0x33 
        s.CSI_CTL1         = 0x33 
        s.CSI_CAL_EN             = 0x40  # Enable Initial Cal sequence
        s.CSI_LANE_COUNT4        = 0x00  # 4 CSI lanes
        s.CSI_LANE_COUNT3        = 0x10  # 3 CSI lanes
        s.CSI_LANE_COUNT2        = 0x20  # 2 CSI lanes
        s.CSI_LANE_COUNT1        = 0x30  # 1 CSI lanes
        s.CSI_LANE_COUNT_MASK    = 0x30  # Mask for CSI lane counts
        s.CCI_ULP_NORMAL         = 0x00  # Normal clock/data lane operation
        s.CCI_ULP_LP00_DATA      = 0x04  # Force LP00 on data lanes
        s.CCI_ULP_LP00_BOTH      = 0x0C  # Force LP00 on clock/data lanes
        s.CCI_ULP_MASK           = 0x0C  # Mask for CCI ULP modes
        s.CCI_CONTS_CLK          = 0x02  # Enable CSI continuous clock mode
        s.CSI_CONTS_CLOCK        = 0x02  # Enable CSI continuous clock mode
        s.CSI_ENABLE             = 0x01  # Enable CSI output
        s.CSI_CTL2         = 0x34 
        s.CSI_PASS_MODE          = 0x08  # Assert pass on ALL enabled ports valid
        s.CSI_CAL_INV            = 0x04  # Invert CSI Cal data
        s.CSI_CAL_SINGLE         = 0x02  # Send single short cal sequence
        s.CSI_CAL_PERIODIC       = 0x01  # Enable Periodic Cal sequence
        s.CSI_STS           = 0x35 
        s.TX_PORT_NUM            = 0x10  # TX port number
        s.TX_PORT_SYNC           = 0x02  # TX port Synchronized
        s.CSI_SYNC               = 0x02  # CSI synchronization error flag
        s.TX_PORT_PASS           = 0x01  # TX port PASS
        s.CSI_PASS               = 0x01  # CSI receive port pass error flag
        s.CSI_TX_ICR        = 0x36  # CSI interrupt control register
        s.IE_RX_PORT_INT         = 0x10 
        s.IE_CSI_SYNC_ERR        = 0x08 
        s.IE_CSI_SYNC            = 0x04 
        s.IE_CSI_PASS_ERR        = 0x02 
        s.IE_CSI_PASS            = 0x01 
        s.CSI_TX_ISR        = 0x37  # CSI interrupt status register
        s.IS_RX_PORT_INT        = 0x10 
        s.IS_CSI_SYNC_ERR        = 0x08 
        s.IS_CSI_SYNC         = 0x04 
        s.IS_CSI_PASS_ERR        = 0x02 
        s.IS_CSI_PASS            = 0x01 
        s.CSI_TEST_CTL        = 0x38 
        s.CSI_TEST_PATT_HI    = 0x39 
        s.CSI_TEST_PATT_LOW    = 0x3A 
        # TDA1 register locations
        s.CSI_TEST_CTL_TDA1    = 0x47 
        s.CSI_TEST_PATT_HI_TDA1    = 0x48 
        s.CSI_TEST_PATT_LOW_TDA1 = 0x49 

        # ----- RX PORT REGISTERS
        s.FPD3_PORT_SEL        = 0x4C 
        s.RX_READ_PORT3        = 0x30 
        s.RX_READ_PORT2        = 0x20 
        s.RX_READ_PORT1        = 0x10 
        s.RX_READ_PORT0        = 0x00 
        s.RX_WRITE_PORT3         = 0x08 
        s.RX_WRITE_PORT2         = 0x04 
        s.RX_WRITE_PORT1         = 0x02 
        s.RX_WRITE_PORT0         = 0x01 
        s.RX_WRITE_ALL         = 0x0F 
        s.RX_PORT_STS1      = 0x4D  
        s.BCC_CRC_ERROR        = 0x20  # Bidirectional Control Channel CRC Error Detected
        s.LOCK_STS_CHG        = 0x10  # Detected loss of De lock
        s.BCC_SEQ_ERR            = 0x08  # Control channel sequence error detected
        s.CRC_ERROR            = 0x04  # CRC error detected
        s.PARITY_ERROR        = 0x04  # FPD3 parity error detected
        s.PORT_PASS            = 0x02  # Receiver met PASS criteria
        s.LOCK_DET            = 0x01  # Deserializer locked to recovered clock 
        s.RX_PORT_STS2        = 0x4E 
        s.LINE_LEN_UNSTABLE        = 0x80  # Line length unstable during previous frame
        s.LINE_LEN_CHG        = 0x40  # Line length change detected
        s.FPD3_ENCODE_ERROR        = 0x20  # FPD3 encoder error detected
        s.BUFFER_ERROR        = 0x10  # Packet buffer overflow FIFO error detected
        s.CSI_ERROR            = 0x08  # CSI receive error detected
        s.FREQ_STABLE            = 0x04  # Frequency measurement stable
        s.NO_FPD3_CLK            = 0x02  # No FPD3 clock detected
        s.LINE_CNT_CHG        = 0x01  # Line count changed
        s.RX_FREQ_HIGH         = 0x4F 
        s.RX_FREQ_LOW         = 0x50 
        s.CAMERA_STS0         = 0x51 
        s.CAMERA_STS1         = 0x52 
        s.CAMERA_STS2         = 0x53 
        s.CAMERA_STS3         = 0x54 
        s.RX_PAR_ERR_HI       = 0x55 
        s.RX_PAR_ERR_LO       = 0x56 
        s.BIST_ERR_CNT         = 0x57 
        s.BCC_CONFIG         = 0x58 
        s.I2C_PASS_ALL        = 0x80  # I2C pass-through all transactions
        s.I2C_PASSTHROUGH        = 0x40  # I2C pass-through if decode matches
        s.AUTO_ACK            = 0x20  # Auto acknowledge I2C writes
        s.CAM_BC_EN            = 0x10  # Back channel enable for camera mode
        s.BC_CRC_GEN_EN        = 0x08  # Back channel CRC generator enable
        s.BC_RATE_100            = 0x07  # 100 Mbps back channel
        s.BC_RATE_50            = 0x06  # 50 Mbps back channel
        s.BC_RATE_25            = 0x05  # 25 Mbps back channel
        s.BC_RATE_20            = 0x04  # 20 Mbps back channel
        s.BC_RATE_12P5        = 0x03  # 12.5 Mbps back channel
        s.BC_RATE_10            = 0x02  # 10 Mbps back channel
        s.BC_RATE_1P5625        = 0x01  # 1.5625 Mbps back channel
        s.BC_RATE_2P5            = 0x00  # 2.5 Mbps back channel
        s.BC_RATE_MASK        = 0x07  # Write mask for BC frequency
        s.DATAPATH_CTL1        = 0x59 
        s.FC_CONFIG_OV        = 0x80  # Disable loading of datapath control registers 
                             # from forward channel    
        s.DATAPATH_CTL2        = 0x5A 
        s.SER_ID_REG         = 0x5B 
        s.FREEZE_DEVID        = 0x01  # Freeze remote serializer device ID
        s.SER_ALIAS         = 0x5C 
        s.SER_AUTO_ACK        = 0x01  # Auto acknowledge I2C writes to remote ser
        s.SLAVE_ID_INDEX0     = 0x5D  # Slave Device ID
        s.SLAVE_ID_INDEX1     = 0x5E  # Slave Device ID
        s.SLAVE_ID_INDEX2     = 0x5F  # Slave Device ID
        s.SLAVE_ID_INDEX3     = 0x60  # Slave Device ID
        s.SLAVE_ID_INDEX4     = 0x61  # Slave Device ID
        s.SLAVE_ID_INDEX5     = 0x62  # Slave Device ID
        s.SLAVE_ID_INDEX6     = 0x63  # Slave Device ID
        s.SLAVE_ID_INDEX7     = 0x64  # Slave Device ID
        s.SLAVE_ID_MATCH0     = 0x65  # Slave Device Alias ID - local alias
        s.SLAVE_ID_MATCH1     = 0x66  # Slave Device Alias ID - local alias
        s.SLAVE_ID_MATCH2     = 0x67  # Slave Device Alias ID - local alias
        s.SLAVE_ID_MATCH3     = 0x68  # Slave Device Alias ID - local alias
        s.SLAVE_ID_MATCH4     = 0x69  # Slave Device Alias ID - local alias
        s.SLAVE_ID_MATCH5     = 0x6A  # Slave Device Alias ID - local alias
        s.SLAVE_ID_MATCH6     = 0x6B  # Slave Device Alias ID - local alias
        s.SLAVE_ID_MATCH7     = 0x6C  # Slave Device Alias ID - local alias
        s.PORT_CONFIG        = 0x6D 
        s.CSI_WAIT_FS1        = 0x80  # CSI wait for framestart packet with count 1
        s.CSI_WAIT_FS            = 0x40  # CSI wait for framestart packet
        s.CSI_FWD_CKSUM        = 0x20  # Forward CSI packets with checksum errors
        s.CSI_FWD_ECC            = 0x10  # Forward CSI packets with ECC errors
        s.CSI_FWD_LEN            = 0x08  # Forward CSI packets with length errors
        s.COAX_MODE            = 0x04  # Enable coax cable mode
        s.FPD3_MODE_CSI        = 0x00  # CSI mode
        s.FPD3_MODE_RAW12_50        = 0x01  # RAW12 50 MHz
        s.FPD3_MODE_RAW12_75        = 0x02  # RAW12 75 MHz
        s.FPD3_MODE_RAW10        = 0x03  # RAW10 (100 MHz)
        s.FPD3_MODE_MASK        = 0x03  # Bit mask for FPD3 mode
        s.BC_GPIO_CTL0         = 0x6E 
        s.BC_GPIO_SEL_L0        = 0x8   # Select Logic0 input source
        s.BC_GPIO_SEL_L1        = 0x9   # Select Logic0 input source
        s.BC_GPIO_SEL_FS        = 0xA   # Select FrameSync source
        s.BC_GPIO_CTL1         = 0x6F 
        s.RAW10_ID        = 0x70 
        s.RAW12_ID        = 0x71 
        # The following 5 bit definition lines apply to the RAW10_ID and
        # RAW12_ID registers
        s.RAW_VC0            = 0x00  # Map to Virtual Channel 0
        s.RAW_VC1            = 0x40  # Map to Virtual Channel 1
        s.RAW_VC2            = 0x80  # Map to Virtual Channel 2
        s.RAW_VC3            = 0xC0  # Map to Virtual Channel 3
        s.RAW_VC_MASK            = 0xC0  # Bit mask for RAW VC
        s.CSI_VC_MAP        = 0x72 
        s.LINE_COUNT_HI        = 0x73 
        s.LINE_COUNT_LO        = 0x74 
        s.LINE_LEN_1        = 0x75  # Line length  hi byte
        s.LINE_LEN_0        = 0x76  # Line length  lo byte
        s.FREQ_DET_CTL        = 0x77  # Frequency detect control
        s.MAILBOX1         = 0x78 
        s.MAILBOX2         = 0x79 
        s.CSI_RX_STS        = 0x7A  # CSI Receive Status
        s.LENGTH_ERR            = 0x08  # CSI length error
        s.CKSUM_ERR            = 0x04  # CSI checksum error
        s.ECC2_ERR            = 0x02  # CSI 2-bit ECC error
        s.ECC1_ERR            = 0x01  # CSI 1-bit ECC error
        s.CSI_ERR_COUNTER    = 0x7B  # CSI Error Counter
        s.PORT_CONFIG2        = 0x7C  # Port configuration
        s.RAW10_8BIT_MASK        = 0xC0  # Mask for RAW10/8-bit config
        s.DISCARD_ON_PAR_ERR        = 0x20  # Drop frame on parity err
        s.DISCARD_ON_LINE_SIZE    = 0x10  # Drop frame on line size chg
        s.DISCARD_ON_FRAME_SIZE    = 0x08  # Drop frame on frame size chg
        s.AUTO_POLARITY        = 0x04  # Auto LV/FV polarity detect
        s.LV_POLARITY            = 0x02  # Line Valid Polarity
        s.FV_POLARITY            = 0x01  # Frame Valid Polarity
        s.PORT_PASS_CTL        = 0x7D  # Configure conditions for PASS
        s.PASS_DISCARD_EN        = 0x80  # 1 = diard packets if Pass = 0
        s.PASS_FREEZE            = 0x40  # 1 = include video freeze detect
        s.PASS_LINE_CNT        = 0x20  # 1 = check line count
        s.PASS_LINE_SIZE        = 0x10  # 1 = check line size
        s.PASS_PARITY_ERR        = 0x08  # 1 = check parity errors
        s.PASS_WDOG_DIS        = 0x04  # 1 = disable Pass watchdog timer
        s.PASS_THRESHOLD_0        = 0x00  # Pass at first start of frame
        s.PASS_THRESHOLD_1        = 0x01  # Pass after 1 valid frame
        s.PASS_THRESHOLD_2        = 0x02  # Pass after 2 valid frames
        s.PASS_THRESHOLD_3        = 0x03  # Pass after 3 valid frames
        s.PASS_THRESHOLD_MASK        = 0x03  # Mask for Pass threshold
        s.VIDEO_FREEZE        = 0x7E  # Video freeze detection control
        s.FREEZE_DET_EN        = 0x01  # Enable video freeze detect

        s.BACK_CHAN_DBG     = 0xD0 
        s.PORT_DBG         = 0xD0 
        s.CRC_FRC_ERROR      = 0xD0  # Another name for BACK CHAN DBG reg
        s.AEQ_REVERT            = 0x40  # Revert AEQ functionality to 928 testchip
        s.SER_BIST_ACT        = 0x20  # Serializer BIST active
        s.FPD3_CLK_POL        = 0x10  # Invert FPD3 clock polarity
        s.FORCE_CLK_DET        = 0x08  # Force FPD3 clock detected
        s.DRIVE_BC            = 0x04  # Drive back-channel test
        s.FORCE_ERR            = 0x02  # Force continuous errors in back channel frame
        s.FORCE_1ERR            = 0x01  # Force 1 error into the back channel frame
        s.LOCK_TIME         = 0xD1 
        s.FRC_LOCK_VAL           = 0x80  # Force system lock to value defined in this bit
        s.FRC_LOCK               = 0x08  # Force system lock 
        s.AEQ_TST           = 0xD2 
        s.AEQ_TEST          = 0xD2 
        s.AEQ_RELOCK_MASK        = 0xE0  # AEQ Relock time mask
        s.AEQ_1ST_LOCK           = 0x10  # AEQ first lock mode
        s.AEQ_RST                = 0x08  # AEQ restart adaptation from initial value
        s.AEQ_RESTART            = 0x08  # AEQ restart adaptation from initial value
        s.SET_AEQ_FLOOR          = 0x04  # AEQ adaptation from floor calue
        s.AEQ_TST_SELECT_MASK    = 0x03  # AEQ Test Select output
        s.AEQ_STS           = 0xD3 
        s.AEQ_BYP           = 0xD4 
        s.AEQ_BYPASS        = 0xD4 
        s.AEQ_LOCK_MODE          = 0x10  # AEQ_LOCK_MODE:  1=include AEQ in lock
        s.ADAPT_EQ_BYP           = 0x01  # Enable adaptive EQ bypass
        s.AEQ_MIN_MAX       = 0xD5 
        s.AEQ_MAX_MASK           = 0xF0 
        s.AEQ_MIN_MASK           = 0x0F 
        s.SFILTER_STS_0     = 0xD6  # SFILTER status register 0
        s.SFILTER_MAXED          = 0x80  # SFILTER max limit reached
        s.SFILTER_STABLE         = 0x40  # SFILTER stable - latched low
        s.SFILTER_CDLY_MASK      = 0x3F  # SFILTER clock delay
        s.SFILTER_STS_1     = 0xD7  # SFILTER status register 0
        s.SFILTER_ERROR          = 0x40  # SFILTER measurement error detect
        s.SFILTER_DDLY           = 0x3F  # SFILTER data delay
        s.PORT_ICR_HI       = 0xD8  # Hi byte of Interrupt Control Register
        s.IE_FPD3_ENC_ERR        = 0x04  # Int. on FPD3 RX error
        s.IE_BCC_SEQ_ERR         = 0x02  # Int. on BCC sequence error
        s.IE_BCC_CRC_ERR         = 0x01  # Int. on BCC CRC error
        s.PORT_ICR_LO       = 0xD9  # Lo byte of Interrupt Control Register
        s.IE_VIDEO_FREEZE        = 0x80  # Int. on video freeze
        s.IE_LINE_LEN_CHG        = 0x40  # Int. on line length change
        s.IE_LINE_CNT_CHG        = 0x20  # Int. on line count change
        s.IE_BUFFER_ERR        = 0x10  # Int. on RX buffer error
        s.IE_CSI_RX_ERR        = 0x08  # Int. on CSI RX error
        s.IE_FPD3_PAR_ERR        = 0x04  # Int. on FPD3 RX parity error
        s.IE_PORT_VALID        = 0x02  # Int. on change in Port Valid
        s.IE_LOCK_STS            = 0x01  # Int. on change in lock
        s.PORT_ISR_HI        = 0xDA  # Hi byte of Interrupt Status Register
        s.IS_FPD3_ENC_ERR        = 0x04  # FPD3 RX error
        s.IS_BCC_SEQ_ERR        = 0x02  # BCC sequence error
        s.IS_BCC_CRC_ERR        = 0x01  # BCC CRC error
        s.PORT_ISR_LO        = 0xDB  # Lo byte of Interrupt Status Register
        s.IS_VIDEO_FREEZE        = 0x80  # video freeze
        s.IS_LINE_LEN_CHG        = 0x40  # line length change
        s.IS_LINE_CNT_CHG        = 0x20  # line count change
        s.IS_BUFFER_ERR        = 0x10  # RX buffer error
        s.IS_CSI_RX_ERR        = 0x08  # CSI RX error
        s.IS_FPD3_PAR_ERR        = 0x04  # FPD3 RX parity error
        s.IS_PORT_VALID        = 0x02  # change in Port Valid
        s.IS_LOCK_STS            = 0x01  # change in lock
        # FPD3 RX ID (shared)
        s.FPD3_RX_ID         = 0xF0         # ID String location (value = "_UB960")

class TimeStamp_config:
    def __init__( s):
        s.ts_mode = 0       # TS_MODE configuration setting
        s.ts_mode_names = ['LineStart', 'FrameStart']
        s.ts_freerun = 0        # TS_FREERUN configuration setting
        s.ts_as_avail = 0       # TS_AS_AVAIL configuration setting
        s.ts_res_ctl = 0x0      # TS resolution control
        s.ts_fs_polarity = 0    # FS_POLARITY configuration setting
        
class AEQ_Config:
    def __init__( s):
        s.aeq_parity_en = 0
        s.aeq_dca_en = 0
        s.aeq_clk1clk0_en = 0
        s.aeq_error_threshold = 1    # must be greater than 0
        s.aeq_2step_en = 0          # 2-step enable
        s.aeq_outer = 0         # outer loop control:  1 = AEQ outer,  0 = SFILTER outer
        s.aeq_sfilter_en = 0    # AEQ + SFILTER enable
        s.aeq_sfil_min = 5
        s.aeq_sfil_max = 7
        s.aeq_lock_mode = 0     # AEQ Lock Mode -- 0 : Lock detect circuit,  1 : AEQ lock
        s.aeq_relock_time = 4   # AEQ Relock time setting
        s.aeq_relock_list = ['0.164ms', '0.328ms', '0.655ms', '1.31ms', '2.62ms', '5.24ms', '10.5ms', '21ms']
        s.aeq_1st_lock_mode = 0     # AEQ !st Lock mode
        s.aeq_min = 0
        s.aeq_max = 0xF
    
class Lock_Detect_Config:
    def __init__( s):
        s.error_threshold_en = 0
        s.error_threshold = 3
        s.dis_dca = 0
        s.dis_clk1clk0 = 0
        s.dis_link_par = 1
        s.dis_linkloss_par = 1
        s.par_err_cntr_mode = 0

class Sfilter_Config:
    def __init__( s):
        s.enable = 0
        s.adapt_mode = 0   # 0 = Lock detect, 1 = AEQ Lock, 2 = Always On
        s.sfil_size = 0    # 256, 512, 1024, 2048 samples
        s.threshold_ctl = 0  # Disabled, 60%, 1/2 hysteresis, full hysteresis
        s.measure_only = 0

class DS90UB960_ENG( ALPExtensionModule):
    def __init__( s, *args, **argd):
        ALPExtensionModule.__init__( s, *args, **argd)
        s.devAddr = 0xC0
        s.emulRegs = DS90UB960RegDefaults
        s.Initialize()
        
    def Initialize( s):
        s.modelName = "UNKNOWN"
        s.devAddr = s.rxAddr = 0x60
        s.rxPortCnt = 4     # Number of receive ports
        s.rxPortSel = 0
        s.rxPortWrMask = 0x0
        s.rxCSISel = 0
        s.rxCSIWrMask = 0x0
        s.rxRevId = 0x1
        s.rxValid = False
        s.rxTestdie = False
        s.testDie913mode = False
        s.txValid = [False, False, False, False]
        s.txAddr = [0x0, 0x0, 0x0, 0x0]
        s.txAliasAddr = [0x18, 0x1A, 0x1C, 0x1E]
        s.shortDescription = "N/A"
        s.longDescription  = "N/A"
        #
        s.rx_port_sts1 = [0, 0, 0, 0]   # RX_PORT_STS1 register value
        s.rx_port_sts2 = [0, 0, 0, 0]   # RX_PORT_STS2 register value
        s.rxLinkSts = [0, 0, 0, 0]
        s.rxPassSts = [0, 0, 0, 0]
        s.rxLockStsChg = [0, 0, 0, 0]
        s.lock_chg_cnt = [0, 0, 0, 0]
        s.rxParityFlag = [0, 0, 0, 0]
        s.par_err_cnt = [0, 0, 0, 0]
        s.encode_err_cnt = [0, 0, 0, 0]
        s.rxCoaxMode = [0, 0, 0, 0]
        s.rxPortMode = [0, 0, 0, 0]
        s.rxPortModeTxt = ["CSI/953", "RAW12/LF", "RAW12/HF", "RAW10"]
        s.gpio_pin_sts = [0, 0, 0, 0, 0, 0, 0, 0]
        s.csi_pass_sts = [0, 0]
        s.csi_sync_sts = [0,0]
        # PortMask assignment for writing to each port
        s.portMask = [1, 2, 4, 8]
        # Registers
        s.rx = DS90UB960_Const()
        # GPIO Pin control
        s.gpio0_pin_ctl = 0
        s.gpio1_pin_ctl = 0
        s.gpio2_pin_ctl = 0
        s.gpio3_pin_ctl = 0
        s.gpio4_pin_ctl = 0
        s.gpio5_pin_ctl = 0
        s.gpio6_pin_ctl = 0
        s.gpio7_pin_ctl = 0
        # BC GPIO control for each RX port
        s.bc_gpio_ctl0 = [0, 0, 0, 0]
        s.bc_gpio_ctl1 = [0, 0, 0, 0]
        # AON and BC frequence settings lookup tables
        s.vco_factor = [1, 1, 1, 1, 2, 0.5, 2, 0.5]
        s.td_bc_freq_lookup = [5, 6.25, 10, 12.5, 20, 25, 50, 100]
        s.bc_freq_lookup = [2.5, 1.5625, 10, 12.5, 20, 25, 50, 100]
        # Timestamp control and status
        s.ts_config = TimeStamp_config()
        s.ts_control_val = 0    # value of TS_CONTROL register
        s.ts_config_val = 0     # value of TS_CONFIG register
        s.ts_status_val = 0     # value of TS_STATUS register
        s.ts_valid = [False, False, False, False]
        s.timestamps = [0, 0, 0, 0]   # Most recent timestamp values
        s.ts_skew = [0, 0, 0, 0]      # skew based on most recent timestamp values
        s.ts_unit_list = [40, 80, 160, 1000]   # Timestamp reference period (ns)
        s.ts_units = 40             # Timestamp units (based on ts_unit_list)
        # Port Control variables
        s.rx_port_ctl_val = 0x0F        # RX_PORT_CTL register setting
        s.port_cfg_val = [0, 0, 0, 0]   # PORT_CFG register setting
        s.port_pass_ctl_val = [0, 0, 0, 0]    # PORT_PASS_CTL register setting
        # Forwarding Control variables
        s.replicate_en = False
        s.fwd_ctl1_val = 0xF0       # FWD_CTL1 Register setting 
        s.fwd_ctl2_val = 0xF0       # FWD_CTL2 Register setting 
        s.csi_ctl1_val = [0,0]      # CSI_CTL1 register (per port)
        s.csi_ctl2_val = [0,0]      # CSI_CTL2 register (per port)
        # CSI PLL control
        s.csi_pll_ctl_val = [0,0]  # CSI_PLL_CTL register (per port)
        # AEQ and SFILTER control
        s.lock_detect = Lock_Detect_Config()
        s.aeq_config = AEQ_Config()
        s.sfilter_config = Sfilter_Config()
        
    def SetDeviceSlaveAddr(s, slaveAddr):
        s.devAddr = slaveAddr

    # ReadI2C reads from the specified I2C address
    def ReadI2C( s, devAddr, regIndex, regLength=1):
        if s.demoMode:
            s.rc = 1
            if (regLength == 1):
                if (devAddr == s.devAddr):
                    return s.emulRegs[regIndex][0]
                elif (devAddr == s.rxAddr):
                    return s.emulRegs[regIndex][0]
                elif (devAddr == s.txAddr[0]):
                    return s.emulRegs[regIndex][0]
                else:   # emulate read from missing device
                    s.rc = 0
		    return regIndex
            else:
                readStatus = []
                for i in range(regLength):
                    if (devAddr == s.devAddr):
                        readStatus += [s.emulRegs[regIndex+i][0]]
                    elif (devAddr == s.rxAddr):
                        readStatus += [s.emulRegs[regIndex+i][0]]
                    elif (devAddr == s.txAddr[0]):
                        readStatus += [s.emulRegs[regIndex+i][0]]
                    else:   # emulate read from missing device
		        s.rc = 0
                        readStatus += [regIndex+i]
                return readStatus
            
        if hasattr(s.alpBaseBoard,'shortName'):
            if s.alpBaseBoard.shortName == 'USB2ANY':
                readStatus = s.alpBaseBoard.USB2ANY.i2c_readByteMult(devAddr>>1,regIndex,regLength)
            elif s.alpBaseBoard.shortName == 'Aardvark':
                readValue = s.alpBaseBoard.Aardvark.readI2C(devAddr>>1,regIndex,regLength)
                readStatus = []
                if not readValue:
                    readStatus.append(0)
                    tempList = []
                    for x in range(0,regLength):
                        tempList.append(0)
                    readStatus.append(tempList)
                else:
                    readStatus.insert(0,1)
                    readStatus.append(readValue.tolist())
            else:
                readStatus = NanoALP.ReadI2C( s.GetALPInterface(), devAddr, regIndex, regLength)
        else:
            readStatus = NanoALP.ReadI2C( s.GetALPInterface(), devAddr, regIndex, regLength)
         
        #readStatus = NanoALP.ReadI2C( s.GetALPInterface(), devAddr, regIndex, regLength)
        s.rc = readStatus[0]
        if (regLength == 1):
            return int(array( 'B', readStatus[1]).tolist()[0])
        else:
            return array( 'B', readStatus[1]).tolist()
            
    # WriteI2C writes to the specified I2C address
    def WriteI2C( s, devAddr, regIndex, regVal):
        if s.demoMode:
            s.rc = 1
	    if (devAddr == s.devAddr):  # Only write if address matches
                try:    # Multi-byte write
                    for i in range(len( regVal)):
                        s.emulRegs[regIndex+i][0]= regVal[i]
                except:
                    s.emulRegs[regIndex][0]= regVal
            elif (devAddr == s.rxAddr):
                try:    # Multi-byte write
                    for i in range(len( regVal)):
                        s.emulRegs[regIndex+i][0]= regVal[i]
                except:
                    s.emulRegs[regIndex][0]= regVal
            elif (devAddr == s.txAddr[0]):
                try:    # Multi-byte write
                    for i in range(len( regVal)):
                        s.emulRegs[regIndex+i][0]= regVal[i]
                except:
                    s.emulRegs[regIndex][0]= regVal
	    else:
		s.rc = 0
            return
        try:    # Do multi-byte write
            len(regVal)
            reg_list = regVal
        except:
            reg_list = [regVal,]
        
        if hasattr(s.alpBaseBoard,'shortName'):
            if s.alpBaseBoard.shortName == 'USB2ANY':
                s.alpBaseBoard.USB2ANY.i2c_writeByteMult(devAddr>>1,regIndex,regVal)
            elif s.alpBaseBoard.shortName == 'Aardvark':
                s.alpBaseBoard.Aardvark.writeI2C(devAddr>>1,regIndex,regVal)
            else:
                NanoALP.WriteI2C( s.GetALPInterface(), devAddr, regIndex, array( 'B', regVal).tostring())
        else:
            NanoALP.WriteI2C( s.GetALPInterface(), devAddr, regIndex, array( 'B', [regVal,]).tostring())
        
        #s.rc = NanoALP.WriteI2C( s.GetALPInterface(), devAddr, regIndex, array( 'B', reg_list).tostring())

    # ReadReg reads from the current I2C address specified in "devAddr"
    def ReadReg( s, regIndex, regLength=1):       
        readVal = s.ReadI2C(s.devAddr, regIndex, regLength)
        return readVal
             
    # WriteReg writes to the current I2C address specified in "devAddr"
    def WriteReg( s, regIndex, regVal):
        s.WriteI2C(s.devAddr, regIndex, regVal)
        
    # ReadTXReg reads from the I2C address specified in "txAddr"
    # Device address is based on port number and the txAliasAddr setting for that port
    def ReadTXReg( s, portIndex, regIndex, regLength=1):
        readVal = s.ReadI2C(s.txAliasAddr[portIndex], regIndex, regLength)
        return readVal
            
    # WriteTXReg writes to the I2C address specified in "txAddr"
    # Device address is based on port number and the txAliasAddr setting for that port
    def WriteTXReg( s, portIndex, regIndex, regVal):
        s.WriteI2C(s.txAliasAddr[portIndex], regIndex, regVal)
        
    # ReadRXReg reads from the I2C address specified in "rxAddr"
    def ReadRXReg( s, regIndex, regLength=1):
        readVal = s.ReadI2C(s.rxAddr, regIndex, regLength)
        return readVal
            
    # WriteRXReg writes to the I2C address specified in "rxAddr"
    def WriteRXReg( s, regIndex, regVal):
        s.WriteI2C(s.rxAddr, regIndex, regVal)
                   
    # Set FPD3 Port Selection register
    def Get_FPD3_PORT_SEL( s):
        fpd3_port_sel = s.ReadRXReg(s.rx.FPD3_PORT_SEL)
        s.rxPortSel = fpd3_port_sel >> 4
        s.rxPortWrMask = fpd3_port_sel & 0xF
        
    # Set FPD3 Port Selection register to value in x.rxPortSel, s.rxPortWrMask
    # If no port_sel or write_mask in routine call, current settings will be used
    # If port_sel value is included, but not write_mask, the write mask will be set to select
    # the same port as port_sel
    def Set_FPD3_PORT_SEL( s, port_sel=-1, write_mask=-1):
        if (port_sel in range(4)):
            s.rxPortSel = port_sel
            if (write_mask in range(16)):
                s.rxPortWrMask = write_mask
            else:
                s.rxPortWrMask = 1 << port_sel
        elif (write_mask in range(16)):
            s.rxPortWrMask = write_mask            
        s.WriteRXReg(s.rx.FPD3_PORT_SEL, ((s.rxPortSel << 4) | s.rxPortWrMask))

    # ReadRXPortReg reads from the specified RX Port at I2C address specified in "rxAddr"
    def ReadRXPortReg( s, portIndex, regIndex, regLength=1):
        if (s.rxPortSel != portIndex):
            s.rxPortSel = portIndex
            s.Set_FPD3_PORT_SEL()
        readVal = s.ReadI2C(s.rxAddr, regIndex, regLength)
        return readVal
            
    # WriteRXReg writes to specified port at I2C address specified in "rxAddr"
    def WriteRXPortReg( s, portIndex, regIndex, regVal):
        if (s.rxPortWrMask != s.portMask[portIndex]):
            s.rxPortWrMask = s.portMask[portIndex]
            s.Set_FPD3_PORT_SEL()
        s.WriteI2C(s.rxAddr, regIndex, regVal)
                   
    # WriteRXReg writes using a port Mask at I2C address specified in "rxAddr"
    # Note portMask is not the same as portIndex.  You may use portMask[portIndex] when calling this routine
    def WriteRXPortReg_Mask( s, portMask, regIndex, regVal):
        if (s.rxPortWrMask != portMask):
            s.rxPortWrMask = portMask
            s.Set_FPD3_PORT_SEL()
        s.WriteI2C(s.rxAddr, regIndex, regVal)
                   
    # Set RX CSI TX PortSelection register
    def Get_CSI_PORT_SEL( s):
        csi_port_sel = s.ReadRXReg(s.rx.CSI_PORT_SEL)
        s.rxCSISel = csi_port_sel >> 4
        s.rxCSIWrMask = csi_port_sel & 0x3
        
    # Set RX CSI TX Port Selection register
    # If no port_sel or write_mask in routine call, current settings will be used
    # If port_sel value is included, but not write_mask, the write mask will be set to select
    # the same port as port_sel
    def Set_CSI_PORT_SEL( s, port_sel = -1, write_mask = -1):
        if (port_sel in range(2)):
            s.rxCSISel = port_sel
            if (write_mask in range(4)):
                s.rxCSIWrMask = write_mask
            else:
                s.rxCSIWrMask = 1 << port_sel
        elif (write_mask in range(4)):
            s.rxCSIWrMask = write_mask            
        s.WriteRXReg(s.rx.CSI_PORT_SEL, ((s.rxCSISel << 4) | s.rxCSIWrMask))

    # ReadRXCSItxReg reads from the specified RX CSI port at I2C address specified in "rxAddr"
    def ReadRXCSItxReg( s, portIndex, regIndex, regLength=1):
        if (s.rxCSISel != portIndex):
            s.rxCSISel = portIndex
            s.Set_CSI_PORT_SEL()
        readVal = s.ReadI2C(s.rxAddr, regIndex, regLength)
        return readVal
            
    # WriteRXCSItxReg writes to specified port at I2C address specified in "rxAddr"
    def WriteRXCSItxReg( s, portIndex, regIndex, regVal):
        if (s.rxCSIWrMask != s.portMask[portIndex]):
            s.rxCSIWrMask = s.portMask[portIndex]
            s.Set_CSI_PORT_SEL()
        s.WriteI2C(s.rxAddr, regIndex, regVal)
                   
    # WriteRXCSItxReg writes using a port Mask at I2C address specified in "rxAddr"
    # Note portMask is not the same as portIndex.  You may use portMask[portIndex] when calling this routine
    def WriteRXCSItxReg_Mask( s, portMask, regIndex, regVal):
        if (s.rxCSIWrMask != portMask):
            s.rxCSIWrMask = portMask
            s.Set_CSI_PORT_SEL()
        s.WriteI2C(s.rxAddr, regIndex, regVal)

    # Indirect Register Write
    def Ind_Acc_Write(s, block_select, offset, data, xfer_length=0):
        if (offset > 255):
            print "ERROR - Indirect write to address > 0xFF"
            return(0)
        autoinc = (xfer_length > 1)
        ind_ctl_val = (block_select << 2)
        if (not autoinc):
            s.WriteReg(s.rx.IND_ACC_CTL, ind_ctl_val)
            s.WriteReg(s.rx.IND_ACC_ADDR, offset)
            s.WriteReg(s.rx.IND_ACC_DATA, data)
        else:
            ind_ctl_val |= s.rx.IA_AUTO_INC
            s.WriteReg(s.rx.IND_ACC_CTL, ind_ctl_val)
            s.WriteReg(s.rx.IND_ACC_ADDR, offset)
            for offset2 in range(xfer_length):
                s.WriteReg(s.rx.IND_ACC_DATA, data[offset2])
        return(0)
        
    # Indirect Register Read
    def Ind_Acc_Read(s, block_select, offset, xfer_length=0, verbose=0):
        if (offset > 255):
            print "ERROR - Indirect read from address > 0xFF"
            return(0)
        s.WriteReg(s.rx.IND_ACC_ADDR, offset)
        autoinc = (xfer_length > 1)
        ind_ctl_val = (block_select << 2)
        if (not autoinc):
            s.WriteReg(s.rx.IND_ACC_CTL, ind_ctl_val)
            temp_rd = s.ReadReg(s.rx.IND_ACC_DATA, 1)
            print "Indirect Read, block: %d, address: %x Result: %x" \
                    % (block_select, offset, temp_rd)
            return(temp_rd)
        else:
            ind_ctl_val |= s.rx.IA_AUTO_INC
            s.WriteReg(s.rx.IND_ACC_CTL, ind_ctl_val)
            temp_rd = []
            for offset2 in range(xfer_length):
                rd_offset = (offset + offset2) & 0xFF
                temp_rd += [s.ReadReg(s.rx.IND_ACC_DATA, 1)]
                if (verbose): print "Indirect Read, block: %d, address: %x Result: %x" \
                    % (block_select, rd_offset, temp_rd[offset2])
            return(temp_rd)

    # PollTxDevices searches for devices at the address in the SER_ID_REG location.
    # Devices are assumed to be remote devices
    def PollTxDevices(s, portIndex=0, remote=1, silent = 0):
        # Check for RX Lock.  If not locked, assume not valid TX
        locked = s.GetRxPortStatus(portIndex)
        if locked:
            # Enable control channel
            s.txAddr[portIndex] = s.ReadRXPortReg(portIndex, s.rx.SER_ID_REG)
            s.txAddr[portIndex] &= 0xFE
            if (s.txAddr[portIndex] != 0):
                # enable back channel
                sts = [ord('_'), ord('U'), ord('B'), ord('9'), ord('1'), ord('3')]
                s.txValid[portIndex] = True
            else:
                s.txValid[portIndex] = False
        else:
                s.txValid[portIndex] = False   
 
        if s.txValid[portIndex]:
            # Enable access to Serializer
            temp_reg58 = s.ReadRXPortReg(portIndex, s.rx.BCC_CONFIG)
            s.WriteRXPortReg(portIndex, s.rx.BCC_CONFIG, (temp_reg58 | s.rx.I2C_PASSTHROUGH))
            temp_alias = s.ReadRXPortReg(portIndex, s.rx.SER_ALIAS)
            if (temp_alias !=0):
                s.txAliasAddr[portIndex] = temp_alias
            else:    
                s.WriteRXPortReg(portIndex, s.rx.SER_ALIAS, (s.txAliasAddr[portIndex]))
            # Check serializer Address for match
            read_addr = s.ReadI2C(s.txAliasAddr[portIndex], 0)
            if (read_addr != s.txAddr[portIndex]):
                s.txValid[portIndex] = False
        if (not s.txValid[portIndex]):
            temp_reg58 = s.ReadRXPortReg(portIndex, s.rx.BCC_CONFIG)
            s.WriteRXPortReg(portIndex, s.rx.BCC_CONFIG, (temp_reg58 & 0xBF))
            s.WriteRXPortReg(portIndex, s.rx.SER_ALIAS, 0x00)
        
        if s.txValid[portIndex]:
            #if not silent and s.bcc_cfg.verbose:
            if not silent:
                print "Found serializer at address 0x%x" % (s.txAddr[portIndex])
            return 0
        else:
            if not silent:
                print "FAILED polling for Transmitter I2C address"
            return 1

    # PollRxDevices searches for "_" in the first byte and an even number in the sixth byte.
    def PollRxDevices(s, remote=0, silent = 0):
        if s.rxValid:
            # For local device, first try previous valid address, if it exists
            sts = s.ReadI2C(s.rxAddr, s.rx.I2C_DEVICE_ID, 1)
            if (s.rc and (sts == s.rxAddr)):
                s.rxValid = True
            else:
                s.rxValid = False
        else:
            # Otherwise poll full range; s.rxValid is already False
            for addr in range (128):
                sts = s.ReadI2C(addr<<1, 0x0, 1)
                if (s.rc and (sts == addr<<1)):
                    s.rxAddr = (addr<<1)
                    s.rxValid = True
                    break
 
        if s.rxValid:
            # Get revision ID to determine Testdie versus Production die
            revid = s.ReadRXReg(s.rx.REV_MASK_ID)
            revid >>= 4
            s.rxRevId = revid
            s.rxTestdie = False
            # Check if Testdie (read ID at 0xF0-0xF5)
            id_val = s.ReadRXReg(s.rx.FPD3_RX_ID, 6)
            if ((id_val == [0, 0, 0, 0, 0, 0]) and (s.rxRevId < 2)):
                s.modelName = "ADAS_HUB Testdie"
                s.rxTestdie = True
            elif (id_val[0:5] == UB960_ID_CODE[0:5]):
                s.modelName = "DS90UB96" + chr(id_val[5])
            else:
                s.modelName = "UNKNOWN DESERIALIZER"
            if (s.rxTestdie):
                s.bc_freq_lookup = s.td_bc_freq_lookup;
                
            if (not remote):
                s.devAddr = s.rxAddr
            if not silent:
                print "Found deserializer at address 0x%x" % (s.rxAddr)
            return 0
        else:
            if not silent:
                print "FAILED polling for Receiver I2C address"
            return 1

    def ApplyTestdieWorkarounds(s, testdie_913):
        if (testdie_913):
            # Set VCO frequency
            s.WriteRXReg(0x1f, 0x05) # VCO to 400MHz for BC 2.5Mbps
            s.testDie913mode = True
            s.WriteRXReg(0x08, 0x06)  # Change I2C Control 1 timers
            s.WriteRXReg(0x0A, 0x40)  # Change SCL HIGH time
            s.WriteRXReg(0x0B, 0x40)  # Change SCL Low Time            
        else:
            s.WriteRXReg(0x1f, 0x02) # VCO to 800MHz for BC 5Mbps+
            s.testDie913mode = True
            s.WriteRXReg(0x08, 0x1E)  # Default I2C Control 1 timers
            s.WriteRXReg(0x0A, 0x7F)  # Default SCL HIGH time
            s.WriteRXReg(0x0B, 0x7F)  # Default SCL Low Time            
        return
        
    # Set default register values for untrimmed UB964 devices
    def ApplyUntrimmedWorkarounds(s):
        #VOD and back channel rise and fall time adjusted to these target values:

        #VOD = 220 mV
        # FPD3 Share registers, address 0x4
        s.Ind_Acc_Write(0x5,0x4, 0x04)

        #tRF = 6.67 ns
        #All FPD3 Port registers, address 0x14
        s.Ind_Acc_Write(0x6,0x14, 0x1F)
         
        #Echo canceller adjust also needs to be implemented
        # All port registers, address 0x13
        s.Ind_Acc_Write(0x6,0x13, 0x25)

        return
        
    def GetDevInfo(s):
        # Local actual deserializer
        s.PollRxDevices(silent=1)
                    
        s.shortDescription = s.modelName
        if (s.modelName != "UNKNOWN DESERIALIZER"):
            s.longDescription  = s.modelName + " FPD-Link III Deserializer"
        else:
            s.longDescription = s.modelName
        
        # s.partnerShortDescription = "DS90UB913A"
        # s.partnerShortDescription = "DS90UB953_ENG"
        # s.partnerLongDescription  = "DS90UB913A FPD-Link III Serializer"

        # Get Device Operating Mode
        if s.rxValid:
            for port_num in range(2):
                port_config = s.ReadRXPortReg(port_num, s.rx.PORT_CONFIG)
                s.rxCoaxMode[port_num] = (port_config & s.rx.COAX_MODE) == s.rx.COAX_MODE
                s.rxPortMode[port_num] = (port_config & s.rx.FPD3_MODE_MASK)
                if s.rxPortMode[0] == 0:
                    s.partnerShortDescription = "DS90UB953_ENG"
                else:
                    s.partnerShortDescription = "DS90UB913"
    
        # Check for Serializer
        if (s.rxValid):
            for portIndex in range(2):
                s.PollTxDevices(portIndex, remote=1, silent=1)
            
        #s.capa = CapabilitiesMap[s.dev]
        #s.partCapa = CapabilitiesMap[s.partDev]        
        return 1

    # Get current status for selected RX Port
    def GetRxPortStatus(s, portIndex):
        # Read port Status
        port_sts = s.ReadRXPortReg(portIndex, s.rx.RX_PORT_STS1, 2)
        s.rx_port_sts1[portIndex] = port_sts[0]
        s.rx_port_sts2[portIndex] = port_sts[1]
        s.rxLinkSts[portIndex] = (port_sts[0] & s.rx.LOCK_DET) == s.rx.LOCK_DET
        s.rxPassSts[portIndex] = (port_sts[0] & s.rx.PORT_PASS) == s.rx.PORT_PASS
        s.rxLockStsChg[portIndex] = (port_sts[0] & s.rx.LOCK_STS_CHG) == s.rx.LOCK_STS_CHG
        s.rxParityFlag[portIndex] = (port_sts[0] & s.rx.PARITY_ERROR) == s.rx.PARITY_ERROR
        return(s.rxLinkSts[portIndex])

    def GetParityErrors(s, portIndex):
        #Disable checking
        temp_val = s.ReadReg(s.rx.GENERAL_CFG)
        s.WriteReg(s.rx.GENERAL_CFG, (temp_val & 0xFD))
        #Read parity error count
        parity_err_list = s.ReadRXPortReg(portIndex, s.rx.RX_PAR_ERR_HI, 2)
        # Convert to integer
        parity_err_cnt = parity_err_list[1] + (parity_err_list[0] << 8)
        # Reneable Parity checking
        s.WriteReg(s.rx.GENERAL_CFG, (temp_val  | s.rx.RX_PAR_CHK_ENABLE))        
        return(parity_err_cnt)
    
    def GetRxPortFreq(s, portIndex):
        # Read port Frequency
        freq = s.ReadRXPortReg(portIndex, s.rx.RX_FREQ_HIGH)
        # Adjust frequency based on VCO selection
        vco_select = s.ReadRXReg(s.rx.CSI_PLL_CTL) & 0x7
        if ((vco_select == 5) or (vco_select == 7)):
            freq = freq / 2
        elif ((vco_select == 4) or (vco_select == 6)):
            freq = freq * 2
        return(freq)

    def GetRxLineLen(s, portIndex):
        # Read Line Length (2 bytes)
        line_len = s.ReadRXPortReg(portIndex, s.rx.LINE_LEN_1, 2)
        line_len_bytes = (line_len[0] << 8) | line_len[1]
        return(line_len_bytes)

    def GetRxLineCnt(s, portIndex):
        # Read line count (2 bytes)
        line_cnt = s.ReadRXPortReg(portIndex, s.rx.LINE_COUNT_HI, 2)
        line_cnt_bytes = (line_cnt[0] << 8) | line_cnt[1]
        return(line_cnt_bytes)

    # Return Back channel frequency in MHz for specified port
    def GetRxPortBCFreq(s, portIndex):
        aon_setting = s.ReadRXReg(s.rx.CSI_PLL_CTL) & 0x7
        bc_setting = s.ReadRXPortReg(portIndex, s.rx.BCC_CONFIG) & 0x7
        bc_freq = s.bc_freq_lookup[bc_setting] * s.vco_factor[aon_setting]
        #frame_period = 30 * 1e-6 / bc_freq
        return(bc_freq)

    # Get current status for selected CSI TX POrt
    def GetCSITXStatus(s, portIndex):
        # Read port Status
        port_sts = s.ReadRXCSItxReg(portIndex, s.rx.CSI_STS)
        s.csi_pass_sts[portIndex] = (port_sts & s.rx.TX_PORT_PASS) == s.rx.TX_PORT_PASS
        s.csi_sync_sts[portIndex] = (port_sts & s.rx.TX_PORT_SYNC) == s.rx.TX_PORT_SYNC
        return(s.csi_pass_sts[portIndex])

    # Return Reference clock frequency in MHz (options are 100/200/400)
    def GetRefFreq(s):
        aon_setting = s.ReadRXReg(s.rx.CSI_PLL_CTL) & 0x7
        ref_freq = 200 * s.vco_factor[aon_setting]
        return(ref_freq)

    def GetGPIOPinStatus(s):
        # Read GPIO Pin Status register
        pin_sts = s.ReadRXReg(s.rx.GPIO_PIN_STS)
        for bit_num in range(8):
            s.gpio_pin_sts[bit_num] = pin_sts & 0x1
            pin_sts = pin_sts >> 1
        return(s.gpio_pin_sts)

    # Enable Timestamps for selected Ports
    def ConfigureTimestamps(s):
        ts_config = s.ts_config
        s.ts_config_val = ts_config.ts_mode
        s.ts_config_val |= (ts_config.ts_freerun << 1)
        s.ts_config_val |= (ts_config.ts_as_avail << 3)
        s.ts_config_val |= (ts_config.ts_res_ctl << 4)
        s.ts_config_val |= (ts_config.ts_fs_polarity << 6)
        s.WriteReg(s.rx.TS_CONFIG, s.ts_config_val)
        s.ts_units = s.ts_unit_list[ts_config.ts_res_ctl]
        return(s.ts_config_val)

    # Get Timestamps Config and Control based on current register settings
    def GetTimestampConfig(s):
        s.ts_config_val = s.ReadReg(s.rx.TS_CONFIG)
        
        s.ts_config.ts_mode = (s.ts_config_val & s.rx.TS_MODE) == s.rx.TS_MODE
        s.ts_config.ts_freerun = (s.ts_config_val & s.rx.TS_FREERUN) == s.rx.TS_FREERUN
        s.ts_config.ts_as_avail = (s.ts_config_val & s.rx.TS_AS_AVAIL) == s.rx.TS_AS_AVAIL
        s.ts_config.ts_res_ctl = (s.ts_config_val & 0x30) >> 4
        s.ts_config.ts_fs_polarity = (s.ts_config_val & s.rx.FS_POLARITY) == s.rx.FS_POLARITY
        s.ts_units = s.ts_unit_list[s.ts_config.ts_res_ctl]
        return(s.ts_config_val)

    # Enable Timestamps for selected Ports
    def EnableTimestamps(s, port_list):
        port_enable = 0
        for portIndex in range(len(port_list)):
            if (port_list[portIndex] < 0) or (port_list[portIndex] > 3):
                print "ERROR - value in port_list is out of range (0..3) %d" % port_list[portIndex]
            else:
                port_enable |= 0x1 << port_list[portIndex]
        s.ts_control_val = port_enable
        s.WriteReg(s.rx.TS_CONTROL, s.ts_control_val)
        return(port_enable)
        
    # Read timestamps and save in integer list
    def ReadTimestamps(s, get_all = False):
        timestamp_list = s.ReadReg(s.rx.TIMESTAMP_P0, 8)
        print timestamp_list
        s.ts_valid = [False, False, False, False]
        s.ts_valid[0] = ((s.ts_status_val & s.rx.TS_VALID0) == s.rx.TS_VALID0) or get_all
        s.ts_valid[1] = ((s.ts_status_val & s.rx.TS_VALID1) == s.rx.TS_VALID1) or get_all
        s.ts_valid[2] = ((s.ts_status_val & s.rx.TS_VALID2) == s.rx.TS_VALID2) or get_all
        s.ts_valid[3] = ((s.ts_status_val & s.rx.TS_VALID3) == s.rx.TS_VALID3) or get_all
        
        if (s.ts_valid[0]):
            s.timestamps[0] = (timestamp_list[0] << 8) | timestamp_list[1]
        if (s.ts_valid[1]):
            s.timestamps[1] = (timestamp_list[2] << 8) | timestamp_list[3]
        if (s.ts_valid[2]):
            s.timestamps[2] = (timestamp_list[4] << 8) | timestamp_list[5]
        if (s.ts_valid[3]):
            s.timestamps[3] = (timestamp_list[6] << 8) | timestamp_list[7]
        return(s.ts_valid[0] | s.ts_valid[1] | s.ts_valid[2] | s.ts_valid[3])
        
    # Get Timestamps for active RX ports
    def GetTimestamps(s, verbose=False):
        # Read TS Status
        s.ts_status_val = s.ReadReg(s.rx.TS_STATUS)
        ts_ready = ((s.ts_status_val & s.rx.TS_READY) == s.rx.TS_READY)
        if (not ts_ready):
            return(0)
        # If ready, Freeze timestamps
        s.WriteReg(s.rx.TS_CONTROL, s.ts_control_val | s.rx.TS_FREEZE)
        # Read Timestamps
        s.ReadTimestamps()
        # Un-freeze timestamps
        s.WriteReg(s.rx.TS_CONTROL, s.ts_control_val)
        if (verbose):
            for portIndex in range(4):
                if (s.ts_valid[portIndex]):
                    valid_str = 'Valid'
                else:
                    valid_str = 'Not Valid'
                print "Port %d Timestamp (%s): %d" % (portIndex, valid_str, s.timestamps[portIndex])
        return(ts_ready)
        
    # Get skew for timestamps
    # Reported in units of ns
    def GetTimestampSkew(s, verbose=False):
        max_skew = 0
        # Determine minimum/maximum timestamps
        min_ts = 0xffff
        max_ts = 0x0000
        for portIndex in range(4):
            if (s.ts_valid[portIndex]):
                if (s.timestamps[portIndex] < min_ts):
                    min_ts = s.timestamps[portIndex]
                if (s.timestamps[portIndex] > max_ts):
                    max_ts = s.timestamps[portIndex]
        if (verbose):
            print "Minimum timestamp = %d", min_ts
            print "Maximum timestamp = %d", max_ts
        max_skew = max_ts - min_ts
        for portIndex in range(4):
            if (s.ts_valid[portIndex]):
                s.ts_skew[portIndex] = (s.timestamps[portIndex] - min_ts) * s.ts_units
                print "Port %d skew: %d ns" % (portIndex, s.ts_skew[portIndex])
        return(max_skew)
        
    # Restart Adaptive EQ
    def RestartAeq(s, port):
        aeq_test_val = s.ReadRXPortReg(port, s.rx.AEQ_TEST)
        s.WriteRXPortReg(port, s.rx.AEQ_TEST, aeq_test_val | s.rx.AEQ_RESTART)

    def Deinit( s):
        """Called to cleanup state and resources when we're being unloaded."""
        pass

    def GetLinkStatus(s):
        # Cable link detect
        if s.demoMode:
            return 1
        # link = s.ReadRXReg(0x00) #Check if the slave's DES ID is the same as the local Device ID
         #Check bit 0 of register 0x1C
        elif (s.GetRxPortStatus(0)):  #elif ((s.ReadReg(0x4D) & 0x01) == 0x01):
            return 1 #s.ReadReg(0x06)
        elif (s.GetRxPortStatus(1)):
            return 1
        elif (s.GetRxPortStatus(2)):
            return 1
        elif (s.GetRxPortStatus(3)):
            return 1
        else:
            return 0

    def GetRefClkFreq(s):
        refclk_sts = s.ReadReg(s.rx.DEVICE_STS)
        refclk_sts &= s.rx.REFCLK_VALID
        
        if (refclk_sts == s.rx.REFCLK_VALID):
            # Read Frequency
            freq = s.ReadReg(s.rx.REFCLK_FREQ)
            freq_txt = "%2d MHz" % freq
        else:
            freq_txt = "No"

        return(freq_txt)
        
    def DigitalReset(s):
        # Digital Reset
        s.WriteReg(s.rx.RESET_CTL, s.rx.DIGITAL_RESET1)