#include <stdbool.h>
#include <stdio.h>
#include <string.h>
#include <hid.h>
#include <fcntl.h>
#include <linux/hiddev.h>
#include <sys/ioctl.h>
#include <sys/stat.h>
#include <errno.h>
#include <string>
#include <stdlib.h>
#include <linux/hid.h>
//#include <linux/libusb.h>
//#include </usr/local/stow/libhid/include/hid.h>
//#include </usr/local/stow/libhid/include/hidparser.h>
#include <usb.h>
#include "DescriptorDeclarations.h"
#include <time.h>
#include "Hex2Bin.cpp"

#define SKEL_IOC_MAGIC 	0xEB
#define DOWNLOAD_ROM _IOR(SKEL_IOC_MAGIC,  0,char *)

int    fd;
int 	HIDDevicesCount=0;
int     DevDevicesCount=0;

struct hiddev_report_info rep_info;
struct hiddev_devinfo dev_info;
struct hiddev_field_info finfo;

char *BinName=NULL;
char *HexName=NULL;

uint  devVID;;
unsigned int  devPID;
uchar PIDTI [2];
uchar ID_hex[4];

char devlist[10][100]={'0','0','0','0','0','0','0','0','0','0'};
//char* DEVICE=NULL;
char* Device=NULL;

Output_Buffer OutBuffer;

void HIDGetFeatureReport(char*  DevName);

struct hiddev_usage_ref uref;

char* ManufactureID=NULL;
char* VID=NULL;
char* PID=NULL;
char* ProductID=NULL;
char* SerialID=NULL;
char* Ex_SerialID=NULL;
bool ExtDescriptors_flag=false;
bool allflag=false;
bool UseSpeciicSerialNumber = false;
bool UseDieIDinSerNum = true;
bool Bin = false;
int* HexFWBuffer=NULL;
void GetRawDevices(const char * DevNamePrefix )
{
    DIR *dp;
    struct dirent *ep;       
    char * DevName = NULL;
    char** RawDevPathName =NULL;
    int i; 
    uint DevNamePrefixL = 0;
    
    RawDevPathName =new char* [128];
    DevNamePrefixL = strlen( DevNamePrefix ); 
    DevDevicesCount=0;
		
    dp = opendir ("/dev/");    
 
   if (dp == NULL)
    {	
	//debug printf("* Unable to open device directory.\n");
	return;
    }
    while ( (ep = readdir(dp)) )
    {	
	if((strlen(ep->d_name)) >DevNamePrefixL)
	{
	    DevName = new char[DevNamePrefixL + 1];	  
	    strncpy (DevName, ep->d_name, DevNamePrefixL);
	    DevName[DevNamePrefixL] = '\0';

	    i = strcmp( DevName, DevNamePrefix );
	    if(i == 0)
	    {	
		RawDevPathName [DevDevicesCount] = ep->d_name ;	
		DevDevicesCount++;
	    }
	}
    }
    delete DevName;
    (void) closedir (dp);
}


void GetHIDDevices(const char *DevNamePrefix)
{
	
    DIR *dp;
    struct dirent *ep;       
    char * DevName = NULL;
    char** HIDDevPathName =NULL;
    int i; 
    unsigned int DevNamePrefixL = 0;
    
    
    int nn;	
    
    HIDDevPathName =new char*[128];    
    DevNamePrefixL = strlen( DevNamePrefix );
    HIDDevicesCount=0;

    dp = opendir ("/dev/usb");    
    if (dp == NULL)
    	{		
	    	//debug printf("* Unable to open device directory.\n");
		return;
    	}
    else 
    {
	printf("\nNo. TUSB9260 Device\n");
    }

    while ( (ep = readdir(dp)) )
    {	
	if((strlen(ep->d_name)) >DevNamePrefixL)
	{
	    DevName = new char[DevNamePrefixL + 1];	  
	    strncpy (DevName, ep->d_name, DevNamePrefixL);
	    DevName[DevNamePrefixL] = '\0';

	    i = strcmp( DevName, DevNamePrefix );
	    
	    if(i == 0)
	    {	
		if(DevNamePrefix == "hiddev")
		{  
		    DevName = new char[strlen(ep->d_name) +1 ];
		    strncpy (DevName, ep->d_name, strlen(ep->d_name));
		    DevName[strlen(ep->d_name)] = '\0';
		    
		    HIDGetFeatureReport (DevName);
		    
		   
		     
		    if ( PIDTI[0]==0x92 && PIDTI[1]==0x60 )
		    {         
			if(dev_info.devnum < 10)
			{
			   if(devPID== 0x926b){  //remove when  process implemented
			    nn=sprintf (devlist[HIDDevicesCount+1],"VID = 0x0%x / PID = 0x%x %s Bus/Dev=00%x/00%d", devVID,devPID, ep->d_name, dev_info.busnum,dev_info.devnum );
			   }
			    
			}
			else
			{
                           if(dev_info.devnum < 100)
			   {
			    if(devPID== 0x926b){  //remove when ERASE process implemented
		            nn=sprintf (devlist[HIDDevicesCount+1],"VID = 0x0%x / PID = 0x%x %s Bus/Dev=00%x/0%d", devVID,devPID, ep->d_name, dev_info.busnum,dev_info.devnum );
			    }
			   }
                           else
			   {
	                    if(devPID== 0x926b){  //remove when ERASE process implemented
		           nn=sprintf (devlist[HIDDevicesCount+1],"VID = 0x0%x / PID = 0x%x %s Bus/Dev=00%x/%d", devVID,devPID, ep->d_name, dev_info.busnum,dev_info.devnum );
			    }
			   }
			}
			if(devPID== 0x926b)
			{  //remove when ERASE process implemented
			printf("device = %s", DevName);
			
			HIDDevPathName [HIDDevicesCount] = DevName ;
			HIDDevicesCount++;
					
			if (HIDDevicesCount == 1)
			{
                        printf("\n0. Program all devices.\n");
			printf("%d. %s\n",HIDDevicesCount, devlist[1]);
			//debug printf("%d. %s\n",HIDDevicesCount, devlist[2]);
			}
			else if (HIDDevicesCount > 1)
			{
			printf("%d. %s\n",HIDDevicesCount, devlist[HIDDevicesCount]);
			}
			}
			}
		}			
	      }
	}
     }	
	
 (void) closedir (dp);
}	 


    

     

void HIDGetFeatureReport(char*  DevName)
{
    int FR, DevNameSize;
    char* FileName=NULL;
    int ret;
    uint i, j;
       
    uref.value = 1;
    DevNameSize = strlen(DevName); 
    FileName = new char [DevNameSize + 6];
    
    strcpy (FileName, "/dev/usb/");
    strncat ( FileName,DevName,DevNameSize);
         
    FR = open(FileName, O_RDWR);    
    if (FR <0)
    {
	//SWAT debug printf (" Unable to open device directory. \n");
    }
    else
    {
	//SWAT debug printf ("Open Ok \n"); 	
     }    
    
    if (ioctl(FR, HIDIOCINITREPORT,0)<0)
    {
          //SWAT debug printf("ERROR: HIDIOCINREPORT FAILED \n");          
    }
    else
    {
	// SWATdebug printf("OK: HIDIOCINREPORT\n");
	rep_info.report_id = HID_REPORT_ID_FIRST;
	rep_info.report_type = HID_REPORT_TYPE_FEATURE; 
	// SWATdebug printf("Type: %d.\n", rep_info.report_type);
	// SWATdebug printf("ID: %d.\n", rep_info.report_id);
	// SWATdebug printf("Fields: %d.\n\n", rep_info.num_fields);
	                       
	ret = ioctl(FR, HIDIOCGDEVINFO, &dev_info);
	
	if(ret == -1)
	{
	    printf("ERROR:  HIDIOCGDEVINFO  failed\n"); 
	}
	else
	{
	      devVID = dev_info.vendor;
	      devPID =dev_info.product & 0x0000FFFF ;
	      //SWAT debug printf("VID = %x \n PID = %x \n",devVID, devPID );
	  }
	
	ret = ioctl(FR, HIDIOCGREPORTINFO, &rep_info);
	
	if(ret == -1)
	{
	    printf("ERROR:  HIDIOCGREPORTINFO  failed\n"); 
	}
	
	// SWAT printf("Type: %d.\n", rep_info.report_type);
	// SWAT printf("ID: %d.\n", rep_info.report_id);
	// SWAT printf("Fields: %d.\n", rep_info.num_fields);
	
	// SWAT printf("ret = %d.\n", ret);
	
	while (ret >= 0)
	{
	  for (i = 0; i < rep_info.num_fields; i++)
	  { 
	      finfo.report_type = rep_info.report_type;
	      finfo.report_id = rep_info.report_id;
	      finfo.field_index = i;
	      if (-1 == ioctl(FR, HIDIOCGFIELDINFO, &finfo))
	      {
		 printf("HIDIOCGFIELDINFO FAILED \n"); 
	      }

	      for (j = 0; j < finfo.maxusage; j++) 
	      {
		  uref.report_type = finfo.report_type;
		  uref.report_id   = finfo.report_id;
		  uref.field_index = i;
		  uref.usage_index = j;
		  if (-1 == ioctl(FR, HIDIOCGUCODE, &uref))
		  {
		    fprintf(stderr, "HIDIOCGUCODE (%s)\n", strerror(errno));
		  }
		  if (-1 == ioctl(FR, HIDIOCGUSAGE, &uref))
		  {
		      fprintf(stderr, "HIDIOCGUSAGE (%s)\n", strerror(errno));
		  }
		  if (uref.value == 0x60)
		  {
		      PIDTI[1] = 0x60;
		  }
		  if (uref.value == 0x92)
		  {                     
		      PIDTI[0] = 0x92;
		  }
		  
	      }	      
	     
	  }// SWAT debug printf("PIDTI = %x%x.\n", PIDTI[0],PIDTI[1]);
	  rep_info.report_id |= HID_REPORT_ID_NEXT;
	  ret = ioctl(FR, HIDIOCGREPORTINFO, &rep_info);
      }
    }
    close (FR);   
}


bool UpdateDeviceList()
{
	GetHIDDevices("hiddev");
	GetRawDevices("TUSB9260");

	//SWATdebug printf("HIDDevicesCount = %d",HIDDevicesCount);


   if (HIDDevicesCount == 0)
    {
	printf("NO COMPATIBLE DEVICES FOUND...\nPlease connect a valid TUSB926x device\n");
	return false;	
    }
 
    if(DevDevicesCount > 0 && HIDDevicesCount> 0)       
    {
    }
   
   if(DevDevicesCount == 0 && HIDDevicesCount > 0)
   {
   }
	
 return true;
}

char* GetDevName(int selection)  //obtain the bus path device
{
 int DataIndex;
 char* ListDevice=NULL;

 ListDevice = new char [ strlen(devlist[selection]) - (strlen(devlist[selection]) - 7)+1];
 
 for (DataIndex=0;  DataIndex<(strlen(devlist[selection]) - (strlen(devlist[selection]) - 7)) ;DataIndex++)
    {	
	ListDevice[ DataIndex ] = devlist[selection][DataIndex +(strlen(devlist[selection]) - 7)];
    }	
ListDevice[7]='\0'; 
 return ListDevice;
}


/**********************************************************
Build the output Buffer
*************************************************************/

bool ValidHex (char *CustomSerialNumber, int SerialLength)
{
  
  
  
  for (int SerialIteration= 0; SerialIteration< SerialLength; SerialIteration++ ) 
  {
    if ( (CustomSerialNumber[SerialIteration] < 0x30) || ((CustomSerialNumber[SerialIteration] > 0x39) && (CustomSerialNumber[SerialIteration] < 0x41)) || ((CustomSerialNumber[SerialIteration] > 0x46) && (CustomSerialNumber[SerialIteration] < 0x61)) || (CustomSerialNumber[SerialIteration] < 0x66) )
    {      
      return false;
    }
  }
 
  printf("Valid Hex = %s\n",CustomSerialNumber);
  return true;	
}

void getIDs (char ID [4])
{
  uint 	ID_size;
    
  for ( ID_size = 0; ID_size < 4; ID_size ++ )
  {
   if ( ID_size == 0 || ID_size == 2 )
       {
	   if(ID[ID_size] > 0x60)
	   {
	       ID_hex[ID_size] = (uchar) (((ID[ID_size]) - 0x57) << 4 ) ;
	   }
	   else
	   {
	       if ( ID[ID_size] > 0x39 )
	       {
		   ID_hex[ID_size] = (uchar) (((ID[ID_size]) - 0x37) << 4 ) ;
	       }
                       else
	       {
		   ID_hex[ID_size] = (uchar) (((ID[ID_size]) - 0x30) << 4 );
	       }
	   }
       }
   else
       {
	   if(ID[ID_size] > 0x60)
	   {
	       ID_hex[ID_size] = (uchar) (((ID[ID_size]) - 0x37) ) ;
	   }
	   else
	   {
	       if ( ID[ID_size] > 0x39 )
	       ID_hex[ID_size] = (uchar) (((ID[ID_size]) - 0x37) ) ;
	       else
	       {
		   ID_hex[ID_size] = (uchar) (((ID[ID_size]) - 0x30) );
	       }
	   }      
       }
  }
 
}

void Gen_serial_number() //DeviceListBox_activated
{    
   time_t rawtime;
   struct tm* timeinfo;
   char buffer [80];
   long int index,y;
      
   FILE *SystemCommand;
   char CommandValue[1024];
   char *pch;
   
   
   SerialID=new char [64];
   SystemCommand = popen("hdparm -I /dev/sda | grep -i serial", "r");
   fgets(CommandValue,sizeof(CommandValue), SystemCommand);
   pclose(SystemCommand);
   pch = strtok (CommandValue, " ");
   pch = strtok (NULL, " ");
   pch = strtok (NULL, " ");
   if(!ExtDescriptors_flag)
  {
   for (index=0; index<8; index++)
   {	
     y = (char) ((rand() % 10)+48);	
     SerialID [index]= y;
   }
   }
   SerialID [0]= '\0';
   
   time( &rawtime);
   timeinfo = localtime (&rawtime);

   strftime (buffer, 80, "%Y%m%d%H%M%S%j",timeinfo);
   if(!ExtDescriptors_flag)
  {
   strcat(SerialID,buffer);
   strcat(SerialID,pch);
   }
   else
   {
   strcat(SerialID,Ex_SerialID);
   }
   //SWAT debugg printf("serial =%s size=%d\n", SerialID, strlen ( SerialID ));
   
}

uchar Checksum( uchar* Data, int Lentgh)
{
 int index;
 uchar ChecksumData = 0x00;
 
 for ( index = 0 ; index < Lentgh ; index ++)
 {
	ChecksumData += Data[index];
 }
    
 return ChecksumData;
}

bool GetOutBuffer ()
{
  
  uchar Descriptor_Header[3] = { 0x60, 0x92, 0x01 };
  uchar Firmware_Header [1] = {0x02};

  uint 	index,TextIndex;
  uchar* VID_hex;
  uchar* PID_hex;

  int status;
  const uint MaxDescriptorSize = 540;
  
  uchar* Descriptor_Data=NULL;
  uchar* Manufacture_Data=NULL; 
  char*  Manufacture_Text=NULL;
  uchar* Product_Data=NULL; 
  char*  Product_Text=NULL;
  uchar* Serial_Data=NULL; 
  char*  Serial_Text=NULL;

  uchar  DescriptorChecksum [1] = {0x00};
  uchar  FirmwareChecksum [1] = {0x00};

  uint 	 Int_DescriptorSize;
  char 	Descriptor_Size [4]={0x00,0x00,0x00,0x00}; 
  uchar* FirmwareBuffer = NULL;
  uint 	 Int_FirmwareSize;
  char	 Firmware_Size [4] = {0x00,0x00,0x00,0x00};

  FILE* FirmwareFile;
  //FILE*	OutFile; //only for testing
  
  
  //Replace the Device Descriptor VID with the one defined by the user.
  if(!ExtDescriptors_flag)
  {
   VID=new char [4];
   status = sprintf(VID,"0451");
  }
  getIDs (VID);
  VID_hex = ID_hex;

  Device_Descriptor[8] = VID_hex[2] + VID_hex[3];
  Device_Descriptor[9] = VID_hex[0] + VID_hex[1];

  //Replace the Device Descriptor PID with the one defined by the user.
  if(!ExtDescriptors_flag)
  {
   PID=new char [4];
   status = sprintf(PID,"9261");
   }
   getIDs (PID);
   PID_hex = ID_hex;
   
   Device_Descriptor[10] = PID_hex[2] + PID_hex[3];
   Device_Descriptor[11] = PID_hex[0] + PID_hex[1];

   //Get the Manufacture info and build the correspondant string descriptor.//SWAT:Change "ManufactureID" for dinamic string
  if(!ExtDescriptors_flag)
  {
   ManufactureID=new char [17];
   status = sprintf(ManufactureID,"Texas Instruments");
  }
   Manufacture_Data = new uchar [( (strlen ( ManufactureID )) * 2 ) +2];
   Manufacture_Text = new char [(strlen ( ManufactureID ))]; 
   Manufacture_Data[0] = ( (strlen (ManufactureID)) * 2 ) +2;
   Manufacture_Data[1] = 0x03;
   
   strncpy(Manufacture_Text,ManufactureID, strlen( ManufactureID ));
   index = 2;

   for ( TextIndex = 0; TextIndex < (strlen ( ManufactureID )); TextIndex ++)
    {
	Manufacture_Data[index] = (uchar) Manufacture_Text[TextIndex];
	Manufacture_Data[index + 1] = 0x00;
	index += 2;
    }

   //Get the Product info and build the correspondant string descriptor.
   
  if(!ExtDescriptors_flag)
  {
   ProductID=new char [22];
   status = sprintf(ProductID,"TUSB9260 USB 3 to SATA");
   }
   Product_Data = new uchar [( (strlen ( ProductID )) * 2 ) +2];
   Product_Text = new char [(strlen ( ProductID ))]; 
   Product_Data[0] = ( (strlen ( ProductID )) * 2 ) +2;
   Product_Data[1] = 0x03;

   strncpy(Product_Text,ProductID, strlen ( ProductID ) );
   index = 2;

   for ( TextIndex = 0; TextIndex < (strlen ( ProductID )); TextIndex ++)
    {
	Product_Data[index] = (uchar) Product_Text[TextIndex];
	Product_Data[index + 1] = 0x00;
	index += 2;
    }
 
   //Get the Serial info and build the correspondant string descriptor.
   if (!UseSpeciicSerialNumber)
   {
     Gen_serial_number();
   }

   Serial_Data = new uchar [( (strlen ( SerialID )) * 2 ) +2];
   Serial_Text = new char [(strlen ( SerialID ))]; 
   Serial_Data[0] = ( (strlen ( SerialID )) * 2 ) +2;
   Serial_Data[1] = 0x03;
   
   strncpy(Serial_Text,SerialID, strlen ( SerialID ) );
   index = 2;
   
   for ( TextIndex = 0; TextIndex < (strlen ( SerialID )); TextIndex ++)
    {
	Serial_Data[index] = (uchar) Serial_Text[TextIndex];
	Serial_Data[index + 1] = 0x00;
	index += 2;
    }

   //User option to keep the provided serial number without using the device's DieID.
   //Replace the first null character on the string with 0xCA
 
   if (!UseDieIDinSerNum)
    {
      Serial_Data[1] = 0xCA;
    }
  
   //Now we have user defined strings, we can calculate the size of the descriptor
   Int_DescriptorSize =sizeof ( Device_Descriptor )+
		      Manufacture_Data [0] +
		      Product_Data[0]+
		      Serial_Data[0] +
		      sizeof ( BOT_Descriptors);
 
   if (UAS_descriptorsFlag)
   {
	Int_DescriptorSize = Int_DescriptorSize + sizeof (UAS_Descriptors);
   }
   if (HID_descriptorsFlag)
   {
	Int_DescriptorSize = Int_DescriptorSize + sizeof (HID_Descriptors);
   }   
  
   //And now we create an array to store all the other temporary arrays that form the whole descriptor.           
    Descriptor_Data = new uchar [MaxDescriptorSize];
 
    memcpy (Descriptor_Data, Device_Descriptor, sizeof ( Device_Descriptor ));
    memcpy (Descriptor_Data + sizeof ( Device_Descriptor), Manufacture_Data, Manufacture_Data [0] );
    memcpy (Descriptor_Data + sizeof ( Device_Descriptor) + Manufacture_Data [0], Product_Data, Product_Data [0]);
    memcpy (Descriptor_Data + sizeof ( Device_Descriptor) + Manufacture_Data [0] + Product_Data [0], Serial_Data, Serial_Data [0]);
    memcpy (Descriptor_Data + sizeof ( Device_Descriptor) + Manufacture_Data [0] + Product_Data [0] + Serial_Data [0], BOT_Descriptors, sizeof ( BOT_Descriptors ));
    
    if (UAS_descriptorsFlag)
    {
	memcpy (Descriptor_Data + sizeof ( Device_Descriptor) + Manufacture_Data [0] + Product_Data [0] + Serial_Data [0] + sizeof(BOT_Descriptors),UAS_Descriptors, sizeof ( UAS_Descriptors ));	
    }
 
    if (UAS_descriptorsFlag)
    {
	memcpy (Descriptor_Data + sizeof ( Device_Descriptor) + Manufacture_Data [0] + Product_Data [0] + Serial_Data [0] + sizeof(BOT_Descriptors)+sizeof(UAS_Descriptors),HID_Descriptors, sizeof (HID_Descriptors ));	
    }
 
    for ( index = Int_DescriptorSize -1; index < MaxDescriptorSize; index++ )
    {
	Descriptor_Data[index] = 0x00;	
    }

   //And we get the Descriptor's Checksum    
 
   DescriptorChecksum[0] = Checksum (Descriptor_Data, Int_DescriptorSize);
 
   if (Bin)
   {
   //Now we will read the firmware image into a buffer.
   if (BinName ==NULL)
    {
	printf("Please select a valid Firmware file.\n");
	return false;
    }

   FirmwareFile = fopen(BinName, "rb");
   if (!FirmwareFile)
   {
   	printf("*Unable to open the Firmware file.\n");
        return false;
   }
   fseek (FirmwareFile, 0, SEEK_END);
   Int_FirmwareSize =ftell(FirmwareFile);
   fseek (FirmwareFile, 0, SEEK_SET);
    
   FirmwareBuffer = (uchar *) malloc (Int_FirmwareSize+1);
   if( !fread (FirmwareBuffer , Int_FirmwareSize , 1 , FirmwareFile))
   {
       fclose(FirmwareFile);
       printf("Unable to read from the Firmware file.\n");
       return false;
    }
    fclose(FirmwareFile);
   }
   else
   {
     Int_FirmwareSize = (uint) HexDataSize;
     FirmwareBuffer = (uchar *) malloc (Int_FirmwareSize+1);
     memcpy(FirmwareBuffer, HexFWBuffer, Int_FirmwareSize);/////////
   }

   //And we get the Firmware's Checksum 
    for ( index = 0 ; index < Int_FirmwareSize ; index ++)
    {
	FirmwareChecksum[0] = FirmwareChecksum[0] + FirmwareBuffer[index];
    }
    
    //Get a byte array containing the Descriptor lenght.
    for(index =0; index < 4; index ++ )
    {	
	Descriptor_Size[index] = MaxDescriptorSize >> (index*8);
    }
    //Get a byte array containing the Firmware lenght.
    for(index =0; index < 4; index ++ )
    {	
	Firmware_Size[index] = Int_FirmwareSize >> (index*8);
    }

   //Finally, we have all the data we need, so we set the Output buffer to contain all of the data we'll later send to the device through an IOCTL call.
    OutBuffer.Buffer = new uchar [ 7 + MaxDescriptorSize + 6  + Int_FirmwareSize + 1];    
    OutBuffer.BufferSize = 7 + MaxDescriptorSize + 6  + Int_FirmwareSize + 1;

    uchar  tempo [1] = {0x02};
    memcpy ( OutBuffer.Buffer, Descriptor_Header ,  3);
    memcpy ( OutBuffer.Buffer + 3, Descriptor_Size, 4 );
    memcpy ( OutBuffer.Buffer + 7, Descriptor_Data, Int_DescriptorSize );
    memcpy ( OutBuffer.Buffer + 7 + MaxDescriptorSize, DescriptorChecksum, 1);
    memcpy ( OutBuffer.Buffer + 7 + MaxDescriptorSize + 1, tempo , 1);
    memcpy ( OutBuffer.Buffer + 7 + MaxDescriptorSize + 2, Firmware_Size, 4);
    memcpy ( OutBuffer.Buffer + 7 + MaxDescriptorSize + 6, FirmwareBuffer, Int_FirmwareSize);
    memcpy ( OutBuffer.Buffer + 7 + MaxDescriptorSize + 6 + Int_FirmwareSize, FirmwareChecksum, 1);
   
   //for testing purposes only: We write the data into a file so we can check it out.
   
/*   OutFile = fopen ( "Descriptor-Firmware.bin" , "wb" );
    if (OutFile == NULL)
    {
	printf("Open fail");
	return false;
    }
    if (!fwrite ( OutBuffer.Buffer , 1 , 7 + MaxDescriptorSize + 6  + Int_FirmwareSize +1 , OutFile ))
    {
	printf("Unable to write to the output file.");
    }
    fclose( OutFile );USB9260_0
*/  

//free(FirmwareBuffer);

delete[] ManufactureID;

delete[] Manufacture_Data;

delete[] Manufacture_Text;

delete[] VID;

delete[] PID;

delete[] ProductID;

delete[] Product_Data;

delete[] Product_Text;

delete[] SerialID;

delete[] Serial_Data;

delete[] Serial_Text;

return true;

}


/***************************************************
HID reports
***************************************************/

char *hid_id[32];

bool device_iterator (struct usb_dev_handle const* usbdev, void* custom, unsigned int len)
{
 bool ret = false;
 char current_dev_path[10];
 const struct usb_device *device = usb_device((struct usb_dev_handle *)usbdev);

 //Obtain the device's full path 
 sprintf(current_dev_path, "%s/%s", device->bus->dirname, device->filename);

 //SWAT debugg printf("Current device path: %s\n",current_dev_path);  
  
 //SWAT debugg ("Device =%s \n path =%s", Device, current_dev_path);
 if (!strcmp(Device, current_dev_path ) )
	{
	 //SWAT debugg printf("DEVICE = CURRENT DEV\n");
		ret = true;
	}
 else
 {  //debugg printf("Wrong Device\n");
 }
  
 return ret;
}



void WriteOutputReport( uchar OutReportBuffer[] ) //send the repor package to the device.
{
  int i;
  hid_return ret;
  HIDInterface* hid;
  HIDInterfaceMatcher matcher;
  int const PATH_IN[1] = {0xffb00003 };
  
  //debug hid_set_debug(HID_DEBUG_ALL);
  //debug hid_set_debug_stream(stderr);
  //debug hid_set_usb_debug(0);
  for (i = 0 ; i < 32 ; i++)
	hid_id[i] = NULL;

  ret = hid_init();

  hid = hid_new_HIDInterface();
  matcher.vendor_id = 0x0451;
  if (DevDevicesCount==0)
  {matcher.product_id = 0x9260;}
  else{
      matcher.product_id = 0x926b;
  }
  matcher.matcher_fn = device_iterator;
  
  while ( (ret = hid_force_open(hid, 0, &matcher, 2)) != HID_RET_DEVICE_NOT_FOUND)    //find and open the valid 926x device.
	{
	  hid_write_identification(stdout, hid);
	  
	  //debug fprintf(stderr,"Sending Report......\n");
	  ret = hid_set_output_report(hid, PATH_IN, 1, (char* )OutReportBuffer, 9);  //send the report package.
      	  if (ret != HID_RET_SUCCESS) {
          fprintf(stderr, "hid_set_output_report failed with return code %d\n", ret);
           }
	 
	  hid_close(hid);
	  break;
	}
  hid_delete_HIDInterface(&hid);
  ret = hid_cleanup();
  return ;
}

/********************************************
Device Handle Functions
**********************************************/

bool OpenDeviceHandle(int selection)  //open and handle the TUSB9260_x eBurner instance
{
 char Text[28];
 char Namedev[16];
 int i;
 uint index;
 char* Name = NULL;
  
 strncpy (Text,devlist[selection],27);
 Text[27] = '\0';
 i = strcmp(Text, "VID = 0x0451 / PID = 0x926b" );
 if(i != 0)
 {	
	printf("* Please select a device.\n");
	return false;
 }
 
 Name = new char [ 5 + strlen(devlist[selection]) - 28 +1];
 Device = new char [ strlen(devlist[selection]) ];
 strcpy (Name, "/dev/usb");
 strncpy(Device,devlist[selection],strlen(devlist[selection]));
 for (index=0;  index<(strlen(devlist[selection]) - 28) ; index++)
    {
	Name[ index +5 ] = Device[index +28];
    }
 Name[ 5 + strlen(devlist[selection]) - 28 ] = '\0';
 strcpy (Namedev,"/dev/TUSB9260_");
 Namedev[14]= Name [11];
 Namedev[15]= '\0';
 //debug   printf("name=%s\n", Name);
 //debug  printf("namedev=%s\n", Namedev);
 fd = open("/dev/TUSB9260_1", O_RDWR );
 if(fd < 0)
 {
	printf("Cannot open the selected device.\n ");
	return false;
 }
 
 //debug printf("* Device Connected.\n"); 
 delete Name;
 return true;

}

/*********************************
Burn proccess
*************************************/

int Programming(int selection)
{
 int status;
 char CurrentProccess[1][1024];
 uchar OutBuff [9] = {0x07, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
 Device=GetDevName(selection);
 //debug 
 //printf ("Device programming =%s\n",Device);
//debug printf("DevDevicesCount = %d\nHIDDevicesCount = %d\n ",DevDevicesCount,HIDDevicesCount);

	if ( DevDevicesCount == 0 && HIDDevicesCount > 0 )
	{
	 //HID Enable Re-program
	 status = sprintf(CurrentProccess[0],"issuing HID Enable Re-program command");
	 //debug printf( "FHID Enable Re-program\n");
         //scanf("%d", &status);	
	 //uchar OutBuff [9] = {0x07, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
	 WriteOutputReport(OutBuff);

	 //Poison the Flash
         //debug printf( "Poison the Flash\n");
         
	 status = sprintf(CurrentProccess[0],"issuing HID Enable Re-program command");	    
	 OutBuff [0] = 0x03;
	 OutBuff [1] = 0x00;
	 WriteOutputReport(OutBuff);
	 sleep (4);
	    
         //debug printf( "softreset\n");
         OutBuff [0] = 0x02;
	 WriteOutputReport(OutBuff);
	 sleep (4);

	 //Wait for the BootLoader device to come up	  
	 printf("\nProgramming......... Please wait.\n");	     
	 
	 Device=GetDevName(selection);
	 //debug printf ("%s\n",Device);	
	}
	//debug	printf("DEVICE=%s\n",Device);
	//printf ("Device programming =%s\n",Device);
 	//printf("DevDevicesCount = %d\nHIDDevicesCount = %d\n ",DevDevicesCount,HIDDevicesCount);
	if ( DevDevicesCount > 0 && HIDDevicesCount >0)
	{
         if (!allflag )
	 {
	  if (!GetOutBuffer ())
	    {
		//debug 
		printf("ERROR: GetOutBuffer FAIL!!!");
		return 0;
	    }
	 }
 	 //HID Setup Download Data
         status= sprintf(CurrentProccess[0],"issuing HID SetupDownload Data command");
	 OutBuff [0] = 0x01;
	 OutBuff [1] = 0x00;
	 WriteOutputReport(OutBuff);
	 //SWAT	 printf("Selection = %d", selection);
         if (!OpenDeviceHandle(selection))
	    {   
 		printf("ERROR: OpenDeviceHandle FAIL!!!\n");
		close(fd);
	        return 0;
	    }
	 
	status= sprintf(CurrentProccess[0],"sending the firmware file (ioctl DOWNLOAD_ROM)");
 	printf( "\nSending Firmware....\n");

        //send the Firmware buffer to the device trough the IOCTL 	
	if((ioctl(fd, DOWNLOAD_ROM, &OutBuffer)) == -1)
	    {
		printf("ERROR: IOCTL FAIL!!!");
                close(fd);
		return 0;
	    }
         
	Device=GetDevName(selection);
	Device[7]='\0'; 

	printf( "\nFirmware sent to TUSB926x (%s) device.\n\n", Device);
	 
 	//Softreset
        OutBuff [0] = 0x02;
	OutBuff [1] = 0x00;
	WriteOutputReport(OutBuff);
	sleep (2);
	printf("\nPROGRAMMING SUCCESS!!!!!!\n");
        
	}
  
close(fd);
  return 1;
}


void EraseFlash (int selection) //function not implemented
{
 int status;
 char CurrentProccess[1][1024];

Device=GetDevName(selection);
printf ("Device =%s\n", Device);
status = sprintf(CurrentProccess[0],"issuing HID Enable Re-program command");
uchar test [9] = {0x07, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
WriteOutputReport(test);
 
 //Poison the Flash
 //printf( "Poison the Flash\n");
 //scanf("%d", &status);
 status = sprintf(CurrentProccess[0],"issuing HID Enable Re-program command");	    
 test [0] = 0x03;
 test [1] = 0x00;
 WriteOutputReport(test);
 sleep (4);
    
 //printf( "softreset\n");
 //scanf("%d", &status);
 printf ("Device =%s\n", Device);
 test [0] = 0x02;
 test [1] = 0x00;
 WriteOutputReport(test);
 
}

void GetManufacturer (char DescFile_path [])
{
   long int index,y;
   char Commandstr[1024];
   FILE *SystemCommand;
   char CommandValue[1024];
   char *pch;
   
   
   ManufactureID=new char [1024];
   strcpy (Commandstr,"cat ");
   strcat (Commandstr, DescFile_path);
   strcat (Commandstr, " | grep -i Manufacturer");
   SystemCommand = popen(Commandstr, "r");
   fgets(CommandValue,sizeof(CommandValue), SystemCommand);
   pclose(SystemCommand);
   pch = strtok (CommandValue, " ");
   pch = strtok (NULL, " ");
   pch = strtok (NULL, "\0");
   ManufactureID [0]= '\0';
   strcat(ManufactureID,pch);
   ManufactureID [strlen ( ManufactureID )-2]= '\0';
   //debug printf("ManufactureID=%s size=%d\n", ManufactureID, strlen ( ManufactureID ));
}

void Get_ProductName (char DescFile_path [])
{
   long int index,y;
   FILE *SystemCommand;
   char Commandstr[1024];
   char CommandValue[1024];
   char *pch;
   
   
   ProductID=new char [1024];
   strcpy (Commandstr,"cat ");
   strcat (Commandstr, DescFile_path);
   strcat (Commandstr, " | grep -i 'Product ='");
   SystemCommand = popen(Commandstr, "r");
   fgets(CommandValue,sizeof(CommandValue), SystemCommand);
   pclose(SystemCommand);
   pch = strtok (CommandValue, " ");
   pch = strtok (NULL, " ");
   pch = strtok (NULL, "\0");
   ProductID [0]= '\0';
   strcat(ProductID,pch);
   ProductID [strlen ( ProductID )-2]= '\0';
   //debug printf("ProductID=%s size=%d\n", ProductID, strlen ( ProductID ));
}

int LoadDesc(char DescFile_path [])
{
 FILE* Descriptors_File=NULL;
 int line_iterator=0;
 int i=0;
 int status;
 char *pch=NULL;
 char *line=NULL;
 uchar* wU2DevExitLat_hex;
 uchar* bMaxPower_hex;
 uint 	FileSize;
 char* ex_ManufactureID=NULL;
 char* Ex_ProductID=NULL;
 
 Descriptors_File= fopen (DescFile_path,"r");
 
 fseek (Descriptors_File, 0, SEEK_END);
 FileSize =ftell(Descriptors_File);
 fseek (Descriptors_File, 0, SEEK_SET);

 line = (char *) malloc (FileSize);
 if (Descriptors_File != NULL)
 {
  while (fgets( line, 100, Descriptors_File) != NULL )
  
  {line_iterator ++;
   pch = strtok (line, " ");
   pch = strtok (NULL, " ");
   pch = strtok (NULL, "\0");
   pch[strlen(pch)-2]='\0';
   
   switch (line_iterator)
   {
	case 1:	
		if ( !strcmp(pch,"True") )
   		{
      		 UAS_descriptorsFlag = true;
      		}
		break;
	case 2:	
		if ( !strcmp(pch,"True") )
   		{
      		 HID_descriptorsFlag = true;
      		}
		break;
	case 3:	
		if ( !strcmp(pch,"True") )
   		{
      		 Self_powered_flag = true;
      		}
		break;
	case 4:	
		if ( !strcmp(pch,"True") )
   		{
      		 RemoteWakeup_flag = true;
      		}
		break;
	case 5:
		VID=new char [strlen(pch)-2];
		status = sprintf(VID,pch);
                break;
	case 6:
		PID=new char [strlen(pch)-2];
		status = sprintf(PID,pch);
		break;
	
	case 9:
		Ex_SerialID=new char [strlen(pch)-2];
		status = sprintf(Ex_SerialID,pch);
		break;
	case 10:
		getIDs (pch);
		wU2DevExitLat_hex=ID_hex;
		BOT_Descriptors[20] = wU2DevExitLat_hex[2] + wU2DevExitLat_hex[3];
  		BOT_Descriptors[21] = wU2DevExitLat_hex[0] + wU2DevExitLat_hex[1];
		break;	
	case 11:
		getIDs (pch);
		bMaxPower_hex=ID_hex;
		BOT_Descriptors[50] = bMaxPower_hex[0] + bMaxPower_hex[1];
	        break;
	default: 
		break;
   }
       
   }

  ExtDescriptors_flag=true;
  
 }

fclose(Descriptors_File);

GetManufacturer (DescFile_path);
Get_ProductName (DescFile_path);
}

int main(int argc,char *argv[])
{
  int selection,dev_iteration;
  int arg_iteration=0; 
  char argument[6];
  int SerialLength = 0;
  char *CustomSerialNumber =NULL;
  int BinSize;  
  int MaxFirmwareFileSize=65535;


  struct stat BinProperties;  
   

  if (argv[1] == NULL || !strcmp(argv[1],"--help") || !strcmp(argv[1],"-h")) 
  {
   printf("TUSB926x FlashBurner v0.1\n\nusage: ./TUSB926x_FlashBurner [-l] [file path] [-f] [file path]  Burn Firmware to the EEPROM.\n\nArguments:\n   -l       Load External Descriptors ( DESC file ).\n   -f       Select the Firmware File ( BIN file/Hex File ).\n\n   -s       Specify a the Serial Number.\n\n   -i       Ignore DieID.\n\nExample:\n ./TUSB926x_FlashBurner -l TUSB926x_Descriptors.desc -f TUSB9260_FW097.bin\n");

   return 0;  
   } 

  arg_iteration =1;
  for (arg_iteration; arg_iteration<argc; arg_iteration++)
  {  
  if (argv[arg_iteration][0] == '-' && argv[arg_iteration][1] != 'f' && argv[arg_iteration][1] != 'l' && argv[arg_iteration][1] != 's')  //change it
  {
   printf("Invalid argument.\nMore info with: 'TUSB9260_FlashBurner -h'\n");
   return 1;
  }
  }
  
  if (!UpdateDeviceList())
  {
    return 1;
  }
  
  if(HIDDevicesCount>1)
  {
  printf("\nPlease select a device:");
  scanf("%d", &selection);
  }
  else
  {
   selection=1;
  }
  
  arg_iteration =1;
  for (arg_iteration; arg_iteration<argc; arg_iteration++)
  {  
  if (!strcmp(argv[arg_iteration],"-e"))
  {
  printf("ERASING...\n");
  EraseFlash(selection);
  return 0;
  }
  else if (!strcmp(argv[arg_iteration],"-s"))
  {
  SerialLength = strlen(argv[arg_iteration+1]);
   
	if(SerialLength <= 64 )
	{ 
	  CustomSerialNumber = argv[arg_iteration+1];
          if (!ValidHex (CustomSerialNumber, SerialLength))//change it
	  {
	    printf ("\nInvalid Serial Number Format. Serial Number can only have exadecimal characters.\n");
	    return 1;
	  }
	  
	  printf("\nCustomSerialNumber = %s\nSerialLength = %d\n",CustomSerialNumber, SerialLength);
	  SerialID = CustomSerialNumber;
	  UseSpeciicSerialNumber = true; 
	}
	else 
	{
	  printf("\nSerial number value is too long.\n");
	  return 1;
	}

  	
  }
  else if (!strcmp(argv[arg_iteration],"-i"))
  {
    if (UseSpeciicSerialNumber)
    {
      UseDieIDinSerNum = false;
    }
  }
  else if (!strcmp(argv[arg_iteration],"-l"))
  {
  printf("Loading Descriptors...\n");
  LoadDesc(argv[arg_iteration+1]);
  
  }
  else if (!strcmp(argv[arg_iteration],"-f"))
  {
   const char* FWfile =strrchr(argv[arg_iteration+1], '.');
   if(!strcmp(FWfile,".bin"))
   {
     BinName = argv[arg_iteration+1];
     stat(BinName, &BinProperties);
     BinSize = BinProperties.st_size;
    
     if(BinSize > MaxFirmwareFileSize)
     {
      printf("\nFirmware file too long. THe firmware content mus be under %d bytes\n.", MaxFirmwareFileSize);
      return 1;
     }
     Bin =true; 
   }
   else if(!strcmp(FWfile,".hex"))
   {
     HexName=argv[arg_iteration+1];
     HexFWBuffer=VerifyFile(HexName);    
    
     if(HexDataSize > MaxFirmwareFileSize)
     {
       printf("\nFirmware file too long. THe firmware content mus be under %d bytes\n.", MaxFirmwareFileSize);
       return 1;
     }     
   }
   else
   {
     printf("Invalid Fimware FIle. Please select a valid '.bin' or '.hex' file.\n");
     return 1;
   }
   
  }
     
  }
  /***************************
   PROGRAMMING PROCESS
  *****************************/
  if (selection > HIDDevicesCount)
  {
   printf("Invalid selection\n");
   return 1;
  }
  else
  {
     
  if(selection != 0)
  {
  //debug printf("You selected the device %s\n", devlist[selection]);
    printf("\nPROGRAMMING............\n");
   if (!Programming(selection));
   {
     return 1;
   }
  }
  else
  {  
     dev_iteration=HIDDevicesCount;
     
     for (dev_iteration; dev_iteration >0 ; dev_iteration-- )
     {
	//debug 
	printf("You selected the device %s\n", devlist[dev_iteration]);
  	
  	/***************************
   	PROGRAMMING PROCESS
  	*****************************/
  	printf("\nPROGRAMMING............\n"); 
  	if(!Programming(dev_iteration))
        {
	  return 1;
        }
        allflag = true;
     }
  }

  }

return 0;
}
