/*
 * tusb926x-Erase-tool-0.2.0.0
 *
 * The software is a Linux-based tool allowing the TUSB926x in-circuit erasing of the SPI Flash via the 
 *   universal serial bus (USB).
 *
 * Copyright (C) 2015 Texas Instruments Incorporated - http://www.ti.com/ 
 * 
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/

#include <stdbool.h>
#include <stdio.h>
#include <string.h>
#include <hid.h>
#include <fcntl.h>
#include <linux/hiddev.h>
#include <sys/ioctl.h>
#include <errno.h>
#include <string>
#include <stdlib.h>
#include <linux/hid.h>
#include <usb.h>
#include <time.h>
#include <scsi/sg.h>
#include <sys/ioctl.h>
#include <scsi/scsi.h>

int SCSIDevicesCount;
int nn, status;
char SCSIdevlist[10][100] =
{ '0', '0', '0', '0', '0', '0', '0', '0', '0', '0' };
char SCSICommand[100];

typedef struct my_scsi_ioctl_command
{
	unsigned int inlen; /* _excluding_ scsi command length */
	unsigned int outlen;
	unsigned char data[1]; /* was 0 but that's not ISO C!! */
	/* on input, scsi command starts here then opt. data */
} My_Scsi_Ioctl_Command;

#define OFF (2 * sizeof(unsigned int))

#ifndef SCSI_IOCTL_SEND_COMMAND
#define SCSI_IOCTL_SEND_COMMAND 1
#endif

#define INQUIRY_CMD     0x12
#define INQUIRY_CMDLEN  6
#define INQUIRY_REPLY_LEN 96

/*SCSI funtions */

void GetSCSIDevices(const char *DevNamePrefix)
{
	FILE *SystemCommand;
	DIR *dp = NULL;
	struct dirent *ep = NULL;
	char * DevName = NULL;
	char** SCSIDevPathName = NULL;
	int i;
	unsigned int DevNamePrefixL = 0;
	char CommandValue[1024];

	SCSIDevPathName = new char*[128];
	DevNamePrefixL = strlen(DevNamePrefix);
	SCSIDevicesCount = 0;

	dp = opendir("/dev");
	if (dp == NULL)
	{
		//debugg printf("* Unable to open device directory.\n");
		delete[] SCSIDevPathName;
		return;
	}


	while ((ep = readdir(dp)))
	{
		if ((strlen(ep->d_name)) > DevNamePrefixL)
		{
			DevName = new char[DevNamePrefixL + 1];
			strncpy(DevName, ep->d_name, DevNamePrefixL);
			DevName[DevNamePrefixL] = '\0';

			i = strcmp(DevName, DevNamePrefix);
			delete[] DevName;
			if (i == 0)
			{
				if (DevNamePrefix == "sg" && strcmp(ep->d_name, "sg0"))
				{
					DevName = new char[strlen(ep->d_name) + 1];
					strncpy(DevName, ep->d_name, strlen(ep->d_name));
					DevName[strlen(ep->d_name)] = '\0';

					nn = sprintf(SCSICommand,
							"sg_raw -r 2b /dev/%s E3 00 00 00 00 00 -n", ep->d_name);

					SystemCommand = popen(SCSICommand, "r");
					fgets(CommandValue, sizeof(CommandValue), SystemCommand);
					pclose(SystemCommand);
					CommandValue[13]='\0';         

					//Value returned from the TUSB926x is " 00     60 92"  
					if (!strcmp(CommandValue, " 00     60 92"))
					{
						nn = sprintf(SCSIdevlist[SCSIDevicesCount + 1],
								"/dev/%s", ep->d_name);
						SCSIDevicesCount++;

					}
					delete[] DevName;

				}
			}

		}
	}

	DevNamePrefix = NULL;
	delete[] SCSIDevPathName;
	(void) closedir(dp);
}

int SCSI_inq(const char* SCSIdev, int iteration, int HIDDevCount)
{
	int s_fd, res, k, to;
	unsigned char inqCmdBlk[INQUIRY_CMDLEN] =
	{ INQUIRY_CMD, 0, 0, 0,
			INQUIRY_REPLY_LEN, 0 };      //CDB_Inquiry
	unsigned char * inqBuff = (unsigned char *) malloc(
			OFF + sizeof(inqCmdBlk) + 512);
	unsigned char * buffp = inqBuff + OFF;
	My_Scsi_Ioctl_Command * ishp = (My_Scsi_Ioctl_Command *) inqBuff;
	int do_nonblock = 0;
	int oflags = 0;

	if (do_nonblock)
		oflags = O_NONBLOCK;
	s_fd = open(SCSIdev, oflags | O_RDWR);
	if (s_fd < 0)
	{
		if ((EROFS == errno) || (EACCES == errno))
		{
			s_fd = open(SCSIdev, oflags | O_RDONLY);
			if (s_fd < 0)
			{
				perror("scsi_inquiry1: open error");
				return 1;
			}
		}
		else
		{
			perror("scsi_inquiry2: open error");
			return 1;
		}
	}

	/* Don't worry, being very careful not to write to a none-scsi file ... */
	res = ioctl(s_fd, SCSI_IOCTL_GET_BUS_NUMBER, &to);
	if (res < 0)
	{

		/* perror("ioctl on scsi device, error"); */
		printf("scsi_inquiry: not a scsi device\n");
		return 1;
	}

	ishp->inlen = 0;
	ishp->outlen = INQUIRY_REPLY_LEN;
	memcpy(buffp, inqCmdBlk, INQUIRY_CMDLEN);
	res = ioctl(s_fd, SCSI_IOCTL_SEND_COMMAND, inqBuff);
	if (res == 0)
	{
		to = (int) *(buffp + 7);

		printf("[%d]%s  %.8s %.16s\n", iteration + HIDDevCount,
				SCSIdevlist[iteration], buffp + 8, buffp + 16);
	}
	else if (res < 0)
		perror("scsi_inquiry: SCSI_IOCTL_SEND_COMMAND err");
	else
		printf("scsi_inquiry: SCSI_IOCTL_SEND_COMMAND status=0x%x\n", res);

	res = close(s_fd);
	if (res < 0)
	{
		perror("scsi_inquiry: close error");
		return 1;
	}
	return 0;
}

void EraseFlash_SCSI(int selection)
{
	printf("ERASING DEVICE %s ....\n\n", SCSIdevlist[selection]);

	nn = sprintf(SCSICommand, "sg_raw %s E1 00 00 00 00 00 -n",
			SCSIdevlist[selection]); //Unlock Flash
	printf("UNLOCK Flash %s\n", SCSIdevlist[selection]);
	status = system(SCSICommand);
	nn = sprintf(SCSICommand, "sg_raw %s E2 00 00 00 00 00 -n",
			SCSIdevlist[selection]); //Erase Flash
	printf("Erase Flash %s\n", SCSIdevlist[selection]);
	status = system(SCSICommand);
	nn = sprintf(SCSICommand, "sg_raw %s E6 00 00 00 00 00 -t 1 -n",
			SCSIdevlist[selection]); //Reset Device
	printf("UNLOCK Flash %s\n",SCSIdevlist[selection]);
	status = system(SCSICommand);

	printf("ERASE FLASH SUCCESS....\n\n");

}

void UpdateSCSIList()
{
	int i, n, status;

	GetSCSIDevices("sg");
	//n= system("clear");

	return;

}
