#include <i2c_t3.h>
#include "INA233.h"

#define ALERT_PIN 0

INA233 INA(0x40);  // address 0x40 1000000, both I2C address pins GND

int SampleCount = 0;
uint16_t bugcount = 0;
uint32_t t1 = 0;
uint32_t t2 = 0;

#define TriggerBug 1

void setup() {
  
  Serial.begin(9600);
  delay(3000);

  pinMode(ALERT_PIN,INPUT); //physical pullup on board
  
  INA.begin(400000); //Don't go above 100kHz or it will cause a HW bug with the accumulator

  INA.ADCShuntConversionTime(4);
  INA.ADCVoltageConversionTime(4);
  INA.ADCAveraging(2);

  INA.calibrateCurrent(2048,1,1.012,-0.001);
  INA.calibrateVoltage(2,1.0092,0);
  //INA.printCalibration();

}

void loop() {

  delay(1000);
  Serial.println();
  
  
  uint32_t sampleCount = 0;
  uint32_t rawEnergy = 0;
  t2 = micros();
  INA.getEnergy_raw(&sampleCount,&rawEnergy);
  
  if((sampleCount > 31) || (sampleCount < 30) ){bugcount++;}

  Serial.print("TriggerBug: ");Serial.print(TriggerBug);
  Serial.print("\tBugCount:");Serial.print(bugcount);
  Serial.println();
  
  Serial.print("SampleCount:"); Serial.print(sampleCount);
  Serial.print("\tEnergyReg:"); Serial.print(rawEnergy);
  Serial.print("\tSampleWindow:"); Serial.print(t2 - t1);
  Serial.print("\tEnergyPerSample:"); Serial.print(rawEnergy/sampleCount);
  Serial.print("\tEnergyPerTime:"); Serial.print((float)rawEnergy/((float)(t2 - t1)/1000000));
  Serial.println();
  
  t1 = t2;

  if(TriggerBug){
    //When operating at 400kHz, reading values disturbs the power accumulator
    float voltage = INA.getBusVoltage_V();
    float shunt_voltage = INA.getShuntVoltage_mV();
    float current = INA.getCurrent_A();
    float power = INA.getPower_W();
  
    Serial.print("V: "); Serial.print(voltage,3);Serial.print("\t");
    Serial.print("sV: "); Serial.print(shunt_voltage,4);Serial.print("\t");
    Serial.print("A: "); Serial.print(current,3);Serial.print("\t");
    Serial.print("W: "); Serial.print(power,3);Serial.print("\t");
  }

}





void printBin16(uint16_t num){
  uint16_t clearBits = 1;
  for(int i = 15; i>=0; i--){
    Serial.print((bool)(clearBits & (num >> i)));
  }
}

void printBin8(uint16_t num){
  uint8_t clearBits = 1;
  for(int i = 7; i>=0; i--){
    Serial.print((bool)(clearBits & (num >> i)));
  }
}


