/* 
 * File:   ShaDe.h
 * Author: andre
 *
 * Created on 21 maggio 2019, 19.08
 */

#ifndef SHADE_H
#define	SHADE_H

// PIC24FJ64GB002 Configuration Bit Settings: variations respect to defaults. Modtronics
// 'C' source line config statements 

// CONFIG4
#pragma config DSWDTPS = DSWDTPS3       // DSWDT Postscale Select (1:128 (132 ms))
#pragma config RTCOSC = LPRC            // RTCC Reference Oscillator  Select (RTCC uses Low Power RC Oscillator (LPRC))
#pragma config DSBOREN = OFF            // Deep Sleep BOR Enable bit (BOR disabled in Deep Sleep)
#pragma config DSWDTEN = OFF            // Deep Sleep Watchdog Timer (DSWDT disabled)

// CONFIG3
#pragma config WPFP = WPFP0             // Write Protection Flash Page Segment Boundary (Page 0 (0x0))
#pragma config SOSCSEL = IO             // Secondary Oscillator Pin Mode Select (SOSC pins have digital I/O functions (RA4, RB4))
#pragma config WUTSEL = FST             // Voltage Regulator Wake-up Time Select (Fast regulator start-up time used)

// CONFIG2
#pragma config IOL1WAY = OFF            // IOLOCK One-Way Set Enable (The IOLOCK bit can be set and cleared using the unlock sequence)
#pragma config FCKSM = CSECME           // Clock Switching and Fail-Safe Clock Monitor (Sw Enabled, Mon Enabled)
#pragma config FNOSC = FRCPLL           // Initial Oscillator Select (Fast RC Oscillator with Postscaler and PLL module (FRCPLL))
#pragma config PLLDIV = DIV2          // USB 96 MHz PLL Prescaler Select (Oscillator input divided by 2 (16 MHz input))
#pragma config IESO = OFF               // Internal External Switchover (IESO mode (Two-Speed Start-up) disabled)

// CONFIG1
#pragma config WDTPS = PS8192           // Watchdog Timer Postscaler (1:8,192)
#pragma config FWPSA = PR32             // WDT Prescaler (Prescaler ratio of 1:32)
#pragma config FWDTEN = OFF             // Watchdog Timer (Watchdog Timer is disabled)
#pragma config JTAGEN = OFF             // JTAG Port Enable (JTAG port is disabled)

#ifdef	__cplusplus
extern "C" {
#endif

#define OUTPUT_PIN 0
#define INPUT_PIN 1

#ifdef	__cplusplus
}
#endif

#endif	/* SHADE_H */