/* 
 * File:   Lcd.h
 * Author: andre
 *
 * Created on 5 giugno 2019, 16.03
 */

#include <xc.h> // include processor files - each processor file is guarded.

#ifndef LCD_H
#define	LCD_H

#ifdef	__cplusplus
extern "C" {
#endif

#define LCD_data LATB
#define LCD_en LATAbits.LATA0
#define LCD_rs LATAbits.LATA1
#define LCD_rw LATAbits.LATA2

void LCD_delay(unsigned short usDelay);
void LCD_init(void);
void LCD_command(unsigned int var);
void LCD_senddata(unsigned int var);
unsigned int Map(unsigned int var);
void lcd_putc(char c);
void lcd_puts(const char *s);

#ifdef	__cplusplus
}
#endif

#endif	/* LCD_H */