/*
 *
 * Copyright (c) 2019 Texas Instruments Incorporated
 *
 * All rights reserved not granted herein.
 *
 * Limited License.
 *
 * Texas Instruments Incorporated grants a world-wide, royalty-free, non-exclusive
 * license under copyrights and patents it now or hereafter owns or controls to make,
 * have made, use, import, offer to sell and sell ("Utilize") this software subject to the
 * terms herein.  With respect to the foregoing patent license, such license is granted
 * solely to the extent that any such patent is necessary to Utilize the software alone.
 * The patent license shall not apply to any combinations which include this software,
 * other than combinations with devices manufactured by or for TI ("TI Devices").
 * No hardware patent is licensed hereunder.
 *
 * Redistributions must preserve existing copyright notices and reproduce this license
 * (including the above copyright notice and the disclaimer and (if applicable) source
 * code license limitations below) in the documentation and/or other materials provided
 * with the distribution
 *
 * Redistribution and use in binary form, without modification, are permitted provided
 * that the following conditions are met:
 *
 * *       No reverse engineering, decompilation, or disassembly of this software is
 * permitted with respect to any software provided in binary form.
 *
 * *       any redistribution and use are licensed by TI for use only with TI Devices.
 *
 * *       Nothing shall obligate TI to provide you with source code for the software
 * licensed and provided to you in object code.
 *
 * If software source code is provided to you, modification and redistribution of the
 * source code are permitted provided that the following conditions are met:
 *
 * *       any redistribution and use of the source code, including any resulting derivative
 * works, are licensed by TI for use only with TI Devices.
 *
 * *       any redistribution and use of any object code compiled from the source code
 * and any resulting derivative works, are licensed by TI for use only with TI Devices.
 *
 * Neither the name of Texas Instruments Incorporated nor the names of its suppliers
 *
 * may be used to endorse or promote products derived from this software without
 * specific prior written permission.
 *
 * DISCLAIMER.
 *
 * THIS SOFTWARE IS PROVIDED BY TI AND TI'S LICENSORS "AS IS" AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL TI AND TI'S LICENSORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#include "TI/tivx.h"
#include "TI/tivx_dms.h"
#include "VX/vx.h"
#include "tivx_dms_kernels_priv.h"
#include "tivx_kernel_apply_gain.h"
#include "TI/tivx_target_kernel.h"
#include "tivx_kernels_target_utils.h"
#include "tivx_bam_kernel_wrapper.h"

typedef struct
{
    tivx_bam_graph_handle graph_handle;
} tivxApplyGainParams;

static tivx_target_kernel vx_apply_gain_target_kernel = NULL;

static vx_status VX_CALLBACK tivxApplyGainProcess(
       tivx_target_kernel_instance kernel,
       tivx_obj_desc_t *obj_desc[],
       uint16_t num_params, void *priv_arg);
static vx_status VX_CALLBACK tivxApplyGainCreate(
       tivx_target_kernel_instance kernel,
       tivx_obj_desc_t *obj_desc[],
       uint16_t num_params, void *priv_arg);
static vx_status VX_CALLBACK tivxApplyGainDelete(
       tivx_target_kernel_instance kernel,
       tivx_obj_desc_t *obj_desc[],
       uint16_t num_params, void *priv_arg);
static vx_status VX_CALLBACK tivxApplyGainControl(
       tivx_target_kernel_instance kernel,
       uint32_t node_cmd_id,
       tivx_obj_desc_t *obj_desc[],
       uint16_t num_params, void *priv_arg);

static vx_status VX_CALLBACK tivxApplyGainProcess(
       tivx_target_kernel_instance kernel,
       tivx_obj_desc_t *obj_desc[],
       uint16_t num_params, void *priv_arg)
{
    vx_status status = VX_SUCCESS;
    tivxApplyGainParams *prms = NULL;
    tivx_obj_desc_image_t *in_desc;
    tivx_obj_desc_image_t *out_desc;

    if ( (num_params != TIVX_KERNEL_APPLY_GAIN_MAX_PARAMS)
        || (NULL == obj_desc[TIVX_KERNEL_APPLY_GAIN_GAIN_IDX])
        || (NULL == obj_desc[TIVX_KERNEL_APPLY_GAIN_IN_IDX])
        || (NULL == obj_desc[TIVX_KERNEL_APPLY_GAIN_OUT_IDX])
    )
    {
        status = VX_FAILURE;
    }

    if(VX_SUCCESS == status)
    {
        uint32_t size;
        in_desc = (tivx_obj_desc_image_t *)obj_desc[TIVX_KERNEL_APPLY_GAIN_IN_IDX];
        out_desc = (tivx_obj_desc_image_t *)obj_desc[TIVX_KERNEL_APPLY_GAIN_OUT_IDX];

        status = tivxGetTargetKernelInstanceContext(kernel,
            (void **)&prms, &size);
        if ((VX_SUCCESS != status) || (NULL == prms) ||
            (sizeof(tivxApplyGainParams) != size))
        {
            status = VX_FAILURE;
        }
    }

    if(VX_SUCCESS == status)
    {
        void *in_target_ptr;
        void *out_target_ptr;

        in_target_ptr = tivxMemShared2TargetPtr(&in_desc->mem_ptr[0]);
        tivxMemBufferMap(in_target_ptr,
           in_desc->mem_size[0], VX_MEMORY_TYPE_HOST,
           VX_READ_ONLY);

        out_target_ptr = tivxMemShared2TargetPtr(&out_desc->mem_ptr[0]);
        tivxMemBufferMap(out_target_ptr,
           out_desc->mem_size[0], VX_MEMORY_TYPE_HOST,
           VX_WRITE_ONLY);

        {
            /*void *img_ptrs[2];*/
            VXLIB_bufParams2D_t vxlib_in;
            uint8_t *in_addr = NULL;
            VXLIB_bufParams2D_t vxlib_out;
            uint8_t *out_addr = NULL;

            tivxInitBufParams(in_desc, &vxlib_in);
            tivxSetPointerLocation(in_desc, &in_target_ptr, &in_addr);

            tivxInitBufParams(out_desc, &vxlib_out);
            tivxSetPointerLocation(out_desc, &out_target_ptr, &out_addr);

            /*img_ptrs[0] = in_addr;
            img_ptrs[1] = out_addr;*/
            /* < DEVELOPER_TODO: Uncomment once BAM graph has been created > */
            /* tivxBamUpdatePointers(prms->graph_handle, 1U, 1U, img_ptrs); */

            /* < DEVELOPER_TODO: Uncomment once BAM graph has been created > */
            /* status  = tivxBamProcessGraph(prms->graph_handle); */

            /* call kernel processing function */

            /* < DEVELOPER_TODO: Add target kernel processing code here > */

            /* kernel processing function complete */

        }
        tivxMemBufferUnmap(in_target_ptr,
           in_desc->mem_size[0], VX_MEMORY_TYPE_HOST,
            VX_READ_ONLY);

        tivxMemBufferUnmap(out_target_ptr,
           out_desc->mem_size[0], VX_MEMORY_TYPE_HOST,
            VX_WRITE_ONLY);



    }

    return status;
}

static vx_status VX_CALLBACK tivxApplyGainCreate(
       tivx_target_kernel_instance kernel,
       tivx_obj_desc_t *obj_desc[],
       uint16_t num_params, void *priv_arg)
{
    vx_status status = VX_SUCCESS;
    tivxApplyGainParams *prms = NULL;

    /* < DEVELOPER_TODO: (Optional) Add any target kernel create code here (e.g. allocating */
    /*                   local memory buffers, one time initialization, etc) > */
    if ( (num_params != TIVX_KERNEL_APPLY_GAIN_MAX_PARAMS)
        || (NULL == obj_desc[TIVX_KERNEL_APPLY_GAIN_GAIN_IDX])
        || (NULL == obj_desc[TIVX_KERNEL_APPLY_GAIN_IN_IDX])
        || (NULL == obj_desc[TIVX_KERNEL_APPLY_GAIN_OUT_IDX])
    )
    {
        status = VX_FAILURE;
    }
    else
    {


        prms = tivxMemAlloc(sizeof(tivxApplyGainParams), TIVX_MEM_EXTERNAL);
        if (NULL != prms)
        {

        }
        else
        {
            status = VX_ERROR_NO_MEMORY;
            VX_PRINT(VX_ZONE_ERROR, "Unable to allocate local memory\n");
        }

        if (NULL != prms)
        {
            /* < DEVELOPER_TODO: Create BAM graph using graph_handle > */
        }

        if (VX_SUCCESS == status)
        {
            tivxSetTargetKernelInstanceContext(kernel, prms,
                sizeof(tivxApplyGainParams));
        }
        else
        {
            status = VX_ERROR_NO_MEMORY;
            VX_PRINT(VX_ZONE_ERROR, "Unable to allocate local memory\n");
        }
    }

    return status;
}

static vx_status VX_CALLBACK tivxApplyGainDelete(
       tivx_target_kernel_instance kernel,
       tivx_obj_desc_t *obj_desc[],
       uint16_t num_params, void *priv_arg)
{
    vx_status status = VX_SUCCESS;
    tivxApplyGainParams *prms = NULL;
    uint32_t size;

    /* < DEVELOPER_TODO: (Optional) Add any target kernel delete code here (e.g. freeing */
    /*                   local memory buffers, etc) > */
    if ( (num_params != TIVX_KERNEL_APPLY_GAIN_MAX_PARAMS)
        || (NULL == obj_desc[TIVX_KERNEL_APPLY_GAIN_GAIN_IDX])
        || (NULL == obj_desc[TIVX_KERNEL_APPLY_GAIN_IN_IDX])
        || (NULL == obj_desc[TIVX_KERNEL_APPLY_GAIN_OUT_IDX])
    )
    {
        status = VX_FAILURE;
    }
    else
    {
        tivxGetTargetKernelInstanceContext(kernel, (void **)&prms, &size);

        if ((NULL != prms) &&
            (sizeof(tivxApplyGainParams) == size))
        {
            /* < DEVELOPER_TODO: Uncomment once BAM graph has been created > */
            /* tivxBamDestroyHandle(prms->graph_handle); */
            tivxMemFree(prms, size, TIVX_MEM_EXTERNAL);
        }
    }

    return status;
}

static vx_status VX_CALLBACK tivxApplyGainControl(
       tivx_target_kernel_instance kernel,
       uint32_t node_cmd_id,
       tivx_obj_desc_t *obj_desc[],
       uint16_t num_params, void *priv_arg)
{
    vx_status status = VX_SUCCESS;

    /* < DEVELOPER_TODO: (Optional) Add any target kernel control code here (e.g. commands */
    /*                   the user can call to modify the processing of the kernel at run-time) > */

    return status;
}

void tivxAddTargetKernelBamApplyGain(void)
{
    vx_status status = VX_FAILURE;
    char target_name[TIVX_TARGET_MAX_NAME];
    vx_enum self_cpu;

    self_cpu = tivxGetSelfCpuId();

    if ( self_cpu == TIVX_CPU_ID_DSP1 )
    {
        strncpy(target_name, TIVX_TARGET_DSP1, TIVX_TARGET_MAX_NAME);
        status = VX_SUCCESS;
    }
    else
    if ( self_cpu == TIVX_CPU_ID_DSP2 )
    {
        strncpy(target_name, TIVX_TARGET_DSP2, TIVX_TARGET_MAX_NAME);
        status = VX_SUCCESS;
    }
    else
    {
        status = VX_FAILURE;
    }

    if (status == VX_SUCCESS)
    {
		
        vx_apply_gain_target_kernel = tivxAddTargetKernelByName(
                            TIVX_KERNEL_APPLY_GAIN_NAME,
                            target_name,
                            tivxApplyGainProcess,
                            tivxApplyGainCreate,
                            tivxApplyGainDelete,
                            tivxApplyGainControl,
                            NULL);
    }
}

void tivxRemoveTargetKernelBamApplyGain(void)
{
    vx_status status = VX_SUCCESS;

    status = tivxRemoveTargetKernel(vx_apply_gain_target_kernel);
    if (status == VX_SUCCESS)
    {
        vx_apply_gain_target_kernel = NULL;
    }
}


