/* --COPYRIGHT--,BSD
 * Copyright (c) 2017, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * --/COPYRIGHT--*/

#include <CC1120.hpp>
#include "config.h"
#include "driverlib.h"
#include <mbed.hpp>

#ifdef DEVBOARD
#define CC11200_CS_PORT GPIO_PORT_P3
#define CC11200_CS_PIN GPIO_PIN0
#define CC11200_RESET_PORT GPIO_PORT_P1
#define CC11200_RESET_PIN GPIO_PIN5
#else
#error "TODO"
#endif



void main(void)
{
    //Stop watchdog timer
    WDT_A_hold(WDT_A_BASE);

    GPIO_setAsOutputPin(GPIO_PORT_P1, GPIO_PIN0);
    GPIO_setOutputLowOnPin(GPIO_PORT_P1, GPIO_PIN0);

    GPIO_setAsOutputPin(GPIO_PORT_P4, GPIO_PIN6);
    GPIO_setOutputHighOnPin(GPIO_PORT_P4, GPIO_PIN6);

    DigitalOut radio_cs(CC11200_CS_PORT, CC11200_CS_PIN);
    radio_cs.write(false);

    DigitalOut radio_reset(CC11200_RESET_PORT, CC11200_RESET_PIN);
    radio_reset.write(1);
    radio_reset.write(true);
    SPI spi = init_spi_and_i_promise_to_only_call_this_once(4000000);
    CC1120 radio(spi, radio_cs, radio_reset);

    radio.begin();

    GPIO_setOutputLowOnPin(GPIO_PORT_P4, GPIO_PIN6);

    // set the RX off mode to go into the idle state
    //radio.setRxOffMode(0x00);

    // set the TX off mode to go into the RX state
    //radio.setTxOffMode(0x03);

    // enter loop
    char sendData[16] = "testing123";
    char recvData[16] = {'\0'};
    for(int i=0; ; i++) {
        if (i % 10 == 0) {
            // wake up by getting state
            while(radio.getState() != CC1120_STATE_IDLE) {
                wait(100);
            }


            radio.pushTxFifo(sendData, sizeof(sendData));
            radio.strobeTransmit();

            // keep waiting until we are idle
            while(radio.getState() != CC1120_STATE_IDLE) {
                wait(100);
            }

            int res = radio.popRxFifo(recvData, 16);
            recvData[res] = '\0';

            // put the radio into deep sleep mode
            radio.deepSleep();
        }
        wait(500);
        GPIO_toggleOutputOnPin(GPIO_PORT_P4, GPIO_PIN6);
    }
}

