#include <mbed.hpp>
#include "driverlib.h"

DigitalOut::DigitalOut(uint8_t port, uint16_t pin)
: _port(_port), _pin(_pin)
 {
    GPIO_setAsOutputPin(_port, _pin);
}

void DigitalOut::write(bool enabled) volatile {
    if (enabled) {
        GPIO_setOutputHighOnPin(_port, _pin);
    } else {
        GPIO_setOutputLowOnPin(_port, _pin);
    }
}
