#ifndef __MBED_COMPAT_H
#define __MBED_COMPAT_H

#include <stdint.h>
#include <stdbool.h>

class DigitalOut {
private:
    uint8_t _port;
    uint16_t _pin;

public:
    DigitalOut(uint8_t port, uint16_t pin);
    DigitalOut(DigitalOut&&) = default;
    DigitalOut(const DigitalOut&) = default;
    void write(bool enabled) volatile;
};

class SPI {
private:
    SPI(uint32_t freq_hz);

public:
    SPI(SPI&&) = default;
    SPI(const SPI&) = default;

    uint8_t write(uint8_t value) volatile;

    friend SPI init_spi_and_i_promise_to_only_call_this_once(uint32_t freq_hz);
};

SPI init_spi_and_i_promise_to_only_call_this_once(uint32_t freq_hz);

void wait(uint32_t millis);

#endif
