/*
 * Copyright (c) 2020, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/*
 *  ======== uart2echo.c ========
 */
#include <stdint.h>
#include <stdbool.h>
#include <stddef.h>

/* Driver Header files */
#include <ti/drivers/GPIO.h>


#include "../HRSbootloader/common/common_Bootloader.h"

// Reserve 4 bytes for the FUIP to place the size of the Application. This is at the end of the Vector Table.
#pragma LOCATION ( ImageSize , BOOTLOADER_SIZE + VECTOR_TABLE_SIZE )
#pragma RETAIN ( ImageSize )
const int ImageSize = 0xAABBBBAA;


#define BUZZER 29

#define CONSTANT_REPEATIONS 10
#define RANDOM_REPEATIONS   20


static bool random = false;


// random number generator
//

static unsigned long a = 1664525;
static unsigned long c = 1013904223;

static unsigned long Xn;

void PRNG_LCG_seed ( unsigned int seed )
{
    Xn = seed;
}

unsigned int PRNG_LCG_generate (void)
{
    Xn = ( a * Xn + c );

    return (unsigned int)Xn;
}

//
// random number generator


/*
 *  ======== mainThread ========
 */
void *mainThread(void *arg0)
{
    uint8_t repeations = 0;

//    (void)ImageSize;

    /* Call driver init functions */
    GPIO_init();

    PRNG_LCG_seed ( 1000 );

    while (1)
    {
        int i;

        if ( !random )
        {
            GPIO_write ( BUZZER, 0 );
            for ( i=0 ; i<3000000 ; i++ );

            GPIO_write ( BUZZER, 1 );
            for ( i=0 ; i<30000 ; i++ );

            if ( ++repeations == CONSTANT_REPEATIONS )
            {
                random = true;
                repeations = 0;
            }
        }
        else
        {
            unsigned int N;

            GPIO_write ( BUZZER, 0 );
            N = (PRNG_LCG_generate() %9) +1;     // generate a number between 1 and 9!
            for ( i=0 ; i< N* 100000 ; i++ );

            GPIO_write ( BUZZER, 1 );
            N = (PRNG_LCG_generate() %9) +1;     // generate a number between 1 and 9!
            for ( i=0 ; i< N* 100000 ; i++ );

            if ( ++repeations == RANDOM_REPEATIONS )
            {
                random = false;
                repeations = 0;
            }
        }
    }
}


