///////////////////////////////////////////////////////////////////////////////
//                              RTC ð 
///////////////////////////////////////////////////////////////////////////////


#define ONEDAY_MS               24*3600*1000
#define RTCDEVIATIONMAX         30000   //ms, RTC 1 5,  Ȯ RV3032 ִ  13

static JTIME64 CalStartTime;    //ð踦   (ms)
static int RtcDeviation;        // Rtc , ms
static int DeviationPeriod;     //Ⱓ, ms



//-----------------------------------------------------------------------------
//      RTC  ε
//-----------------------------------------------------------------------------
VOID WINAPI RTC_SetDeviation(int Deviation, int Period)
    {
    SYSTEMTIME ST;

    GetLocalTime(&ST);
    CalStartTime=PackTotalSecond64(&ST);    //  RTC ð ƴ  ϰ ִ ͺٴ ⿡...
    RtcDeviation=Deviation;
    DeviationPeriod=Period;
    }

VOID WINAPI RTC_GetDeviation(int *lpDeviation, int *lpPeriod)
    {
    *lpDeviation=RtcDeviation;
    *lpPeriod=DeviationPeriod;
    }




//-----------------------------------------------------------------------------
//      ־ ο ð  Ͽ 
//      NewTime RTC ϱ  ȣ
//-----------------------------------------------------------------------------
VOID WINAPI RTC_CalcDeviation(JTIME NewTime_Sec, UINT NewTime_ms)
    {
    INT64 Period, Deviation;
    JTIME64 NewTime, RtcTime;
    SYSTEMTIME ST;
    static BYTE CalStartTimeCorrect;    //  RTC ߱  0 

    NewTime=JTimeToJTime64(NewTime_Sec)+NewTime_ms;

    #if RTCDEVIATION_DEBUG
    GetLocalTime(&ST);
    Printf("SENSOR: Calibrated RTC deviation=%,d ms" CRLF, (int)(PackTotalSecond64(&ST)-NewTime));
    #endif

    GetLocalTime_(&ST); RtcTime=PackTotalSecond64(&ST);
    Deviation=RtcTime-NewTime;

    #if RTCDEVIATION_DEBUG
    Printf("SENSOR: Original RTC deviation=%,d ms" CRLF, (int)Deviation);
    #endif

    Period=RtcTime-CalStartTime;                                                //GetLocalTime()   ð    ,  RTC ð ð 
    if (CalStartTimeCorrect!=0 &&
        Deviation>-RTCDEVIATIONMAX && Deviation<RTCDEVIATIONMAX &&              //RTCDEVIATIONMAX Ϸ , ߰ ð ٲ  ͹   츦 
        Period>ONEDAY_MS/24 && Period<ONEDAY_MS*2)                              //Period=   , Period>ONEDAY_MS/24  <0 ɷ
        {                                                                       //ּ 1ð ̻  Ǿ߸   (ʹ ª ð  ϸ  )
        if ((int)Period>=ONEDAY_MS/2 || (int)Period>=DeviationPeriod)           //12ð ̻  ٷ Ʈ, 12ð ̸   ð ū  Ʈ
            {
            RtcDeviation=(int)Deviation;
            DeviationPeriod=(int)Period;

            #if RTCDEVIATION_DEBUG
            Printf("SENSOR: Set Deviation=%,d (Period=%,d)" CRLF, (int)Deviation, (int)Period);
            #endif
            }
        }
    CalStartTime=NewTime;                                                       // Լ Ŀ NewTime RTC 
    CalStartTimeCorrect=1;
    }




//-----------------------------------------------------------------------------
//        ð 
//-----------------------------------------------------------------------------
VOID WINAPI GetLocalTime(SYSTEMTIME *ST)
    {
    int     Delta;
    INT64   Elapse;
    JTIME64 RtcTime;

    GetLocalTime_(ST);                                                          //RTC ð 
    if (DeviationPeriod!=0)
        {
        RtcTime=PackTotalSecond64(ST);
        Elapse=RtcTime-CalStartTime;                                            //CalStartTime RTC_CalcDeviation()   ð,  ÿ RTCð 
        if (Elapse>0 && Elapse<3*ONEDAY_MS)
            {
            Delta=MulDiv(RtcDeviation, (int)Elapse, DeviationPeriod);

            #if 0//RTCDEVIATION_DEBUG
            {
            static BYTE Second;
            if (ST->wSecond!=Second)
                {
                Printf("SENSOR: RTC CalTime MulDiv(%,d, %,u, %,u)=%d ms" CRLF, RtcDeviation, (int)Elapse, DeviationPeriod, Delta);
                Second=ST->wSecond;
                }
            }
            #endif

            RtcTime-=Delta;                                                     //RTC 

            UnpackTotalSecond64(ST, RtcTime);
            if ((int)Elapse>=2*ONEDAY_MS)                                       //ð   MulDiv() ÷ο ߻
                {
                CalStartTime=RtcTime;

                if (ST->wMilliseconds!=0)
                    {
                    Sleep(1000-ST->wMilliseconds);
                    UnpackTotalSecond(ST, PackTotalSecond(ST)+1);
                    }
                SetLocalTime(ST);
                }
            }
        }
    }



