///////////////////////////////////////////////////////////////////////////////
//                              STM32L0XX Driver
//
// : 2019-01-21 ~
// α׷: 
///////////////////////////////////////////////////////////////////////////////


#include "JLIB.H"
#include "DRIVER.H"
#include "JOS.H"
#include "MONITOR.H"


#define RTCDEVIATION_DEBUG      1           //ð   簡 ִ ð ĸ ǥ. ̸  ̰ ̸  


volatile DWORD FineTickCnt; //JOS 
static BYTE DebugPort=COM_DEBUG;

VOID WINAPI _1msProc(VOID);


//#define MODIFYBIT(Reg, ClearMask, SetMask) {Reg=(Reg & ~(ClearMask)) | (SetMask);}    //̰ź Ʒ ڵ尡 ª
#define MODIFYBIT(Reg, Clear, Set) {UINT R=Reg & ~(Clear); R|=Set; Reg=R;}
#define BITSET(Reg, Bit, OnOff)    {UINT R=Reg; R&=~(Bit); if (OnOff) R|=Bit; Reg=R;}



//-----------------------------------------------------------------------------
//      Hard Fault exception.
//      ͼ ߻  CPU Pushϴ  xPSR,PC,LR,R12,R3,R2,R1,R0, R7,R6,R5,R4
//-----------------------------------------------------------------------------
LOCAL(VOID) DefaultExpHandler(UINT *lpStack, LPCSTR FaultTitle)
    {
    LowPrintf(CRLF"%s"CRLF, FaultTitle);
    LowPrintf("  R0=%08X  R1=%08X  R2=%08X  R3=%08X"CRLF, lpStack[4], lpStack[5], lpStack[6], lpStack[7]);
    LowPrintf("  R4=%08X  R5=%08X  R6=%08X  R7=%08X"CRLF, lpStack[0], lpStack[1], lpStack[2], lpStack[3]);
    LowPrintf(" R12=%08X  SP=%08X  LR=%08X  PC=%08X"CRLF, lpStack[8], lpStack+12, lpStack[9], lpStack[10]);
    #ifdef USE_JOS
    LowPrintf("  SR=%08X Task=%d"CRLF, lpStack[11], JOSCurrPrio);
    #else
    LowPrintf("  SR=%08X"CRLF, lpStack[11]);
    #endif
    LowPrintf("Halted...");
    FatalError(FERR_EXCEPTION);
    }



//-----------------------------------------------------------------------------
//      Hard Fault exception.
//      ͼ ߻  CPU Pushϴ  xPSR,PC,LR,R12,R3,R2,R1,R0, R11,R10,R9,R8,R7,R6,R5,R4
//-----------------------------------------------------------------------------
VOID NMI_Handler_C(UINT *lpStack) {DefaultExpHandler(lpStack, "NMI Occured");}
VOID HardFault_Handler_C(UINT *lpStack) {DefaultExpHandler(lpStack, "Hard Fault");}
VOID UndefinedIntHandler_C(UINT *lpStack) {DefaultExpHandler(lpStack, "Undefined Interrupt");}
VOID SVC_Handler_C(UINT *lpStack) {DefaultExpHandler(lpStack, "Called SVC");}
VOID PendSV_Handler_C(UINT *lpStack) {DefaultExpHandler(lpStack, "PendSV Exception");}
VOID SysTick_Handler_C(UINT *lpStack) {DefaultExpHandler(lpStack, "SysTick Exception");}





VOID SysTick_Handler(VOID)  //Startup_STM32L083xx.s  ȣ
    {
    FineTickCnt++;
    _1msProc();
    }


UINT HAL_GetTick(VOID)      //STM32L0xx_hal.cȿ __weakԼ 
    {
    if (FineTickCnt==0) return 1;   //÷׷  
    return FineTickCnt;
    }



VOID WINAPI Delay_us(int T)
    {
    volatile int I;
    for (I=0; I<T; I++);
    }



//-----------------------------------------------------------------------------
//      ɾ ݺ ms  
//-----------------------------------------------------------------------------
static UINT DelayValue=972;     //STM32L083 8MHz   
VOID WINAPI Delay1ms(UINT ms)
    {
    volatile UINT Cnt;
    while (ms--) {Cnt=DelayValue; while (Cnt--);}
    }

VOID WINAPI CalcDelay1ms(BOOL CalFg)
    {
    DWORD Time, Org;

    if (CalFg!=0)
        {
        Org=DelayValue;
        Time=GetTickCount();
        Delay1ms(1000);
        Time=GetTickCount()-Time;
        DelayValue=MulDiv(DelayValue, 1000, Time);
        Printf("Delay1ms=%u, Delay: %u->%u"CRLF, Time, Org, DelayValue);
        }
    else DelayValue=MulDiv(DelayValue, SystemCoreClock, 8000000);
    }



///////////////////////////////////////////////////////////////////////////////
//                              GPIO
///////////////////////////////////////////////////////////////////////////////


#ifdef STM32L083xx
#define GPIO_MODER_MODER0           GPIO_MODER_MODE0
#define GPIO_OSPEEDER_OSPEEDR0      GPIO_OSPEEDER_OSPEED0
#define GPIO_PUPDR_PUPDR0           GPIO_PUPDR_PUPD0
#endif //STM32L083xx


//-----------------------------------------------------------------------------
//      GPIO Port Base 
//-----------------------------------------------------------------------------
LOCAL(GPIO_TypeDef*) GetGpioBase(int PinNo)
    {
    GPIO_TypeDef *GB=NULL;

    switch (PinNo>>4)
        {
        case 0: GB=GPIOA; break;
        case 1: GB=GPIOB; break;
        case 2: GB=GPIOC; break;
        case 3: GB=GPIOD; break;
        #ifndef STM32L053xx
        case 4: GB=GPIOE; break;
        #endif
        case 7: GB=GPIOH; //break;
        }
    return GB;
    }



#define GPIO_MODE             0x00000003
#define RISING_EDGE           0x00100000
#define FALLING_EDGE          0x00200000
#define GPIO_MODE_IT          0x00010000
#define EXTI_MODE             0x10000000
#define GPIO_OUTPUT_TYPE      0x00000010
#define GPIO_MODE_EVT         0x00020000
#define GPIO_MODER_MODER0       GPIO_MODER_MODE0
#define GPIO_OSPEEDER_OSPEEDR0  GPIO_OSPEEDER_OSPEED0
#define GPIO_PUPDR_PUPDR0       GPIO_PUPDR_PUPD0
VOID HAL_GPIO_Init(GPIO_TypeDef *GPIOx, GPIO_InitTypeDef *GI)   //STM32L0xx_hal_rcc.c  ϹǷ Լ  ؾ
    {
    UINT Shift, BitPos, CurrBit;

    for (BitPos=0; (GI->Pin>>BitPos)!=0; BitPos++)      //GI->Pin>>BitPos -  BitPos ʺκ  0̸  
        {
        CurrBit=1<<BitPos;
        if (GI->Pin & CurrBit)
            {
            if (GI->Mode==GPIO_MODE_AF_PP || GI->Mode==GPIO_MODE_AF_OD)
                {
                //GPIO_PinAFConfig()
                Shift=(BitPos&7)<<2;
                MODIFYBIT(GPIOx->AFR[BitPos>>3], 0x0F<<Shift, GI->Alternate << Shift);
                }

            MODIFYBIT(GPIOx->MODER, GPIO_MODER_MODER0<<BitPos*2, (GI->Mode&GPIO_MODE)<<BitPos*2);

            if (GI->Mode==GPIO_MODE_OUTPUT_PP || GI->Mode==GPIO_MODE_AF_PP ||
                GI->Mode==GPIO_MODE_OUTPUT_OD || GI->Mode==GPIO_MODE_AF_OD)
                {
                MODIFYBIT(GPIOx->OSPEEDR, GPIO_OSPEEDER_OSPEEDR0<<BitPos*2, GI->Speed<<BitPos*2);
                MODIFYBIT(GPIOx->OTYPER, GPIO_OTYPER_OT_0<<BitPos, ((GI->Mode&GPIO_OUTPUT_TYPE)>>4)<<BitPos);
                }

            MODIFYBIT(GPIOx->PUPDR, GPIO_PUPDR_PUPDR0<<BitPos*2, (GI->Pull)<<BitPos*2);
            GPIOx->BRR=1<<BitPos;   //2020-01-15 ·Ʈ 0

            if (GI->Mode & EXTI_MODE)
                {
                __HAL_RCC_SYSCFG_CLK_ENABLE();

                Shift=(BitPos&3)<<2;
                MODIFYBIT(SYSCFG->EXTICR[BitPos>>2], 0x0F<<Shift, GPIO_GET_INDEX(GPIOx)<<Shift);

                BITSET(EXTI->IMR,  CurrBit, GI->Mode & GPIO_MODE_IT);
                BITSET(EXTI->EMR,  CurrBit, GI->Mode & GPIO_MODE_EVT);
                BITSET(EXTI->RTSR, CurrBit, GI->Mode & RISING_EDGE);
                BITSET(EXTI->FTSR, CurrBit, GI->Mode & FALLING_EDGE);
                }
            }
        }
    }



VOID WINAPI GPIO_DeInit(int PinNo)
    {
    int Port, BitPos, BitMask, T;
    GPIO_TypeDef     *GB;

    Port=PinNo>>4;
    BitPos=PinNo & 0x0F;
    BitMask=1<<BitPos;
    if ((GB=GetGpioBase(PinNo))!=NULL)
        {
        GB->MODER|=GPIO_MODER_MODE0<<(BitPos*2);
        GB->AFR[BitPos>>3]&=~(0xF<<((BitPos&7)*4));
        GB->OSPEEDR&=~(GPIO_OSPEEDER_OSPEED0<<(BitPos*2));
        GB->OTYPER&=~(GPIO_OTYPER_OT_0<<BitPos);
        GB->PUPDR&=~(GPIO_PUPDR_PUPD0<<(BitPos*2));
        GB->BRR=BitMask;        //2020-01-14 ·Ʈ 0

        T=4*(BitPos&3);
        if ((SYSCFG->EXTICR[BitPos>>2] & (0x0F<<T))==(Port<<T))
            {
            SYSCFG->EXTICR[BitPos>>2]&=~(0x0F<<T);
            EXTI->IMR&=~BitMask;
            EXTI->EMR&=~BitMask;
            EXTI->RTSR&=~BitMask;
            EXTI->FTSR&=~BitMask;
            }
        }
    }



//-----------------------------------------------------------------------------
//      Init GPIO
//-----------------------------------------------------------------------------
VOID WINAPI InitPortEx(int PinNo, int PinMode, int PullUpDown, int AltFnc, int Speeed)
    {
    int Port;
    __IO UINT Dummy;
    GPIO_InitTypeDef GITD;
    GPIO_TypeDef     *GB;

    Port=PinNo>>4;
    if ((GB=GetGpioBase(PinNo))!=NULL)
        {
        //ش GPIO Clock Enable, __HAL_RCC_GPIO?_CLK_ENABLE
        RCC->IOPENR|=RCC_IOPENR_GPIOAEN<<Port;
        Dummy=RCC->IOPENR & (RCC_IOPENR_GPIOAEN<<Port);
        UNUSED(Dummy);

        ZeroMem(&GITD, sizeof(GPIO_InitTypeDef));
        GITD.Mode=PinMode;
        GITD.Pull=PullUpDown;
        GITD.Speed=Speeed;
        GITD.Pin=1<<(PinNo & 0x0F);
        GITD.Alternate=AltFnc;
        HAL_GPIO_Init(GB, &GITD);
        }
    }

VOID WINAPI InitPort(int PinNo, int PinMode, int PullUpDown, int AltFnc)
    {
    InitPortEx(PinNo, PinMode, PullUpDown, AltFnc, GPIO_SPEED_HIGH);    //GPIO_SPEED_HIGH:50MHz
    }

VOID WINAPI InitPortOutputPP(int PinNo)
    {
    InitPort(PinNo, GPIO_MODE_OUTPUT_PP, GPIO_NOPULL, 0);
    }

VOID WINAPI InitPortOutputOD(int PinNo)
    {
    InitPort(PinNo, GPIO_MODE_OUTPUT_OD, GPIO_NOPULL, 0);
    }

#if 0   //   ҷ   
VOID WINAPI InitPortFloating(int PinNo)
    {
    InitPort(PinNo, GPIO_MODE_OUTPUT_OD, GPIO_NOPULL, 0);
    PortOut(PinNo, HIGH);
    }
#endif

VOID WINAPI InitPortInput(int PinNo, int PullUpDown)
    {
    InitPort(PinNo, GPIO_MODE_INPUT, PullUpDown, 0);
    }



//-----------------------------------------------------------------------------
//      GPIO Out
//-----------------------------------------------------------------------------
BOOL WINAPI PortOut(int PinNo, int PinData)
    {
    int PinBit, Rslt=0, BitNo;
    GPIO_TypeDef *GB;

    if (PinNo<I2CPORT)
        {
        BitNo=PinNo & 0x0F;
        PinBit=1<<BitNo;
        if ((GB=GetGpioBase(PinNo))!=NULL)
            {
            JOS_ENTER_CRITICAL();
            switch (PinData)
                {
                case LOW: GB->BRR=PinBit; break;        //HAL_GPIO_WritePin(GB, PinBit, (GPIO_PinState)PinData);
                case HIGH: GB->BSRR=PinBit; break;
                case PO_NOT: GB->ODR^=PinBit; break;    //HAL_GPIO_TogglePin(GB, PinBit);
                case PO_GETSTATE: Rslt=(GB->ODR >> BitNo) & 1;
                }
            JOS_EXIT_CRITICAL();
            }
        }
    return Rslt;
    }



BOOL WINAPI PortIn(int PinNo)
    {
    BOOL Rslt=FALSE;
    GPIO_TypeDef *GB;

    if (PinNo<I2CPORT)
        {
        if ((GB=GetGpioBase(PinNo))!=NULL)
            Rslt=(GB->IDR & (1<<(PinNo & 0x0F)))!=0;
        }

    return Rslt;
    }

DWORD WINAPI PortAIn(VOID) {return GPIOA->IDR;}
DWORD WINAPI PortBIn(VOID) {return GPIOB->IDR;}




///////////////////////////////////////////////////////////////////////////////
//                              UART, RS232
///////////////////////////////////////////////////////////////////////////////


#define UART_TIMEOUT    5000

typedef struct
    {
    USART_TypeDef *Instance;
    UART_AdvFeatureInitTypeDef AdvancedInit;
    JOS_EVENT *hEvGroupTx;
    JOS_EVENT *RxQ;
    JOS_EVENT *TxQ;
    BYTE PO_RTS;
    BYTE PI_CTS;
    BYTE PO_DTR;
    BYTE PI_DSR;
    UINT BaudRate;
    UINT Mode;
    UINT OverSampling;
    UINT ErrorCode;
    } UART_HANDLE;


typedef struct
    {
    USART_TypeDef *Instance;
    } UART_INST;



static UART_HANDLE UartHandle[USART_QTY];
//static UART_HandleTypeDef LPUartHandle;



//-----------------------------------------------------------------------------
//      CTSɻ¸ ˷
//-----------------------------------------------------------------------------
int WINAPI UART_InCTS(int Port)
    {
    int CtsPin;

    //return (UartHandle+Port)->Instance->ISR & UART_FLAG_CTS;
    if ((CtsPin=(UartHandle+Port)->PI_CTS)==0) return 0;
    return PortIn(CtsPin);
    }



//-----------------------------------------------------------------------------
//      RTS 
//-----------------------------------------------------------------------------
int WINAPI UART_OutRTS(int Port, BOOL EnableFg)
    {
    int RtsPin, Rslt=0;

    if ((RtsPin=(UartHandle+Port)->PO_RTS)!=0)
        {
        //Printf("COM%d RTS<-%d"CRLF, Port+1, EnableFg);
        Rslt=PortOut(RtsPin, EnableFg);
        }
    return Rslt;
    }



//-----------------------------------------------------------------------------
//      DSRɻ¸ ˷
//-----------------------------------------------------------------------------
int WINAPI UART_InDSR(int Port)
    {
    int DsrPin;

    if ((DsrPin=(UartHandle+Port)->PI_DSR)==0) return 0;
    return PortIn(DsrPin);
    }



//-----------------------------------------------------------------------------
//      DTR 
//-----------------------------------------------------------------------------
int WINAPI UART_OutDTR(int Port, BOOL EnableFg)
    {
    int DtrPin, Rslt=0;

    if ((DtrPin=(UartHandle+Port)->PO_DTR)!=0) Rslt=PortOut(DtrPin, EnableFg);
    return Rslt;
    }



//-----------------------------------------------------------------------------
//      RS232  ǥ
//-----------------------------------------------------------------------------
VOID WINAPI UART_DisplayError(VOID)
    {
    int I, ErrCode, HwErr;
    UART_HANDLE *hUart;

    for (I=LPCOM1; I<USART_QTY; I++)
        {
        hUart=UartHandle+I;
        if ((ErrCode=hUart->ErrorCode)!=0)
            {
            HwErr=0;
            if (ErrCode & HAL_UART_ERROR_PE) {Printf("SENSOR: COM%d Parity Err"CRLF, I+1); HwErr=1;}
            if (ErrCode & HAL_UART_ERROR_FE) {Printf("SENSOR: COM%d Frame Err"CRLF, I+1); HwErr=1;}
            if (ErrCode & HAL_UART_ERROR_NE) {Printf("SENSOR: COM%d Noise Err"CRLF, I+1); HwErr=1;}
            if (ErrCode & HAL_UART_ERROR_ORE) Printf("SENSOR: COM%d Over Run"CRLF, I+1);
            if (HwErr) UART_ErrUsrHandler(I, ErrCode);
            hUart->ErrorCode=0;
            }
        }
    }



//-----------------------------------------------------------------------------
//      UART Ŭ 
//-----------------------------------------------------------------------------
LOCAL(UINT) UART_GetClock(USART_TypeDef *UB)
    {
    UINT InClk=0;
    UART_INST UINST={UB};
    UART_ClockSourceTypeDef ClkSrc;

    UART_GETCLOCKSOURCE(&UINST, ClkSrc);
    switch (ClkSrc)
        {
        case UART_CLOCKSOURCE_PCLK1:
            InClk=HAL_RCC_GetPCLK1Freq();
            break;

        case UART_CLOCKSOURCE_HSI:
            InClk=HSI_VALUE;
            if (__HAL_RCC_GET_FLAG(RCC_FLAG_HSIDIV)!=0) InClk=HSI_VALUE>>2;
            break;

        case UART_CLOCKSOURCE_SYSCLK:
            InClk=HAL_RCC_GetSysClockFreq();
            break;

        case UART_CLOCKSOURCE_LSE:
            InClk=LSE_VALUE;
            //break;
        }
    return InClk;
    }




//-----------------------------------------------------------------------------
//       Baudrate  
//-----------------------------------------------------------------------------
DWORD WINAPI UART_GetBaudrate(int Port)
    {
    int UartDiv;
    DWORD BaudRate=0, InClk;
    UART_HANDLE *hUart;
    USART_TypeDef *UB;

    hUart=UartHandle+Port;
    UB=hUart->Instance;
    if ((InClk=UART_GetClock(UB))>0)
        {
        UartDiv=UB->BRR;

        if (UB==LPUART1)
            BaudRate=(UINT)DIV_ROUNDUP((UINT64)InClk*256, UartDiv);
        else
            BaudRate=DIV_ROUNDUP(InClk, UartDiv);
        }
    return BaudRate;
    }




//-----------------------------------------------------------------------------
//      Baudrate 
//-----------------------------------------------------------------------------
LOCAL(BOOL) SetBaudRate(USART_TypeDef *UB, UINT BaudRate)
    {
    BOOL Rslt=FALSE;
    UINT InClk;

    if ((InClk=UART_GetClock(UB))>0)
        {
        if (UB==LPUART1)                                            //InClk BaudRate*3 ~ BaudRate*4096 ̾ 
            UB->BRR=UART_DIV_LPUART(InClk, BaudRate);               //BRR 0x300~0xFFFFF  ̾ 
        else
            UB->BRR=(WORD)(UART_DIV_SAMPLING16(InClk, BaudRate));   //BRR 0x10~0xFFFF ̾ 
        Rslt++;
        }
    return Rslt;
    }



VOID WINAPI UART_SetBaudrate(int Port, DWORD NewBaud)
    {
    SetBaudRate((UartHandle+Port)->Instance, NewBaud);
    }




//-----------------------------------------------------------------------------
//      ͷƮ Ź 
//-----------------------------------------------------------------------------
LOCAL(VOID) UART_PrepareRecvIT(UART_HANDLE *hUart)
    {
    USART_TypeDef *UB;

    hUart->RxQ=JOSQCreate(UART_RECV_BUFF_SIZE, JOSQTYPE_BYTE);
    UB=hUart->Instance;
    UB->CR3|=USART_CR3_EIE;     //Enable the UART Error Interrupt: (Frame error, noise error, overrun error)
    UB->CR1|=USART_CR1_PEIE|    //Enable the UART Parity Error Interrupt
             USART_CR1_RXNEIE;  //Enable the UART Data Register not empty Interrupt
    }



//-----------------------------------------------------------------------------
//      ͷƮ ۽Ź 
//-----------------------------------------------------------------------------
LOCAL(VOID) UART_PrepareSendIT(UART_HANDLE *hUart)
    {
    USART_TypeDef *UB;

    hUart->TxQ=JOSQCreate(UART_SEND_BUFF_SIZE, JOSQTYPE_BYTE);
    hUart->hEvGroupTx=JOSSemCreate(1);
    UB=hUart->Instance;
    UB->CR3|=USART_CR3_EIE;     //Enable the UART Error Interrupt: (Frame error, noise error, overrun error)
    UB->CR1|=USART_CR1_TXEIE;   //Enable the UART Transmit Data Register Empty Interrupt
    }




VOID UART_IRQHandler(UART_HANDLE *hUart)
    {
    UINT ISR;
    USART_TypeDef *UB;

    UB=hUart->Instance;
    ISR=UB->ISR;

    if (ISR & USART_ISR_PE)         //Parity error
        {
        UB->ICR=UART_CLEAR_PEF;     //__HAL_UART_CLEAR_FLAG()
        hUart->ErrorCode|=HAL_UART_ERROR_PE;
        }

    if (ISR & USART_ISR_FE)         //Frame error
        {
        UB->ICR=UART_CLEAR_FEF;
        hUart->ErrorCode|=HAL_UART_ERROR_FE;
        }

    if (ISR & USART_ISR_NE)         //Noise error
        {
        UB->ICR=UART_CLEAR_NEF;
        hUart->ErrorCode|=HAL_UART_ERROR_NE;
        }

    if (ISR & USART_ISR_ORE)        //Over-Run
        {
        UB->ICR=UART_CLEAR_OREF;
        hUart->ErrorCode|=HAL_UART_ERROR_ORE;
        }

    #if 0
    if (ISR & USART_ISR_WUF) //CR3 & USART_CR3_WUFIE
        {
        UB->ICR=UART_CLEAR_WUF;
        HAL_UARTEx_WakeupCallback(hUart);
        }
    #endif

    if (ISR & USART_ISR_RXNE)
        {
        if (JOSQPost(hUart->RxQ, UB->RDR, 0)!=JOS_ERR_NONE) hUart->ErrorCode|=HAL_UART_ERROR_ORE;
        //else UB->CR1&=~USART_CR1_RXNEIE;              //۰ ,  Byte о   Int ɸ
        }

    if (ISR & USART_ISR_TXE)
        {
        DWORD Data;
        JOS_RESULT QRslt;

        Data=JOSQPend(hUart->TxQ, CHECKACCEPT, &QRslt);
        if (QRslt==JOS_ERR_NONE) UB->TDR=Data;
        else{
            UB->CR1&=~USART_CR1_TXEIE;          //Disable the UART Transmit Data Register Empty Interrupt
            //UB->CR1|=USART_CR1_TCIE;          //Enable the UART Transmit Complete Interrupt
            }
        }

    #if 0
    if (ISR & USART_ISR_TC)
        {
        UB->CR1&=~USART_CR1_TCIE;
        HAL_UART_TxCpltCallback(hUart);
        }
    #endif
    }



#ifdef STM32L073xx
VOID RNG_LPUART1_IRQHandler(VOID)
    {
    UART_IRQHandler(UartHandle+LPCOM1);
    }
#endif



#ifdef STM32L083xx
VOID AES_RNG_LPUART1_IRQHandler(VOID)
    {
    UART_IRQHandler(UartHandle+LPCOM1);
    }
#endif


#ifdef PO_COM1TX
VOID USART1_IRQHandler(VOID)
    {
    UART_IRQHandler(UartHandle+COM1);
    }
#endif

#ifdef PO_COM2TX
VOID USART2_IRQHandler(VOID)
    {
    UART_IRQHandler(UartHandle+COM2);
    }
#endif

#if defined(PO_COM4TX) || defined(PO_COM5TX)
VOID USART4_5_IRQHandler(VOID)
    {
    //UART_IRQHandler(UartHandle+COM4);
    UART_IRQHandler(UartHandle+COM5);
    }
#endif




VOID WINAPI InitUart(int ComNo, DWORD BaudRate, int Parity, int DataLen, int StopBit, int IntExtClock)
    {
    int HwFlowCtl=UART_HWCONTROL_NONE, Mode=UART_MODE_TX_RX, OverSampling=UART_OVERSAMPLING_16;
    UINT Dw, TickStart;
    USART_TypeDef *UB;
    UART_HANDLE *hUart;

    hUart=UartHandle+ComNo;
    switch (ComNo)
        {
        #ifdef PO_LPCOM1TX
        case LPCOM1:
            if (IntExtClock)    //UART_EXTCLOCK
                {
                RCC_OscInitTypeDef OSCI;
                RCC_PeriphCLKInitTypeDef PCKI;

                OSCI.OscillatorType=RCC_OSCILLATORTYPE_LSE;
                OSCI.PLL.PLLState=RCC_PLL_NONE;
                OSCI.LSEState=RCC_LSE_ON;
                HAL_RCC_OscConfig(&OSCI);

                PCKI.PeriphClockSelection=RCC_PERIPHCLK_LPUART1;
                PCKI.Lpuart1ClockSelection=RCC_LPUART1CLKSOURCE_LSE;
                HAL_RCCEx_PeriphCLKConfig(&PCKI);
                }

            hUart->Instance=LPUART1;
            __HAL_RCC_LPUART1_CLK_ENABLE();
            NVIC_SetPriority(LPUART1_IRQn, 1);
            NVIC_EnableIRQ(LPUART1_IRQn);

            UART_PrepareRecvIT(hUart);  //Ź 
            UART_PrepareSendIT(hUart);
            break;
        #endif

        #ifdef PO_COM1TX
        case COM1:
            hUart->Instance=USART1;
            __HAL_RCC_USART1_CLK_ENABLE();
            NVIC_SetPriority(USART1_IRQn, 1);
            NVIC_EnableIRQ(USART1_IRQn);

            UART_PrepareRecvIT(hUart);  //Ź 
            UART_PrepareSendIT(hUart);
            break;
        #endif

        #ifdef PO_COM2TX
        case COM2:
            hUart->Instance=USART2;
            __HAL_RCC_USART2_CLK_ENABLE();
            NVIC_SetPriority(USART2_IRQn, 1);
            NVIC_EnableIRQ(USART2_IRQn);

            UART_PrepareRecvIT(hUart);  //Ź 
            UART_PrepareSendIT(hUart);
            break;
        #endif

        #ifdef PO_COM4TX
        case COM4:
            hUart->Instance=USART4;
            __HAL_RCC_SYSCFG_CLK_ENABLE();
            __HAL_RCC_USART4_CLK_ENABLE();
            NVIC_SetPriority(USART4_5_IRQn, 0);
            NVIC_EnableIRQ(USART4_5_IRQn);

            UART_PrepareRecvIT(hUart);  //Ź 
            UART_PrepareSendIT(hUart);
            break;
        #endif

        #ifdef PO_COM5TX
        case COM5:
            hUart->Instance=USART5;
            __HAL_RCC_SYSCFG_CLK_ENABLE();
            __HAL_RCC_USART5_CLK_ENABLE();
            NVIC_SetPriority(USART4_5_IRQn, 0);
            NVIC_EnableIRQ(USART4_5_IRQn);

            UART_PrepareRecvIT(hUart);  //Ź 
            UART_PrepareSendIT(hUart);
            break;
        #endif
        }

    UB=hUart->Instance;
    UB->CR1 &= ~USART_CR1_UE;  //__HAL_UART_DISABLE()

    Dw=DataLen|Parity|Mode|OverSampling;
    MODIFYBIT(UB->CR1, USART_CR1_M|USART_CR1_PCE|USART_CR1_PS|USART_CR1_TE|USART_CR1_RE|USART_CR1_OVER8, Dw);

    MODIFYBIT(UB->CR2, USART_CR2_STOP, StopBit);

    Dw=HwFlowCtl;
    //if (UB!=LPUART1) Dw|=hUart->Init.OneBitSampling;
    MODIFYBIT(UB->CR3, USART_CR3_RTSE|USART_CR3_CTSE|USART_CR3_ONEBIT, Dw);

    if (OverSampling==UART_OVERSAMPLING_8) goto ProcExit;       //No Support
    if (SetBaudRate(UB, BaudRate)==FALSE) goto ProcExit;

    //if (hUart->AdvancedInit.AdvFeatureInit!=UART_ADVFEATURE_NO_INIT) UART_AdvFeatureConfig(hUart);

    UB->CR2&=~(USART_CR2_LINEN|USART_CR2_CLKEN);
    UB->CR3&=~(USART_CR3_SCEN|USART_CR3_HDSEL|USART_CR3_IREN);

    UB->CR1|=USART_CR1_UE;  //__HAL_UART_ENABLE();

    //return UART_CheckIdleState(hUart)
    TickStart=HAL_GetTick();
    if (UB->CR1 & USART_CR1_TE)
        {
        while ((UB->ISR & USART_ISR_TEACK)==0)
            {
            if (HAL_GetTick()-TickStart>UART_TIMEOUT)
                {
                TimeOut:
                UB->CR1&=~(USART_CR1_RXNEIE|USART_CR1_PEIE|USART_CR1_TXEIE);
                UB->CR3&=~USART_CR3_EIE;
                goto ProcExit;
                }
            }
        }

    if (UB->CR1 & USART_CR1_RE)
        {
        while ((UB->ISR & USART_ISR_REACK)==0)
            {
            if ((HAL_GetTick()-TickStart)>UART_TIMEOUT) goto TimeOut;
            }
        }

    ProcExit:;
    }




//-----------------------------------------------------------------------------
//       Ʈ 
//-----------------------------------------------------------------------------
int WINAPI UART_ReceiveCntIT(int Port)
    {
    return JOSQEntries((UartHandle+Port)->RxQ);
    }



//-----------------------------------------------------------------------------
//      ۽ߴ üũ
//-----------------------------------------------------------------------------
VOID WINAPI UART_WaitAllSendIT(int ComPort, DWORD TimeOut)
    {
    UART_HANDLE *hUart;
    DWORD Time;

    hUart=UartHandle+ComPort;
    Time=GetTickCount();
    for (;;)
        {
        if (JOSQEntries(hUart->TxQ)==0 && (hUart->Instance->ISR & USART_ISR_TC)!=0) break;
        if (GetTickCount()-Time>TimeOut)
            {
            Printf("COM%d: WaitAllSendIT Timeout"CRLF, ComPort+1);
            break;
            }
        }
    }




//-----------------------------------------------------------------------------
//      ۽ Q 1Byte 
//-----------------------------------------------------------------------------
BOOL WINAPI UART_TxByteIT(int Port, int Ch)
    {
    JOS_RESULT Rslt;
    USART_TypeDef *UB;
    UART_HANDLE *hUart;

    hUart=UartHandle+Port;
    UB=hUart->Instance;
    Rslt=JOSQPost(hUart->TxQ, Ch, 0);
    UB->CR1|=USART_CR1_TXEIE;           //Enable the UART Transmit Data Register Empty Interrupt
    return Rslt==JOS_ERR_NONE;
    }




//-----------------------------------------------------------------------------
//      Serial Port  (ͷƮ̿)
//-----------------------------------------------------------------------------
VOID WINAPI UART_TxBinIT(int Port, LPCBYTE Data, int SendBytes)
    {
    int   Ch;
    DWORD EndTime;

    EndTime=GetTickCount()+SendBytes+1; //+1 1   GetCount() 1ms ٷ Ѿ  
    while (SendBytes--)
        {
        Ch=*Data++;
        while (UART_TxByteIT(Port, Ch)==FALSE)
            {
            if (GetTickCount()>=EndTime) return;
            }
        }
    }


VOID WINAPI UART_TxStrIT(int Port, LPCSTR Str)
    {
    UART_TxBinIT(Port, (LPCBYTE)Str, lstrlen(Str));
    }



//-----------------------------------------------------------------------------
//      ͷƮ 
//-----------------------------------------------------------------------------
int WINAPI UART_RxByteIT(int Port)
    {
    int RcvByte;
    JOS_RESULT QRslt;
    UART_HANDLE *hUart;

    hUart=UartHandle+Port;
    RcvByte=JOSQPend(hUart->RxQ, CHECKACCEPT, &QRslt);
    if (QRslt!=JOS_ERR_NONE) RcvByte=-1;
    return RcvByte;
    }





VOID WINAPI UART_TxBin(int Port, LPCBYTE Data, int SendBytes)
    {
    DWORD EndTime;
    USART_TypeDef *UB;

    UB=(UartHandle+Port)->Instance;
    EndTime=GetTickCount()+SendBytes+1; //+1 1   GetCount() 1ms ٷ Ѿ  
    while (SendBytes--)
        {
        while ((UB->ISR & USART_ISR_TXE)==0)
            {
            if (GetTickCount()>=EndTime) return;
            }
        UB->TDR=*Data++;
        }
    }

VOID WINAPI UART_TxStr(int Port, LPCSTR Text)
    {
    UART_TxBin(Port, (LPCBYTE)Text, lstrlen(Text));
    }



VOID Printf(LPCSTR DispStr, ...)
    {
    va_list VA;
    CHAR Buff[128];

    va_start(VA, DispStr);
    Vsprintf(Buff, DispStr, VA);
    va_end(VA);
    UART_TxStrIT(DebugPort, Buff);
    }



VOID PrintfII(int Port, LPCSTR DispStr, ...)
    {
    va_list VA;
    CHAR Buff[128];

    if (Port<USART_QTY)
        {
        va_start(VA, DispStr);
        Vsprintf(Buff, DispStr, VA);
        va_end(VA);
        UART_TxStrIT(Port, Buff);
        }
    }



VOID LowPrintf(LPCSTR DispStr, ...)         //HardFault óƾ ȿ   
    {
    va_list VA;
    CHAR Buff[128];

    va_start(VA, DispStr);
    Vsprintf(Buff, DispStr, VA);
    va_end(VA);
    UART_TxStr(DebugPort, Buff);
    }


int  WINAPI GetChar(VOID) {return UART_RxByteIT(DebugPort);}
int  WINAPI GetDebugPort(VOID) {return DebugPort;}
VOID WINAPI SetDebugPort(int PortNo) {DebugPort=PortNo;}




///////////////////////////////////////////////////////////////////////////////
//                      WatchDog
///////////////////////////////////////////////////////////////////////////////


#define HAL_IWDG_DEFAULT_TIMEOUT    48


VOID WINAPI IWDG_Refresh(VOID)
    {
    IWDG->KR=IWDG_KEY_RELOAD;   //__HAL_IWDG_RELOAD_COUNTER(hiwdg);
    }


BOOL WINAPI IWDG_Init(int Prescaler, int Reload, int Window)
    {
    BOOL Rslt=FALSE;
    DWORD Tick;
    IWDG_TypeDef *IWdg;

    IWdg=IWDG;
    IWdg->KR=IWDG_KEY_ENABLE;               //__HAL_IWDG_START();
    IWdg->KR=IWDG_KEY_WRITE_ACCESS_ENABLE;  //IWDG_ENABLE_WRITE_ACCESS();
    IWdg->PR=Prescaler;
    IWdg->RLR=Reload;

    Tick=HAL_GetTick();
    while (IWdg->SR!=0)
        {
        if (HAL_GetTick()-Tick>HAL_IWDG_DEFAULT_TIMEOUT) goto ProcExit;
        }

    if (IWdg->WINR!=Window) IWdg->WINR=Window;
    else IWDG_Refresh();        //__HAL_IWDG_RELOAD_COUNTER();
    Rslt++;

    ProcExit:
    return Rslt;
    }



VOID WINAPI SystemReset(LPCSTR BootReason)
    {
    Printf(BootReason);
    Printf("SENSOR: Shutdown..."CRLF);
    UART_WaitAllSendIT(DebugPort, 10);  //ڿ  ð

    IWDG_Init(IWDG_PRESCALER_32, 10, 0);
    //HAL_NVIC_SystemReset();
    }




///////////////////////////////////////////////////////////////////////////////
//                              LPTIM
///////////////////////////////////////////////////////////////////////////////
#define TIMEOUT         1000

VOID WINAPI LPTIM1_PWM_Stop(LPTIM_HandleTypeDef *hLPTim)
    {
    UINT Time, ClkSrc, IER, CFGR, CMP, ARR;
    LPTIM_TypeDef *LPTIMB;

    JOS_ENTER_CRITICAL();

    ClkSrc=__HAL_RCC_GET_LPTIM1_SOURCE();

    LPTIMB=hLPTim->Instance;
    IER=LPTIMB->IER;
    CFGR=LPTIMB->CFGR;
    CMP=LPTIMB->CMP;
    ARR=LPTIMB->ARR;

    __HAL_RCC_LPTIM1_FORCE_RESET();
    __HAL_RCC_LPTIM1_RELEASE_RESET();

    if (CMP!=0 || ARR!=0)
        {
        __HAL_RCC_LPTIM1_CONFIG(0);

        if (CMP!=0)
            {
            LPTIMB->CR|=LPTIM_CR_ENABLE;
            LPTIMB->CMP=CMP;
            Time=HAL_GetTick();
            while ((LPTIMB->ISR & LPTIM_FLAG_CMPOK)==0)
                {
                if (HAL_GetTick()-Time>=TIMEOUT) break;
                }
            LPTIMB->ICR=LPTIM_FLAG_CMPOK;
            }

        if (ARR!=0)
            {
            LPTIMB->CR|=LPTIM_CR_ENABLE;
            LPTIMB->ARR=ARR;
            Time=HAL_GetTick();
            while ((LPTIMB->ISR & LPTIM_FLAG_ARROK)==0)
                {
                if (HAL_GetTick()-Time>=TIMEOUT) break;
                }
            LPTIMB->ICR=LPTIM_FLAG_ARROK;
            }

        __HAL_RCC_LPTIM1_CONFIG(ClkSrc);
        }

    LPTIMB->CR&=~LPTIM_CR_ENABLE;
    LPTIMB->IER=IER;
    LPTIMB->CFGR=CFGR;
    JOS_EXIT_CRITICAL();
    }



//Period 65535
VOID WINAPI LPTIM_PWM_Start(LPTIM_HandleTypeDef *hLPTim, UINT Period, UINT Pulse)
    {
    hLPTim->Instance->CFGR&=~LPTIM_CFGR_WAVE;
    __HAL_LPTIM_ENABLE(hLPTim);
    __HAL_LPTIM_AUTORELOAD_SET(hLPTim, Period);
    __HAL_LPTIM_COMPARE_SET(hLPTim, Pulse);
    __HAL_LPTIM_START_CONTINUOUS(hLPTim);
    }





VOID WINAPI LPTIM_Init(LPTIM_HandleTypeDef*hLPTim)
    {
    UINT CFGR;

    CFGR=hLPTim->Instance->CFGR;

    if (hLPTim->Init.Clock.Source==LPTIM_CLOCKSOURCE_ULPTIM || hLPTim->Init.CounterSource==LPTIM_COUNTERSOURCE_EXTERNAL)
        {
        CFGR&=~(LPTIM_CFGR_CKPOL|LPTIM_CFGR_CKFLT);
        }
    if (hLPTim->Init.Trigger.Source!=LPTIM_TRIGSOURCE_SOFTWARE)
        {
        CFGR&=~(LPTIM_CFGR_TRGFLT|LPTIM_CFGR_TRIGSEL);
        }

    CFGR&=~(LPTIM_CFGR_CKSEL|LPTIM_CFGR_CKPOL|LPTIM_CFGR_TRIGEN|LPTIM_CFGR_PRELOAD|
                LPTIM_CFGR_WAVPOL|LPTIM_CFGR_PRESC|LPTIM_CFGR_COUNTMODE);

    CFGR|=hLPTim->Init.Clock.Source|
        hLPTim->Init.Clock.Prescaler|
        hLPTim->Init.OutputPolarity|
        hLPTim->Init.UpdateMode|
        hLPTim->Init.CounterSource;

    if (hLPTim->Init.Clock.Source==LPTIM_CLOCKSOURCE_ULPTIM || hLPTim->Init.CounterSource==LPTIM_COUNTERSOURCE_EXTERNAL)
        {
        CFGR|=hLPTim->Init.UltraLowPowerClock.Polarity|hLPTim->Init.UltraLowPowerClock.SampleTime;
        }

    if (hLPTim->Init.Trigger.Source!=LPTIM_TRIGSOURCE_SOFTWARE)
        {
        CFGR|=hLPTim->Init.Trigger.Source|
            hLPTim->Init.Trigger.ActiveEdge|
            hLPTim->Init.Trigger.SampleTime;
        }
    hLPTim->Instance->CFGR=CFGR;
    }




#ifdef HAL_I2C_MODULE_ENABLED
///////////////////////////////////////////////////////////////////////////////
//                              I2C
///////////////////////////////////////////////////////////////////////////////


static I2C_HandleTypeDef I2cHandle1;
#ifdef PO_I2C2SCL
static I2C_HandleTypeDef I2cHandle2;
#endif
static JOS_EVENT* I2C_Sem;


#define TIMING_CLEAR_MASK       0xF0FFFFFF      //I2C TIMING clear register Mask
#define I2C_TIMEOUT_STOPF       25
#define I2C_TIMEOUT_BUSY        25
#define MAX_NBYTE_SIZE          255


LOCAL(I2C_TypeDef*) GetI2cCtrlAddr(int I2C_Ch)
    {
    I2C_TypeDef *I2CA=NULL;

    if (I2C_Ch==IIC1) I2CA=I2cHandle1.Instance;
    #ifdef PO_I2C2SCL
    else              I2CA=I2cHandle2.Instance;
    #endif
    return I2CA;
    }



//-----------------------------------------------------------------------------
//      I2C ʱȭ (HAL_I2C_Init(), HAL_I2C_MspInit())
//-----------------------------------------------------------------------------
VOID WINAPI InitI2C(int I2C_Ch, DWORD Timing)
    {
    I2C_TypeDef *I2CA;
    I2C_HandleTypeDef*hI2C;
    RCC_PeriphCLKInitTypeDef PCKI={0};

    if (I2C_Ch==IIC1)
        {
        PCKI.PeriphClockSelection=RCC_PERIPHCLK_I2C1;
        PCKI.I2c1ClockSelection=RCC_I2C1CLKSOURCE_SYSCLK;
        HAL_RCCEx_PeriphCLKConfig(&PCKI);

        __HAL_RCC_I2C1_CLK_ENABLE();

        hI2C=&I2cHandle1;
        hI2C->Instance=I2CA=I2C1;
        }
    #ifdef PO_I2C2SCL
    else{
        PCKI.PeriphClockSelection=RCC_PERIPHCLK_I2C2;
        PCKI.I2c1ClockSelection=RCC_I2C2CLKSOURCE_SYSCLK;
        HAL_RCCEx_PeriphCLKConfig(&PCKI);

        __HAL_RCC_I2C2_CLK_ENABLE();

        hI2C=&I2cHandle2;
        hI2C->Instance=I2CA=I2C2;
        }
    #endif

    hI2C->Init.Timing=Timing;  //0x10A13E56=100kHz, 0x00B1112E=400kHz
    hI2C->Init.DualAddressMode=I2C_DUALADDRESS_DISABLE;
    hI2C->Init.OwnAddress1=0x00;
    hI2C->Init.OwnAddress2=0x00;
    hI2C->Init.AddressingMode=I2C_ADDRESSINGMODE_7BIT;
    hI2C->Init.GeneralCallMode=I2C_GENERALCALL_DISABLE;         //CR1
    hI2C->Init.NoStretchMode=I2C_NOSTRETCH_DISABLE;             //CR1

    I2CA->CR1&=~I2C_CR1_PE;  //__HAL_I2C_DISABLE(hI2c);

    I2CA->TIMINGR=hI2C->Init.Timing&TIMING_CLEAR_MASK;
    I2CA->OAR1&=~I2C_OAR1_OA1EN;
    if (hI2C->Init.AddressingMode==I2C_ADDRESSINGMODE_7BIT)
        I2CA->OAR1=I2C_OAR1_OA1EN|hI2C->Init.OwnAddress1;
    else
        I2CA->OAR1=I2C_OAR1_OA1EN|I2C_OAR1_OA1MODE|hI2C->Init.OwnAddress1;

    if (hI2C->Init.AddressingMode==I2C_ADDRESSINGMODE_10BIT) I2CA->CR2=I2C_CR2_ADD10;
    I2CA->CR2|=I2C_CR2_AUTOEND|I2C_CR2_NACK;
    I2CA->OAR2&=~I2C_DUALADDRESS_ENABLE;
    I2CA->OAR2=hI2C->Init.DualAddressMode|hI2C->Init.OwnAddress2|(hI2C->Init.OwnAddress2Masks<<8);
    I2CA->CR1=hI2C->Init.GeneralCallMode|hI2C->Init.NoStretchMode;

    I2CA->CR1&=~I2C_CR1_ANFOFF;         //HAL_I2CEx_ConfigAnalogFilter(&I2cHandle, I2C_ANALOGFILTER_ENABLE);

    I2CA->CR1|=I2C_CR1_PE;  //__HAL_I2C_ENABLE(hI2c);

    if (I2C_Sem==NULL) I2C_Sem=JOSSemCreate(1); // Լ ݺ ȣ
    }

BOOL WINAPI I2C_Lock(VOID) {return JOSSemPend(I2C_Sem, JOS_TICKS_PER_SEC*3)==JOS_ERR_NONE;}
VOID WINAPI I2C_Unlock(VOID) {JOSSemPost(I2C_Sem);}



LOCAL(VOID) I2C_SetCR2(I2C_TypeDef *I2CA, UINT DevAddr, UINT Size, UINT Mode, UINT Request)
    {
    MODIFYBIT(I2CA->CR2, I2C_CR2_SADD|I2C_CR2_NBYTES|I2C_CR2_RELOAD|I2C_CR2_AUTOEND|(I2C_CR2_RD_WRN&(Request>>(31-I2C_CR2_RD_WRN_Pos)))|I2C_CR2_START|I2C_CR2_STOP,
        (DevAddr&I2C_CR2_SADD) | ((Size<<I2C_CR2_NBYTES_Pos)&I2C_CR2_NBYTES) | Mode|Request);
    }


LOCAL(UINT) I2C_TransferConfig(I2C_TypeDef *I2CA, UINT DevAddr, UINT Size, UINT Request)
    {
    UINT Mode=I2C_AUTOEND_MODE;

    if (Size>MAX_NBYTE_SIZE)
        {
        Size=MAX_NBYTE_SIZE;
        Mode=I2C_RELOAD_MODE;
        }
    I2C_SetCR2(I2CA, DevAddr, Size, Mode, Request);
    return Size;
    }



LOCAL(HAL_StatusTypeDef) I2C_IsAcknowledgeFailed(I2C_TypeDef *I2CA, UINT Timeout, UINT TickStart)
    {
    HAL_StatusTypeDef Rslt=HAL_OK;

    if (I2CA->ISR & I2C_ISR_NACKF)      //__HAL_I2C_GET_FLAG(hI2c, I2C_FLAG_AF), NACK received flag
        {
        Rslt=HAL_ERROR;
        while ((I2CA->ISR & I2C_ISR_STOPF)==0) //__HAL_I2C_GET_FLAG(hI2c, I2C_FLAG_STOPF)
            {
            if (HAL_GetTick()-TickStart>Timeout) break;
            }

        I2CA->ICR=I2C_ISR_NACKF;        //__HAL_I2C_CLEAR_FLAG(hi2c, I2C_FLAG_AF);
        //I2CA->ICR=I2C_ISR_STOPF;      //__HAL_I2C_CLEAR_FLAG(hi2c, I2C_FLAG_STOPF); =>ηƾ   ó

        //I2C_Flush_TXDR(hi2c);
        if (I2CA->ISR & I2C_ISR_TXIS) I2CA->TXDR=0;
        I2CA->ISR|=I2C_ISR_TXE;
        }
    return Rslt;
    }




//̸: I2C_WaitOnFlagUntilTimeout
LOCAL(HAL_StatusTypeDef) I2C_WaitOnFlag(I2C_TypeDef *I2CA, UINT Flag, BOOL OnOff, UINT Timeout, UINT TickStart)
    {
    HAL_StatusTypeDef Rslt=HAL_OK;

    for (;;)
        {
        if (OnOff)
            {
            if ((I2CA->ISR & Flag)==0) break;
            }
        else{
            if (I2CA->ISR & Flag) break;
            }
        if (GetTickCount()-TickStart>=Timeout) {Rslt=HAL_ERROR; break;}
        }
    return Rslt;
    }



//̸: I2C_WaitOnSTOPFlagUntilTimeout
LOCAL(HAL_StatusTypeDef) I2C_WaitOnSTOPFlag(I2C_TypeDef *I2CA, UINT Timeout, UINT TickStart)
    {
    HAL_StatusTypeDef Rslt=HAL_OK;

    while ((I2CA->ISR & I2C_ISR_STOPF)==0)
        {
        if ((Rslt=I2C_IsAcknowledgeFailed(I2CA, Timeout, TickStart))!=HAL_OK) break;
        if (GetTickCount()-TickStart>=Timeout) {Rslt=HAL_TIMEOUT; break;}
        }
    return Rslt;
    }




//̸: I2C_WaitOnTXISFlagUntilTimeout
LOCAL(HAL_StatusTypeDef) I2C_WaitOnTXISFlag(I2C_TypeDef *I2CA, UINT Timeout, UINT TickStart)
    {
    HAL_StatusTypeDef Rslt=HAL_OK;

    while ((I2CA->ISR & I2C_FLAG_TXIS)==0)
        {
        if ((Rslt=I2C_IsAcknowledgeFailed(I2CA, Timeout, TickStart))!=HAL_OK) break;
        if (GetTickCount()-TickStart>=Timeout) {Rslt=HAL_TIMEOUT; break;}
        }
    return Rslt;
    }




LOCAL(VOID) I2C_Stop(I2C_TypeDef *I2CA)
    {
    I2CA->ICR=I2C_ISR_STOPF;
    I2CA->CR2 &= ~(I2C_CR2_SADD|I2C_CR2_HEAD10R|I2C_CR2_NBYTES|I2C_CR2_RELOAD|I2C_CR2_RD_WRN);  //I2C_RESET_CR2(hI2C);
    }



//-----------------------------------------------------------------------------
//      HAL_I2C_Master_Transmit(), Size 255 ϸ 
//-----------------------------------------------------------------------------
BOOL WINAPI I2C_MasterTx(int I2C_Ch, int DevAddr, LPCBYTE lpData, int Size, int Timeout)
    {
    BOOL Rslt=FALSE;
    UINT TickStart;
    I2C_TypeDef *I2CA;

    I2CA=GetI2cCtrlAddr(I2C_Ch);
    TickStart=HAL_GetTick();
    if (I2C_WaitOnFlag(I2CA, I2C_FLAG_BUSY, SET, I2C_TIMEOUT_BUSY, TickStart)!=HAL_OK) goto Ret;
    I2C_TransferConfig(I2CA, DevAddr, Size, I2C_GENERATE_START_WRITE);

    while (Size--)
        {
        if (I2C_WaitOnTXISFlag(I2CA, Timeout, TickStart)!=HAL_OK) goto ProcExit;
        I2CA->TXDR=*lpData++;
        }

    Rslt=I2C_WaitOnSTOPFlag(I2CA, Timeout, TickStart)==HAL_OK;

    ProcExit:
    I2C_Stop(I2CA);
    Ret:
    return Rslt;
    }



//-----------------------------------------------------------------------------
//      HAL_I2C_Master_Receive(), Size 255 ϸ 
//-----------------------------------------------------------------------------
BOOL WINAPI I2C_MasterRx(int I2C_Ch, int DevAddr, LPBYTE lpData, int Size, int Timeout)
    {
    BOOL Rslt=FALSE;
    UINT TickStart;
    I2C_TypeDef *I2CA;

    I2CA=GetI2cCtrlAddr(I2C_Ch);
    TickStart=HAL_GetTick();
    if (I2C_WaitOnFlag(I2CA, I2C_FLAG_BUSY, SET, I2C_TIMEOUT_BUSY, TickStart)!=HAL_OK) goto Ret;
    I2C_TransferConfig(I2CA, DevAddr, Size, I2C_GENERATE_START_READ);

    while (Size--)
        {
        //I2C_WaitOnRXNEFlagUntilTimeout()
        while ((I2CA->ISR & I2C_ISR_RXNE)==0)
            {
            if (I2C_IsAcknowledgeFailed(I2CA, Timeout, TickStart)!=HAL_OK) goto ProcExit;
            if (I2CA->ISR & I2C_ISR_STOPF) goto Stoped;
            if (HAL_GetTick()-TickStart>=Timeout)goto ProcExit;
            }
        *lpData++=(BYTE)I2CA->RXDR;
        }

    Stoped:
    Rslt=I2C_WaitOnSTOPFlag(I2CA, Timeout, TickStart)==HAL_OK;

    ProcExit:
    I2C_Stop(I2CA);
    Ret:
    return Rslt;
    }




LOCAL(BOOL) I2C_SetMemAddr(I2C_TypeDef *I2CA, UINT MemAddr, UINT MemAddSize, UINT Timeout, UINT TickStart)
    {
    BOOL Rslt=FALSE;

    if (I2C_WaitOnTXISFlag(I2CA, Timeout, TickStart)!=HAL_OK) goto ProcExit;
    if (MemAddSize!=I2C_MEMADD_SIZE_8BIT)
        {
        I2CA->TXDR=MemAddr>>8;
        if (I2C_WaitOnTXISFlag(I2CA, Timeout, TickStart)!=HAL_OK) goto ProcExit;
        }
    I2CA->TXDR=MemAddr&0xFF;
    Rslt++;

    ProcExit:
    return Rslt;
    }



//-----------------------------------------------------------------------------
//      MemAddSize : I2C_MEMADD_SIZE_8BIT / I2C_MEMADD_SIZE_16BIT
//      ̸ HAL_I2C_Mem_Read()
//-----------------------------------------------------------------------------
BOOL WINAPI I2C_MemRead(int I2C_Ch, UINT DevAddr, UINT MemAddr, UINT MemAddSize, LPBYTE lpData, UINT Size, UINT Timeout)
    {
    int Rslt=FALSE, BlockSize;
    DWORD TickStart;
    I2C_TypeDef *I2CA;

    TickStart=HAL_GetTick();
    I2CA=GetI2cCtrlAddr(I2C_Ch);

    if (I2C_WaitOnFlag(I2CA, I2C_FLAG_BUSY, SET, I2C_TIMEOUT_BUSY, TickStart)!=HAL_OK) goto ProcExit;

    //if (I2C_RequestMemoryRead(hi2c, DevAddr, MemAddress, MemAddSize, Timeout, TickStart)!=HAL_OK) goto ProcExit;
    I2C_SetCR2(I2CA, DevAddr, MemAddSize, I2C_SOFTEND_MODE, I2C_GENERATE_START_WRITE);
    if (I2C_SetMemAddr(I2CA, MemAddr, MemAddSize, Timeout, TickStart)==FALSE) goto ProcExit;
    if (I2C_WaitOnFlag(I2CA, I2C_FLAG_TC, 0, Timeout, TickStart)!=HAL_OK) goto ProcExit;

    BlockSize=I2C_TransferConfig(I2CA, DevAddr, Size, I2C_GENERATE_START_READ);
    Size-=BlockSize;
    for (;;)
        {
        if (I2C_WaitOnFlag(I2CA, I2C_FLAG_RXNE, 0, Timeout, TickStart)!=HAL_OK) goto ProcExit;

        *lpData++=I2CA->RXDR;
        if (--BlockSize==0)
            {
            if (Size==0) break;
            if (I2C_WaitOnFlag(I2CA, I2C_FLAG_TCR, 0, Timeout, TickStart)!=HAL_OK) goto ProcExit;
            BlockSize=I2C_TransferConfig(I2CA, DevAddr, Size, I2C_NO_STARTSTOP);
            Size-=BlockSize;
            }
        }
    Rslt=I2C_WaitOnSTOPFlag(I2CA, Timeout, TickStart)==HAL_OK;

    ProcExit:
    I2C_Stop(I2CA);
    return Rslt;
    }




//-----------------------------------------------------------------------------
//      ̸: HAL_I2C_Mem_Write
//-----------------------------------------------------------------------------
BOOL WINAPI I2C_MemWrite(int I2C_Ch, UINT DevAddr, UINT MemAddr, UINT MemAddSize, LPCBYTE lpData, UINT Size, UINT Timeout)
    {
    int Rslt=FALSE, BlockSize;
    DWORD TickStart;
    I2C_TypeDef *I2CA;

    TickStart=HAL_GetTick();
    I2CA=GetI2cCtrlAddr(I2C_Ch);
    if (I2C_WaitOnFlag(I2CA, I2C_FLAG_BUSY, SET, I2C_TIMEOUT_BUSY, TickStart)!=HAL_OK) goto ProcExit;

    //if (I2C_RequestMemoryWrite(I2CA, DevAddr, MemAddr, MemAddSize, Timeout, TickStart)!=HAL_OK) goto ProcExit;
    I2C_SetCR2(I2CA, DevAddr, MemAddSize, I2C_RELOAD_MODE, I2C_GENERATE_START_WRITE);
    if (I2C_SetMemAddr(I2CA, MemAddr, MemAddSize, Timeout, TickStart)==FALSE) goto ProcExit;
    if (I2C_WaitOnFlag(I2CA, I2C_FLAG_TCR, 0, Timeout, TickStart)!=HAL_OK) goto ProcExit;

    BlockSize=I2C_TransferConfig(I2CA, DevAddr, Size, I2C_NO_STARTSTOP);
    Size-=BlockSize;
    for (;;)
        {
        if (I2C_WaitOnTXISFlag(I2CA, Timeout, TickStart)!=HAL_OK) goto ProcExit;
        I2CA->TXDR=*lpData++;
        if (--BlockSize==0)
            {
            if (Size==0) break;
            if (I2C_WaitOnFlag(I2CA, I2C_FLAG_TCR, 0, Timeout, TickStart)!=HAL_OK) goto ProcExit;
            BlockSize=I2C_TransferConfig(I2CA, DevAddr, Size, I2C_NO_STARTSTOP);
            Size-=BlockSize;
            }
        }

    Rslt=I2C_WaitOnSTOPFlag(I2CA, Timeout, TickStart)==HAL_OK;

    ProcExit:
    I2C_Stop(I2CA);
    return Rslt;
    }


#endif //HAL_I2C_MODULE_ENABLED





#ifdef HAL_SPI_MODULE_ENABLED
///////////////////////////////////////////////////////////////////////////////
//                              SPI
///////////////////////////////////////////////////////////////////////////////

static SPI_HandleTypeDef Spi1Handle;
static SPI_HandleTypeDef Spi2Handle;



//-----------------------------------------------------------------------------
//      8Bit SPI ۼ
//-----------------------------------------------------------------------------
BOOL WINAPI SPI_TransmitReceive8(int SPI_Ch, LPCBYTE TxData, int TxSize, LPBYTE RxData, int RxSize, int RecvSkip, UINT Timeout)
    {
    int Rslt=FALSE, TxAllowed=1, Data;
    DWORD TickStart;
    SPI_TypeDef *SPIB;
    SPI_HandleTypeDef *hSpi;

    if (SPI_Ch==SPI_CH1) hSpi=&Spi1Handle; else hSpi=&Spi2Handle;
    SPIB=hSpi->Instance;
    TickStart=HAL_GetTick();

    if ((SPIB->CR1 & SPI_CR1_SPE)==0) SPIB->CR1|=SPI_CR1_SPE;    //__HAL_SPI_ENABLE(hSpi);

    if (hSpi->Init.Mode==SPI_MODE_SLAVE || TxSize==1)
        {
        *((__IO BYTE*)&SPIB->DR)=*TxData++;
        TxAllowed=0;
        TxSize--;
        }

    while (TxSize>0 || RxSize>0)
        {
        if (TxAllowed!=0 && (SPIB->SR & SPI_SR_TXE)!=0)
            {
            Data=0;     //͸ ϱ  , ؾ Ŭ ߻
            if (TxSize>0) {Data=*TxData++; TxSize--;}
            *(__IO BYTE*)&SPIB->DR=Data;
            TxAllowed=0;
            }

        if (SPIB->SR & SPI_SR_RXNE)
            {
            Data=SPIB->DR;
            //if (RecvSkip>0) RecvSkip--;
            //else
            if (RxSize>0) {*RxData++=Data; RxSize--;}
            TxAllowed=1;
            }

        if (HAL_GetTick()-TickStart>=Timeout) goto ProcExit;
        }

    while (SPIB->SR & SPI_SR_BSY)
        {
        if (HAL_GetTick()-TickStart>=Timeout)
            {
            SPIB->CR2&=~(SPI_IT_TXE|SPI_IT_RXNE|SPI_IT_ERR);  //__HAL_SPI_DISABLE_IT(hSpi, );

            if (hSpi->Init.Mode==SPI_MODE_MASTER &&
                (hSpi->Init.Direction==SPI_DIRECTION_1LINE ||
                 hSpi->Init.Direction==SPI_DIRECTION_2LINES_RXONLY)) SPIB->CR1&=~SPI_CR1_SPE;    //__HAL_SPI_DISABLE(hSpi);

            goto ProcExit;
            }
        }

    if (hSpi->Init.Direction==SPI_DIRECTION_2LINES)
        {
        //__HAL_SPI_CLEAR_OVRFLAG(hSpi);
        Data=SPIB->DR;
        Data=SPIB->SR;
        (VOID)Data;
        }
    Rslt++;

    ProcExit:
    return Rslt;
    }



//-----------------------------------------------------------------------------
//      SPI ʱȭ
//
//      GPIO ɼ: GPIO_MODE_AF_PP, GPIO_AF?_SPI?, GPIO_PULLDOWN, GPIO_SPEED_FREQ_VERY_HIGH,
//-----------------------------------------------------------------------------
VOID WINAPI SPI_InitMaster(int SPI_Ch, int BaudPrescaler)
    {
    SPI_TypeDef *SPIB;
    SPI_HandleTypeDef *hSpi;

    if (SPI_Ch==SPI_CH1)
        {
        __HAL_RCC_SPI1_CLK_ENABLE();
        hSpi=&Spi1Handle;
        SPIB=SPI1;
        }
    else{
        __HAL_RCC_SPI2_CLK_ENABLE();
        hSpi=&Spi2Handle;
        SPIB=SPI2;
        }

    hSpi->Instance=SPIB;
    hSpi->Init.BaudRatePrescaler=BaudPrescaler;     //SPI_BAUDRATEPRESCALER_8:4MHz, _16:2MHz, _256(Clock:128KHz);
    hSpi->Init.Direction=SPI_DIRECTION_2LINES;
    hSpi->Init.CLKPhase=SPI_PHASE_1EDGE;
    hSpi->Init.CLKPolarity=SPI_POLARITY_LOW;
    hSpi->Init.DataSize=SPI_DATASIZE_8BIT;
    hSpi->Init.FirstBit=SPI_FIRSTBIT_MSB;
    hSpi->Init.TIMode=SPI_TIMODE_DISABLE;
    hSpi->Init.CRCCalculation=SPI_CRCCALCULATION_DISABLE;
    hSpi->Init.CRCPolynomial=7;
    hSpi->Init.NSS=SPI_NSS_SOFT;
    hSpi->Init.Mode=SPI_MODE_MASTER;

    __HAL_SPI_DISABLE(hSpi);
    SPIB->CR1=hSpi->Init.Mode|hSpi->Init.Direction|hSpi->Init.DataSize|
        hSpi->Init.CLKPolarity|hSpi->Init.CLKPhase|(hSpi->Init.NSS&SPI_CR1_SSM)|
        hSpi->Init.BaudRatePrescaler|hSpi->Init.FirstBit|hSpi->Init.CRCCalculation;

    SPIB->CR2=((hSpi->Init.NSS>>16)&SPI_CR2_SSOE)|hSpi->Init.TIMode;

    #if defined(SPI_I2SCFGR_I2SMOD)
    SPIB->I2SCFGR&=~SPI_I2SCFGR_I2SMOD;
    #endif
    }



#endif //HAL_SPI_MODULE_ENABLED



///////////////////////////////////////////////////////////////////////////////
//                              FLASH
///////////////////////////////////////////////////////////////////////////////


#ifdef HAL_FLASH_MODULE_ENABLED


#if 0
#define FLASH_FLAG_BSY             FLASH_SR_BSY              1   //FLASH Busy flag
#define FLASH_FLAG_EOP             FLASH_SR_EOP              2   //FLASH End of Programming flag
#define FLASH_FLAG_ENDHV           FLASH_SR_HVOFF            4   //FLASH End of High Voltage flag
#define FLASH_FLAG_READY           FLASH_SR_READY            8   //FLASH Ready flag after low power mode
#define HAL_FLASH_ERROR_FWWERR                            0x20
#define FLASH_FLAG_WRPERR          FLASH_SR_WRPERR       0x100   //FLASH Write protected error flag
#define FLASH_FLAG_PGAERR          FLASH_SR_PGAERR       0x200   //FLASH Programming Alignment error flag
#define FLASH_FLAG_SIZERR          FLASH_SR_SIZERR       0x400   //FLASH Size error flag
#define FLASH_FLAG_OPTVERR         FLASH_SR_OPTVERR      0x800   //FLASH Option Validity error flag
#define FLASH_FLAG_RDERR           FLASH_SR_RDERR       0x2000   //FLASH Read protected error flag
#define FLASH_FLAG_FWWERR          FLASH_SR_FWWERR     0x20000   //FLASH Write or Errase operation aborted
#define FLASH_FLAG_NOTZEROERR      FLASH_SR_NOTZEROERR 0x10000   //FLASH Read protected error flag
#endif



LOCAL(BOOL) FLASH_WaitForLastOp(UINT Timeout)
    {
    BOOL Rslt=FALSE;
    UINT SR, Time=HAL_GetTick();

    while (FLASH->SR & FLASH_FLAG_BSY)
        {
        if (HAL_GetTick()-Time>Timeout) goto ProcExit;
        }

    SR=FLASH->SR;
    if (SR & FLASH_FLAG_EOP) FLASH->SR=FLASH_FLAG_EOP;
    if (SR & (FLASH_FLAG_WRPERR|FLASH_FLAG_PGAERR|FLASH_FLAG_SIZERR|FLASH_FLAG_OPTVERR|FLASH_FLAG_RDERR|FLASH_FLAG_FWWERR|FLASH_FLAG_NOTZEROERR))
        {
        if (SR & FLASH_FLAG_FWWERR)
            {
            SR &= ~FLASH_FLAG_FWWERR;
            SR|=HAL_FLASH_ERROR_FWWERR;
            }
        FLASH->SR=SR;
        goto ProcExit;
        }

    Rslt++;

    ProcExit:
    return Rslt;
    }




BOOL WINAPI FLASH_ErasePage(UINT PageAddress, UINT PagesQty)  //HAL_FLASHEx_Erase()
    {
    UINT Addr, EndAddr;
    BOOL Rslt=FALSE;

    //Printf("PageAddress=%X"CRLF,PageAddress);
    if (FLASH_WaitForLastOp(FLASH_TIMEOUT_VALUE))
        {
        EndAddr=(PagesQty*FLASH_PAGE_SIZE)+PageAddress;
        for (Addr=PageAddress; Addr<EndAddr; Addr+=FLASH_PAGE_SIZE)
            {
            SET_BIT(FLASH->PECR, FLASH_PECR_ERASE);
            SET_BIT(FLASH->PECR, FLASH_PECR_PROG);
            *(__IO UINT*)(Addr&~(FLASH_PAGE_SIZE-1))=0;

            Rslt=FLASH_WaitForLastOp(FLASH_TIMEOUT_VALUE);

            CLEAR_BIT(FLASH->PECR, FLASH_PECR_PROG);
            CLEAR_BIT(FLASH->PECR, FLASH_PECR_ERASE);

            if (Rslt==FALSE) break;
            }
        }
    return Rslt;
    }



//-----------------------------------------------------------------------------
//      FLASH  (WriteBytes 4Ʈ ϰ)
//-----------------------------------------------------------------------------
BOOL WINAPI FLASH_Program(UINT StartAddr, CONST DWORD *WriteBuff, int WriteBytes)
    {
    BOOL Rslt=FALSE;
    UINT Addr, EndAddr;
    CONST DWORD *lpD;

    EndAddr=StartAddr+WriteBytes;
    lpD=WriteBuff;
    for (Addr=StartAddr; Addr<EndAddr; Addr+=4)
        {
        if ((Addr&(FLASH_PAGE_SIZE-1))==0) FLASH_ErasePage(Addr, 1);
        if (FLASH_WaitForLastOp(FLASH_TIMEOUT_VALUE)==FALSE) goto ProcExit;
        *(__IO DWORD*)Addr=*lpD++;
        if (FLASH_WaitForLastOp(FLASH_TIMEOUT_VALUE)==FALSE) goto ProcExit;
        }

    lpD=WriteBuff;
    for (Addr=StartAddr; Addr<EndAddr; Addr+=4)
        {
        if (*(__IO DWORD*)Addr!=*lpD)
            {
            Printf("Flash Verify Error, Addr=%X: Data=%08X, Read=%08X"CRLF, Addr, *(__IO WORD*)Addr, *lpD);
            goto ProcExit;
            }
        lpD++;
        }
    Rslt++;

    ProcExit:
    return Rslt;
    }



BOOL WINAPI FLASH_Unlock(VOID)
    {
    BOOL Rslt=FALSE;

    if (FLASH->PECR & FLASH_PECR_PELOCK)
        {
        JOS_ENTER_CRITICAL();
        FLASH->PEKEYR=FLASH_PEKEY1;
        FLASH->PEKEYR=FLASH_PEKEY2;
        JOS_EXIT_CRITICAL();

        if (FLASH->PECR & FLASH_PECR_PELOCK) goto ProcExit;
        }

    if (FLASH->PECR & FLASH_PECR_PRGLOCK)
        {
        JOS_ENTER_CRITICAL();
        FLASH->PRGKEYR=FLASH_PRGKEY1;
        FLASH->PRGKEYR=FLASH_PRGKEY2;
        JOS_EXIT_CRITICAL();

        if (FLASH->PECR & FLASH_PECR_PRGLOCK) goto ProcExit;
        }
    Rslt++;

    ProcExit:
    return Rslt;
    }



VOID WINAPI FLASH_Lock(VOID)
    {
    FLASH->PECR|=FLASH_PECR_PRGLOCK;
    FLASH->PECR|=FLASH_PECR_PELOCK;
    }




//-----------------------------------------------------------------------------
//      INI ͸   
//-----------------------------------------------------------------------------
BOOL WINAPI FLASH_WriteIniData(UINT StartAddr, LPCSTR WriteData, int WriteBytes)
    {
    BOOL Rslt;
    JOS_CRITICAL_VAR;

    JOS_ENTER_CRITICAL();
    FLASH_Unlock();
    Rslt=FLASH_Program(StartAddr, (CONST DWORD*)WriteData, WriteBytes);
    FLASH_Lock();
    JOS_EXIT_CRITICAL();
    return Rslt;
    }




//-----------------------------------------------------------------------------
//      FLASH ǵڿ   ũ⸦ Ҵ
//-----------------------------------------------------------------------------
LPVOID WINAPI AllocFlash(UINT Size)
    {
    UINT First;
    static UINT FlashBottom;

    if (FlashBottom==0) FlashBottom=FLASH_BASE+FLASH_SIZE;  //FLASH_SIZE L083  ƴ (0x1FF8007C 1KB ũⰡ  )
    First=FlashBottom;
    for (;;)
        {
        FlashBottom-=FLASH_PAGE_SIZE;
        if (First-FlashBottom>=Size) break;
        }
    return (LPVOID)FlashBottom;
    }



#endif //HAL_FLASH_MODULE_ENABLED




///////////////////////////////////////////////////////////////////////////////
//                      RTC
///////////////////////////////////////////////////////////////////////////////
#ifdef HAL_RTC_MODULE_ENABLED


#define RTC_WRITEPROTECTION_DISABLE(Inst) (Inst)->WPR=0xCA; (Inst)->WPR=0x53
#define RTC_WRITEPROTECTION_ENABLE(Inst)  (Inst)->WPR=0xFF

static RTC_HandleTypeDef RtcHandle;



LOCAL(BOOL) RTC__EnterInitMode(RTC_TypeDef *RTCB)
    {
    DWORD Time;

    if ((RTCB->ISR & RTC_ISR_INITF)==0)
        {
        RTCB->ISR=RTC_INIT_MASK;

        Time=HAL_GetTick();
        while ((RTCB->ISR & RTC_ISR_INITF)==0)
            {
            if (HAL_GetTick()-Time > RTC_TIMEOUT_VALUE) return FALSE;
            }
        }
    return TRUE;
    }




LOCAL(BOOL) RTC_WaitForSynchro(RTC_TypeDef *RTCB)
    {
    DWORD Time;

    RTCB->ISR&=RTC_RSF_MASK;

    Time=HAL_GetTick();
    while ((RTCB->ISR & RTC_ISR_RSF)==0)
        {
        if (HAL_GetTick()-Time>RTC_TIMEOUT_VALUE) return FALSE;
        }
    return TRUE;
    }




VOID WINAPI RTC_Calibration(VOID)
    {
    RTC_TypeDef *RTCB;
    DWORD SubSec, Meas_ms, StartTime, NewValue;

    if ((RTCB=RtcHandle.Instance)!=NULL)
        {
        StartTime=GetTickCount();
        SubSec=(WORD)RTC->SSR;
        HAL_Delay(100);
        while ((WORD)RTC->SSR!=SubSec);
        Meas_ms=GetTickCount()-StartTime;
        //Printf("Measure Time=%u"CRLF, Meas_ms);

        NewValue=(((WORD)RTC->PRER+1)*1000+(Meas_ms>>1))/Meas_ms;

        RTC_WRITEPROTECTION_DISABLE(RTCB);
        if (RTC__EnterInitMode(RTCB)!=FALSE)
            {
            RTC->PRER=(RTC->PRER & 0xFFFF0000) | ((NewValue-1) & 0xFFFF);

            RTCB->CR&=~RTC_CR_BKP;
            RTCB->ISR&=~RTC_ISR_INIT;
            if ((RTCB->CR & RTC_CR_BYPSHAD)==0) RTC_WaitForSynchro(RTCB);
            }
        RTC_WRITEPROTECTION_ENABLE(RTCB);
        }
    }




LOCAL(BOOL) RTC_Init(RTC_HandleTypeDef *hRtc)
    {
    BOOL Rslt=FALSE;
    RTC_TypeDef *RTCB;

    RTCB=hRtc->Instance;
    RTC_WRITEPROTECTION_DISABLE(RTCB);
    if (RTC__EnterInitMode(RTCB)==FALSE) goto ProcExit;

    RTCB->CR&=~(RTC_CR_FMT|RTC_CR_OSEL|RTC_CR_POL);
    RTCB->CR|=hRtc->Init.HourFormat|hRtc->Init.OutPut|hRtc->Init.OutPutPolarity;
    RTCB->PRER=(1<<16)|16384;
    RTCB->ISR&=~RTC_ISR_INIT;
    RTCB->OR&=~(RTC_OR_ALARMOUTTYPE|RTC_OR_OUT_RMP);
    RTCB->OR|=hRtc->Init.OutPutType|hRtc->Init.OutPutRemap;

    if ((RTCB->CR & RTC_CR_BYPSHAD)==0)
        {
        if (RTC_WaitForSynchro(RTCB)==FALSE) goto ProcExit;
        }
    Rslt=TRUE;

    ProcExit:
    RTC_WRITEPROTECTION_ENABLE(RTCB);
    return Rslt;
    }



#define RTC_SYNCH_PREDIV_I      283     //0~0x7FFF, 283:1ð 5ʴ, 282:1ð 9 
#define RTC_SYNCH_PREDIV_E      255
VOID WINAPI InitRTC(int ClkSrc)
    {
    RCC_OscInitTypeDef       OSCI={0};
    RCC_PeriphCLKInitTypeDef PCKI={0};

    __HAL_RCC_PWR_CLK_ENABLE();
    SET_BIT(PWR->CR, PWR_CR_DBP);       //HAL_PWR_EnableBkUpAccess();

    if (ClkSrc==RTCCLKSRC_INTERNAL)
        {   //RC
        OSCI.OscillatorType=RCC_OSCILLATORTYPE_LSI;
        OSCI.PLL.PLLState=RCC_PLL_NONE;
        OSCI.LSIState=RCC_LSI_ON;
        //OSCI.LSEState=RCC_LSE_OFF;
        HAL_RCC_OscConfig(&OSCI);

        PCKI.PeriphClockSelection=RCC_PERIPHCLK_RTC;
        PCKI.RTCClockSelection=RCC_RTCCLKSOURCE_LSI;
        HAL_RCCEx_PeriphCLKConfig(&PCKI);
        }
    else{   //ܺ32768
        OSCI.OscillatorType=RCC_OSCILLATORTYPE_LSE;
        OSCI.PLL.PLLState=RCC_PLL_NONE;
        OSCI.LSEState=RCC_LSE_ON;
        //OSCI.LSIState=RCC_LSI_OFF;
        HAL_RCC_OscConfig(&OSCI);

        PCKI.PeriphClockSelection=RCC_PERIPHCLK_RTC;
        PCKI.RTCClockSelection=RCC_RTCCLKSOURCE_LSE;
        HAL_RCCEx_PeriphCLKConfig(&PCKI);
        }

    __HAL_RCC_RTC_ENABLE();

    NVIC_SetPriority(RTC_IRQn, 0);
    NVIC_EnableIRQ(RTC_IRQn);

    RtcHandle.Instance=RTC;
    RtcHandle.Init.HourFormat=RTC_HOURFORMAT_24;
    RtcHandle.Init.OutPut=RTC_OUTPUT_DISABLE;
    RtcHandle.Init.OutPutPolarity=RTC_OUTPUT_POLARITY_HIGH;
    RtcHandle.Init.OutPutType=RTC_OUTPUT_TYPE_OPENDRAIN;
    RTC_Init(&RtcHandle);
    }




//-----------------------------------------------------------------------------
//      ܺ RTC ݹ鼳
//-----------------------------------------------------------------------------
static GETTIMEFT ExtRTC_GetTime;
static SETTIMEFT ExtRTC_SetTime;
VOID WINAPI SetExtRtcFP(GETTIMEFT GetTimeFP, SETTIMEFT SetTimeFP)
    {
    ExtRTC_GetTime=GetTimeFP;
    ExtRTC_SetTime=SetTimeFP;
    }



//-----------------------------------------------------------------------------
//      RTC ð 
//-----------------------------------------------------------------------------
static SYSTEMTIME TempST;
#ifdef CORRECT_RTC
LOCAL(VOID) GetLocalTime_(SYSTEMTIME *ST)
#else
VOID WINAPI GetLocalTime(SYSTEMTIME *ST)
#endif
    {
    UINT DR, TR;
    RTC_TypeDef *RTCB;

    if (ExtRTC_GetTime) ExtRTC_GetTime(ST);
    else{
        if ((RTCB=RtcHandle.Instance)!=NULL)
            {
            TR=RTCB->TR;
            ST->wHour=Bcd2Bin((TR&(RTC_TR_HT|RTC_TR_HU))>>16);
            ST->wMinute=Bcd2Bin((TR&(RTC_TR_MNT|RTC_TR_MNU))>>8);
            ST->wSecond=Bcd2Bin(TR&(RTC_TR_ST|RTC_TR_SU));
            //ST->wTimeFormat=(TR&(RTC_TR_PM))>>16;
            //ST->wMilliseconds=RTCB->SSR;  //255->0 Downcounter 

            DR=RTCB->DR;
            ST->wYear=Bcd2Bin((DR&(RTC_DR_YT|RTC_DR_YU))>>16)+2000;
            ST->wMonth=Bcd2Bin((DR&(RTC_DR_MT|RTC_DR_MU))>>8);
            ST->wDay=Bcd2Bin(DR&(RTC_DR_DT|RTC_DR_DU));
            ST->wDayOfWeek=(DR & RTC_DR_WDU)>>13;
            }
        else *ST=TempST;
        }
    }


#ifdef CORRECT_RTC
#include "CorrectRtc.c"
#endif



//-----------------------------------------------------------------------------
//       ð 2000/1/1  ؼ ʷ 
//-----------------------------------------------------------------------------
JTIME WINAPI GetTodayToSecond(VOID)
    {
    SYSTEMTIME ST;
    GetLocalTime(&ST);
    return PackTotalSecond(&ST);
    }



//-----------------------------------------------------------------------------
//      RTC ð 
//-----------------------------------------------------------------------------
BOOL WINAPI SetLocalTime(CONST SYSTEMTIME *ST)
    {
    int Rslt=FALSE, Week;
    RTC_TypeDef *RTCB;

    if (ExtRTC_SetTime) Rslt=ExtRTC_SetTime(ST);
    else{
        if ((RTCB=RtcHandle.Instance)!=NULL)
            {
            RTC_WRITEPROTECTION_DISABLE(RTCB);
            if (RTC__EnterInitMode(RTCB)==FALSE) goto ProtEn;

            if ((Week=GetWeek(ST->wYear, ST->wMonth, ST->wDay))==0) Week=7; //
            RTCB->DR=(Bin2Bcd(ST->wYear-2000)<<16)|(Bin2Bcd(ST->wMonth)<<8)|Bin2Bcd(ST->wDay)|(Week<<13);
            RTCB->TR=(Bin2Bcd(ST->wHour)<<16)|(Bin2Bcd(ST->wMinute)<<8)|Bin2Bcd(ST->wSecond);

            RTCB->CR&=~RTC_CR_BKP;
            //RTCB->CR|=ST->DayLightSaving|ST->StoreOperation;
            RTCB->ISR&=~RTC_ISR_INIT;
            if ((RTCB->CR & RTC_CR_BYPSHAD)==0)
                {
                if (RTC_WaitForSynchro(RTCB)==FALSE) goto ProtEn;
                }
            Rslt++;

            ProtEn:
            RTC_WRITEPROTECTION_ENABLE(RTCB);
            }
        else TempST=*ST;
        }
    return Rslt;
    }



//-----------------------------------------------------------------------------
//      __HAL_RTC_ALARM_CLEAR_FLAG()
//-----------------------------------------------------------------------------
LOCAL(VOID) RTC_AlarmClearFlag(RTC_TypeDef *RTCB, UINT Flag)
    {
    RTCB->ISR = ~(Flag|RTC_ISR_INIT) | (RTCB->ISR & RTC_ISR_INIT);
    }



//-----------------------------------------------------------------------------
//  RTC_FORMAT_BIN , 24ð 
//-----------------------------------------------------------------------------
LOCAL(BOOL) RTC_SetAlarm_IT(RTC_TypeDef *RTCB, RTC_AlarmTypeDef *AT)
    {
    BOOL Rslt=FALSE;
    UINT Time, AR, SSR;

    AR=(Bin2Bcd(AT->AlarmTime.Hours)<<16)|
       (Bin2Bcd(AT->AlarmTime.Minutes)<<8)|
       (Bin2Bcd(AT->AlarmTime.Seconds))|
       ((AT->AlarmTime.TimeFormat)<<16)|
       (Bin2Bcd(AT->AlarmDateWeekDay)<<24)|
       AT->AlarmDateWeekDaySel|AT->AlarmMask;

    SSR=AT->AlarmTime.SubSeconds|AT->AlarmSubSecondMask;

    RTC_WRITEPROTECTION_DISABLE(RTCB);

    if (AT->Alarm==RTC_ALARM_A)
        {
        RTCB->CR&=~RTC_CR_ALRAE;
        RTC_AlarmClearFlag(RTCB, RTC_FLAG_ALRAF);

        Time=HAL_GetTick();
        while ((RTCB->ISR & RTC_FLAG_ALRAWF)==0)
            {
            if ((HAL_GetTick()-Time)>RTC_TIMEOUT_VALUE) goto ProcExit;
            }

        RTCB->ALRMAR=AR;
        RTCB->ALRMASSR=SSR;
        RTCB->CR|=RTC_CR_ALRAE|RTC_IT_ALRA;
        }
    else{   //RTC_ALARM_B
        RTCB->CR&=~RTC_CR_ALRBE;
        RTC_AlarmClearFlag(RTCB, RTC_FLAG_ALRBF);

        Time=HAL_GetTick();
        while ((RTCB->ISR & RTC_FLAG_ALRBWF)==0)
            {
            if ((HAL_GetTick()-Time)>RTC_TIMEOUT_VALUE) goto ProcExit;
            }

        RTCB->ALRMBR=AR;
        RTCB->ALRMBSSR=SSR;
        RTCB->CR|=RTC_CR_ALRBE|RTC_IT_ALRB;
        }

    __HAL_RTC_ALARM_EXTI_ENABLE_IT();
    __HAL_RTC_ALARM_EXTI_ENABLE_RISING_EDGE();
    Rslt++;

    ProcExit:
    RTC_WRITEPROTECTION_ENABLE(RTCB);
    return Rslt;
    }



//-----------------------------------------------------------------------------
//      ˶ (AlarmAB: RTC_ALARM_A/RTC_ALARM_B)
//-----------------------------------------------------------------------------
VOID WINAPI RTC_SetAlarmTime(SYSTEMTIME *ST, BOOL EnableIT, int AlarmAB)
    {
    RTC_AlarmTypeDef AT;

    ZeroMem(&AT, sizeof(AT));

    if (ST->wDay==0)            AT.AlarmMask|=RTC_ALARMMASK_DATEWEEKDAY;
    if (ST->wHour==(WORD)-1)    AT.AlarmMask|=RTC_ALARMMASK_HOURS;
    if (ST->wMinute==(WORD)-1)  AT.AlarmMask|=RTC_ALARMMASK_MINUTES;
    if (ST->wSecond==(WORD)-1)  AT.AlarmMask|=RTC_ALARMMASK_SECONDS;

    AT.Alarm=AlarmAB;
    AT.AlarmDateWeekDay=ST->wDay;                           //ΰ 1:,2:ȭ...:7
    AT.AlarmDateWeekDaySel=RTC_ALARMDATEWEEKDAYSEL_DATE;    //RTC_ALARMDATEWEEKDAYSEL_WEEKDAY
    AT.AlarmSubSecondMask=RTC_ALARMSUBSECONDMASK_NONE;      //RTC_ALARMSUBSECONDMASK_SS14_1~RTC_ALARMSUBSECONDMASK_SS14_13
    AT.AlarmTime.TimeFormat=0;                              //24ð  0
    AT.AlarmTime.Hours=ST->wHour;
    AT.AlarmTime.Minutes=ST->wMinute;
    AT.AlarmTime.Seconds=ST->wSecond;
    AT.AlarmTime.SubSeconds=0;
    if (RTC_SetAlarm_IT(RtcHandle.Instance, &AT))
        {
        if (EnableIT)           //Alarm Wakeup   Interrupt ʿġ 
            {
            NVIC_SetPriority(RTC_IRQn, 0);
            NVIC_EnableIRQ(RTC_IRQn);
            }
        }
    else Printf("RTC: Set Alarm Error"CRLF);
    }




//-----------------------------------------------------------------------------
//       ð  ־ Ⱓ()Ŀ  ˶ 
//-----------------------------------------------------------------------------
VOID WINAPI RTC_SetAlarmAfterSecond(int AfterSec, BOOL EnableIT, int AlarmAB)
    {
    //CHAR Buff[40];
    SYSTEMTIME ST;

    GetLocalTime(&ST);
    //Printf("Currect Time: %s"CRLF, MakeYMDHMS(Buff, &ST));
    UnpackTotalSecond(&ST, PackTotalSecond(&ST)+AfterSec);
    //Printf("Wakeup  Time: %s"CRLF, MakeYMDHMS(Buff, &ST));
    RTC_SetAlarmTime(&ST, EnableIT, AlarmAB);
    }




//-----------------------------------------------------------------------------
//      RTC IRQ ڵ鷯, Wakeup ؼ ʿġ 
//
//      RTC_ISR_INIT=0x80, RTC_ISR_ALRAF=0x100, RTC_ISR_ALRBF=0x200, RTC_ISR_WUTF=0x400
//-----------------------------------------------------------------------------
VOID RTC_IRQHandler(VOID)
    {
    RTC_TypeDef *RTCB;

    JOSIntEnterII();
    RTCB=RtcHandle.Instance;
    //HAL_RTCEx_WakeUpTimerIRQHandler(&RtcHandle);

    //HAL_RTC_AlarmIRQHandler(&RtcHandle);
    if (RTCB->ISR & RTC_FLAG_ALRAF) //__HAL_RTC_ALARM_GET_FLAG
        {
        //UART_TxStr(DebugPort, "RTC_AlarmAEventInt"CRLF);
        RTC_WakeupCB(RTCWKUP_ALARM_A);
        RTC_AlarmClearFlag(RTCB, RTC_FLAG_ALRAF);
        }

    if (RTCB->ISR & RTC_FLAG_ALRBF)
        {
        //UART_TxStr(DebugPort, "RTC_AlarmBEventInt"CRLF);
        RTC_WakeupCB(RTCWKUP_ALARM_B);
        RTC_AlarmClearFlag(RTCB, RTC_FLAG_ALRBF);
        }

    __HAL_RTC_ALARM_EXTI_CLEAR_FLAG();


    if (RTCB->ISR & RTC_FLAG_WUTF)
        {
        __HAL_PWR_CLEAR_FLAG(PWR_FLAG_WU);  //Clear the PWR pending flags: Wake Up

        //UART_TxStr(DebugPort, "RTC_WakeUpTimerInt"CRLF);      //̰ ϸ ٽ Ƴ 
        RTC_WakeupCB(RTCWKUP_TIMER);
        RTC_AlarmClearFlag(RTCB, RTC_FLAG_WUTF);
        }
    __HAL_RTC_WAKEUPTIMER_EXTI_CLEAR_FLAG();

    JOSIntExitII();
    }




//WakeUpCounter 16Ʈ
LOCAL(BOOL) RTCEx_SetWakeUpTimer_IT(RTC_TypeDef *RTCB, UINT WakeUpCounter, UINT WakeUpClock)
    {
    BOOL Rslt=FALSE;
    UINT Time;

    RTC_WRITEPROTECTION_DISABLE(RTCB);
    if (RTCB->CR & RTC_CR_WUTE)
        {
        Time=HAL_GetTick();
        while (RTCB->ISR & RTC_FLAG_WUTWF)
            {
            if (HAL_GetTick()-Time>=RTC_TIMEOUT_VALUE) goto ProcExit;
            }
        }
    RTCB->CR&=~RTC_CR_WUTE; //__HAL_RTC_WAKEUPTIMER_DISABLE()
    RTC_AlarmClearFlag(RTCB, RTC_FLAG_WUTF);

    Time=HAL_GetTick();
    while ((RTCB->ISR & RTC_FLAG_WUTWF)==0)
        {
        if (HAL_GetTick()-Time>=RTC_TIMEOUT_VALUE) goto ProcExit;
        }

    RTCB->WUTR=WakeUpCounter;
    RTCB->CR&=~RTC_CR_WUCKSEL;
    RTCB->CR|=WakeUpClock;
    __HAL_RTC_WAKEUPTIMER_EXTI_ENABLE_IT();
    __HAL_RTC_WAKEUPTIMER_EXTI_ENABLE_RISING_EDGE();
    RTCB->CR|=RTC_IT_WUT;   //__HAL_RTC_WAKEUPTIMER_ENABLE_IT();
    RTCB->CR|=RTC_CR_WUTE;  //__HAL_RTC_WAKEUPTIMER_ENABLE();
    Rslt++;

    ProcExit:
    RTC_WRITEPROTECTION_ENABLE(RTCB);
    return HAL_OK;
    }




LOCAL(BOOL) RTCEx_DeactivateWakeUpTimer(RTC_TypeDef *RTCB)
    {
    BOOL Rslt=FALSE;
    UINT Time;

    RTC_WRITEPROTECTION_DISABLE(RTCB);
    RTCB->CR&=~RTC_CR_WUTE; //__HAL_RTC_WAKEUPTIMER_DISABLE()
    RTCB->CR&=~RTC_IT_WUT;  //__HAL_RTC_WAKEUPTIMER_DISABLE_IT()

    Time=HAL_GetTick();
    while ((RTCB->ISR & RTC_FLAG_WUTWF)==0)
        {
        if (HAL_GetTick()-Time>=RTC_TIMEOUT_VALUE) goto ProcExit;
        }
    Rslt++;

    ProcExit:
    RTC_WRITEPROTECTION_ENABLE(RTCB);
    return HAL_OK;
    }



//-----------------------------------------------------------------------------
//      ִ 25 (Time_ms==0 ̸ Ÿ̸Ӹ Stop)
//-----------------------------------------------------------------------------
VOID WINAPI RTC_SetWakeupTimer(int Time_ms)
    {
    RTCEx_DeactivateWakeUpTimer(RtcHandle.Instance);
    if (Time_ms) RTCEx_SetWakeUpTimer_IT(RtcHandle.Instance, UMulDiv(Time_ms, 256, 100), RTC_WAKEUPCLOCK_RTCCLK_DIV16);
    }



#endif //HAL_RTC_MODULE_ENABLED




///////////////////////////////////////////////////////////////////////////////
//                      POWER CONTROL
///////////////////////////////////////////////////////////////////////////////



//-----------------------------------------------------------------------------
//      Stop 
//
//Regulator: PWR_MAINREGULATOR_ON / PWR_LOWPOWERREGULATOR_ON
//STOPEntry: PWR_STOPENTRY_WFI / PWR_STOPENTRY_WFE // WFI(Wait for Interrupt) or WFE(Wait for Event)
//-----------------------------------------------------------------------------
VOID PWR_EnterSTOPMode(UINT Regulator, int StopEntry)
    {
    UINT CR;

    CR=PWR->CR;
    CLEAR_BIT(CR, (PWR_CR_PDDS|PWR_CR_LPSDSR));
    SET_BIT(CR, Regulator);
    PWR->CR=CR;

    SET_BIT(SCB->SCR, SCB_SCR_SLEEPDEEP_Msk);

    if (StopEntry==PWR_STOPENTRY_WFI)
        {
        __WFI();
        }
    else{
        __SEV();
        __WFE();
        __WFE();
        }
    CLEAR_BIT(SCB->SCR, SCB_SCR_SLEEPDEEP_Msk);
    }



//-----------------------------------------------------------------------------
//      StandBy 
//-----------------------------------------------------------------------------
VOID PWR_EnterSTANDBYMode(VOID)
    {
    Printf("Standby Mode..."CRLF); HAL_Delay(100);

    SET_BIT(PWR->CR, PWR_CR_PDDS);
    SET_BIT(SCB->SCR, SCB_SCR_SLEEPDEEP_Msk);

    #if defined (__CC_ARM)
    __force_stores();
    #endif
    __WFI();
    }




///////////////////////////////////////////////////////////////////////////////
//                      ADC
//
//  뿹
//  #define PI_MEASURE  PA0     //
//
//  //ʱȭ
//  InitPort(PI_MEASURE, GPIO_MODE_ANALOG, GPIO_NOPULL, 0);
//  InitADC(ADC_SAMPLETIME_39CYCLES_5);
//  AdcCalValue=ADC_GetCalibrationValue();
//
//  //AI0 
//  int AI0, ARef, mV;
//  AI0=ADC_GetValueAverage(ADC_CHSELR_CHSEL0, 16)+AdcCalValue;
//  ARef=ADC_GetValueAverage(ADC_CHSELR_CHSEL17, 16)+AdcCalValue;
//  mV=AI0*1224/ARef;
///////////////////////////////////////////////////////////////////////////////
#ifdef HAL_ADC_MODULE_ENABLED

#define ADC_CALIBRATION_TIMEOUT     10
#define ADC_TEMPSENSOR_DELAY_US     10
#define ADC_STAB_DELAY_US           1
#define SYSCFG_BUF_VREFINT_ENABLE_TIMEOUT   3

ADC_HandleTypeDef AdcHandle;



LOCAL(BOOL) ADC_IsEnable(ADC_TypeDef *ADCx)    //ADC_IS_ENABLE()
    {
    return (ADCx->CR & (ADC_CR_ADEN|ADC_CR_ADDIS))==ADC_CR_ADEN &&
           (ADCx->ISR & ADC_FLAG_RDY)!=0;
    }



LOCAL(VOID) ADC_ClockPrescaler(ADC_TypeDef *ADCx, int ClockPrescaler)  //__HAL_ADC_CLOCK_PRESCALER
    {
    if (ClockPrescaler==ADC_CLOCK_SYNC_PCLK_DIV1 ||
        ClockPrescaler==ADC_CLOCK_SYNC_PCLK_DIV2 ||
        ClockPrescaler==ADC_CLOCK_SYNC_PCLK_DIV4)
        {
        ADCx->CFGR2&=~ADC_CFGR2_CKMODE;
        ADCx->CFGR2|=ClockPrescaler;
        }
    else{
        ADCx->CFGR2&=~ADC_CFGR2_CKMODE;
        ADC->CCR&=~ADC_CCR_PRESC;
        ADC->CCR|=ClockPrescaler;
        }
    }



LOCAL(HAL_StatusTypeDef) ADC_Init(ADC_HandleTypeDef *hAdc)
    {
    ADC_TypeDef *ADCx;

    ADCx=hAdc->Instance;
    if (ADCx->CR & ADC_CR_ADSTART) return HAL_ERROR;

    if (ADC_IsEnable(ADCx)==FALSE)
        {
        ADC_ClockPrescaler(ADCx, hAdc->Init.ClockPrescaler);
        ADCx->CFGR1&=~ADC_CFGR1_RES;
        ADCx->CFGR1|=hAdc->Init.Resolution;
        }

    ADC->CCR&=~ADC_CCR_LFMEN;
    ADC->CCR|=__HAL_ADC_CCR_LOWFREQUENCY(hAdc->Init.LowPowerFrequencyMode);

    if (HAL_IS_BIT_CLR(ADCx->CR, ADC_CR_ADVREGEN)) ADCx->CR|=ADC_CR_ADVREGEN;

    ADCx->CFGR1&=~(ADC_CFGR1_ALIGN|
        ADC_CFGR1_SCANDIR|
        ADC_CFGR1_EXTSEL|
        ADC_CFGR1_EXTEN|
        ADC_CFGR1_CONT|
        ADC_CFGR1_DMACFG|
        ADC_CFGR1_OVRMOD|
        ADC_CFGR1_AUTDLY|
        ADC_CFGR1_AUTOFF|
        ADC_CFGR1_DISCEN);

    ADCx->CFGR1|=hAdc->Init.DataAlign|
        ADC_SCANDIR(hAdc->Init.ScanConvMode)|
        ADC_CONTINUOUS(hAdc->Init.ContinuousConvMode)|
        ADC_DMACONTREQ(hAdc->Init.DMAContinuousRequests)|
        hAdc->Init.Overrun|
        __HAL_ADC_CFGR1_AutoDelay(hAdc->Init.LowPowerAutoWait)|
        __HAL_ADC_CFGR1_AUTOFF(hAdc->Init.LowPowerAutoPowerOff);

    if (hAdc->Init.ExternalTrigConv!=ADC_SOFTWARE_START)
        ADCx->CFGR1|=hAdc->Init.ExternalTrigConv|hAdc->Init.ExternalTrigConvEdge;

    if (hAdc->Init.DiscontinuousConvMode==ENABLE &&
        hAdc->Init.ContinuousConvMode==DISABLE) ADCx->CFGR1|=ADC_CFGR1_DISCEN;

    if (hAdc->Init.OversamplingMode==ENABLE)
        {
        ADCx->CFGR2&=~(ADC_CFGR2_OVSR|ADC_CFGR2_OVSS|ADC_CFGR2_TOVS);
        ADCx->CFGR2|=hAdc->Init.Oversample.Ratio|hAdc->Init.Oversample.RightBitShift|hAdc->Init.Oversample.TriggeredMode;
        ADCx->CFGR2|=ADC_CFGR2_OVSE;
        }
    else{
        if (HAL_IS_BIT_SET(ADCx->CFGR2, ADC_CFGR2_OVSE)) ADCx->CFGR2&=~ADC_CFGR2_OVSE;
        }

    ADCx->SMPR&=~ADC_SMPR_SMPR;
    ADCx->SMPR|=hAdc->Init.SamplingTime;
    return HAL_OK;
    }




LOCAL(BOOL) ADCEx_Calibration_Start(ADC_TypeDef *ADCx)
    {
    BOOL Rslt=FALSE;
    DWORD TickStart;
    UINT BkupDmaTx;

    if (ADC_IsEnable(ADCx)) goto ProcExit;

    BkupDmaTx=READ_BIT(ADCx->CFGR1, ADC_CFGR1_DMAEN|ADC_CFGR1_DMACFG);
    CLEAR_BIT(ADCx->CFGR1, ADC_CFGR1_DMAEN|ADC_CFGR1_DMACFG);

    ADCx->CR|=ADC_CR_ADCAL;

    Rslt=TRUE;
    TickStart=HAL_GetTick();
    while (HAL_IS_BIT_SET(ADCx->CR, ADC_CR_ADCAL))
        {
        if (HAL_GetTick()-TickStart>ADC_CALIBRATION_TIMEOUT) {Rslt=FALSE; break;}
        }
    SET_BIT(ADCx->CFGR1, BkupDmaTx);

    ProcExit:
    return Rslt;
    }



LOCAL(VOID) ADC_DelayMicroSecond(UINT mS)
    {
    __IO UINT W=(mS*(SystemCoreClock/1000000U));
    while (W!=0) W--;
    }




//-----------------------------------------------------------------------------
//      Channel: ADC_CHANNEL_0 ~ 15
//               ADC_CHANNEL_TEMPSENSOR
//               ADC_CHANNEL_VREFINT
//               ADC_CHANNEL_VLCD
//-----------------------------------------------------------------------------
LOCAL(HAL_StatusTypeDef) ADC_ConfigChannel(ADC_TypeDef *ADCx, int Channel, int Rank)
    {
    if (ADCx->CR & ADC_CR_ADSTART) return HAL_ERROR;   //ADC_IS_CONVERSION_ONGOING_REGULAR

    if (Rank!=ADC_RANK_NONE)
        {
        ADCx->CHSELR|=(UINT)(Channel&ADC_CHANNEL_MASK);

        #if defined(ADC_CCR_TSEN)
        if (((Channel&ADC_CHANNEL_MASK)&ADC_CHANNEL_TEMPSENSOR)==(ADC_CHANNEL_TEMPSENSOR&ADC_CHANNEL_MASK))
            {
            ADC->CCR|=ADC_CCR_TSEN;
            ADC_DelayMicroSecond(ADC_TEMPSENSOR_DELAY_US);
            }
        #endif

        if (((Channel&ADC_CHANNEL_MASK) & ADC_CHANNEL_VREFINT)==(ADC_CHANNEL_VREFINT&ADC_CHANNEL_MASK))
            {
            ADC->CCR|=ADC_CCR_VREFEN;
            }

        #if defined (STM32L053xx) || defined (STM32L063xx) || defined (STM32L073xx) || defined (STM32L083xx)
        if (((Channel&ADC_CHANNEL_MASK)&ADC_CHANNEL_VLCD)==(ADC_CHANNEL_VLCD&ADC_CHANNEL_MASK))
            {
            ADC->CCR|=ADC_CCR_VLCDEN;
            }
        #endif
        }
    else{
        ADCx->CHSELR&=~(Channel&ADC_CHANNEL_MASK);

        #if defined(ADC_CCR_TSEN)
        if (((Channel&ADC_CHANNEL_MASK)&ADC_CHANNEL_TEMPSENSOR)==(ADC_CHANNEL_TEMPSENSOR&ADC_CHANNEL_MASK))
            {
            ADC->CCR&=~ADC_CCR_TSEN;
            }
        #endif

        if (((Channel&ADC_CHANNEL_MASK)&ADC_CHANNEL_VREFINT)==(ADC_CHANNEL_VREFINT&ADC_CHANNEL_MASK))
            {
            ADC->CCR&=~ADC_CCR_VREFEN;
            }

        #if defined (STM32L053xx) || defined (STM32L063xx) || defined (STM32L073xx) || defined (STM32L083xx)
        if (((Channel&ADC_CHANNEL_MASK)&ADC_CHANNEL_VLCD)==(ADC_CHANNEL_VLCD&ADC_CHANNEL_MASK))
            {
            ADC->CCR&=~ADC_CCR_VLCDEN;
            }
        #endif
        }

    return HAL_OK;
    }




LOCAL(HAL_StatusTypeDef) ADC_Enable(ADC_TypeDef *ADCx)
    {
    UINT TickStart;

    if (ADC_IsEnable(ADCx)==FALSE)
        {
        if (ADCx->CR & (ADC_CR_ADCAL|ADC_CR_ADSTP|ADC_CR_ADSTART|ADC_CR_ADDIS|ADC_CR_ADEN)) return HAL_ERROR;  //ADC_ENABLING_CONDITIONS(hAdc)==0
        ADCx->CR|=ADC_CR_ADEN; //__HAL_ADC_ENABLE(hAdc);
        ADC_DelayMicroSecond(ADC_STAB_DELAY_US);

        TickStart=HAL_GetTick();
        while ((ADCx->ISR & ADC_FLAG_RDY)==0)
            {
            if (HAL_GetTick()-TickStart>ADC_ENABLE_TIMEOUT) return HAL_ERROR;
            }
        }
    return HAL_OK;
    }




HAL_StatusTypeDef HAL_ADC_Start(ADC_HandleTypeDef *hAdc)
    {
    HAL_StatusTypeDef Rslt=HAL_OK;
    ADC_TypeDef   *ADCx;

    ADCx=hAdc->Instance;
    if ((ADCx->CR & ADC_CR_ADSTART)==0)
        {
        if (hAdc->Init.LowPowerAutoPowerOff!=ENABLE) Rslt=ADC_Enable(ADCx);

        if (Rslt==HAL_OK)
            {
            ADCx->ISR=ADC_FLAG_EOC|ADC_FLAG_EOS|ADC_FLAG_OVR;
            ADCx->CR|=ADC_CR_ADSTART;
            }
        }
    else Rslt=HAL_BUSY;
    return Rslt;
    }



HAL_StatusTypeDef HAL_ADC_PollForConversion(ADC_HandleTypeDef *hAdc, UINT Timeout)
    {
    UINT TickStart, EOS;
    ADC_TypeDef   *ADCx;

    ADCx=hAdc->Instance;

    EOS=ADC_FLAG_EOS;
    if (hAdc->Init.EOCSelection!=ADC_EOC_SEQ_CONV)
        {
        if (HAL_IS_BIT_SET(ADCx->CFGR1, ADC_CFGR1_DMAEN)) return HAL_ERROR;
        EOS|=ADC_FLAG_EOC;
        }

    TickStart=HAL_GetTick();
    while (HAL_IS_BIT_CLR(ADCx->ISR, EOS))
        {
        if (Timeout!=HAL_MAX_DELAY)
            {
            if ((Timeout==0) || HAL_GetTick()-TickStart>Timeout) return HAL_TIMEOUT;
            }
        }

    if ((ADCx->CFGR1 & ADC_CFGR1_EXTEN)==0 && hAdc->Init.ContinuousConvMode==DISABLE)
        {
        if (ADCx->ISR & ADC_FLAG_EOS)
            {
            if ((ADCx->CR & ADC_CR_ADSTART)==0)
                ADCx->IER&=~(ADC_IT_EOC|ADC_IT_EOS);    //__HAL_ADC_DISABLE_IT(hAdc, ADC_IT_EOC|ADC_IT_EOS);
            }
        }

    if (hAdc->Init.LowPowerAutoWait==DISABLE) ADCx->ISR=ADC_FLAG_EOC|ADC_FLAG_EOS;
    return HAL_OK;
    }




HAL_StatusTypeDef HAL_ADCEx_EnableVREFINT(VOID)
    {
    UINT TickStart;

    SET_BIT(SYSCFG->CFGR3, SYSCFG_CFGR3_ENBUF_VREFINT_ADC);
    TickStart=HAL_GetTick();
    while (HAL_IS_BIT_CLR(SYSCFG->CFGR3, SYSCFG_CFGR3_VREFINT_RDYF))
        {
        if ((HAL_GetTick()-TickStart)>SYSCFG_BUF_VREFINT_ENABLE_TIMEOUT) return HAL_ERROR;
        }
    return HAL_OK;
    }




VOID HAL_ADCEx_DisableVREFINT(VOID)
    {
    CLEAR_BIT(SYSCFG->CFGR3, SYSCFG_CFGR3_ENBUF_VREFINT_ADC);
    }



//-----------------------------------------------------------------------------
//      ۷  ADC17 ... 1.224 V
//      Channel: ADC_CHANNEL_0 ~ 15
//               ADC_CHANNEL_TEMPSENSOR
//               ADC_CHANNEL_VREFINT
//               ADC_CHANNEL_VLCD
//-----------------------------------------------------------------------------
UINT WINAPI ADC_GetValue(int Channel)
    {
    UINT Value;

    //if (Channel==ADC_CHANNEL_VREFINT) HAL_ADCEx_EnableVREFINT();  //ص   
    ADC_ConfigChannel(AdcHandle.Instance, Channel, ADC_RANK_CHANNEL_NUMBER);
    HAL_ADC_Start(&AdcHandle);
    HAL_ADC_PollForConversion(&AdcHandle, 10);
    Value=AdcHandle.Instance->DR;
    //if (Channel==ADC_CHANNEL_VREFINT) HAL_ADCEx_DisableVREFINT();

    ADC_ConfigChannel(AdcHandle.Instance, Channel, ADC_RANK_NONE);  //̰ ָ ä ߼õǾ  ä      
    return Value;
    }



UINT WINAPI ADC_GetCalibrationValue(VOID)   //ADCEx_Calibration_GetValue()
    {
    return AdcHandle.Instance->CALFACT & 0x7F;
    }



//-----------------------------------------------------------------------------
//      ־ ä ADC ־ Ƚŭ о   ( ҽ)
//-----------------------------------------------------------------------------
UINT WINAPI ADC_GetValueAverage(UINT Channel, UINT Cnt)
    {
    int I,J, Sum=0;
    ADC_TypeDef *ADCx;

    ADCx=AdcHandle.Instance;
    if (ADCx->ISR & ADC_ISR_EOC)
        {
        (VOID)ADCx->DR;
        ADCx->ISR|=ADC_ISR_EOC;
        }

    ADCx->CFGR1|=ADC_CFGR1_AUTOFF;
    ADCx->CHSELR=Channel;
    ADCx->SMPR|=(ADC_SMPR_SMP_0|ADC_SMPR_SMP_2);
    ADCx->IER=ADC_IER_EOCIE;
    if (Channel==ADC_CHSELR_CHSEL17) ADC->CCR|=ADC_CCR_VREFEN;
    else if (Channel==ADC_CHSELR_CHSEL18)
        {
        ADC->CCR|=ADC_CCR_TSEN;
        ADC_DelayMicroSecond(ADC_TEMPSENSOR_DELAY_US);
        }
    ADCx->CR|=ADC_CR_ADSTART;

    for (I=0; I<Cnt; I++)
        {
        for (J=0; J<100; J++)
            {
            Delay_us(1);        //2020-01-14  10->1 
            if (ADCx->ISR & ADC_ISR_EOC) break;
            }
        Sum+=ADCx->DR;
        ADCx->ISR|=ADC_ISR_EOC;
        }

    if (ADCx->CR & ADC_CR_ADSTART) ADCx->CR|=ADC_CR_ADSTP;
    if (Channel==ADC_CHSELR_CHSEL17) ADC->CCR&=~ADC_CCR_VREFEN;
    else if (Channel==ADC_CHSELR_CHSEL18) ADC->CCR&=~ADC_CCR_TSEN;
    return DIV_ROUNDUP(Sum, Cnt);
    }



//-----------------------------------------------------------------------------
//      ADC ʱȭ
//-----------------------------------------------------------------------------
VOID WINAPI InitADC(UINT SamplingTime)
    {
    __HAL_RCC_ADC1_CLK_ENABLE();

    AdcHandle.Instance=ADC1;
    //AdcHandle.Init.OversamplingMode=DISABLE;
    AdcHandle.Init.ClockPrescaler=ADC_CLOCK_SYNC_PCLK_DIV1;
    AdcHandle.Init.LowPowerAutoPowerOff=DISABLE;
    AdcHandle.Init.LowPowerFrequencyMode=ENABLE;
    AdcHandle.Init.LowPowerAutoWait=DISABLE;
    AdcHandle.Init.Resolution=ADC_RESOLUTION_12B;
    AdcHandle.Init.SamplingTime=SamplingTime;   //ADC_SAMPLETIME_7CYCLES_5, ADC_SAMPLETIME_39CYCLES_5;
    AdcHandle.Init.ScanConvMode=ADC_SCAN_DIRECTION_FORWARD;
    AdcHandle.Init.DataAlign=ADC_DATAALIGN_RIGHT;
    AdcHandle.Init.ContinuousConvMode=(FunctionalState)ENABLE;
    AdcHandle.Init.DiscontinuousConvMode=(FunctionalState)DISABLE;
    AdcHandle.Init.ExternalTrigConvEdge=ADC_EXTERNALTRIGCONVEDGE_NONE;
    AdcHandle.Init.EOCSelection=ADC_EOC_SINGLE_CONV;
    AdcHandle.Init.DMAContinuousRequests=(FunctionalState)DISABLE;
    ADC_Init(&AdcHandle);

    ADCEx_Calibration_Start(AdcHandle.Instance);
    }



LOCAL(BOOL) ADC_ConversionStop(ADC_TypeDef *ADCx)
    {
    DWORD TickStart;

    if (ADCx->CR & ADC_CR_ADSTART)        //ADC_IS_CONVERSION_ONGOING_REGULAR
        {
        if ((ADCx->CR & ADC_CR_ADSTART)!=0 &&
            (ADCx->CR & ADC_CR_ADDIS)==0)   ADCx->CR|=ADC_CR_ADSTP;

        TickStart=HAL_GetTick();
        while (ADCx->CR & ADC_CR_ADSTART)
            {
            if (HAL_GetTick()-TickStart>=ADC_STOP_CONVERSION_TIMEOUT) return FALSE;
            }
        }
    return TRUE;
    }



LOCAL(BOOL) ADC_Disable(ADC_TypeDef *ADCx)
    {
    DWORD TickStart;

    if (ADC_IsEnable(ADCx))     //ADC_IS_ENABLE()
        {
        if ((ADCx->CR & (ADC_CR_ADSTART|ADC_CR_ADEN))!=ADC_CR_ADEN) return FALSE; //ADC_DISABLING_CONDITIONS

        //__HAL_ADC_DISABLE(hAdc);
        ADCx->CR|=ADC_CR_ADDIS;
        ADCx->ISR=ADC_FLAG_EOSMP|ADC_FLAG_RDY;

        TickStart=HAL_GetTick();
        while (ADCx->CR & ADC_CR_ADEN)
            {
            if (HAL_GetTick()-TickStart>ADC_DISABLE_TIMEOUT) return FALSE;
            }
        }
    return TRUE;
    }



LOCAL(VOID) ADC_DeInit(ADC_TypeDef *ADCx)
    {
    ADC_ConversionStop(ADCx);
    ADC_Disable(ADCx);

    ADCx->IER&=~(ADC_IT_AWD|ADC_IT_OVR|ADC_IT_EOCAL|ADC_IT_EOS|ADC_IT_EOC|ADC_IT_RDY|ADC_IT_EOSMP);             //__HAL_ADC_DISABLE_IT()
    ADCx->ISR=ADC_FLAG_AWD|ADC_FLAG_EOCAL|ADC_FLAG_OVR|ADC_FLAG_EOS|ADC_FLAG_EOC|ADC_FLAG_EOSMP|ADC_FLAG_RDY;   //__HAL_ADC_CLEAR_FLAG()

    ADCx->CR&=~ADC_CR_ADVREGEN;
    ADCx->CFGR1&=~(ADC_CFGR1_AWDCH|ADC_CFGR1_AWDEN|ADC_CFGR1_AWDSGL|\
        ADC_CFGR1_DISCEN|ADC_CFGR1_AUTOFF|ADC_CFGR1_AUTDLY|\
        ADC_CFGR1_CONT|ADC_CFGR1_OVRMOD|ADC_CFGR1_EXTEN|\
        ADC_CFGR1_EXTSEL|ADC_CFGR1_ALIGN|ADC_CFGR1_RES|\
        ADC_CFGR1_SCANDIR|ADC_CFGR1_DMACFG|ADC_CFGR1_DMAEN);

    ADCx->CFGR2&=~(ADC_CFGR2_TOVS|ADC_CFGR2_OVSS|ADC_CFGR2_OVSR|ADC_CFGR2_OVSE|ADC_CFGR2_CKMODE);
    ADCx->SMPR&=~(ADC_SMPR_SMPR);
    ADCx->TR&=~(ADC_TR_LT|ADC_TR_HT);
    ADCx->CALFACT&=~(ADC_CALFACT_CALFACT);
    ADCx->CALFACT&=~(ADC_CALFACT_CALFACT);
    }


VOID WINAPI ReleaseADC(VOID)
    {
    ADC_DeInit(AdcHandle.Instance);
    __HAL_RCC_ADC1_CLK_DISABLE();
    }



#endif //HAL_ADC_MODULE_ENABLED



///////////////////////////////////////////////////////////////////////////////
//                  DAC
///////////////////////////////////////////////////////////////////////////////
#ifdef HAL_DAC_MODULE_ENABLED


LOCAL(VOID) DAC_ConfigChannel(UINT Channel, UINT Trigger, UINT OutputBuff)
    {
    UINT T;

    T=DAC->CR & ~((DAC_CR_MAMP1|DAC_CR_WAVE1|DAC_CR_TSEL1|DAC_CR_TEN1|DAC_CR_BOFF1)<<Channel);
    DAC->CR=T | ((Trigger|OutputBuff)<<Channel);
    DAC->CR&=~(DAC_CR_WAVE1<<Channel);
    }



#if defined(STM32L053xx) || defined(STM32L072xx) || defined(STM32L073xx) || defined(STM32L082xx) || defined(STM32L083xx)
VOID WINAPI DAC_SetValue(UINT Channel, UINT Alignment, UINT Data)
    {
    UINT SetAddr;

    SetAddr=(UINT)DAC;
    if (Channel==DAC_CHANNEL_1) SetAddr+=DAC_DHR12R1_ALIGNMENT(Alignment);
    else                        SetAddr+=DAC_DHR12R2_ALIGNMENT(Alignment);
    *(__IO UINT*)SetAddr=Data;
    }
#endif



LOCAL(VOID) DAC_Start(UINT Channel)
    {
    DAC->CR|=DAC_CR_EN1<<Channel;  //__HAL_DAC_ENABLE(hdac, Channel);
    if (Channel==DAC_CHANNEL_1)
        {
        if ((DAC->CR & DAC_CR_TEN1)!=0 &&
            (DAC->CR & DAC_CR_TSEL1)==DAC_CR_TSEL1) DAC->SWTRIGR|=DAC_SWTRIGR_SWTRIG1;
        }
    #ifndef STM32L053xx
    else{
        if ((DAC->CR & DAC_CR_TEN2)!=0 &&
            (DAC->CR & DAC_CR_TSEL2)==DAC_CR_TSEL2) DAC->SWTRIGR|=DAC_SWTRIGR_SWTRIG2;
        }
    #endif
    }



VOID WINAPI InitDAC(UINT Channel)
    {
    __HAL_RCC_DAC_CLK_ENABLE();

    DAC_ConfigChannel(Channel, DAC_TRIGGER_NONE, DAC_OUTPUTBUFFER_DISABLE);
    DAC_SetValue(Channel, DAC_ALIGN_8B_R, 0x0);
    DAC_Start(Channel);
    }



VOID WINAPI ReleaseDAC(UINT Channel)
    {
    DAC->CR&=~(DAC_CR_EN1<<Channel);    //__HAL_DAC_DISABLE(&DacHandle, DAC_CHANNEL_1);   //HAL_DAC_Stop(&DacHandle, DAC_CHANNEL_1);

    __HAL_RCC_DAC_CLK_DISABLE();
    __HAL_RCC_DAC_FORCE_RESET();
    __HAL_RCC_DAC_RELEASE_RESET();
    }


#endif //HAL_DAC_MODULE_ENABLED





///////////////////////////////////////////////////////////////////////////////
//                      TIMER
///////////////////////////////////////////////////////////////////////////////
#ifdef HAL_TIM_MODULE_ENABLED

LOCAL(VOID) TIM_Base_SetConfig(TIM_TypeDef *TIMx, TIM_Base_InitTypeDef *TI)
    {
    UINT CR1;

    CR1=TIMx->CR1;

    if (IS_TIM_COUNTER_MODE_SELECT_INSTANCE(TIMx))
        {
        CR1&=~(TIM_CR1_DIR|TIM_CR1_CMS);
        CR1|=TI->CounterMode;
        }

    if (IS_TIM_CLOCK_DIVISION_INSTANCE(TIMx))
        {
        CR1&=~TIM_CR1_CKD;
        CR1|=TI->ClockDivision;
        }

    MODIFY_REG(CR1, TIM_CR1_ARPE, TI->AutoReloadPreload);
    TIMx->CR1=CR1;
    TIMx->ARR=TI->Period;
    TIMx->PSC=TI->Prescaler;
    TIMx->EGR=TIM_EGR_UG;
    }



#if 0
//-----------------------------------------------------------------------------
//      ͷƮ ڵ鷯
//-----------------------------------------------------------------------------
VOID WINAPI TIM_IRQHandler(TIM_TypeDef *TIMx)
    {
    UINT SR;

    SR=TIMx->SR;
    if (SR & TIM_IT_CC1)
        {
        TIMx->SR=~TIM_IT_CC1;           //__HAL_TIM_CLEAR_IT

        #if 0
        if (TIMx->CCMR1 & TIM_CCMR1_CC1S)
            {
            HAL_TIM_IC_CaptureCallback(TIMx, HAL_TIM_ACTIVE_CHANNEL_1);
            }
        else{
            HAL_TIM_OC_DelayElapsedCallback(TIMx, HAL_TIM_ACTIVE_CHANNEL_1);
            HAL_TIM_PWM_PulseFinishedCallback(TIMx, HAL_TIM_ACTIVE_CHANNEL_1);
            }
        #endif
        }

    if (SR & TIM_IT_CC2)
        {
        TIMx->SR=~TIM_IT_CC2;

        #if 0
        if (TIMx->CCMR1 & TIM_CCMR1_CC2S)
            {
            HAL_TIM_IC_CaptureCallback(TIMx, HAL_TIM_ACTIVE_CHANNEL_2);
            }
        else{
            HAL_TIM_OC_DelayElapsedCallback(TIMx, HAL_TIM_ACTIVE_CHANNEL_2);
            HAL_TIM_PWM_PulseFinishedCallback(TIMx, HAL_TIM_ACTIVE_CHANNEL_2);
            }
        #endif
        }

    if (SR & TIM_IT_CC3)
        {
        TIMx->SR=~TIM_IT_CC3;

        #if 0
        if (TIMx->CCMR2 & TIM_CCMR2_CC3S)
            {
            HAL_TIM_IC_CaptureCallback(TIMx, HAL_TIM_ACTIVE_CHANNEL_3);
            }
        else{
            HAL_TIM_OC_DelayElapsedCallback(TIMx, HAL_TIM_ACTIVE_CHANNEL_3);
            HAL_TIM_PWM_PulseFinishedCallback(TIMx, HAL_TIM_ACTIVE_CHANNEL_3);
            }
        #endif
        }

    if (SR & TIM_IT_CC4)
        {
        TIMx->SR=~TIM_IT_CC4;

        #if 0
        if (TIMx->CCMR2 & TIM_CCMR2_CC4S)
            {
            TIM_IC_CaptureCallback(TIMx, HAL_TIM_ACTIVE_CHANNEL_4);
            }
        else{
            TIM_OC_DelayElapsedCallback(TIMx, HAL_TIM_ACTIVE_CHANNEL_4);
            TIM_PWM_PulseFinishedCallback(TIMx, HAL_TIM_ACTIVE_CHANNEL_4);
            }
        #endif
        }

    if (SR & TIM_IT_UPDATE)
        {
        TIMx->SR=~TIM_IT_UPDATE;
        //HAL_TIM_PeriodElapsedCallback(htim);
        }

    if (SR & TIM_IT_TRIGGER)
        {
        TIMx->SR=~TIM_IT_TRIGGER;
        //HAL_TIM_TriggerCallback(htim);
        }
    }
#endif



//-----------------------------------------------------------------------------
//      ־ Ÿ̸Ӹ ī , ͷƮ 
//-----------------------------------------------------------------------------
VOID WINAPI TIM_UpCounterSetup(TIM_TypeDef *TIMx, UINT Freq, UINT Divisor)
    {
    IRQn_Type Irq;
    TIM_HandleTypeDef THT;

    if (TIMx==TIM2)
        {
        __HAL_RCC_TIM2_CLK_ENABLE();
        Irq=TIM2_IRQn;
        }
    else if (TIMx==TIM6)
        {
        __HAL_RCC_TIM6_CLK_ENABLE();
        Irq=TIM6_DAC_IRQn;
        }
    else goto ProcExit;

    ZeroMem(&THT, sizeof(THT));
    THT.Instance=TIMx;
    THT.Init.AutoReloadPreload=TIM_AUTORELOAD_PRELOAD_ENABLE;
    THT.Init.ClockDivision=TIM_CLOCKDIVISION_DIV1;
    THT.Init.CounterMode=TIM_COUNTERMODE_UP;
    THT.Init.Prescaler=DIV_ROUNDUP(SystemCoreClock, Freq)-1;
    THT.Init.Period=Divisor;
    TIM_Base_SetConfig(TIMx, &THT.Init);

    HAL_NVIC_SetPriority(Irq, 3, 0);
    HAL_NVIC_EnableIRQ(Irq);

    //TIM_Base_Start_IT(TIMx);
    TIMx->DIER=TIM_IT_UPDATE;       //__HAL_TIM_ENABLE_IT()
    if ((TIMx->SMCR & TIM_SMCR_SMS)!=TIM_SLAVEMODE_TRIGGER) //IS_TIM_SLAVEMODE_TRIGGER_ENABLED
        TIMx->CR1|=TIM_CR1_CEN;     //__HAL_TIM_ENABLE()

    ProcExit:;
    }



VOID WINAPI TIM_SetPrescalerFreq(TIM_TypeDef *TIMx, UINT Freq)
    {
    TIMx->PSC=DIV_ROUNDUP(SystemCoreClock, Freq)-1;
    }

VOID WINAPI TIM_SetDivisor(TIM_TypeDef *TIMx, UINT Divisor)
    {
    TIMx->ARR=Divisor;
    }



VOID WINAPI TIM_Stop(TIM_TypeDef *TIMx)
    {
    TIMx->DIER&=~TIM_IT_UPDATE; //__HAL_TIM_DISABLE_IT(htim, TIM_IT_UPDATE);

    //__HAL_TIM_DISABLE()
    if ((TIMx->CCER & TIM_CCER_CCxE_MASK)==0) TIMx->CR1&=~TIM_CR1_CEN;
    }



VOID WINAPI TIM_Release(TIM_TypeDef *TIMx)
    {
    if (TIMx==TIM2)
        {
        TIM_Stop(TIM2);
        __HAL_RCC_TIM2_FORCE_RESET();
        __HAL_RCC_TIM2_RELEASE_RESET();
        }
    if (TIMx==TIM6)
        {
        TIM_Stop(TIM6);
        __HAL_RCC_TIM6_FORCE_RESET();
        __HAL_RCC_TIM6_RELEASE_RESET();
        }
    }

#endif //HAL_TIM_MODULE_ENABLED



#if !defined(STM32L071xx) && !defined(STM32L081xx)
//-----------------------------------------------------------------------------
//          32Ʈ  ġ 
//-----------------------------------------------------------------------------
VOID WINAPI TM_RNG_Init(VOID)
    {
    __HAL_RCC_RNG_CLK_ENABLE();
    RNG->CR |= RNG_CR_RNGEN;
    }


UINT WINAPI TM_RNG_Get(VOID)
    {
    while ((RNG->SR & RNG_SR_DRDY)==0); //Wait until one RNG number is ready
    return RNG->DR; //Get a 32-bit Random number
    }
#endif



VOID WINAPI InitDriver(VOID)
    {
    }




