///////////////////////////////////////////////////////////////////////////////
//                              ȭ簨 
//
//  2  
// --------------------------
// 1.   ½
//   ۵:    ǿº 30(ǳ85cm/s)   ξ  30  ۵ .
//   ۵:  ǿº 15(ǳ60cm/s)   ξ  1̳ ۵ .
//
// 2.   ½
//   ۵:    4.5  ǿ¿ 67.5 ϴ  ξ   Ⱓȿ  .
//   ۵:  15   ǿ¿ 45 ϴ  ξ   Ⱓȿ ۵ .
//
// ۼ: , 
// 2019-04-28 v1.0
// 2021-01-07  
// 2021-04-15 Ⱘ ݺ   ʰ Լȿ ó,
//             ݺ ϰ 1ȸ  ó
///////////////////////////////////////////////////////////////////////////////

#include "JLIB.H"
#include "DRIVER.H"
#include "JOS.h"
#include "MONITOR.h"
#include "DetectFire.h"
#include "MAIN.h"

#define SMOKE_MEASURE_QTY       16      //⺻      ݺϴ Ƚ (ⷮ  ϴ  0.3ms  Ƚ),   Ű  Irִ ð ()
#define SMOKE_REPEAT_MEAS_QTY   10      // ݺ  Ƚ
#define HEAT_MEASURE_QTY        16      //⺻      ݺϴ Ƚ
#define TEMPHOSTORYQTY          18      //8ʴ 2.5 з


static BYTE ResetTempHistoryCmd;
static BYTE HeatTempCnt;
static BYTE SmokeIncrementalCnt;
static int  HeatTempAcc;
static int  SmokeIncrementalAcc;


//-----------------------------------------------------------------------------
//      ֱ   ͸ 
//-----------------------------------------------------------------------------
VOID WINAPI GetSmokeHeat(int *lpSmoke, int *lpHeatTemp)
    {
    int Smoke=0;

    if (SmokeIncrementalCnt>0) Smoke=SmokeIncrementalAcc/SmokeIncrementalCnt;
    *lpSmoke=Limit(Smoke*100/GetSensorDetectLevel(), 0, 100);
    SmokeIncrementalAcc=Smoke;
    SmokeIncrementalCnt=1;

    *lpHeatTemp=(HeatTempCnt>0) ? HeatTempAcc/HeatTempCnt:0;
    HeatTempAcc=*lpHeatTemp;
    HeatTempCnt=1;              //ȭ߿   Ƿ 0 Ǵ ʵ ϱ 
    }



//-----------------------------------------------------------------------------
//      ȭ縦 ϸ µ 丮 ä
//      ȭ   丮  ֱ     
//-----------------------------------------------------------------------------
VOID WINAPI ResetTempHistory(VOID)
    {
    ResetTempHistoryCmd=1;
    }




#define ADCMAXVALUE             4095
#ifdef PO_SEN_LDO_EN
LOCAL(int) Adc2Volt(int AdcValue, int Vdd)
    {
    return AdcValue*Vdd/ADCMAXVALUE;
    }



//-----------------------------------------------------------------------------
//      Smoke   
//-----------------------------------------------------------------------------
LOCAL(UINT) MeasureSmoke(BOOL IROnOff)
    {
    UINT Value;

    PortOut(PO_SEN_LDO_EN, IROnOff);    //IR ѱ  LDO Enable
    PortOut(PO_SMOKE_SEN_PW, HIGH);     //OPAMP 
    //PortOut(PO_SMOKE_SEN_PW2, HIGH);  // GPIO 1 
    Delay_us(600);                      //LDO  ȭ Ǳ ð (976us  )

    PortOut(PO_SMOKE_SEN_IR, IROnOff);  //IR ĳҵ , IR 

    //GPIOC->BSRR=1<<13;                //FireLed ġ Ȯ
    Value=ADC_GetValueAverage(ADC_CHSELR_CHSEL0, SMOKE_MEASURE_QTY);            //16 ð 272usɸ
    //GPIOC->BRR=1<<13;

    PortOut(PO_SMOKE_SEN_IR, LOW);
    PortOut(PO_SMOKE_SEN_PW, LOW);
    //PortOut(PO_SMOKE_SEN_PW2, LOW);
    PortOut(PO_SEN_LDO_EN, LOW);
    return Value;
    }




//-----------------------------------------------------------------------------
//      Ⱘ    Ǵ
//-----------------------------------------------------------------------------
LOCAL(BOOL) CheckSmokeFault(int BaseValue, int Vdd, int AdcCal)
    {
    int I, Sum;

    for (I=Sum=0; I<SMOKE_REPEAT_MEAS_QTY; I++)
        Sum+=Adc2Volt(MeasureSmoke(OFF)+AdcCal, Vdd);

    return Sum/SMOKE_REPEAT_MEAS_QTY > (BaseValue>>1);  //IR     ̽ ݺ   Ǵ
    }




//-----------------------------------------------------------------------------
//       
//
//      Main() ƴ´ ȣ
//-----------------------------------------------------------------------------
int WINAPI CheckSmokeSensor(int Vdd, int AdcCal)
    {
    int  I, Rslt=CS_MEASUREING, AverageSmoke, Incremental, DetectLevel; //Incremental:Ķ극̼ǰ(ýð)  
    UINT SmokeValueSum=0;
    static BYTE AutoCalFg, NoFirst;
    static WORD SenAutoCalVal;

    Adc2Volt(MeasureSmoke(OFF)+AdcCal, Vdd);                    // ù°     //891 1052 1080 1079 1064 1052 1024 1075 1072 1087 1076 1128 1047 1058 1006 1073 1074
    for (I=0; I<SMOKE_REPEAT_MEAS_QTY; I++)
        {
        SmokeValueSum+=Adc2Volt(MeasureSmoke(ON)+AdcCal, Vdd);  //Opamp  ܵ  ̶ IR ѳ    
        #if KETEP_GOVERNMENTTASK==0                             //   ؾ ؼ 16  о
        if (I==0 && AutoCalFg!=0)
            {
            DetectLevel=GetSensorDetectLevel();
            Incremental=(AverageSmoke=SmokeValueSum)-SenAutoCalVal;
            if (Incremental<(DetectLevel>>1))
                {
                static int NormalAvrgSum, NormalAvrgCnt;

                NormalAvrgSum+=AverageSmoke;
                if (++NormalAvrgCnt>=10800)                     //24*3600/8=10800 (1ġ)
                    {
                    SenAutoCalVal=DIV_ROUNDUP(NormalAvrgSum, NormalAvrgCnt);
                    NormalAvrgSum=NormalAvrgCnt=0;
                    if (CheckSmokeFault(SenAutoCalVal, Vdd, AdcCal)!=FALSE) goto SensorFault;
                    }

                Rslt=CS_NOTDETECTED;
                goto DispValue;
                }
            }
        #endif
        }

    AverageSmoke=SmokeValueSum/SMOKE_REPEAT_MEAS_QTY;
    DetectLevel=GetSensorDetectLevel();
    if (AutoCalFg==0)   //  3ʰ    ̽ 
        {
        static int CalCnt, CalSum;

        CalSum+=AverageSmoke;
        if (++CalCnt<60) goto ProcExit;                         //  , 60ȸ  3 ҿ
        SenAutoCalVal=CalSum/CalCnt;                            //  ó   
        Incremental=0;
        AutoCalFg=1;
        if (CheckSmokeFault(SenAutoCalVal, Vdd, AdcCal)!=FALSE) {SensorFault: Rslt=CS_SENSORFAULT; Printf("SENSOR: Smoke Sensor Fault"CRLF); goto ProcExit;}
        }
    else Incremental=AverageSmoke-SenAutoCalVal;

    if (SmokeIncrementalCnt==255) {SmokeIncrementalAcc=0; SmokeIncrementalCnt=0;}
    SmokeIncrementalAcc+=Incremental; SmokeIncrementalCnt++;

    Rslt=(Incremental>=DetectLevel) ? CS_DETECTED:CS_NOTDETECTED;

    DispValue:
    if (SysDebugFg || NoFirst==0) Printf("SENSOR: VDD=%.03d, Smoke=%d/%d, Detect=%d/%d"CRLF, Vdd, AverageSmoke, SenAutoCalVal, Incremental, DetectLevel);
    NoFirst=1;

    ProcExit:
    return Rslt;
    }
#endif //PO_SEN_LDO_EN



//-----------------------------------------------------------------------------
//      NTC(µ¿  پ), µȯ (*100  )
//-----------------------------------------------------------------------------
#define TABLEFIRSTDEGREE    (-4000)                         //̺ ù°  µ  (-40.00)
int WINAPI NTC_ConvTemp(int AdcValue)
    {
    int  I, Temp, Volt, PrevVolt=0, TableQty;
    CONST WORD *NtcCnvTable;

    static CONST WORD NtcTempVoltage1M[]=                   //Vcc  100ڰ 1 NTC ߰ (ADC) ȯ ̺ (0 ~ 151)
        {
        4087,4087,4086,4085,4085,4084,4083,4082,4081,4080,  //-40~-31
        4079,4078,4077,4076,4074,4073,4071,4070,4068,4066,  //-30~-21
        4064,4062,4060,4058,4055,4053,4050,4047,4044,4041,  //-20~-11
        4038,4034,4030,4026,4022,4018,4013,4008,4003,3997,  //-10~-1
        3992,3986,3979,3972,3965,3958,3950,3942,3934,3925,  //0~9
        3915,3906,3896,3885,3874,3863,3851,3838,3826,3812,  //10~19
        3798,3784,3770,3754,3739,3723,3704,3685,3665,3644,  //20~29
        3623,3602,3580,3557,3534,3510,3486,3461,3436,3410,  //30~39
        3384,3357,3329,3301,3272,3243,3213,3182,3151,3120,  //40~49
        3088,3055,3022,2988,2954,2919,2884,2849,2813,2776,  //50~59
        2739,2702,2665,2627,2588,2550,2511,2472,2432,2393,  //60~69
        2353,2314,2274,2234,2194,2154,2114,2074,2034,1994,  //70~79
        1955,1916,1876,1837,1799,1761,1723,1685,1647,1610,  //80~89
        1574,1538,1503,1467,1432,1398,1365,1332,1299,1267,  //90~99
        1236,1205,1174,1145,1116,1087,1059,1032,1006,979,   //100~109
        954,929,904,881,858,835,813,792,770,750,            //110~119
        731,712,692,675,657,640,624,607,591,576,            //120~129
        561,546,532,518,506,493,481,468,457,446,            //130~139
        434,424,415,403,395,385,376,366,358,349,            //140~149
        343,                                                //150
        };

    static CONST WORD NtcTempVoltage50K[]=                  //Vcc  10ڰ 50 NTC ߰ (ADC) ȯ ̺ (-40 ~ 150)
        {
        4071,4069,4067,4065,4063,4061,4059,4057,4054,4052,  //-40~-31
        4049,4046,4043,4040,4037,4033,4030,4026,4022,4017,  //-30~-21
        4013,4008,4003,3998,3992,3987,3981,3974,3968,3961,  //-20~-11
        3953,3946,3937,3929,3920,3911,3901,3891,3881,3870,  //-10~-1
        3858,3847,3834,3821,3808,3794,3780,3765,3750,3734,  //0~9
        3718,3701,3683,3665,3647,3628,3608,3588,3568,3547,  //10~19
        3526,3504,3482,3459,3436,3413,3387,3361,3335,3308,  //20~29
        3281,3252,3224,3195,3165,3135,3104,3072,3041,3009,  //30~39
        2976,2943,2909,2875,2841,2807,2772,2737,2701,2665,  //40~49
        2629,2593,2557,2520,2484,2447,2410,2374,2337,2300,  //50~59
        2263,2226,2190,2153,2117,2080,2044,2008,1973,1937,  //60~69
        1902,1867,1832,1798,1764,1730,1696,1663,1631,1598,  //70~79
        1566,1535,1504,1473,1443,1413,1383,1355,1326,1298,  //80~89
        1270,1243,1217,1190,1165,1139,1114,1090,1066,1043,  //90~99
        1020,997,975,953,932,911,891,871,851,832,           //100~109
        813,795,777,759,743,726,709,693,678,662,            //110~119
        647,633,618,604,591,577,564,551,539,527,            //120~129
        515,504,492,481,470,460,449,439,430,420,            //130~139
        411,402,393,384,376,367,359,352,344,336,            //140~149
        329                                                 //150
        };

    if (IsUseLowResistNtc())
        {
        NtcCnvTable=NtcTempVoltage50K;
        TableQty=countof(NtcTempVoltage50K);
        }
    else{
        NtcCnvTable=NtcTempVoltage1M;
        TableQty=countof(NtcTempVoltage1M);
        }

    for (I=0; I<TableQty; I++)
        {
        Volt=NtcCnvTable[I];
        if (AdcValue>=Volt)
            {
            if (I==0) Temp=(AdcValue==Volt) ? TABLEFIRSTDEGREE:TABLEFIRSTDEGREE-1000;   //̺   ̺  µ 10  µ 
            else Temp=MulDiv(AdcValue-PrevVolt, 100, Volt-PrevVolt) + (I-1)*100 + TABLEFIRSTDEGREE;
            break;
            }
        PrevVolt=Volt;
        }
    if (I==TableQty) Temp=(TableQty-1+10)*100 + TABLEFIRSTDEGREE;               //ִġ 10   
    return Temp;
    }




//-----------------------------------------------------------------------------
//      ֱ 1ð   µ 
//-----------------------------------------------------------------------------
LOCAL(int) SetTempHistory(int Temp, int AvrgInterval)
    {
    int    I, Sum=0;
    DWORD  CurrTime;
    static WORD  TenHistoryCnt;
    static INT16 TempHistory[TEMPHOSTORYQTY];
    static DWORD OldTime;

    CurrTime=GetTodayToSecond();
    if (CurrTime-OldTime>=AvrgInterval)
        {
        OldTime=CurrTime;
        if (ResetTempHistoryCmd!=0)
            {
            ResetTempHistoryCmd=0;
            for (I=0; I<TEMPHOSTORYQTY; I++) TempHistory[I]=Temp;
            TenHistoryCnt=TEMPHOSTORYQTY;
            }
        else if (TenHistoryCnt<TEMPHOSTORYQTY)
            {
            TempHistory[TenHistoryCnt++]=Temp;
            }
        else{
            MoveMem(TempHistory, TempHistory+1, sizeof(WORD)*(TEMPHOSTORYQTY-1));
            TempHistory[TEMPHOSTORYQTY-1]=Temp;
            }
        }

    //Printf("Temp:");
    for (I=0; I<TenHistoryCnt; I++)
        {
        Sum+=TempHistory[I];
        //Printf(" %d", TempHistory[I]);
        }
    //Printf(CRLF);
    return DivRoundUp(Sum, TenHistoryCnt);
    }



//-----------------------------------------------------------------------------
//      µ 󿩺 Ǵ
//-----------------------------------------------------------------------------
LOCAL(BOOL) CheckTempFault(int CurrTemp)
    {
    BOOL Rslt=FALSE;
    static INT16 MinTemp, MaxTemp, DayCnt;

    if (DayCnt==0) MinTemp=MaxTemp=CurrTemp;
    else{
        MinTemp=GetMin(MinTemp, CurrTemp);
        MaxTemp=GetMax(MaxTemp, CurrTemp);
        }
    if (++DayCnt>=10800)                        //24*3600/8=10800 (1ġ)
        {
        DayCnt=0;
        if (MaxTemp-MinTemp<=200) Rslt++;         //Ϸ µȭ 2 ̸ NTC ҷ Ǵ
        }
    return Rslt;
    }



//-----------------------------------------------------------------------------
//      µ ȭ簨
//-----------------------------------------------------------------------------
int WINAPI CheckTempSensor(int Vdd, int AdcCal, int Type, int AvrgInterval)
    {
    int I, Rslt=CS_NOTDETECTED, SensorValue, CurrTemp, DetectTemp, NormalTemp;
    static BYTE NoFirst;

    #ifndef ANSANYOUTHCENTER
    if (DetectorType==SMOKE_HEAT_DETECTOR)
        {                                       // PO_SMOKE_SEN_IR Ʈ    ̹ 'L' Ǿ 
        #if NAMDONGPOWERPLANT
        #if NAMDONGPOWERPLANTNB==0
        PortOut(PO_SMOKE_SEN_PW, HIGH);
        Delay_us(30);                           //̰  µ  Ҿ
        SensorValue=ADC_GetValueAverage(ADC_CHSELR_CHSEL1, HEAT_MEASURE_QTY);   //ADC_CHSELR_CHSEL0 Ⱘ OPAMP ¿ Ǿ   
        PortOut(PO_SMOKE_SEN_PW, LOW);
        #else                                   //NTC 2     USE2NTC==1   ۵
        PortOut(PO_SEN_LDO_EN, HIGH);           //NTC Ʒ LOW
        SensorValue=GetMin(ADC_GetValueAverage(ADC_CHSELR_CHSEL1, HEAT_MEASURE_QTY),    //ADC_CHSELR_CHSEL0 Ⱘ OPAMP ¿ Ǿ   
                           ADC_GetValueAverage(ADC_CHSELR_CHSEL2, HEAT_MEASURE_QTY));   //µ ö󰡸 ADC 
        PortOut(PO_SEN_LDO_EN, LOW);
        #endif
        #elif USE2NTC
        PortOut(PO_SEN_LDO_EN, HIGH);           //NTC Ʒ LOW
        SensorValue=GetMin(ADC_GetValueAverage(ADC_CHSELR_CHSEL1, HEAT_MEASURE_QTY),    //ADC_CHSELR_CHSEL0 Ⱘ OPAMP ¿ Ǿ   
                           ADC_GetValueAverage(ADC_CHSELR_CHSEL2, HEAT_MEASURE_QTY));   //µ ö󰡸 ADC 
        PortOut(PO_SEN_LDO_EN, LOW);
        #else //!NAMDONGPOWERPLANT && !USE2NTC
        PortOut(PO_TOP_SEN_PW, HIGH);           //ܺ忡   ( ), ѹ    main.c  Ʈ ʱ  
        Delay_us(10);
        SensorValue=ADC_GetValueAverage(ADC_CHSELR_CHSEL1, HEAT_MEASURE_QTY);   //ADC_CHSELR_CHSEL0 Ⱘ OPAMP ¿ Ǿ   
        PortOut(PO_TOP_SEN_PW, LOW);
        #endif //NAMDONGPOWERPLANT,USE2NTC
        }
    else
    #endif //ANSANYOUTHCENTER
        {                                       // ܵ  
        PortOut(PO_SMOKE_SEN_IR, LOW);
        Delay_us(10);
        SensorValue=ADC_GetValueAverage(ADC_CHSELR_CHSEL0, HEAT_MEASURE_QTY);   //Ⱘ κ ǰ Ƿ ADC_CHSELR_CHSEL0  
        PortOut(PO_SMOKE_SEN_IR, HIGH);
        }

    CurrTemp=NTC_ConvTemp(SensorValue+AdcCal);
    if (CurrTemp>=2600)     //̺  µ Ȯ 
        {
        if (IsUseLowResistNtc()) CurrTemp=(CurrTemp*4417>>12)-203;              //50K NTC 
        else                     CurrTemp=(CurrTemp*4339>>12)-154;              //1M NTC 
        }

    if (HeatTempCnt==255) {HeatTempAcc=0; HeatTempCnt=0;}
    HeatTempAcc+=CurrTemp; HeatTempCnt++;

    if (CheckTempFault(CurrTemp)!=FALSE) {Rslt=CS_SENSORFAULT; Printf("SENSOR: Heat Sensor Fault"CRLF); goto ProcExit;}

    if (Type==FIXED_HEAT_DETECTOR || Type==SMOKE_HEAT_DETECTOR)
        {
        DetectTemp=GetDetectConstTemp();
        if (CurrTemp>=DetectTemp) Rslt=CS_DETECTED;
        if (SysDebugFg || NoFirst==0) Printf("SENSOR: VDD=%.03d, Temp=%.02d/%.2d"CRLF, Vdd, CurrTemp, DetectTemp);
        }
    else{
        DetectTemp=GetDetectTempDiff();
        NormalTemp=SetTempHistory(CurrTemp, AvrgInterval);
        if ((I=CurrTemp-NormalTemp)>=DetectTemp) {SetOftenCheckFg(FALSE); Rslt=CS_DETECTED;}
        else if (I>=DetectTemp-200) SetOftenCheckFg(TRUE);
        else SetOftenCheckFg(FALSE);
        if (SysDebugFg || NoFirst==0) Printf("SENSOR: VDD=%.03d, Average=%.02d, Current=%.02d, %.02d/%.2d"CRLF, Vdd, NormalTemp, CurrTemp, CurrTemp-NormalTemp, DetectTemp);
        }
    NoFirst=1;

    ProcExit:
    return Rslt;
    }




