///////////////////////////////////////////////////////////////////////////////
//              INI  ٷ
///////////////////////////////////////////////////////////////////////////////


#include "JLIB.H"
#include "JOS.H"
#include "DRIVER.H"
#include "MAIN.H"
#include "INIDATA.H"
#ifdef INIFILENAME
#include "JFAT.H"
#endif



#define MEMOWNER_AddIniSection  (MEMOWNER_INIDATA+0)
#define MEMOWNER_AddIniEntry    (MEMOWNER_INIDATA+1)
#define MEMOWNER_LoadIniFile    (MEMOWNER_INIDATA+2)
#define MEMOWNER_SaveIniFile    (MEMOWNER_INIDATA+3)
#define MEMOWNER_EraseAllIniData (MEMOWNER_INIDATA+4)



typedef struct _ENTRYDATAS
    {
    struct _ENTRYDATAS *Next;
    LPSTR Value;
    CHAR EntryName[1];
    } ENTRYDATAS;


typedef struct _INISECTIONS
    {
    struct _INISECTIONS *Next;
    ENTRYDATAS *Entrys;
    CHAR SectionName[1];
    } INISECTIONS;


typedef struct _INIFILEDATAS
    {
    //struct _INIFILEDATAS *Next;
    #ifdef JOS_VERSION
    JOS_TMR *SaveTmr;
    #else
    DWORD AccessTime;
    #endif
    BYTE  ChangedFg;
    INISECTIONS *Sections;
    //CHAR FileName[1];
    } INIFILEDATAS;


static INIFILEDATAS IniFileDatas;
#ifdef JOS_VERSION
static JOS_EVENT *IniDataSem;
#endif



//-----------------------------------------------------------------------------
//      Ini Data
//-----------------------------------------------------------------------------
LOCAL(VOID) WriteStrMem(LPSTR IniBuff, LPCSTR Str)
    {
    lstrcatn(IniBuff, Str, INIFILESIZEMAX);
    }



//-----------------------------------------------------------------------------
//      Flash ȯ Data 
//-----------------------------------------------------------------------------
LOCAL(VOID) SaveFlash(LPCSTR Buff)
    {
    #ifdef INIFILENAME
    HFILE hFile;

    if ((hFile=_lopen(INIFILENAME, OF_WRITE))==HFILE_ERROR)
        hFile=_lcreat(INIFILENAME, 0);

    if (hFile!=HFILE_ERROR)
        {
        _lwrite(hFile, Buff, lstrlen(Buff)+1);      //+1  پ    ʰ ϱ 
        _lclose(hFile);
        }

    Printf("SENSOR: Cfg Save %s"CRLF, hFile!=HFILE_ERROR ? "OK":"Fail");
    #else
    BOOL Rslt;
    Rslt=FLASH_WriteIniData((UINT)GetIniSavePtr(), Buff, INIFILESIZEMAX);
    Printf("SENSOR: Cfg Save %s"CRLF, Rslt ? "OK":"Fail");
    #endif
    }




LOCAL(INISECTIONS*) AddIniSection(INISECTIONS **Root, LPCSTR SecName)
    {
    INISECTIONS *Section;

    if ((Section=(INISECTIONS*)AllocMem(lstrlen(SecName)+sizeof(INISECTIONS), MEMOWNER_AddIniSection))!=NULL)
        {
        ZeroMem(Section, sizeof(INISECTIONS));
        lstrcpy(Section->SectionName, SecName);
        ADDSINGLELINKEDLIST(INISECTIONS, *Root, Section)
        }
    return Section;
    }


LOCAL(ENTRYDATAS*) AddIniEntry(ENTRYDATAS **Root, LPCSTR EntryName)
    {
    ENTRYDATAS *Entry;

    if ((Entry=(ENTRYDATAS*)AllocMem(lstrlen(EntryName)+sizeof(ENTRYDATAS), MEMOWNER_AddIniEntry))!=NULL)
        {
        ZeroMem(Entry, sizeof(ENTRYDATAS));
        lstrcpy(Entry->EntryName, EntryName);
        ADDSINGLELINKEDLIST(ENTRYDATAS, *Root, Entry)
        }
    return Entry;
    }


LOCAL(VOID) LockIniFile()
    {
    #ifdef JOS_VERSION
    if (IniDataSem==NULL) IniDataSem=JOSSemCreate(1);
    JOSSemPend(IniDataSem, 0);
    #endif
    }

LOCAL(VOID) UnlockIniFile()
    {
    #ifdef JOS_VERSION
    JOSSemPost(IniDataSem);
    #endif
    }



//-----------------------------------------------------------------------------
//      Open Ini 
//-----------------------------------------------------------------------------
#if JOS_VERSION==101
LOCAL(VOID) SaveIniFile(JOS_TMR *Tmr, LPVOID Arg)
#else       //JOS F0̰ų NO JOS
LOCAL(VOID) SaveIniFile(LPVOID Tmr, LPVOID Arg)
#endif
    {
    BOOL FirstFg=TRUE;
    ENTRYDATAS   *Entry, *DelEntry;
    INISECTIONS  *Section, *DelSection;
    INIFILEDATAS *IniFile;
    LPSTR OutBuff;

    IniFile=(INIFILEDATAS*)Arg;
    if (IniFile->Sections==NULL) goto Ret;

    LockIniFile();

    if ((OutBuff=(LPSTR)AllocMem(INIFILESIZEMAX, MEMOWNER_SaveIniFile))==NULL) goto ProcExit;
    FillMem(OutBuff, INIFILESIZEMAX, 0xFF);     //Flash  ̱ 
    OutBuff[0]=0;

    if (IniFile->ChangedFg)
        {
        //Printf("SENSOR: Save Changed"CRLF);
        for (Section=IniFile->Sections; Section!=NULL; Section=Section->Next)
            {
            if (OutBuff!=NULL)
                {
                if (FirstFg==FALSE) WriteStrMem(OutBuff, CRLF); else FirstFg=FALSE;
                WriteStrMem(OutBuff, "[");
                WriteStrMem(OutBuff, Section->SectionName);
                WriteStrMem(OutBuff, "]"CRLF);
                }

            for (Entry=Section->Entrys; Entry!=NULL; Entry=Entry->Next)
                {
                if (OutBuff!=NULL)
                    {
                    WriteStrMem(OutBuff, Entry->EntryName);
                    WriteStrMem(OutBuff, "=");
                    WriteStrMem(OutBuff, Entry->Value);
                    WriteStrMem(OutBuff, CRLF);
                    }
                }
            }
        if (OutBuff) SaveFlash(OutBuff);
        }

    for (Section=IniFile->Sections; Section!=NULL;)
        {
        for (Entry=Section->Entrys; Entry!=NULL;)
            {
            DelEntry=Entry;
            Entry=Entry->Next;
            FreeMem(DelEntry->Value);
            FreeMem(DelEntry);
            }
        DelSection=Section;
        Section=Section->Next;
        FreeMem(DelSection);
        }

    IniFile->Sections=NULL;
    IniFile->ChangedFg=0;
    #ifndef JOS_VERSION
    IniFile->AccessTime=0;
    #endif
    Printf("SENSOR: Ini Closed"CRLF);

    //JOSTmrDel(JOS_TMR *pTmr); //ݹ鿡 Լ 

    ProcExit:                   // Ÿ̸Ӹ   INIFILEDATAS · ܵ
    UnlockIniFile();
    FreeMem(OutBuff);
    Ret:;
    }



//-----------------------------------------------------------------------------
//      Ini εմϴ
//-----------------------------------------------------------------------------
LOCAL(INIFILEDATAS*) LoadIniFile(LPCSTR IniMem)
    {
    UINT  FSize=INIFILESIZEMAX-1;
    #ifdef INIFILENAME
    HFILE hFile=HFILE_ERROR;
    #endif
    LPSTR lp, lpMem=NULL, InBuff;
    ENTRYDATAS   *Entry;
    INISECTIONS  *Section=NULL;
    INIFILEDATAS *IniFile=&IniFileDatas;

    #ifdef JOS_VERSION
    if (IniFile->SaveTmr==NULL) IniFile->SaveTmr=JOSTmrCreate(JOS_TMR_TICKS_PER_SEC*INISAVEHOLDTIME, JOS_TMR_OPT_ONE_SHOT, SaveIniFile, IniFile, NULL, NULL);
    #endif

    if (IniFile->Sections==NULL)
        {
        #ifdef INIFILENAME
        FSize=0;
        if ((hFile=_lopen(INIFILENAME, OF_READ))!=HFILE_ERROR) FSize=GetFileSize(hFile);
        #endif

        ALLOCMEM2(lpMem, INIVALUEMAX,
                  InBuff, (FSize+1),
                  MEMOWNER_LoadIniFile, ProcExit);

        #ifdef INIFILENAME
        if (hFile!=HFILE_ERROR && FSize>0) _lread(hFile, InBuff, FSize);
        #else
        CopyMem(InBuff, GetIniSavePtr(), FSize);
        #endif
        InBuff[FSize]=0;

        while (InBuff[0]!=0)
            {
            InBuff=(LPSTR)CatchStrOneLine(InBuff, lpMem, INIVALUEMAX);
            lp=GetStrLast(lpMem)-1;
            if (lpMem[0]=='[' && lp[0]==']')
                {
                lp[0]=0; DelCha(lpMem, 0);              //[] 
                lpMem[SECTIONNAEMEBUFFLEN-1]=0; //
                if ((Section=AddIniSection(&IniFile->Sections, lpMem))==NULL) break;
                }
            else{
                if (Section!=NULL)
                    {
                    if ((lp=SeparatStr(lpMem, '='))==NULL) continue;
                    if ((Entry=AddIniEntry(&Section->Entrys, lpMem))==NULL) break;
                    PutString(&Entry->Value, lp);
                    }
                }
            }
        }

    #ifdef JOS_VERSION
    JOSTmrStart(IniFile->SaveTmr);
    #else
    IniFile->AccessTime=GetTickCount();
    #endif

    ProcExit:
    #ifdef INIFILENAME
    if (hFile!=HFILE_ERROR) _lclose(hFile);
    #endif
    FreeMem(lpMem);
    return IniFile;
    }



//-----------------------------------------------------------------------------
//      IniϿ ־ Ǿȿ Ʈ Data 
//-----------------------------------------------------------------------------
int WINAPI GetPrivateProfileString(LPCSTR SectionName, LPCSTR EntryName, LPCSTR Default,
                                   LPSTR RetBuff, int RetBuffSize, LPCSTR IniFName)
    {
    int   Rslt=FALSE;
    INIFILEDATAS *IniFile;
    INISECTIONS  *Section;
    ENTRYDATAS   *Entry;

    LockIniFile();

    //Printf("GetIni [%s] %s '%s'"CRLF, SectionName, EntryName, IniFName);

    RetBuff[0]=0;
    if ((IniFile=LoadIniFile(IniFName))!=NULL)
        {
        for (Section=IniFile->Sections; Section!=NULL; Section=Section->Next)
            if (lstrcmp(Section->SectionName, SectionName)==0)
                {
                for (Entry=Section->Entrys; Entry!=NULL; Entry=Entry->Next)
                    if (lstrcmp(Entry->EntryName, EntryName)==0)
                        {
                        lstrcpyn(RetBuff, Entry->Value, RetBuffSize);
                        Rslt=TRUE;
                        break;
                        }
                break;
                }

        #ifdef JOS_VERSION
        JOSTmrStart(IniFile->SaveTmr);
        #else
        IniFile->AccessTime=GetTickCount();
        #endif
        }

    if (Rslt==FALSE) lstrcpyn(RetBuff, Default, RetBuffSize);

    UnlockIniFile();
    return lstrlen(RetBuff);
    }



//-----------------------------------------------------------------------------
//      IniϿ ־ Ǿȿ Ʈ ġData 
//-----------------------------------------------------------------------------
int WINAPI GetPrivateProfileInt(LPCSTR Section, LPCSTR Entry, int Default, LPCSTR IniFName)
    {
    CHAR Buff[20], Def[20];

    wsprintf(Def, Psnt1d, Default);
    GetPrivateProfileString(Section, Entry, Def, Buff, sizeof(Buff), IniFName);
    return AtoI(Buff, NULL);
    }



//-----------------------------------------------------------------------------
//      IniϿ ־ Ǿȿ Ʈ Data 
//-----------------------------------------------------------------------------
BOOL WINAPI WritePrivateProfileString(LPCSTR SectionName, LPCSTR EntryName, LPCSTR NewValue, LPCSTR IniFName)
    {
    int   Rslt=FALSE;
    INIFILEDATAS *IniFile;
    INISECTIONS  *Section;
    ENTRYDATAS   *Entry;

    LockIniFile();

    Printf("SENSOR: WriteIni [%s] %s '%s'"CRLF, SectionName, EntryName, NewValue);

    if ((IniFile=LoadIniFile(IniFName))!=NULL)
        {
        for (Section=IniFile->Sections; Section!=NULL; Section=Section->Next)
            if (lstrcmp(Section->SectionName, SectionName)==0) break;
        if (Section==NULL && (Section=AddIniSection(&IniFile->Sections, SectionName))==NULL) goto ProcExit;

        for (Entry=Section->Entrys; Entry!=NULL; Entry=Entry->Next)
            if (lstrcmp(Entry->EntryName, EntryName)==0) break;
        if (Entry==NULL && (Entry=AddIniEntry(&Section->Entrys, EntryName))==NULL) goto ProcExit;

        PutString(&Entry->Value, NewValue);

        IniFile->ChangedFg=1;
        #ifdef JOS_VERSION
        JOSTmrStart(IniFile->SaveTmr);
        #else
        IniFile->AccessTime=GetTickCount();
        #endif
        Rslt=TRUE;
        }

    ProcExit:
    UnlockIniFile();
    return Rslt;
    }



//-----------------------------------------------------------------------------
//       Ini   ϰ ĳ ޸𸮵 ع
//-----------------------------------------------------------------------------
VOID WINAPI FlushIniFile(VOID)
    {
    #ifdef JOS_VERSION
    if (IniFileDatas.ChangedFg!=0)
    #endif
        SaveIniFile(NULL, (LPVOID)&IniFileDatas);
    }



//-----------------------------------------------------------------------------
//        ð  ð  ڵ Flush
//      (main()   ȣ )
//-----------------------------------------------------------------------------
VOID WINAPI AutoFlushIniFile(VOID)
    {
    #ifndef JOS_VERSION
    if (IniFileDatas.AccessTime!=0 && GetTickCount()-IniFileDatas.AccessTime>=INISAVEHOLDTIME*1000)
        FlushIniFile();
    #endif
    }



//-----------------------------------------------------------------------------
//      Ini ü ǥ
//-----------------------------------------------------------------------------
VOID WINAPI PrintAllIniData(int PortNo, LPCSTR IniFName)
    {
    INIFILEDATAS *IniFile;
    INISECTIONS  *Section;
    ENTRYDATAS   *Entry;

    LockIniFile();

    if ((IniFile=LoadIniFile(IniFName))!=NULL)
        {
        for (Section=IniFile->Sections; Section!=NULL; Section=Section->Next)
            {
            PrintfII(PortNo, "[%s]"CRLF, Section->SectionName);
            for (Entry=Section->Entrys; Entry!=NULL; Entry=Entry->Next)
                {
                PrintfII(PortNo, "%s=", Entry->EntryName);
                UART_TxStrIT(PortNo, Entry->Value);     //Entry->Value û  쿡 
                PrintfII(PortNo, CRLF);
                }
            PrintfII(PortNo, CRLF);
            }
        #ifdef JOS_VERSION
        JOSTmrStart(IniFile->SaveTmr);
        #else
        IniFile->AccessTime=GetTickCount();
        #endif
        }

    UnlockIniFile();
    }




//-----------------------------------------------------------------------------
//      Ini  ͸ 
//-----------------------------------------------------------------------------
VOID WINAPI EraseAllIniData(VOID)
    {
    #ifdef INIFILENAME
    LockIniFile();
    DeleteFile(INIFILENAME);
    UnlockIniFile();
    #else
    LPSTR OutBuff;

    LockIniFile();
    if ((OutBuff=(LPSTR)AllocMem(INIFILESIZEMAX, MEMOWNER_EraseAllIniData))==NULL) goto ProcExit;

    FillMem(OutBuff, INIFILESIZEMAX, 0xFF);     //Flash  ̱ 
    OutBuff[0]=0;
    SaveFlash(OutBuff);

    ProcExit:
    FreeMem(OutBuff);
    UnlockIniFile();
    #endif
    }

