﻿///////////////////////////////////////////////////////////////////////////////
//          Cortex-M0 전용 JLIB
//
// Cortex-M7용과의 차이
//  ● 메모리 할당할 때 64K를 초과하는 블럭 할당 불가
//  ● M7에서는 JsprintfN()을 쓰는데, M0에서는 Jsprintf() 사용
///////////////////////////////////////////////////////////////////////////////

#include "JLIB.H"
#if INIFILE_EN
#include "INIDATA.H"
#endif


CHAR NullStr[]="";
CHAR Psnt1s[]="%s";
CHAR Psnt1d[]="%d";
CHAR Psnt2d[]="%d %d";
CHAR ConfigStr[]="Config";
CHAR CrLfStr[]=CRLF;
CHAR IniFileName[]="";

#define MAF_NOUSE       0
#define MAF_USE         1
#define MAF_LAST        2

#define MAH_SIGN        0x4D4A      //'MJ' 제어블럭검사

typedef struct MemAllocHeadStruc    //크기를 8Byte로 맞춤
    {
    WORD  Sign;
    WORD  Size;
    BYTE  Flag;
    BYTE  Dummy;
    WORD  OwnerID;                  //Buffer Overflow 일 때 이 구조체에서 가장 안전한 자리
    } MEMALLOCHEAD;

static UINT RamStartAdd;
static UINT RamUsingSize;
static UINT RamMaxUsedSize;

static CHAR WeekNameList[]="Sun\0Mon\0Tue\0Wed\0Thu\0Fri\0Sat";
static CHAR MonthNameList[]="Jan\0Feb\0Mar\0Apr\0May\0Jun\0Jul\0Aug\0Sep\0Oct\0Nov\0Dec";
VOID Printf(LPCSTR DispStr, ...);


#define MEMOWNER_PutString              1



//-----------------------------------------------------------------------------
//              메모리 블럭 초기화
//-----------------------------------------------------------------------------
LOCAL(VOID) SetMAH(MEMALLOCHEAD *MAH, int Owner, UINT BlkSize, BYTE Flag)
    {
    MAH->Sign=MAH_SIGN;
    MAH->OwnerID=Owner;
    MAH->Size=BlkSize;
    MAH->Flag=Flag;
    }



//-----------------------------------------------------------------------------
//              메모리 블럭 초기화
//-----------------------------------------------------------------------------
BOOL WINAPI MemAllocInit(UINT MemStart, UINT BlkSize)
    {
    RamStartAdd=(MemStart+15) & ~0xF;
    BlkSize-=RamStartAdd-MemStart;

    BlkSize&=~0xF;
    BlkSize-=sizeof(MEMALLOCHEAD);      //맨뒤 메모해 놓을 곳

    SetMAH((MEMALLOCHEAD*)RamStartAdd, 0, BlkSize, MAF_NOUSE);

    MemStart=RamStartAdd+BlkSize;
    SetMAH((MEMALLOCHEAD*)MemStart, 0, sizeof(MEMALLOCHEAD), MAF_LAST);

    return ((MEMALLOCHEAD*)MemStart)->Sign==MAH_SIGN &&
           ((MEMALLOCHEAD*)MemStart)->Flag==MAF_LAST;
    }




//-----------------------------------------------------------------------------
//              메모리 할당
//리턴값 0:OK
//       7:메모리 제어블럭 파괴
//       8:요구하는 크기의 메모리가 없다
//-----------------------------------------------------------------------------
LPVOID WINAPI AllocMem(DWORD ReqSize, UINT OwnerID)
    {
    int  Rslt;
    UINT Sz;
    LPVOID lpMem=NULL;
    MEMALLOCHEAD *MAH;
    #if OS_CRITICAL_METHOD==3
    OS_CPU_SR CpuSReg;
    #endif

    ReqSize+=7; ReqSize&=~7;        //8의 배수크기로 할당하게 하는 이유는 Ptr의 하위 3Bit가 0이 되도록 하기 위함 (오류포인터 확인에 사용)
    ReqSize+=sizeof(MEMALLOCHEAD);

    JOS_ENTER_CRITICAL();

    for (MAH=(MEMALLOCHEAD*)RamStartAdd; ;)
        {
        Sz=MAH->Size;
        if (MAH->Sign!=MAH_SIGN || Sz==0) {Printf("Mem=%X Broken"CRLF, MAH); Rslt=MA_BROKENMCB; break;}
        if (MAH->Flag==MAF_LAST) {Rslt=MA_INSUFFICIENT; break;}

        if (MAH->Flag==MAF_NOUSE && Sz>=ReqSize)
            {
            SetMAH(MAH, OwnerID, ReqSize, MAF_USE);
            //MAH->CurrPrio=OSPrioCur;
            Sz-=ReqSize;
            if (Sz>=sizeof(MEMALLOCHEAD)) SetMAH((MEMALLOCHEAD*)((LPBYTE)MAH+ReqSize), 0, Sz, MAF_NOUSE); //나머지 크기를 빈블럭으로 처리
            else MAH->Size=Sz+ReqSize;      //자른 후 나머지 크기가 sizeof(MEMALLOCHEAD)이 안되는 경우

            lpMem=(LPVOID)((LPBYTE)MAH+sizeof(MEMALLOCHEAD));
            Rslt=MA_OK;
            break;
            }
        MAH=(MEMALLOCHEAD*)((LPBYTE)MAH+Sz);
        }
    JOS_EXIT_CRITICAL();

    if (Rslt!=MA_OK) Printf("AllocMem(Req=%d, Owner=%d) %s"CRLF, ReqSize, OwnerID, Rslt==MA_BROKENMCB ? "Broken MCB":(Rslt==MA_INSUFFICIENT ? "Insufficient Memory":"Error"));
    else{
        //Printf("%d=AllocMem(%d, %d) Ok (Task=%d)"CRLF, Rslt, ReqSize, OwnerID);
        if ((RamUsingSize+=ReqSize)>RamMaxUsedSize) RamMaxUsedSize=RamUsingSize;
        }
    return lpMem;
    }



//-----------------------------------------------------------------------------
//              메모리 해재
//              cf<-1일때 ax=1:메모리 제어블럭 파괴
//                           2:주어진 메모리포인터 오류
//-----------------------------------------------------------------------------
int WINAPI FreeMem(LPCVOID lpMem)
    {
    int Rslt=MA_INVALIDPTR;
    UINT Sz;
    MEMALLOCHEAD *MAH, *MAH_NoUseStart;
    #if OS_CRITICAL_METHOD==3
    OS_CPU_SR CpuSReg;
    #endif

    if (lpMem==NULL) goto ProcExit;

    //제어블럭검사
    MAH=(MEMALLOCHEAD*)((LPBYTE)lpMem-sizeof(MEMALLOCHEAD));
    if (MAH->Sign!=MAH_SIGN || MAH->Flag!=MAF_USE) goto ProcExit;
    MAH->Flag=MAF_NOUSE;
    RamUsingSize-=MAH->Size;
    Rslt=MA_OK;

    //연속된 안쓰는 블럭은 하나로 합친다
    MAH_NoUseStart=NULL;

    JOS_ENTER_CRITICAL();
    for (MAH=(MEMALLOCHEAD*)RamStartAdd; ;)
        {
        Sz=MAH->Size;
        if (MAH->Sign!=MAH_SIGN || Sz==0) {Rslt=MA_BROKENMCB; break;}
        if (MAH->Flag==MAF_LAST) break;

        if (MAH->Flag!=MAF_NOUSE) MAH_NoUseStart=NULL;
        else{
            if (MAH_NoUseStart==NULL) MAH_NoUseStart=MAH;       //처음보는 사용안하는 블럭
            else{
                MAH->Sign=0;
                MAH_NoUseStart->Size+=Sz;
                }
            }
        MAH=(MEMALLOCHEAD*)((LPBYTE)MAH+Sz);
        }
    JOS_EXIT_CRITICAL();

    ProcExit:
    return Rslt;
    }



//-----------------------------------------------------------------------------
//              메모리 남은 용량 계산
//리턴값 0:OK
//       7:메모리 제어블럭 파괴
//       8:요구하는 크기의 메모리가 없다
//-----------------------------------------------------------------------------
UINT WINAPI GetMemFree(UINT *lpLargestBlkSize, int *lpRslt, int *BlkQty)
    {
    int  Rslt=MA_OK, Cnt=0;
    UINT MaxBlkSize, FreeSize, Sz;
    MEMALLOCHEAD *MAH;
    #if OS_CRITICAL_METHOD==3
    OS_CPU_SR CpuSReg;
    #endif

    JOS_ENTER_CRITICAL();

    MaxBlkSize=FreeSize=0;
    for (MAH=(MEMALLOCHEAD*)RamStartAdd; MAH->Flag!=MAF_LAST;)
        {
        Cnt++;
        Sz=MAH->Size;
        if (MAH->Sign!=MAH_SIGN || Sz==0) {Rslt=MA_BROKENMCB; break;}

        if (MAH->Flag==MAF_NOUSE)
            {
            FreeSize+=Sz;
            MaxBlkSize=UGetMax(MaxBlkSize, Sz);
            }
        MAH=(MEMALLOCHEAD*)((LPBYTE)MAH+Sz);
        }
    JOS_EXIT_CRITICAL();

    if (lpRslt!=NULL) *lpRslt=Rslt;
    if (lpLargestBlkSize!=NULL) *lpLargestBlkSize=MaxBlkSize;
    if (BlkQty!=NULL) *BlkQty=Cnt;
    return FreeSize;
    }




//-----------------------------------------------------------------------------
//      메모리 블럭을 Dump함
//-----------------------------------------------------------------------------
VOID WINAPI DispMemBlock(BOOL DispBlkFg)
    {
    UINT Sz, Cnt, Used, Free;
    MEMALLOCHEAD *MAH;

    Cnt=Used=Free=0;
    for (MAH=(MEMALLOCHEAD*)RamStartAdd; MAH->Flag!=MAF_LAST;)
        {
        Sz=MAH->Size;
        if (MAH->Sign!=MAH_SIGN || Sz==0) {Printf("%08X %d Owner=%3d Size=%d Broken"CRLF, MAH, MAH->Flag, Sz, MAH->OwnerID); break;}
        if (DispBlkFg) Printf("%08X %d Owner=%3d Size=%d"CRLF, MAH, MAH->Flag, MAH->OwnerID, Sz);
        if (MAH->Flag==MAF_NOUSE) Free+=Sz; else Used+=Sz;
        MAH=(MEMALLOCHEAD*)((LPBYTE)MAH+Sz);
        Cnt++;
        }
    Printf("Total Blocks = %u"CRLF
           "Free Size = %,u"CRLF
           "Use Size  = %,u"CRLF
           "Max Used  = %,u"CRLF, Cnt, Free, Used, RamMaxUsedSize); //RamUsingSize
    }



//-----------------------------------------------------------------------------
//      수치인지 알려줌
//-----------------------------------------------------------------------------
BOOL WINAPI IsNumeric(int Cha)
    {
    return Cha>='0' && Cha<='9';
    }



//-----------------------------------------------------------------------------
//      ASCII문자인지 알려줌
//-----------------------------------------------------------------------------
BOOL WINAPI IsAscii(int Cha)
    {
    return Cha>=' ' && Cha<=0x7F;
    }



//-----------------------------------------------------------------------------
//      ASCII문자인지 알려줌
//-----------------------------------------------------------------------------
int WINAPI CatchAscii(int Cha)
    {
    if (IsAscii(Cha)==FALSE) Cha=' ';
    return Cha;
    }



//-----------------------------------------------------------------------------
//      큰값 또는 작은값을 선택
//-----------------------------------------------------------------------------
int WINAPI GetMin(int A, int B)
    {
    return A<=B ? A:B;
    }

UINT WINAPI UGetMin(UINT A, UINT B)
    {
    return A<=B ? A:B;
    }

int WINAPI GetMax(int A, int B)
    {
    return A>=B ? A:B;
    }

int WINAPI GetAbs(int A)
    {
    return A>=0 ? A:-A;
    }

int WINAPI GetDiff(int A, int B)
    {
    if ((A-=B)<0) A=-A;
    return A;
    }

UINT WINAPI UGetDiff(UINT A, UINT B)
    {
    return (A>=B) ? A-B:B-A;
    }

UINT WINAPI UGetMax(UINT A, UINT B)
    {
    return A>=B ? A:B;
    }

int WINAPI Limit(int Value, int Min, int Max)
    {
    if (Value<Min) Value=Min;
    else if (Value>Max) Value=Max;
    return Value;
    }

int WINAPI DivRoundUp(int A, int B)
    {
    int Half;

    if ((Half=B>>1)<0) Half=-Half;
    if (A<0) Half=-Half;
    return (A+Half)/B;
    }




//-----------------------------------------------------------------------------
//      십진 문자열과 0x로 시작하는 Hex문자열을 수치로 변화함
//      NonStrLoc에는 수치가 아닌 문자열의 위치임
//-----------------------------------------------------------------------------
int WINAPI AtoI(LPCSTR Str, int *NonStrLoc)
    {
    int  Rslt, Sign, HexMode, NoErr, Cha, Cha2;
    LPCSTR lp;

    Rslt=Sign=HexMode=NoErr=0;
    lp=Str;
    for (;;)
        {
        Cha=*lp++;
        if (Cha>0 && Cha<=' ') continue;
        if (Cha=='+') break;
        if (Cha=='-') {Sign++; break;}
        if (Cha=='0')
            {
            Cha2=*lp++;
            if (Cha2=='x' || Cha2=='X') HexMode++; else lp-=2;
            }
        else lp--;
        break;
        }

    for (;;)
        {
        Cha=*lp++;
        if (Cha<'0') break;
        if (Cha<='9') {Cha-='0'; goto AddDigit;}
        if (HexMode==0) break;
        if (Cha<'A') break;
        if (Cha<='F') {Cha-='A'-10; goto AddDigit;}
        if (Cha<'a' || Cha>'f') break;
        Cha-='a'-10;

        AddDigit:
        NoErr=1;
        if (HexMode) Rslt<<=4;
        else{
            Rslt<<=1;
            Rslt+=Rslt<<2;      //*10
            }
        Rslt+=Cha;
        }

    if (NonStrLoc) *NonStrLoc=(NoErr) ? (int)(lp-Str)-1:0;
    if (Sign) Rslt=-Rslt;
    return Rslt;
    }



//-----------------------------------------------------------------------------
//      주어진 문자열에서 몇개를 떼어내서 숫자로 만듬
//-----------------------------------------------------------------------------
int WINAPI AtoIN(LPCSTR NumStr, int StrLen)
    {
    int Rslt=0;
    CHAR Cha;

    while (StrLen--)
        {
        Cha=*NumStr++;
        if (Cha<'0' || Cha>'9') break;

        Rslt<<=1;
        Rslt+=Rslt<<2;  //*10
        Rslt+=Cha-'0';
        }
    return Rslt;
    }



//-----------------------------------------------------------------------------
//      메모리에서 문자열 비교를 함
//-----------------------------------------------------------------------------
int WINAPI CompMemStr(LPCSTR Src, LPCSTR Find)
    {
    return CompMem(Src, Find, lstrlen(Find));
    }



//-----------------------------------------------------------------------------
//      Memory내용을 비교합니다 (같으면 0, 작으면 -1, 크면 1) (대소문자무시)
//      memicmp
//-----------------------------------------------------------------------------
int WINAPI CompMemI(LPCVOID Str1, LPCVOID Str2, UINT CompSize)
    {
    UINT Cha1, Cha2;
    BOOL Rslt=0;

    while (CompSize--)
        {
        Cha1=*(LPCBYTE)Str1; Str1=(LPCBYTE)Str1+1;
        Cha2=*(LPCBYTE)Str2; Str2=(LPCBYTE)Str2+1;
        if (Cha1>='a' && Cha1<='z') Cha1-=0x20;
        if (Cha2>='a' && Cha2<='z') Cha2-=0x20;
        if ((Rslt=Cha1-Cha2)!=0) break;
        }
    return Rslt;
    }



//-----------------------------------------------------------------------------
//      메모리에서 문자열 비교를 함
//-----------------------------------------------------------------------------
int WINAPI CompMemStrI(LPCSTR Src, LPCSTR Find)
    {
    return CompMemI(Src, Find, lstrlen(Find));
    }



//-----------------------------------------------------------------------------
//      모든 바이트가 0인지 체크해줍니다
//-----------------------------------------------------------------------------
BOOL WINAPI IsZeroMem(LPCVOID Mem, int ByteSize)
    {
    int I;

    for (I=0; I<ByteSize; I++) if (*((LPCBYTE)Mem+I)!=0) break;
    return I>=ByteSize;
    }



//-----------------------------------------------------------------------------
//      문자열을 정해진 Format으로 만들어 줍니다
//      %c, %d, %u, %s, %x, %X
//      %[-][,][#][0][width][.decimal]type
//
//      Test
//      ====
//      CHAR Buff[80];
//      Jsprintf(Buff, "%,X  %.4d   %.2d  %,d  %,.2d", 0x125679AF, 23, 123456789, 123456789, 123456789);
//      DispMsg(NULL, Buff);
//
//      Ver 2.02 2001/1/7 "%.01d" 소수점뒤에 0을 적으면 소숫점뒤에가 0이어도 표시함
//      Ver 2.03 2005/10/17 "%.02d" 에서 넣은 수치가 0일 경우 전에는 0으로 찍었으나 0.00 으로 찍음
//-----------------------------------------------------------------------------
VOID WINAPI Vsprintf(LPSTR DestBuff, LPCSTR FormatStr, va_list ArgList)
    {
    int    I, Width, CommaUnit, FractionUnit, Cha, ZeroFillCha, TypeCha;
    UINT   ArgValue;
    BOOL   LeftAlignFg, HexPrefixFg, FractionZFillFg;
    LPSTR  lp, lpD;
    LPCSTR lpS, lpPsntNextPtr;
    CHAR   Buff[20];

    lpS=FormatStr;
    lpD=DestBuff;

    while (1)
        {
        Cha=*lpS++;
        if (Cha!='%')
            {
            PassCha:
            *lpD++=Cha;
            if (Cha==0) break;
            }
        else{
            if (lpS[0]=='%') {lpS++; goto PassCha;}     //'%%'는 %의 일반 문자로 취급
            lpPsntNextPtr=lpS;
            Width=0;
            LeftAlignFg=0;
            HexPrefixFg=0;
            FractionUnit=0;
            CommaUnit=0;
            FractionZFillFg=0;
            ZeroFillCha=' ';

            while (1)
                {
                Cha=*lpS++;
                if (Cha=='-') LeftAlignFg=1;
                else if (Cha==',') CommaUnit=3;
                else if (Cha=='#') HexPrefixFg=1;
                else if (Cha=='0') ZeroFillCha='0';
                else if (Cha>='1' && Cha<='9')
                    {
                    lpS--;
                    Width=AtoI(lpS, &I); lpS+=I;
                    }
                else if (Cha=='.')
                    {
                    if (lpS[0]=='0') FractionZFillFg=1;
                    FractionUnit=-AtoI(lpS, &I); lpS+=I;
                    }
                else{
                    TypeCha=Cha;
                    ArgValue=va_arg(ArgList, UINT);
                    if (Cha=='c')               //%c
                        {
                        Buff[0]=(BYTE)ArgValue; Buff[1]=0;
                        lp=Buff;

                        PutStr:
                        if (LeftAlignFg!=0)     //'-'가 있으면 왼쪽정렬임
                            {
                            I=0;
                            while ((Cha=*lp++)!=0) {*lpD++=Cha; I++;}
                            for (; I<Width; I++) *lpD++=' ';
                            }
                        else{                   //오른쪽 정렬 처리
                            if (Width!=0)
                                {
                                Width-=lstrlen(lp);
                                while (Width>0) {*lpD++=ZeroFillCha; Width--;}
                                }
                            while ((Cha=*lp++)!=0) *lpD++=Cha;
                            }
                        break;
                        }
                    else if (Cha=='s')          //%s
                        {
                        lp=(LPSTR)ArgValue;
                        goto PutStr;
                        }
                    else if (Cha=='x' || Cha=='X')      //%x, %X
                        {
                        int HexChaOfs;

                        I=0;                            //자릿수 카운터
                        HexChaOfs=(TypeCha=='x') ? 'a'-10:'A'-10;
                        lp=Buff+sizeof(Buff)-1; lp[0]=0;

                        do  {
                            Cha=ArgValue & 0x0F; ArgValue>>=4;
                            if (Cha<=9) Cha+='0'; else Cha+=HexChaOfs;
                            if (CommaUnit!=0 && I!=0 && (I&3)==0) *--lp=',';
                            *--lp=Cha;
                            I++;
                            } while (ArgValue!=0);

                        if (HexPrefixFg!=0)
                            {
                            *--lp='x';
                            *--lp='0';
                            }
                        goto PutStr;
                        }
                    else if (Cha=='d' || Cha=='u')      //%d, %u
                        {
                        int  OrgValue;          //이것은 반드시 int로 해야 함
                        BOOL FirstFg=1;

                        OrgValue=ArgValue;
                        if (TypeCha=='d' && OrgValue<0) ArgValue=-ArgValue;
                        lp=Buff+sizeof(Buff)-1; lp[0]=0;

                        if (FractionZFillFg==0 && ArgValue==0) {*--lp='0'; goto PutStr;}

                        do  {
                            Cha=(ArgValue%10)+'0';
                            ArgValue/=10;
                            if (FractionUnit>=0)
                                {
                                if (CommaUnit!=0 && FractionUnit!=0 && (FractionUnit%CommaUnit)==0) *--lp=',';
                                *--lp=Cha;
                                }
                            else{
                                if (FractionZFillFg!=0 || Cha!='0' || FirstFg==0 || ArgValue==0)
                                    {
                                    FirstFg=0;
                                    *--lp=Cha;
                                    if (FractionUnit+1==0) *--lp='.';
                                    }
                                }
                            FractionUnit++;
                            } while (ArgValue!=0);

                        if (FractionUnit<0)
                            {
                            while (FractionUnit<0) {*--lp='0'; FractionUnit++;}

                            *--lp='.';
                            }
                        if (FractionUnit==0) *--lp='0';
                        if (TypeCha=='d' && OrgValue<0) *--lp='-';
                        goto PutStr;
                        }
                    else{
                        lpS=lpPsntNextPtr;      //처리하지 않는 '%' Type이면 그대로 표시
                        //ArgList--;            //뒤로 돌아가는 기능 못찾음
                        Cha='%';
                        goto PassCha;
                        }
                    }
                } //while (*lpS++)
            } //'%' 처리
        } //while (1)
    }



VOID Jsprintf(LPSTR DestBuff, LPCSTR FormatStr, ...)
    {
    va_list VL;

    va_start(VL, FormatStr);
    Vsprintf(DestBuff, FormatStr, VL);
    va_end(VL);
    }



//-----------------------------------------------------------------------------
//              공백을 Skip함
//-----------------------------------------------------------------------------
LPCSTR WINAPI SkipSpace(LPCSTR lp)
    {
    int Cha;

    for (;;)
        {
        Cha=*(LPCBYTE)lp;
        if (Cha==0 || Cha>' ') break;
        lp++;
        }
    return lp;
    }



//-----------------------------------------------------------------------------
//      String에서 %d, %s, %c, %x를 처리하여 뽑아줍니다
//      %u=%d, %X=%x 같이 처리함
//      %.3d 은 소수점이하 세자리까지 정수로 읽음 (*1000을 하라는 뜻)
//      두 String이 일치하면 True를 리턴합니다

//Test:
//    int  I1, I2, I3, I4, H;
//    CHAR Cha, Str[40], Buff[80];
//    I=Jsscanf("TestStr: 5% +1234 -1234 12.3456 123 AF90 \"This Is Str\" J %z EOF",
//            "TestStr: 5%% %u %d %.2d %.3d %X %s %c %z EOF",
//            &I1, &I2, &I3, &I4, &H, Str, &Cha);
//
//    wsprintfA(Buff, "(Rslt=%d) I1=%d I2=%d I3=%d I4=%d H=%X Str=[%s] Cha=[%c]",
//                    I, I1, I2, I3, I4, H, Str, Cha);
//    DebugFile(Buff); //=> (Rslt=1) I1=1234 I2=-1234 I3=1235 I4=123000 H=AF90 Str=[This Is Str] Cha=[J]
//-----------------------------------------------------------------------------
BOOL Jsscanf(LPCSTR SourceStr, LPCSTR FormatStr, ...)
    {
    int  I, DecimalPt;
    BYTE Cha, SCha,FCha;
    LPCSTR FormatStrBkup, SourceStrBkup;
    LPVOID *lpArg;

    lpArg=(LPVOID*)&FormatStr+1;
    for (;;)
        {
        SCha=*SourceStr++;
        FCha=*FormatStr++;
        if (SCha==0 || FCha==0) break;

        if (FCha=='%')
            {
            SourceStrBkup=SourceStr;
            FormatStrBkup=FormatStr;
            FCha=*FormatStr++;
            if (FCha!='%')      //%%는 %문자 하나로
                {
                DecimalPt=0;
                if (FCha=='.')
                    {
                    DecimalPt=AtoI(FormatStr, &I);
                    FormatStr+=I;
                    FCha=*FormatStr++;
                    }

                if (FCha=='c')                          //'%c'
                    {
                    *(LPBYTE)(*lpArg++)=SCha;
                    continue;
                    }
                else if (FCha=='d' || FCha=='u')        //'%d', '%u'
                    {
                    int Val=0, NumbSignFg, ExistDcmlPtFg, HalfRiseFg, ValidFg;

                    NumbSignFg=ExistDcmlPtFg=HalfRiseFg=ValidFg=0;

                    if (SCha=='-') NumbSignFg++;
                    else if (SCha!='+') SourceStr--;

                    for (;;)
                        {
                        Cha=*SourceStr++;
                        if (Cha=='.')
                            {
                            if (ExistDcmlPtFg) break;   //두번째로 소숫점이 나오는 경우 숫자문자열 종료로 처리
                            ExistDcmlPtFg++;
                            continue;
                            }
                        Cha-='0';
                        if (Cha>9) break;               //숫자문자열 종료
                        ValidFg++;
                        if (ExistDcmlPtFg)
                            {
                            if (DecimalPt==0)           //지정한 유효숫자 이후
                                {
                                if (HalfRiseFg==0)
                                    {
                                    HalfRiseFg++;
                                    if (Cha>=5) Val++;
                                    }
                                continue;
                                }
                            DecimalPt--;
                            }
                        Val<<=1; Val+=Val<<2; Val+=Cha; //Val=Val*10+Cha
                        }

                    if (ValidFg)
                        {
                        SourceStr--;
                        while (DecimalPt!=0) {Val<<=1; Val+=Val<<2; DecimalPt--;}
                        if (NumbSignFg) Val=-Val;
                        *(int*)(*lpArg++)=Val;
                        continue;
                        }

                    //유효한 수자문자가 하나도 없으면 일반 문자열로 처리
                    SourceStr=SourceStrBkup;
                    FormatStr=FormatStrBkup;
                    }
                else if (FCha=='x' || FCha=='X')        //'%x', '%X'
                    {
                    int Val, ValidFg;

                    Val=ValidFg=0;
                    SourceStr--;
                    for (;;)
                        {
                        Cha=*SourceStr++;
                        if (Cha<'0') break;
                        if (Cha<='9') {Cha-='0'; goto AddDigit;}
                        if (Cha<'A') break;
                        if (Cha<='F') {Cha-='A'-10; goto AddDigit;}
                        if (Cha<'a' || Cha>'f') break;
                        Cha-='a'-10;
                        AddDigit:
                        ValidFg++;
                        Val<<=4; Val|=Cha;
                        }

                    if (ValidFg)
                        {
                        SourceStr--;
                        *(UINT*)(*lpArg++)=Val;
                        continue;
                        }

                    //유효한 수자문자가 하나도 없으면 일만 문자열로 처리
                    SourceStr=SourceStrBkup;
                    FormatStr=FormatStrBkup;
                    }
                else if (FCha=='s')             //'%s'
                    {
                    LPSTR lpD;

                    lpD=(LPSTR)(*lpArg++);
                    if (SCha!='\'' && SCha!='"')
                        {
                        SourceStr--;
                        SCha=0;         //0:처음부터 String, 이때는 다음 Space나 Tab문자까지 읽는다
                        }
                    for (;;)
                        {
                        Cha=*SourceStr++;
                        if (Cha==0) {SourceStr--; break;}
                        if (SCha!=0)
                            {
                            if (Cha==SCha) break;
                            }
                        else{
                            if (Cha<=' ') {SourceStr--; break;}
                            }
                        *lpD++=Cha;
                        }
                    *lpD=0;
                    continue;
                    }
                else{
                    FormatStr=FormatStrBkup;
                    FCha='%';
                    }
                }
            }

        //1개 이상의 Space나 Tab은 모두 하나의 Space로 비교한다
        if (SCha<=' ') {SourceStr=SkipSpace(SourceStr); SCha=' ';}
        if (FCha<=' ') {FormatStr=SkipSpace(FormatStr); FCha=' ';}
        if (SCha!=FCha) break;
        }
    return (SCha|FCha)==0;      //SCha과 FCha모두 0이면 두 String이 일치함을 의미함
    }




//-----------------------------------------------------------------------------
//      Hex문자열을 수치로 변화함
//      NonStrLoc에는 Hex가 아닌 문자열의 위치임
//-----------------------------------------------------------------------------
DWORD WINAPI AtoH(LPCSTR String, int *NonStrLoc)
    {
    BOOL   NoErr;
    DWORD  Rslt;
    CHAR   Cha;
    LPCSTR lp;

    Rslt=NoErr=0;
    lp=SkipSpace(String);
    for (;;)
        {
        Cha=*lp++;
        if (Cha<'0') break;
        if (Cha<='9') {Cha-='0'; goto AddDigit;}
        if (Cha<'A') break;
        if (Cha<='F') {Cha-='A'-10; goto AddDigit;}
        if (Cha<'a' || Cha>'f') break;
        Cha-='a'-10;

        AddDigit:
        NoErr=1;
        Rslt<<=4;
        Rslt+=Cha;
        }

    if (NonStrLoc) *NonStrLoc=(NoErr) ? (int)(lp-String)-1:0;
    return Rslt;
    }



//-----------------------------------------------------------------------------
//      Hex문자열을 수치로 변화함
//-----------------------------------------------------------------------------
DWORD WINAPI AtoHN(LPCSTR Str, int StrLen)
    {
    DWORD  Rslt=0;
    int   Cha;

    while (StrLen--)
        {
        Cha=*Str++;
        if (Cha<'0') break;
        if (Cha<='9') {Cha-='0'; goto AddDigit;}
        if (Cha<'A') break;
        if (Cha<='F') {Cha-='A'-10; goto AddDigit;}
        if (Cha<'a' || Cha>'f') break;
        Cha-='a'-10;

        AddDigit:
        Rslt<<=4;
        Rslt+=Cha;
        }
    return Rslt;
    }



//-----------------------------------------------------------------------------
//      Str맨 뒤(NULL문자위치)를 줍니다
//-----------------------------------------------------------------------------
LPSTR WINAPI GetStrLast(LPSTR Str)
    {
    return lstrlen(Str)+Str;
    }



//-----------------------------------------------------------------------------
//      String에 Cha를 더한다
//-----------------------------------------------------------------------------
VOID WINAPI AddCha(LPSTR Str, int Cha)
    {
    int I;

    I=lstrlen(Str);
    Str[I]=Cha;
    Str[I+1]=0;
    }



int WINAPI UpCaseCha(int Cha)
    {
    if (Cha>='a' && Cha<='z') Cha-=0x20;
    return Cha;
    }



//-----------------------------------------------------------------------------
//      주어진 문자열을 대문자로 바꾼다 (옛이름 UpcaseStr)
//-----------------------------------------------------------------------------
VOID WINAPI CharUpper(LPSTR Str)
    {
    int Ch;

    while ((Ch=*(LPCBYTE)Str)!=0)
        {
        if (Ch>='a' && Ch<='z') Str[0]=Ch-0x20;
        Str++;
        }
    }




//-----------------------------------------------------------------------------
//      주어진 길이 문자열을 소문자로 변환
//-----------------------------------------------------------------------------
int WINAPI CharLowerBuff(LPSTR Str, int Len)
    {
    int Cnt=0, Cha;

    while (Len--)
        {
        Cha=*(LPCBYTE)Str;
        if (Cha==0) break;
        if (Cha>='A' && Cha<='Z') Str+=0x20;        //원래는 다른나라 문자도 처리해야 함
        Str++;
        Cnt++;
        }
    return Cnt;
    }



//-----------------------------------------------------------------------------
//      버퍼크기 보다 큰 문자열은 잘라서 넣음
//-----------------------------------------------------------------------------
LPSTR WINAPI lstrcpyn(LPSTR Dest, LPCSTR Src, UINT BuffSize)
    {
    int CopyLen;

    if ((CopyLen=GetMin(lstrlen(Src), BuffSize-1))>0)
        CopyMem(Dest, Src, CopyLen);

    Dest[CopyLen]=0;
    return Dest;
    }



//-----------------------------------------------------------------------------
//      주어진 String의 앞뒤의 공백을 제거해준다 (Trim)
//-----------------------------------------------------------------------------
VOID WINAPI CleanupStr(LPSTR String)
    {
    BYTE Byt;
    LPSTR lp;

    //맨뒤의 공백 제거
    for (lp=GetStrLast(String)-1; lp>=String; lp--)
        {
        if (*(LPCBYTE)lp>0x20) break;
        lp[0]=0;
        }

    //앞의 공백 제거
    for (lp=String; ;lp++)
        {
        Byt=*(LPCBYTE)lp;
        if (Byt==0 || Byt>' ') break;
        }
    if (lp>String) lstrcpy(String, lp);
    }



//-----------------------------------------------------------------------------
//      다음 단어의 위치를 줍니다 (공백이나 TAB기준)
//      현재단어와 공백을 지나 다음 단어의 위치를 줍니다
//      현재위치가 공백이면 바로 다음 나오는 단어
//      '나 "로 묶인경우 하나의 단어로 인식합니다
//-----------------------------------------------------------------------------
LPCSTR WINAPI NextWord(LPCSTR lp, int WordCnt)
    {
    int Cha, FirstCha;

    for (;;)
        {
        lp=SkipSpace(lp);       //공백스킵
        FirstCha=lp[0];
        if (FirstCha==0 || WordCnt==0) break;
        WordCnt--;

        if (FirstCha==0x27 || FirstCha==0x22) lp++;     //"'", '"'
        else FirstCha=0;

        for (;;)                        //단어스킵
            {
            Cha=*(LPCBYTE)lp++;
            if (Cha==0) {lp--; break;}
            if (FirstCha!=0)
                {
                if (FirstCha==Cha) break;
                }
            else{
                if (Cha<=' ') {lp--; break;}
                }
            }
        }
    return lp;
    }



int WINAPI SearchCha(LPCSTR SourceStr, int SrchCha)
    {
    LPCSTR lp;
    return (lp=strchr(SourceStr, SrchCha))!=NULL ? lp-SourceStr:-1;
    }



//-----------------------------------------------------------------------------
//      메모리에서 Byte를 찾음
//-----------------------------------------------------------------------------
int WINAPI SearchMemByte(LPCVOID Mem, int MemSize, int FindByte)
    {
    int I, Find=-1;

    for (I=0; I<MemSize; I++)
        {
        if (*((LPCBYTE)Mem+I)==FindByte) {Find=I; break;}
        }
    return Find;
    }



//-----------------------------------------------------------------------------
//      ','를 기준으로 원하는 번호의 단어 위치를 리턴
//-----------------------------------------------------------------------------
LPCSTR WINAPI NextCommaWord(LPCSTR lp, int WordNo)
    {
    int I;

    lp=SkipSpace(lp);   //공백스킵
    for (;;)
        {
        if (WordNo==0) break;
        if (lp[0]==0) break;
        if ((I=SearchCha(lp, ','))<0) I=lstrlen(lp)-1;
        lp+=I+1;
        WordNo--;
        }
    return lp;
    }



//-----------------------------------------------------------------------------
//      문자열을 분리합니다 (분리문자 다음의 문자열을 줌)
//-----------------------------------------------------------------------------
LPSTR WINAPI SeparatStr(LPSTR String, int SepCha)
    {
    int I;
    if ((I=SearchCha(String, SepCha))<0) return NULL;
    String[I]=0;
    return String+I+1;
    }



//------------------------------------------------------------------------------
//      문자열을 분리합니다 (분리문자열 다음의 문자열을 줌)
//------------------------------------------------------------------------------
LPSTR WINAPI SeparatStrStr(LPSTR Str, LPCSTR SepStr)
    {
    int I;

    if ((I=SearchStr(Str, SepStr))<0) return NULL;
    Str[I]=0;
    return lstrlen(SepStr)+Str+I;
    }



//-----------------------------------------------------------------------------
//      구문자까지의 문자열을 떼어주고 구분자 다음 위치를 리턴함
//      strtok()나 SeparatStr()는 원문을 변경하지만 이 함수는 원문을 훼손하지 않음
//      이전이름 CatchWord()
//      사용예: CatchToken("TE;HU;ANALOG", ';', Buff, sizeof(Buff));
//-----------------------------------------------------------------------------
LPCSTR WINAPI CatchToken(LPCSTR Str, int SepCha, LPSTR Buff, int BuffLen)
    {
    int Find;

    if ((Find=SearchCha(Str, SepCha))<0) Find=lstrlen(Str);
    lstrcpyn(Buff, Str, GetMin(Find+1, BuffLen));
    if (Str[Find]!=0) Find++;
    return Str+Find;
    }



//-----------------------------------------------------------------------------
//      주어진 문자열에서 원하는 길이만큼 끊어줌
//-----------------------------------------------------------------------------
VOID WINAPI SubStr(LPSTR Buff, int BuffSize, LPCSTR Src, int ReqLen)
    {
    lstrcpyn(Buff, Src, GetMin(ReqLen+1, BuffSize));
    }



//-----------------------------------------------------------------------------
//      주어진 스트링에서 주어진 문자를 모두 삭제한다
//-----------------------------------------------------------------------------
VOID WINAPI DelAllCha(LPSTR String, int DelCha)
    {
    int Cha;
    LPSTR lpDest=String;

    if (DelCha!=0)
        for (;;)
            {
            Cha=*(LPCBYTE)String++;
            if (Cha!=DelCha)
                {
                *lpDest++=Cha;
                if (Cha==0) break;
                }
            }
    }



//-----------------------------------------------------------------------------
//      문자열의 주어진 위치의 문자를 지운다
//-----------------------------------------------------------------------------
VOID WINAPI DelCha(LPSTR String, int DelLoc)
    {
    if (lstrlen(String)>DelLoc)
        {
        String+=DelLoc;
        lstrcpy(String, String+1);
        }
    }



//-----------------------------------------------------------------------------
//      주어진 문자열의 마지막 문자를 줌
//-----------------------------------------------------------------------------
int WINAPI GetLastChar(LPCSTR Str)
    {
    int I;

    if ((I=lstrlen(Str))>0) I=Str[I-1];
    return I;
    }



//-----------------------------------------------------------------------------
//      인용부호를 제거함 (StripQuotationMark)
//-----------------------------------------------------------------------------
VOID WINAPI StripQuoteSign(LPSTR Buff)
    {
    int Cha, Len;

    Cha=Buff[0];
    if (Cha=='\'' || Cha=='\"')
        {
        DelCha(Buff, 0);
        if ((Len=lstrlen(Buff)-1)>=0)
            {
            if (Buff[Len]==Cha) Buff[Len]=0;
            }
        }
    }




int WINAPI SearchStr(LPCSTR SourceStr, LPCSTR SrchStr)
    {
    LPCSTR lp;
    return (lp=strstr(SourceStr, SrchStr))!=NULL ? lp-SourceStr:-1;
    }




//-----------------------------------------------------------------------------
//      내 방식의 8Bit 체크썸을 구합니다
//-----------------------------------------------------------------------------
int WINAPI GetJ8ChkSum(LPCBYTE lpMem, UINT Size)
    {
    int LfnSum=0;

    while (Size--)
        {
        //ror LfnSum,1
        if (LfnSum & 1)
            {
            LfnSum>>=1;
            LfnSum^=0xA5;
            }
        else LfnSum>>=1;

        LfnSum+=*lpMem++;
        }

    return LfnSum & 0xFF;
    }




//-----------------------------------------------------------------------------
//      ?VAR1=DATA1&VAR2=DATA2, name=정오장&age=35
//-----------------------------------------------------------------------------
BOOL WINAPI GetUrlVarText(LPCSTR WebArgList, LPCSTR VarName, LPSTR DataBuff, int BuffSize)
    {
    BOOL Rslt=FALSE;
    int   Len, NextPos;

    DataBuff[0]=0;
    Len=lstrlen(VarName);
    while (WebArgList[0]!=0)
        {
        if (lstrlen(WebArgList)<=Len) break;
        NextPos=SearchCha(WebArgList, '&');
        if (WebArgList[Len]=='=' && CompareMem(WebArgList, VarName, Len)==0)
            {
            if (NextPos>=0) BuffSize=GetMin(BuffSize, NextPos-Len);
            lstrcpyn(DataBuff, WebArgList+Len+1, BuffSize);
            Rslt++;
            break;
            }
        if (NextPos<0) break;
        WebArgList+=NextPos+1;
        }
    return Rslt;
    }


int WINAPI GetUrlVarInt(LPCSTR WebArgList, LPCSTR VarName)
    {
    CHAR Buff[16];
    GetUrlVarText(WebArgList, VarName, Buff, sizeof(Buff));
    return AtoI(Buff, NULL);
    }




//-----------------------------------------------------------------------------
//      Null문자열(환경문자열처럼)에서 주어진 위치의 문자열을 줌
//-----------------------------------------------------------------------------
LPCSTR WINAPI GetToken(LPCSTR TokenList, int TokenNo)
    {
    while (TokenList[0]!=0)
        {
        if (TokenNo==0) break;
        TokenList+=lstrlen(TokenList)+1;
        TokenNo--;
        }
    return TokenList;
    }




//-----------------------------------------------------------------------------
//      호스트주소의 기본포트가 다르면 뒤에 붙임
//-----------------------------------------------------------------------------
VOID WINAPI AddPortIfNoDef(LPSTR HostAdd, int ToAddPortNo, int DefPortNo)
    {
    if (ToAddPortNo!=DefPortNo) wsprintf(GetStrLast(HostAdd), ":%d", ToAddPortNo);
    }




//-----------------------------------------------------------------------------
//      Url을 HostAddr과 Host파일로 분리합니다
//      리턴값은 lpHostAdd에서 호스트 파일 Path의 Ptr임
//예)   http://www.abcd.com:120/root/abcd.htm
//    =>lpHostAdd<=www.abcd.com
//      PortNo<=120
//      RetValue=root/abcd.htm
//-----------------------------------------------------------------------------
LPSTR WINAPI SeparateUrl(LPCSTR SrcUrl, LPSTR lpHostAdd, int *PortNo, int DefPortNo)
    {
    int I;
    LPSTR lp, lpHostFName, HostAdd;

    I=SearchStr(SrcUrl, "://");
    HostAdd=(I!=-1) ? (LPSTR)SrcUrl+I+3:(LPSTR)SrcUrl;

    if ((I=SearchCha(HostAdd, '/'))<0)
        {
        lstrcpy(lpHostAdd, HostAdd);
        lpHostFName=NULL;
        }
    else{
        lstrcpyn(lpHostAdd, HostAdd, I+1);
        lpHostFName=HostAdd+I+1;
        }

    *PortNo=DefPortNo;
    if ((lp=SeparatStr(lpHostAdd, ':'))!=NULL) *PortNo=AtoI(lp, NULL);

    return lpHostFName;
    }




//-----------------------------------------------------------------------------
//      Url을 HostAddr과 Host파일로 분리합니다
//      리턴값은 lpHostAdd에서 호스트 파일 Path의 Ptr임
//예)   http://www.abcd.com:120/root/abcd.htm
//    =>lpHostAdd<=www.abcd.com
//      PortNo<=120
//      RetValue=/root/abcd.htm
//-----------------------------------------------------------------------------
LPCSTR WINAPI SeparateUrlEx(LPCSTR SrcUrl, LPSTR lpHostAdd, int *PortNo, int DefPortNo)
    {
    int I;
    LPSTR lp, HostAdd;
    LPCSTR lpHostFName;

    I=SearchStr(SrcUrl, "://");
    HostAdd=(I!=-1) ? (LPSTR)SrcUrl+I+3:(LPSTR)SrcUrl;

    if ((I=SearchCha(HostAdd, '/'))<0)
        {
        lstrcpy(lpHostAdd, HostAdd);
        lpHostFName="/";
        }
    else{
        lstrcpyn(lpHostAdd, HostAdd, I+1);
        lpHostFName=HostAdd+I;
        }

    *PortNo=DefPortNo;
    if ((lp=SeparatStr(lpHostAdd, ':'))!=NULL) *PortNo=AtoI(lp, NULL);

    return lpHostFName;
    }



//-----------------------------------------------------------------------------
//      A*B/C 값을 리턴함, 나눌 때 반올림처리함
//-----------------------------------------------------------------------------
UINT WINAPI UMulDiv(UINT A, UINT B, UINT C)
    {
    return (UINT)(((UINT64)A*B+(C>>1))/C);
    }



//-----------------------------------------------------------------------------
//      2개의 Hex문자를 값으로 변경
//-----------------------------------------------------------------------------
DWORD WINAPI Hex2Int(LPCSTR StrBuff, int ChaQty)
    {
    int I, Cha;
    DWORD Dw=0;

    for (I=0; I<ChaQty; I++)
        {
        Cha=*StrBuff++;
        if (Cha>='0' && Cha<='9') Cha-='0';
        else if (Cha>='A' && Cha<='F') Cha-='A'-10;
        else if (Cha>='a' && Cha<='f') Cha-='a'-10;
        else break;

        Dw<<=4;
        Dw|=Cha;
        }
    return Dw;
    }



//-----------------------------------------------------------------------------
//              문자열 입력 (길이문자열)
//          Out al= 0:1byte문자, 1:2byte문자 첫번째, 2:2byte문자 두번째
//-----------------------------------------------------------------------------
int WINAPI Check2byteCha(LPCSTR Str, int ChkLoc)
    {
    BYTE Cha, HangulFirst=0;
    int I, Rslt;

    for (I=Rslt=0; ;I++)
        {
        if ((Cha=*(LPCBYTE)Str++)==0) break;

        if (I>=ChkLoc)
            {
            if (HangulFirst!=0) Rslt=2;             //2byte문자 두번째 Byte
            else                Rslt=(Cha>=0x80);   //1:2byte문자 첫번째/ 0:1byte문자
            break;
            }

        if (HangulFirst!=0) HangulFirst=0;
        else if (Cha>=0x80) HangulFirst=1;
        }
    return Rslt;
    }



//-----------------------------------------------------------------------------
//      2월의 날수를 구합니다
//-----------------------------------------------------------------------------
int WINAPI GetMonthLastDay(int Year, int Month)
    {
    int LastDay;
    static BYTE LastDays[]={31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

    if (Month!=2) LastDay=LastDays[Month-1];
    else          LastDay=(Year % 400)==0 || ((Year % 100)!=0 && (Year & 3)==0) ? 29:28;
    return LastDay;
    }




//-----------------------------------------------------------------------------
//      주어진 년월일까지의 총 날자수를 구합니다 (0000년 1월 1일부터)
//
//      Year * (365*400+100-4+1) / 400 => Year*146097/400
//      이렇게 정리해서 쓰면 2020-12-31의 총일수와 2021-1-1의 총일수가 같아짐 (심각한 버그임)
//-----------------------------------------------------------------------------
TDATE WINAPI GetTotalDays(int Year, int Month, int Day)
    {
    int I;

    for (I=1; I<Month; I++) Day+=GetMonthLastDay(Year, I);

    if (Year>0)
        {
        Year--;
        Day+=Year*365 + (Year>>2) - Year/100 + Year/400;
        }
    return Day;
    }



int WINAPI GetWeek(int Year, int Month, int Day)
    {
    return GetTotalDays(Year, Month, Day) % 7;
    }




//-----------------------------------------------------------------------------
//      총일수를 년월일로 바꿉니다
//-----------------------------------------------------------------------------
#define YEAR1DAYS       365
#define YEAR4DAYS       1461
#define YEAR100DAYS     36524
#define YEAR400DAYS     146097
VOID WINAPI CnvFromTotalDay(TDATE TotalDays, int *lpYear, int *lpMonth, int *lpDay)
    {
    int Y,M, LDays;

    #if 1
    //A방식
    Y=(TotalDays*400/YEAR400DAYS)+1;    //T=Y*365+Y/4-Y/100+Y/400 => Y=T*400/(365*400+100-4+1)
    TotalDays-=GetTotalDays(Y, 0, 0);
    #else
    //B방식 - A방식으로도 아래처럼 보정하면 3000년까지 문제가 없어서 계산식이 간단한 A방식 선택함
    Y=DivMod(TotalDays, YEAR400DAYS, (int*)&TotalDays)*400+1;
    D=GetMin(DivMod(TotalDays, YEAR100DAYS, &Remain), 3); Y+=D*100;         //3으로 제한하는 하는 이유는 400년에 1일 추가되었기에 146096일 경우 4가 나옴
    TotalDays-=D*YEAR100DAYS;
    Y+=DivMod(TotalDays, YEAR4DAYS, (int*)&TotalDays)*4;
    Y+=D=GetMin(DivMod(TotalDays, YEAR1DAYS, &Remain), 3);                  //3으로 제한하는 하는 이유는 4년에 1일 추가되었기에 1460일 경우 4가 나옴
    TotalDays-=D*YEAR1DAYS;
    #endif

    if (TotalDays==0) {Y--; M=12; TotalDays=31;}    //2021-06-10 추가
    else{
        for (M=1; M<=12; M++)
            {
            LDays=GetMonthLastDay(Y, M);
            if (TotalDays<=LDays) break;
            TotalDays-=LDays;
            }
        if (M>12) {Y++; M=1;}                       //2021-06-10 A방식으로 인한 오류수정
        }

    *lpYear=Y;
    *lpMonth=M;
    *lpDay=TotalDays;
    }




//-----------------------------------------------------------------------------
//      GMT시간을 Local시간으로 변환해줌
//-----------------------------------------------------------------------------
VOID WINAPI SystemTimeToLocalTime(SYSTEMTIME *ST)
    {
    int  Y,M,D;

    ST->wHour+=9;
    if (ST->wHour>=24)
        {
        ST->wHour-=24;
        CnvFromTotalDay(GetTotalDays(ST->wYear, ST->wMonth, ST->wDay)+1, &Y, &M, &D);
        ST->wYear=Y;
        ST->wMonth=M;
        ST->wDay=D;
        }
    }



//-----------------------------------------------------------------------------
//      이 프로그램 컴파일 날짜를 줍니다
//-----------------------------------------------------------------------------
BOOL WINAPI GetAppCompileDate(SYSTEMTIME *ST)
    {
    int Rslt=FALSE, Y,Month,D, H,M,S;
    CHAR MonthName[80];

    Jsscanf(__DATE__ " " __TIME__, "%s %d %d %d:%d:%d", MonthName, &D, &Y, &H, &M, &S);
    //월이름분석
    for (Month=0; Month<12; Month++)
        if (lstrcmpi(GetToken(MonthNameList, Month), MonthName)==0) break;
    if (Month>=12) goto ProcExit;

    ST->wYear=(WORD)Y;
    ST->wMonth=(WORD)(Month+1);
    ST->wDay=(WORD)D;
    ST->wHour=(WORD)H;
    ST->wMinute=(WORD)M;
    ST->wSecond=(WORD)S;
    Rslt=TRUE;

    ProcExit:
    return Rslt;
    }



//-----------------------------------------------------------------------------
//      시간문자열을 만들어 줌 (2017-11-17 15:19:25)
//-----------------------------------------------------------------------------
LPSTR WINAPI MakeYMDHMS(LPSTR Buff, CONST SYSTEMTIME *ST)
    {
    wsprintf(Buff, "%d-%02d-%02d %02d:%02d:%02d", ST->wYear, ST->wMonth, ST->wDay, ST->wHour, ST->wMinute, ST->wSecond);
    return Buff;
    }



//-----------------------------------------------------------------------------
//      이 프로그램 컴파일 날짜를 줍니다
//-----------------------------------------------------------------------------
BOOL WINAPI GetAppCompileDateStr(LPSTR Buff)
    {
    BOOL Rslt;
    SYSTEMTIME ST;

    Buff[0]=0;
    if ((Rslt=GetAppCompileDate(&ST))!=FALSE) MakeYMDHMS(Buff, &ST);
    return Rslt;
    }




//-----------------------------------------------------------------------------
//      이 프로그램 컴파일 날짜를 줍니다 (JTIME으로)
//-----------------------------------------------------------------------------
JTIME WINAPI GetAppCompileDateTime(VOID)
    {
    JTIME Rslt=0;
    SYSTEMTIME ST;

    if (GetAppCompileDate(&ST)!=FALSE) Rslt=PackTotalSecond(&ST);
    return Rslt;
    }




//-----------------------------------------------------------------------------
//      HTTP TimeStr로 만듭니다
//      "Mon, 31 May 2004 13:55:12 GMT"
//-----------------------------------------------------------------------------
LPSTR WINAPI MakeHttpTimeStr(LPSTR TimeStr, CONST SYSTEMTIME *ST)
    {
    wsprintf(TimeStr, "%s, %d %s %d %02d:%02d:%02d GMT", GetToken(WeekNameList, ST->wDayOfWeek),
                      ST->wDay, ST->wMonth==0 ? "0":GetToken(MonthNameList, ST->wMonth-1), ST->wYear,
                      ST->wHour, ST->wMinute, ST->wSecond);
    return TimeStr;
    }




//-----------------------------------------------------------------------------
//      HTTP TimeStr을 분석합니다
//      "Mon, 31 May 2004 13:55:12 GMT"
//-----------------------------------------------------------------------------
BOOL WINAPI AnalysisHttpTimeStr(LPCSTR TimeStr, SYSTEMTIME *ST)
    {
    int   I, Rslt=FALSE, Day, Year, Hour, Min, Sec;
    CHAR  Buff[40], lpGmt[40];

    ZeroMem(ST, sizeof(SYSTEMTIME));

    //요일이름분석
    lstrcpyn(Buff, TimeStr, 3+1);
    for (I=0; I<7; I++)
        if (lstrcmpi(GetToken(WeekNameList, I), Buff)==0) break;
    if (I<7)
        {
        ST->wDayOfWeek=I;

        Jsscanf(NextWord(TimeStr,1), "%d %s %d %d:%d:%d %s", &Day, Buff, &Year, &Hour, &Min, &Sec, lpGmt);
        ST->wDay=Day;
        ST->wYear=Year;
        ST->wHour=Hour;
        ST->wMinute=Min;
        ST->wSecond=Sec;

        //월이름분석
        for (I=0; I<12; I++)
            if (lstrcmpi(GetToken(MonthNameList, I), Buff)==0) break;
        if (I<12)
            {
            ST->wMonth=I+1;
            if (lstrcmpi(lpGmt, "GMT")==0) Rslt++;
            }
        }
    return Rslt;
    }



//-----------------------------------------------------------------------------
//      시간문자열을 만듭니다
//-----------------------------------------------------------------------------
LPSTR WINAPI Make10msTimeStr(LPSTR Buff, DWORD _10msTime, BOOL DetailFg)
    {
    UINT _10ms, M,S;

    _10msTime=UDivMod(_10msTime, 100, &_10ms);
    _10msTime=UDivMod(_10msTime, 60, &S);
    _10msTime=UDivMod(_10msTime, 60, &M);

    if (_10msTime==0) wsprintf(Buff, "%d:%02d", M, S);
    else              wsprintf(Buff, "%d:%02d:%02d", _10msTime, M, S);

    if (DetailFg!=0) wsprintf(GetStrLast(Buff), ".%02d", _10ms);
    return Buff;
    }



//------------------------------------------------------------------------------
//      String에서 from를 찾아 to로 바꾼다 (바꾼 갯수를 알려줌)
//------------------------------------------------------------------------------
int WINAPI ChangeCha(LPSTR String, int from, int to)
    {
    int  Cnt=0;
    int Cha;

    while ((Cha=*String++)!=0)
        {
        if (Cha==from) {String[-1]=to; Cnt++;}
        }
    return Cnt;
    }



//-----------------------------------------------------------------------------
//      현재 문자열의 Cr,Lf 다음 줄 시작을 줍니다
//      LineLen에는 Cr,Lf전까지의 Bytes임
//-----------------------------------------------------------------------------
LPCSTR WINAPI NextLine(LPCSTR SrcStr, int *LineLen)
    {
    int Len=0, Cha, T;

    for (;;)
        {
        if ((Cha=*SrcStr)==0) goto ProcExit;
        SrcStr++;

        T=10; if (Cha==13) break;
        T=13; if (Cha==10) break;
        Len++;
        }
    if (*SrcStr==T) SrcStr++;

    ProcExit:
    if (LineLen!=NULL) *LineLen=Len;
    return SrcStr;
    }



//-----------------------------------------------------------------------------
//      13,10으로 분리된 여러 줄의 현재 줄의 글자수 리턴, Cr,Lf는 제외한
//      다음줄의 시작위치를 리턴함
//-----------------------------------------------------------------------------
LPCSTR WINAPI QueryStrOneLine(LPCSTR Str, int *lpLen)
    {
    int Len=0;
    CHAR Cha;

    for (;;)
        {
        Cha=*Str++;
        if (Cha==0) {Str--; break;}
        if (Cha==13 || Cha==10)
            {
            if (Str[0]==(Cha==13 ? 10:13)) Str++;
            break;
            }
        else Len++;
        }
    *lpLen=Len;
    return Str;
    }



//-----------------------------------------------------------------------------
//      Cr,Lf로 여러줄 문자열에서 주어진 라인 있는지
//      있으면 찾은 문자뒤를 복사해줌
//-----------------------------------------------------------------------------
BOOL WINAPI IsExistLineII(LPCSTR Str, LPCSTR FindLine, LPSTR Buff, int BuffSize)
    {
    int Rslt=FALSE, Len;

    Len=lstrlen(FindLine);
    while (Str[0]!=0)
        {
        if (CompMem(Str, FindLine, Len)==0)
            {
            lstrcpyn(Buff, Str+Len, BuffSize);
            ChangeCha(Buff, 13, 0);
            ChangeCha(Buff, 10, 0);
            Rslt=TRUE;
            break;
            }
        Str=NextLine(Str, NULL);
        }
    return Rslt;
    }




//-----------------------------------------------------------------------------
//      1Line을 빼냄 -  13,10으로 분리된 여러 줄의 Text에서 한라인을 빼냅니다
//              다음줄의 시작위치를 리턴함
//-----------------------------------------------------------------------------
LPCSTR WINAPI CatchStrOneLine(LPCSTR SrcStr, LPSTR DestBuff, int BuffLen)
    {
    BYTE Cha;

    for (;;)
        {
        Cha=*SrcStr++;
        if (Cha==0) {SrcStr--; break;}
        if (Cha==13 || Cha==10)
            {
            if (SrcStr[0]==(Cha==13 ? 10:13)) SrcStr++;
            break;
            }
        else{
            if (BuffLen>1)
                {
                *DestBuff++=Cha;
                BuffLen--;
                }
            }
        }
    if (BuffLen>0) *DestBuff=0;
    return SrcStr;
    }



#if 0
//-----------------------------------------------------------------------------
//      메모리에 있는 Ini파일구조에 변수의 문자열값을 읽음
//-----------------------------------------------------------------------------
int WINAPI GetIniStrInMem(LPCSTR SecName, LPCSTR VarName, LPSTR Buff, int BuffSize, LPCSTR IniMem)
    {
    int  CopyLen=0, SNLen;
    LPSTR lpVal;
    CHAR Tmp[128];

    Buff[0]=0;
    if (IniMem==NULL) goto ProcExit;
    SNLen=lstrlen(SecName);
    while (IniMem[0]!=0)
        {
        IniMem=CatchStrOneLine(IniMem, Tmp, sizeof(Tmp));
        CleanupStr(Tmp);
        if (Tmp[0]=='[' && Tmp[SNLen+1]==']' && CompareMem(Tmp+1, SecName, SNLen)==0)
            {
            while (IniMem[0]!=0)
                {
                IniMem=CatchStrOneLine(IniMem, Tmp, sizeof(Tmp));
                if (Tmp[0]==0) continue;
                if (Tmp[0]=='[') goto ProcExit;       //다음섹션
                lpVal=SeparatStr(Tmp, '=');
                CleanupStr(Tmp);
                if (lstrcmp(Tmp, VarName)==0)
                    {
                    if (lpVal!=NULL)
                        {
                        CleanupStr(lpVal);
                        lstrcpyn(Buff, lpVal, BuffSize);
                        }
                    CopyLen=lstrlen(Buff);
                    goto ProcExit;
                    }
                }
            }
        }

    ProcExit:
    return CopyLen;
    }



//-----------------------------------------------------------------------------
//      메모리에 있는 Ini파일구조에 변수의 정수값을 읽음
//-----------------------------------------------------------------------------
int WINAPI GetIniIntInMem(LPCSTR SecName, LPCSTR VarName, int DefValue, LPCSTR IniMem)
    {
    CHAR Buff[16];
    if (GetIniStrInMem(SecName, VarName, Buff, sizeof(Buff), IniMem)>0) DefValue=AtoI(Buff, NULL);
    return DefValue;
    }
#endif




//-----------------------------------------------------------------------------
//      문자열을 교체함
//-----------------------------------------------------------------------------
VOID WINAPI PutString(LPSTR *lplpStr, LPCSTR PutStr)
    {
    FreeMem(*lplpStr);
    if ((*lplpStr=(LPSTR)AllocMem(lstrlen(PutStr)+1, MEMOWNER_PutString))!=NULL)
        lstrcpy(*lplpStr, PutStr);
    }



//-----------------------------------------------------------------------------
//      주어진 버퍼크기를 오버하지 않게 문자열을 추가합니다
//-----------------------------------------------------------------------------
VOID WINAPI lstrcatn(LPSTR DestBuff, LPCSTR SrcBuff, int BuffSize)
    {
    int Len=lstrlen(DestBuff);
    if (Len<BuffSize) lstrcpyn(DestBuff+Len, SrcBuff, BuffSize-Len);
    }


#if INIFILE_EN
//-----------------------------------------------------------------------------
//      Ini파일을 읽고 쓴다
//-----------------------------------------------------------------------------
int WINAPI GetIniStr(LPCSTR Section, LPCSTR Entry, LPSTR Buff, int BuffSize)
    {return GetPrivateProfileString(Section, Entry, NullStr, Buff, BuffSize, IniFileName);}

int WINAPI GetIniStrEx(LPCSTR Section, LPCSTR Entry, LPSTR Buff, int BuffSize, LPCSTR DefStr)
    {return GetPrivateProfileString(Section, Entry, DefStr, Buff, BuffSize, IniFileName);}

VOID WINAPI WriteIniStrN(LPCSTR Section, int EntryNo, LPCSTR Buff)
    {
    CHAR Entry[16];
    wsprintf(Entry, Psnt1d, EntryNo);
    WriteIniStr(Section, Entry, Buff);
    }

int WINAPI GetIniInt(LPCSTR Section, LPCSTR Entry, int DefValue)
    {return GetPrivateProfileInt(Section, Entry, DefValue, IniFileName);}

int WINAPI GetIniStrN(LPCSTR Section, int EntryNo, LPSTR Buff, int BuffSize)
    {
    CHAR Entry[16];
    wsprintf(Entry, Psnt1d, EntryNo);
    return GetIniStr(Section, Entry, Buff, BuffSize);
    }

VOID WINAPI WriteIniStr(LPCSTR Section, LPCSTR Entry, LPCSTR Data)
    {WritePrivateProfileString(Section, Entry, Data, IniFileName);}

VOID WINAPI WriteIniInt(LPCSTR Section, LPCSTR Entry, int Value)
    {
    CHAR Buff[16];
    wsprintf(Buff, Psnt1d, Value);
    WriteIniStr(Section, Entry, Buff);
    }
#endif //INIFILE_EN



//-----------------------------------------------------------------------------
//      시분초를 합칩
//-----------------------------------------------------------------------------
INT32 WINAPI PackSecondExceptDate(CONST SYSTEMTIME *ST)
    {
    return ST->wHour*3600 + ST->wMinute*60 + ST->wSecond;
    }

INT32 WINAPI PackMilliSecondExceptDate(CONST SYSTEMTIME *ST)
    {
    return PackSecondExceptDate(ST)*1000+ST->wMilliseconds;
    }




//-----------------------------------------------------------------------------
//      GMT UnixTime: 1970 이후를 초단위로 표시함 (2106년이 최대) (WIN32용)
//      1335319508 -> 2012-04-25 11:05:08
//-----------------------------------------------------------------------------
#define ONEDAYSECONDS    86400  //=24*3600
DWORD WINAPI SystemTimeToUnixTime(CONST SYSTEMTIME *ST)
    {
    return (GetTotalDays(ST->wYear, ST->wMonth, ST->wDay)-719163)*ONEDAYSECONDS + PackSecondExceptDate(ST);
    }



//-----------------------------------------------------------------------------
//      주어진 시간을 2000/1/1을 기준으로 해서 초로 계산해줌 (기존 이름: GetTotalSecond)
//      최대 표시가능 시각: 2136-02-07 06:28:15
//-----------------------------------------------------------------------------
JTIME WINAPI PackTotalSecond(CONST SYSTEMTIME *ST)
    {
    return (GetTotalDays(ST->wYear, ST->wMonth, ST->wDay)-730120)*ONEDAYSECONDS + PackSecondExceptDate(ST); //730120=GetTotalDays(2000,1,1) / 86400=24*60*60
    }



//-----------------------------------------------------------------------------
//      JTIME을 JTIME64로 변경
//-----------------------------------------------------------------------------
JTIME64 WINAPI JTimeToJTime64(JTIME JTime)
    {
    return (JTIME64)JTime*1000+63082368000000ULL;                               //2000년까지의 ms = 63082368000000 ms = 730120*86400*1000;
    }



//-----------------------------------------------------------------------------
//      주어진 시간을 AD을 기준으로 해서 ms로 계산해줌
//      최대 표시가능 시각: 제한없음 (11,767,033 년까지 가능)
//-----------------------------------------------------------------------------
JTIME64 WINAPI PackTotalSecond64(CONST SYSTEMTIME *ST)
    {
    JTIME64 T;

    T=(JTIME64)GetTotalDays(ST->wYear, ST->wMonth, ST->wDay)*ONEDAYSECONDS + PackSecondExceptDate(ST);
    return T*1000 + ST->wMilliseconds;
    }




//-----------------------------------------------------------------------------
//      2000/1/1을 기준으로 초단위 값을 년월일시분초로 분리함
//-----------------------------------------------------------------------------
VOID WINAPI UnpackTotalSecond(SYSTEMTIME *ST, JTIME JTime)
    {
    int  Y,M,D;
    UINT Remain;

    JTime=UDivMod(JTime, 60, &Remain); ST->wSecond=(WORD)Remain;
    JTime=UDivMod(JTime, 60, &Remain); ST->wMinute=(WORD)Remain;
    JTime=UDivMod(JTime, 24, &Remain); ST->wHour=(WORD)Remain;

    JTime+=730120;  //730120=GetTotalDays(2000,1,1)
    ST->wDayOfWeek=JTime % 7;
    CnvFromTotalDay(JTime, &Y, &M, &D);
    ST->wYear=(WORD)Y;
    ST->wMonth=(WORD)M;
    ST->wDay=(WORD)D;
    ST->wMilliseconds=0;
    }




//-----------------------------------------------------------------------------
//      AD를 기준으로 ms단위 값을 년월일 시분초,ms로 분리함
//-----------------------------------------------------------------------------
VOID WINAPI UnpackTotalSecond64(SYSTEMTIME *ST, JTIME64 JTime)
    {
    int  Y,M,D;
    UINT JT;

    JTime=UDivMod64(JTime, 1000, &JT); ST->wMilliseconds=(WORD)JT;
    JTime=UDivMod64(JTime, 60, &JT);   ST->wSecond=(WORD)JT;
    JTime=UDivMod64(JTime, 60, &JT);   ST->wMinute=(WORD)JT;
    JTime=UDivMod64(JTime, 24, &JT);   ST->wHour=(WORD)JT;

    ST->wDayOfWeek=(TDATE)JTime % 7;
    CnvFromTotalDay((TDATE)JTime, &Y, &M, &D);
    ST->wYear=(WORD)Y;
    ST->wMonth=(WORD)M;
    ST->wDay=(WORD)D;
    }




//-----------------------------------------------------------------------------
//      CorTex M0에서 지원하지 않는 메모리 경계 읽기/쓰기
//-----------------------------------------------------------------------------
VOID WINAPI PokeW(LPPKVOID Ptr, UINT W)
    {
    *((LPBYTE)Ptr+0)=(BYTE)W;
    *((LPBYTE)Ptr+1)=(BYTE)(W>>8);
    }


VOID WINAPI Poke(LPPKVOID Ptr, DWORD Dw)
    {
    *((LPBYTE)Ptr+0)=(BYTE)Dw;
    *((LPBYTE)Ptr+1)=(BYTE)(Dw>>8);
    *((LPBYTE)Ptr+2)=(BYTE)(Dw>>16);
    *((LPBYTE)Ptr+3)=(BYTE)(Dw>>24);
    }



VOID WINAPI PokeBIW(LPPKVOID Ptr, UINT W)
    {
    *((LPBYTE)Ptr+0)=(BYTE)(W>>8);
    *((LPBYTE)Ptr+1)=(BYTE)W;
    }


VOID WINAPI PokeBI(LPPKVOID Ptr, DWORD Dw)
    {
    *((LPBYTE)Ptr+0)=(BYTE)(Dw>>24);
    *((LPBYTE)Ptr+1)=(BYTE)(Dw>>16);
    *((LPBYTE)Ptr+2)=(BYTE)(Dw>>8);
    *((LPBYTE)Ptr+3)=(BYTE)Dw;
    }



DWORD WINAPI Peek(LPCPKVOID Ptr)
    {
    return *(LPCBYTE)Ptr | (*((LPCBYTE)Ptr+1)<<8) | (*((LPCBYTE)Ptr+2)<<16) | (*((LPCBYTE)Ptr+3)<<24);
    }

UINT WINAPI PeekW(LPCPKVOID Ptr)
    {
    return *(LPCBYTE)Ptr | (*((LPCBYTE)Ptr+1)<<8);
    }


DWORD WINAPI PeekBI(LPCPKVOID Ptr)
    {
    return (*(LPCBYTE)Ptr<<24) | (*((LPCBYTE)Ptr+1)<<16) | (*((LPCBYTE)Ptr+2)<<8) | *((LPCBYTE)Ptr+3);
    }

UINT WINAPI PeekBIW(LPCPKVOID Ptr)
    {
    return (*(LPCBYTE)Ptr<<8) | *((LPCBYTE)Ptr+1);
    }

DWORD WINAPI PeekCDAB(LPCPKVOID Ptr)  //9B F8 48 42 -> 48429BF8
    {
    return (*(LPCBYTE)Ptr<<8) | *((LPCBYTE)Ptr+1) | (*((LPCBYTE)Ptr+2)<<24) | (*((LPCBYTE)Ptr+3)<<16);
    }


UINT WINAPI SwapIndianW(UINT W)
    {
    return (W>>8) | ((W&0xFF)<<8);
    }



//-----------------------------------------------------------------------------
//      주어진 메모리를 연속적인 Hex문자열로 만듦
//-----------------------------------------------------------------------------
VOID WINAPI MakeHexStr(LPSTR Buff, LPCBYTE lpMem, int MemSize)
    {
    BYTE B1, B2;
    while (MemSize--)
        {
        B1=*lpMem++;
        if ((B2=(B1>>4)+'0')>'9') B2+=7;
        *Buff++=B2;
        if ((B2=(B1&0x0F)+'0')>'9') B2+=7;
        *Buff++=B2;
        }
    *Buff=0;
    }



UINT WINAPI htons(UINT W)
    {
    return ((W&0xFF)<<8) | (W>>8);
    }




//-----------------------------------------------------------------------------
//      나눗의 결과와 나머지를 한꺼번에 얻는 함수
//      KEIL 에서는 __aeabi_uidiv()를 한번 불러서 몫과 나머지를 처리함
//-----------------------------------------------------------------------------
UINT WINAPI UDiv(UINT Dividend, UINT Divisor, UINT *lpRemainder)
    {
    if (lpRemainder) *lpRemainder=Dividend % Divisor;
    return Dividend / Divisor;
    }



//-----------------------------------------------------------------------------
//      현재 위치 단어를 떼어 줍니다 (공백이나 TAB기준) (sscanf()의 %s기능)
//      다음 단어의 시작위치를 리턴함
//      '나 "로 묶인경우 그 사이를 모두 떼어 줍니다
//-----------------------------------------------------------------------------
LPCSTR WINAPI ScanWord(LPCSTR Str, LPSTR Buff, int BuffLen)
    {
    int Cha, FirstCha, Dest=0;

    Str=SkipSpace(Str);
    FirstCha=Str[0];
    if (FirstCha==0x27 || FirstCha==0x22) Str++;     //"'", '"'
    else FirstCha=0;

    for (;;)
        {
        Cha=*(LPCBYTE)Str++;
        if (Cha==0) {Str--; break;}
        if (FirstCha!=0)
            {
            if (FirstCha==Cha) break;
            }
        else{
            if (Cha<=' ') break;
            }
        if (Dest+1<BuffLen) Buff[Dest++]=Cha;
        }

    if (Dest<BuffLen) Buff[Dest]=0;
    return SkipSpace(Str);
    }



//-----------------------------------------------------------------------------
//      현재 숫자를 꺼내 줍니다 (sscanf()의 %d기능)
//      다음 단어의 시작위치를 리턴함
//-----------------------------------------------------------------------------
LPCSTR WINAPI ScanInt(LPCSTR Str, int *lpValue)
    {
    int I,J;

    Str=SkipSpace(Str);
    J=AtoI(Str, &I);
    if (I>0) *lpValue=J;
    return (BYTE)Str[I]>' ' ? NextWord(Str+I, 1):SkipSpace(Str+I);  //숫자뒤에 문자가 붙어 있을 때 이 함수를 호출하면 같은 포인터를 리턴하기 때문에 무한루프가 돌아감
    }



//-----------------------------------------------------------------------------
//      주어진 숫자에 1의 갯수를 헤아림
//-----------------------------------------------------------------------------
int WINAPI GetBitCnt(UINT Value)
    {
    int Cnt=0;

    while (Value!=0)
        {
        if (Value&1) Cnt++;
        Value>>=1;
        }
    return Cnt;
    }



//-----------------------------------------------------------------------------
//      CRC를 계산한다
//-----------------------------------------------------------------------------
DWORD WINAPI CalculateCRC(LPCBYTE Buff, DWORD BuffSize, DWORD PreCRC)
    {
    int   I;
    DWORD Dw, Crc;

    Crc=PreCRC;
    while (BuffSize--)
        {
        Dw=(*Buff++) ^ (Crc & 0xFF);
        Crc>>=8;
        for (I=0; I<8; I++)     //CRC Table을 만듭니다
            {
            if (Dw & 1) {Dw>>=1; Dw^=0xEDB88320L;}
            else Dw>>=1;
            }
        Crc^=Dw;
        }
    return Crc;
    }



//-----------------------------------------------------------------------------
//      엔크립션 / 디크립션 (모든 키가 5번째 바이트부터는 모두 풀어짐)
//-----------------------------------------------------------------------------
VOID WINAPI EncryptDecrypt(LPBYTE Buff, int BuffSize, DWORD Crc, int Mode)
    {
    int   I;
    DWORD Dw;

    while (BuffSize--)
        {
        if (Mode==ED_ENCRYPT)
            {
            Dw=Buff[0] ^ (Crc & 0xFF);
            Buff[0]^=(BYTE)Crc;
            }
        else{
            Buff[0]^=(BYTE)Crc;
            Dw=Buff[0] ^ (Crc & 0xFF);
            }
        Buff++;

        for (I=0; I<8; I++)
            {
            if (Dw & 1) {Dw>>=1; Dw^=0xEDB88320;}
            else Dw>>=1;
            }
        Crc>>=8;
        Crc^=Dw;
        }
    }




//-----------------------------------------------------------------------------
//      엔크립션 / 디크립션 (위의 약점 보완)
//-----------------------------------------------------------------------------
VOID WINAPI EncryptDecryptII(LPBYTE Buff, int BuffSize, DWORD Crc, int Mode)
    {
    int   I;
    DWORD Dw;

    while (BuffSize--)
        {
        if (Mode==ED_ENCRYPT)
            {
            Dw=Buff[0] ^ (Crc & 0xFF);
            Buff[0]^=(BYTE)Crc;
            }
        else{
            Buff[0]^=(BYTE)Crc;
            Dw=Buff[0] ^ (Crc & 0xFF);
            }
        Buff++;

        Crc^=Dw;
        for (I=0; I<8; I++)
            {
            if (Crc&1) {Crc>>=1; Crc^=0xED0B8832;}
            else Crc>>=1;
            }
        }
    }




//-----------------------------------------------------------------------------
//      주어진 float 값을 Digit 곱한 정수값을 리턴함
//      float(IEEE-754) 값을 정수로 변환함
//      INTPARTBITS==25 이면 (0.1 ~ 200,0000.0 범위)
//          Fixed 25:7  25비트 정수에 7비트 소수점자리임
//-----------------------------------------------------------------------------
#define INTPARTBITS     25  //고정소숫점방식에서 정수부로 할당된 비트수
#define FRACPARTBITS    (32-INTPARTBITS)
int WINAPI FloatToInt(UINT Float, UINT Digit, UINT Max)
    {
    int  Exp, Value=Max;
    UINT Frac;

    Frac=(Float|0x800000)<<8;   //생략된 비트를 설정하고 맨 앞으로 밀착
    Exp=((Float<<1)>>24)-126-INTPARTBITS; //지수

    if (Exp>0) goto ProcExit;   //OverFlow

    Exp=-Exp;
    if (Exp<INTPARTBITS)        //정수부가 있는 경우
        {
        Frac>>=Exp;
        if ((Frac>>FRACPARTBITS)>Max/Digit) goto ProcExit;  //OverFlow
        Value=(Frac>>FRACPARTBITS)*Digit + UMulDiv((Frac<<INTPARTBITS)>>INTPARTBITS, Digit, 1<<FRACPARTBITS);
        }
    else{                           //유효숫자는 모두 소수부
        Frac>>=Exp-INTPARTBITS+1;   //+1은 양수 범위로 만들기 위함
        Value=UMulDiv(Frac, Digit, 0x80000000); //= 1<<31
        }

    ProcExit:
    if ((Float>>31)!=0) Value=-Value;
    return Value;
    }



//-----------------------------------------------------------------------------
//      CRC16를 계산한다
//
//      http://www.zorc.breitbandkatze.de/crc.html
//      Crc초기값에 0xFFFF을 주면 CCITT CRC16값이 출력됨
//-----------------------------------------------------------------------------
UINT WINAPI CalculateCrc16(LPCVOID Buff, UINT BuffSize, UINT Crc)
    {
    UINT I;

    while (BuffSize--)
        {
        Crc^=*(LPCBYTE)Buff <<8;
        Buff=(LPCBYTE)Buff+1;

        for (I=0; I<8; I++)
            {
            if (Crc & 0x8000) {Crc<<=1; Crc^=0x1021;} else Crc<<=1;
            }
        }
    return Crc & 0xFFFF;
    }




//-----------------------------------------------------------------------------
//      CRC16를 계산한다 (POLYNOMIAL=0x8005)
//-----------------------------------------------------------------------------
UINT WINAPI CalculateCrc16_8005(LPCVOID Buff, UINT BuffSize, UINT Crc)
    {
    UINT I;

    while (BuffSize--)
        {
        Crc^=*(LPCBYTE)Buff <<8;
        Buff=(LPCBYTE)Buff+1;

        for (I=0; I<8; I++)
            {
            if (Crc & 0x8000) {Crc<<=1; Crc^=0x8005;} else Crc<<=1;
            }
        }
    return Crc & 0xFFFF;
    }




//-----------------------------------------------------------------------------
//      문자열의 주어진 위치에 문자를 삽입한다
//-----------------------------------------------------------------------------
VOID WINAPI InsCha(LPSTR SrcStr, int InsLoc, int Cha)
    {
    int SLen;

    SLen=lstrlen(SrcStr);
    if (InsLoc<=SLen)
        {
        while (InsLoc<=SLen)
            {
            SrcStr[1+SLen]=SrcStr[SLen];                //+1은 Null문자까지
            SLen--;
            }
        SrcStr[InsLoc]=Cha;
        }
    }




//-----------------------------------------------------------------------------
//      문자열의 주어진 위치에 문자열을 삽입한다
//-----------------------------------------------------------------------------
VOID WINAPI InsStr(LPSTR SrcStr, int InsLoc, LPCSTR ToInsStr)
    {
    int SLen, ILen;

    SLen=lstrlen(SrcStr);
    ILen=lstrlen(ToInsStr);
    if (InsLoc<=SLen && ILen>0)
        {
        while (SLen>=InsLoc)
            {
            SrcStr[ILen+SLen]=SrcStr[SLen];
            SLen--;
            }
        CopyMem(SrcStr+InsLoc, ToInsStr, ILen);
        }
    }




//-----------------------------------------------------------------------------
//      Word Array에서 주어진 Word를 찾음 (찾은 인덱스를 줌, 못찾으면 -1)
//      WordArray는 오름차순으로 정렬되어 있어야 함
//-----------------------------------------------------------------------------
int WINAPI BinSearchWord(CONST WORD *ArrayBase, UINT Elements, UINT SearchWord)
    {
    int Rslt, Find=-1, Half, Low=0, Mid;

    while (Elements>0)
        {
        Half=Elements>>1;
        Mid=Low+Half;
        if ((Rslt=SearchWord-ArrayBase[Mid])==0) {Find=Mid; break;}
        if (Rslt<0)
            {
            Elements=Half;
            }
        else{
            Low=Mid+1;
            Elements=(Elements&1) ? Half:Half-1;
            }
        }
    return Find;
    }



//-----------------------------------------------------------------------------
//      히스테리시스를 이용한 값비교 (흔들리는 값일 때 이 함수를 이용함)
//      현재상태가 <0인경우 Target+Tolerance 이상이 되면 0보다 큰값을 리턴하고
//                 >0인경우 Target-Tolerance 이하가 되면 0보다 작은값을 리턴함
//-----------------------------------------------------------------------------
int WINAPI CompareUsingHysteresis(int State, int Value, int Target, int Tolerance)
    {
    if (State==0) State=(Value>=Target) ? 1:-1;
    else if (State>0)
        {
        if (Value<=Target-Tolerance) State=-1;
        }
    else{ //if (State<0)
        if (Value>=Target+Tolerance) State=1;
        }
    return State;
    }



//-------------------------------------------------------------------------
//      채터링 제거 (제거된 신호가 바뀐경우 TRUE리턴)
//-------------------------------------------------------------------------
BOOL WINAPI RemoveChattering(REMOVECHATTERING *RC, UINT CurrState, int KeepTime)
    {
    BOOL Rslt=FALSE;

    if (RC->OldState!=CurrState)
        {
        RC->KeepTime=0;
        RC->OldState=CurrState;
        }
    else{
        if (RC->KeepTime<KeepTime) RC->KeepTime++;
        if (RC->KeepTime==KeepTime)         //'H'이든 'L'이든 주어진 시간동안 유지되는지 확인
            {
            if (RC->RegularState!=(BYTE)-1 && RC->RegularState!=CurrState) Rslt++;
            RC->RegularState=CurrState;
            }
        }
    return Rslt;
    }




//-----------------------------------------------------------------------------
//      WELLRNG512 알고리즘 랜덤수치 구하기
//-----------------------------------------------------------------------------
DWORD WINAPI MyRand(DWORD InitData)
    {
    DWORD A,B,C,D;
    static int Index;
    static DWORD State[16];

    if (State[0]==0) for (A=0; A<countof(State); A++) State[A]=++InitData;
    A=State[Index];
    C=State[(Index+13)&0x0F];
    B=A^C^(A<<16)^(C<<15);
    C=State[(Index+9)&0x0F];
    C^=C>>11;
    State[Index]=A=B^C;
    D=A^((A<<5) & 0xDA442D24);
    Index=(Index+15)&0x0F;
    A=State[Index];
    State[Index]=A^B^D^(A<<2)^(B<<18)^(C<<28);
    return State[Index];
    }




//-----------------------------------------------------------------------------
//      데이터를 Shift하면서 평균을 취함 (버퍼를 초과한 과거 데이터는 삭제)
//      버퍼의 첫번째 데이터는 현재 데이터 갯수이어야 함 (MaxQty는 데이터 갯수도 포함)
//-----------------------------------------------------------------------------
int WINAPI CalcAverageI16(INT16 *Buff, int MaxQty, int CurrValue)
    {
    int I,T, ItemQty;

    ItemQty=*Buff++; MaxQty--;

    if (ItemQty<MaxQty) Buff[ItemQty++]=CurrValue;
    else{
        MoveMem(Buff, Buff+1, (MaxQty-1)<<1);
        Buff[MaxQty-1]=CurrValue;
        }
    for (I=T=0; I<ItemQty; I++) T+=Buff[I];

    Buff[-1]=ItemQty;
    return (T+(ItemQty>>1))/ItemQty;
    }




//-----------------------------------------------------------------------------
//      ST 거리측정센서 루틴에서 가져옴
//      32비트 sqrt()
//-----------------------------------------------------------------------------
DWORD WINAPI SqrtDw(DWORD Numb)
    {
    UINT Rslt=0, Bit=1<<30;

    while (Bit>Numb) Bit>>=2;

    while (Bit!=0)
        {
        if (Numb>=Rslt+Bit)
            {
            Numb-=Rslt+Bit;
            Rslt>>=1;
            Rslt+=Bit;
            }
        else Rslt>>=1;
        Bit>>=2;
        }

    return Rslt;
    }




//-----------------------------------------------------------------------------
//      Base64를 엔코딩합니다 (버퍼를 충분히 줄것)
//      OutBuff 예측.. CnvToWebStr==0 인경우는 InDataLen * 1.5 + 4
//                     CnvToWebStr!=0 인경우는 InDataLen * 1.5 * 3
//-----------------------------------------------------------------------------
VOID WINAPI EncodeBase64(LPCSTR InBuff, int InDataLen, LPSTR OutBuff, int LineLen)
    {
    int  EncodeSize, RemainBits, NowBits, LineChaCnt, BufW;
    static CONST CHAR Base64Chars[]="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

    EncodeSize=RemainBits=LineChaCnt=BufW=0;

    while (InDataLen>0)
        {
        NowBits=0;
        if (RemainBits<6)
            {
            BufW<<=RemainBits; NowBits=RemainBits;
            BufW|=*(LPCBYTE)InBuff++; InDataLen--; RemainBits+=8;
            }
        if (NowBits<6)
            {
            BufW<<=6-NowBits;
            }

        *OutBuff++=Base64Chars[(BufW>>8)&0x3F]; RemainBits-=6; EncodeSize++;

        if (LineLen>0 && ++LineChaCnt>=LineLen)
            {
            *OutBuff++=13;
            *OutBuff++=10;
            LineChaCnt=0;
            }
        }

    if (RemainBits>0)
        {
        BufW<<=6;
        *OutBuff++=Base64Chars[(BufW>>8)&0x3F]; EncodeSize++;
        }

    while ((EncodeSize & 3)!=0)
        {
        EncodeSize++;
        *OutBuff++='=';
        }

    *OutBuff=0;
    }




//-----------------------------------------------------------------------------
//      Hex문자를 값으로 변경
//-----------------------------------------------------------------------------
int WINAPI GetHexValue(int Cha)
    {
    if (Cha>='0' && Cha<='9') Cha-='0';
    else if (Cha>='A' && Cha<='F') Cha-='A'-10;
    else if (Cha>='a' && Cha<='f') Cha-='a'-10;
    else Cha=0;
    return Cha;
    }




//-----------------------------------------------------------------------------
//      Base64를 디코딩합니다
//-----------------------------------------------------------------------------
LOCAL(int) Base64Dec(int Cha)
    {
    if (Cha=='+') Cha=0x3E;
    else if (Cha=='/') Cha=0x3F;
    else if (Cha>='0' && Cha<='9') Cha-='0'-0x34;
    else if (Cha>='A' && Cha<='Z') Cha-='A';
    else if (Cha>='a' && Cha<='z') Cha-='a'-0x1A;
    else Cha=-1;
    return Cha;
    }




//-----------------------------------------------------------------------------
//      Base64를 디코딩합니다
//-----------------------------------------------------------------------------
int WINAPI DecodeBase64(LPCSTR InBuff, LPSTR OutBuff, int Inlen)
    {
    int Cha, Ch2, BufW=0, Code, DecodeSize, RemainBits, NowBits, NeedBits;

    DecodeSize=RemainBits=0;
    if (Inlen<0) Inlen=lstrlen(InBuff);
    while (Inlen>0)
        {
        Cha=*InBuff++; Inlen--; if (Cha==0) break;
        if (Cha=='%')
            {
            Cha=*InBuff++; Inlen--; if (Cha==0) break;
            Ch2=*InBuff++; Inlen--; if (Ch2==0) break;
            //Cha=Hex2Cha(Cha, Ch2);
            Cha=(GetHexValue(Cha)<<4) | GetHexValue(Ch2);
            }
        if (Cha>' ')
            {
            if ((Code=Base64Dec(Cha))<0) break;
            BufW&=~0xFF; BufW|=(BYTE)(Code<<2); NowBits=6;

            while (NowBits>0)
                {
                if ((NeedBits=8-RemainBits)>NowBits) NeedBits=NowBits;
                BufW<<=NeedBits; RemainBits+=NeedBits; NowBits-=NeedBits;
                if (RemainBits==8) {*OutBuff++=(BYTE)(BufW>>8); DecodeSize++; RemainBits=0;}
                }
            }
        }
    return DecodeSize;
    }




//-----------------------------------------------------------------------------
//      HEX문자열을 바이너리로 디코딩합니다
//-----------------------------------------------------------------------------
VOID WINAPI DecodeHexStr(LPBYTE OutBuff, LPCSTR InBuff, int Inlen)
    {
    int I;

    for (I=0; I<Inlen; I+=2)
        *OutBuff++=(GetHexValue(InBuff[I])<<4) | GetHexValue(InBuff[I+1]);
    }




//-----------------------------------------------------------------------------
//      바이너리를 HEX문자열로 엔코딩합니다 (OutBuff 맨뒤 0으로 채우지 않음)
//-----------------------------------------------------------------------------
VOID WINAPI EncodeHexStr(LPSTR OutBuff, LPCBYTE InBuff, int Inlen)
    {
    int I,B, Cha;

    for (I=0; I<Inlen; I++)
        {
        Cha=InBuff[I];
        if ((B=((Cha>>4) & 0x0F)+'0')>'9') B+=7;    //7='A'-'0'-10
        *OutBuff++=B;
        if ((B=(Cha      & 0x0F)+'0')>'9') B+=7;
        *OutBuff++=B;
        }
    }




//-----------------------------------------------------------------------------
//      Dos시간을 SYSTEMTIME으로 변환
//-----------------------------------------------------------------------------
VOID WINAPI DosFileTimeToSystemTime(UINT FatDate, UINT FatTime, SYSTEMTIME *ST)
    {
    ST->wYear=((FatDate>>9)&0x7F)+1980;
    ST->wMonth=(FatDate>>5)&0x0F;
    ST->wDay=FatDate&0x1F;
    ST->wHour=(FatTime>>11)&0x1F;
    ST->wMinute=(FatTime>>5)&0x3F;
    ST->wSecond=(FatTime<<1)&0x3E;
    }




//-----------------------------------------------------------------------------
//      바이너리와 BCD사이 변환 (RTC에서 사용)
//-----------------------------------------------------------------------------
int WINAPI Bin2Bcd(int Value)
    {
    return ((Value/10)<<4) | (Value%10);
    }


int WINAPI Bcd2Bin(int Value)
    {
    return ((Value>>4)&0x0F)*10 + (Value & 0x0F);
    }




//-----------------------------------------------------------------------------
//      주어진 문자열이 히스토리에 있는지 확인
//-----------------------------------------------------------------------------
LOCAL(BOOL) IsInStringHistory(CHKDUPLICATEDSTRING *CDS, LPCSTR Str, DWORD NowTime)
    {
    int I, Rslt=FALSE;
    DWORD Crc;
    STRING_HISTORY *SH;

    Crc=CalculateCRC((LPCBYTE)Str, lstrlen(Str), ~0);
    for (I=0, SH=CDS->SH; I<CDS->HistoryQty; I++, SH++)
        {
        if (SH->EnteredTime!=0 && NowTime-SH->EnteredTime<CDS->LifeTime && SH->Crc==Crc)
            {
            Rslt++;
            break;
            }
        }
    return Rslt;
    }




//-----------------------------------------------------------------------------
//      문자열을 히스토리에 등록함
//-----------------------------------------------------------------------------
LOCAL(VOID) PutStringHistory(CHKDUPLICATEDSTRING *CDS, LPCSTR Str, DWORD NowTime)
    {
    int   I;
    DWORD Crc, LongTime=0, ElapseTime;
    STRING_HISTORY *SH, *PutSH=NULL;

    Crc=CalculateCRC((LPCBYTE)Str, lstrlen(Str), ~0);
    for (I=0,SH=CDS->SH; I<CDS->HistoryQty; I++, SH++)
        {
        if (SH->Crc==Crc) {PutSH=SH; break;}
        if ((ElapseTime=NowTime-SH->EnteredTime)>LongTime)                      //가장 오래된 패킷 히스토리 사용
            {
            PutSH=SH;
            LongTime=ElapseTime;
            }
        }
    PutSH->EnteredTime=NowTime;
    PutSH->Crc=Crc;
    }




//-----------------------------------------------------------------------------
//      주어진 시간 기준으로 중복해서 들어온 경우 TRUE 리턴
//      485 수신에서 중복 문자열을 제거하는데 사용함
//-----------------------------------------------------------------------------
BOOL WINAPI IsDuplicatedString(CHKDUPLICATEDSTRING *CDS, LPCSTR Str, DWORD NowTime)
    {
    BOOL Rslt=FALSE;

    if ((Rslt=IsInStringHistory(CDS, Str, NowTime))==FALSE)                     //송신디바이스가 자신의 피드백은 깨져서 재송출했는데 이 수신보드에서는 둘다 정상으로 수신되어 같은 패킷은 버리는 처리를 해야 함
        PutStringHistory(CDS, Str, NowTime);
    return Rslt;
    }



