﻿#ifndef __JLIB_H__
#define __JLIB_H__

#include "string.h"
#include "stdarg.h"

#if defined(__GNUC__)
#include "stdint.h"
#endif

extern char NullStr[];
extern char Psnt1s[];
extern char Psnt1d[];
extern char Psnt2d[];
extern char ConfigStr[];
extern char CrLfStr[];
extern char IniFileName[];
#define CRLF    "\r\n"

#define CopyMem         memcpy
#define CompMem         memcmp
#define CompareMem      memcmp
#define MoveMem         memmove
#define lstrlen         strlen
#define lstrcpy         strcpy
#define lstrcat         strcat
#define lstrcmp         strcmp
#define lstrcmpi        strcasecmp
//#define Jsscanf         sscanf
#define wsprintf        Jsprintf
#define FillMem(Dest, FillBytes, FillByte)   memset(Dest, FillByte, FillBytes)
#define ZeroMem(Dest, FillBytes)             memset(Dest, 0, FillBytes)

#define CopyMemory      memcpy
#define FillMemory      FillMem
#define ZeroMemory      ZeroMem


#define CHAR            char
#define VOID            void
#define CONST           const
typedef unsigned char   BYTE;
typedef unsigned short  WORD;
typedef unsigned long   DWORD;
typedef unsigned long long UINT64;
#if defined(__GNUC__)
#define UINT            uint32_t
#elif defined(__CC_ARM) //KEIL
typedef unsigned int    UINT;
#endif
typedef long            LONG;
typedef char *          LPSTR;
typedef const char *    LPCSTR;
typedef VOID *          LPVOID;
typedef const VOID *    LPCVOID;
typedef BYTE *          LPBYTE;
typedef const BYTE *    LPCBYTE;
typedef int             BOOL;
typedef WORD *          LPWORD;
typedef const WORD *    LPCWORD;
typedef WORD *          LPWSTR;
typedef const WORD *    LPCWSTR;
typedef signed char     INT8;
typedef short           INT16;
typedef int             INT32;
typedef long long       INT64;
#define PTR2INT         int

#if defined(__GNUC__)
typedef void *          LPPKVOID;
typedef const void *    LPCPKVOID;
#elif defined(__CC_ARM) //KEIL
typedef __packed void * LPPKVOID;
typedef __packed const void * LPCPKVOID;
#endif

#define LOCAL(type) static type
#define DIV_ROUNDUP(A,B)    ((A+((B)>>1))/(B))  //A가 양수일 때
#define DIV_ROUNDUPM(A,B)   ((A-((B)>>1))/(B))  //A가 음수일 때
#define countof(StrucName)  (sizeof(StrucName)/sizeof(StrucName[0]))
#define GetMemberOffset(Struc, Member) (int)(&((Struc*)0)->Member)
#define PACKED          __attribute__((packed))

#define WINAPI
#define CALLBACK
#define FALSE           0
#define TRUE            1
//#define NULL          0       //(VOID*)0
typedef signed short  INT16;
typedef volatile unsigned long  VDWORD;
typedef volatile unsigned short VWORD;
typedef volatile unsigned char  VBYTE;
typedef volatile unsigned int   VUINT;

#define HFILE           int
#define SOCKET          int

typedef DWORD           JTIME;  //년월일시분초를 모두 초단위값으로 (2000.1.1기준)
typedef INT64           JTIME64;//년월일시분초를 모두 ms단위값으로 (0000.1.1기준)
typedef DWORD           UTIME;  //년월일시분초를 모두 초단위값으로 (1970.1.1기준)
typedef INT32           TDATE;  //년월일을 총일수로


typedef struct _SYSTEMTIME
    {
    WORD wYear;
    WORD wMonth;
    WORD wDayOfWeek;
    WORD wDay;
    WORD wHour;
    WORD wMinute;
    WORD wSecond;
    WORD wMilliseconds;
    } SYSTEMTIME;

//ASCII코드
#define BEEP            0x07
#define BKSPC           0x08
#define TAB             0x09
#define LF              0x0A
//#define CR            0x0D    //GUI에서 ClientRect의 약어로 CR을 사용한 곳이 있음, 예) RECT CR;
#define ESC             0x1B
#define SPACE           ' '

#define CTRL_A          0x01
#define CTRL_B          0x02
#define CTRL_C          0x03
#define CTRL_D          0x04
#define CTRL_E          0x05
#define CTRL_F          0x06
#define CTRL_G          BEEP
#define CTRL_H          BKSPC
#define CTRL_I          TAB
#define CTRL_J          LF
#define CTRL_K          0x0B
#define CTRL_L          0x0C
#define CTRL_M          0x0D
#define CTRL_N          0x0E
#define CTRL_O          0x0F

#define CTRL_P          0x10
#define CTRL_Q          0x11
#define CTRL_R          0x12
#define CTRL_S          0x13
#define CTRL_T          0x14
#define CTRL_U          0x15
#define CTRL_V          0x16
#define CTRL_W          0x17
#define CTRL_X          0x18
#define CTRL_Y          0x19
#define CTRL_Z          0x1A


#define AllocMemS(struc, Owner) (struc*)AllocMem(sizeof(struc), Owner)

#define ALLOCMEM1(lp1,lp1Size, Owner, ErrJump)                     \
    if ((*(LPSTR*)&lp1=(LPSTR)AllocMem(lp1Size, Owner))==NULL) goto ErrJump

#define ALLOCMEM2(lp1,lp1Size, lp2,lp2Size, Owner, ErrJump)                \
    if ((*(LPSTR*)&lp1=(LPSTR)AllocMem(lp1Size+lp2Size, Owner))==NULL) goto ErrJump; \
    *(LPSTR*)&lp2=(LPSTR)lp1+lp1Size

#define ALLOCMEM3(lp1,lp1Size, lp2,lp2Size, lp3,lp3Size, Owner, ErrJump)           \
    if ((*(LPSTR*)&lp1=(LPSTR)AllocMem(lp1Size+lp2Size+lp3Size, Owner))==NULL) goto ErrJump; \
    *(LPSTR*)&lp2=(LPSTR)lp1+lp1Size;   \
    *(LPSTR*)&lp3=(LPSTR)lp2+lp2Size

#define ALLOCMEM4(lp1,lp1Size, lp2,lp2Size, lp3,lp3Size, lp4,lp4Size, Owner, ErrJump)      \
    if ((*(LPSTR*)&lp1=(LPSTR)AllocMem(lp1Size+lp2Size+lp3Size+lp4Size, Owner))==NULL) goto ErrJump; \
    *(LPSTR*)&lp2=(LPSTR)lp1+lp1Size;   \
    *(LPSTR*)&lp3=(LPSTR)lp2+lp2Size;   \
    *(LPSTR*)&lp4=(LPSTR)lp3+lp3Size

#define ALLOCMEM5(lp1,lp1Size, lp2,lp2Size, lp3,lp3Size, lp4,lp4Size, lp5,lp5Size, Owner, ErrJump) \
    if ((*(LPSTR*)&lp1=(LPSTR)AllocMem(lp1Size+lp2Size+lp3Size+lp4Size+lp5Size, Owner))==NULL) goto ErrJump; \
    *(LPSTR*)&lp2=(LPSTR)lp1+lp1Size;   \
    *(LPSTR*)&lp3=(LPSTR)lp2+lp2Size;   \
    *(LPSTR*)&lp4=(LPSTR)lp3+lp3Size;   \
    *(LPSTR*)&lp5=(LPSTR)lp4+lp4Size

#define ALLOCMEM6(lp1,lp1Size, lp2,lp2Size, lp3,lp3Size, lp4,lp4Size, lp5,lp5Size, lp6,lp6Size, Owner, ErrJump) \
    if ((*(LPSTR*)&lp1=(LPSTR)AllocMem(lp1Size+lp2Size+lp3Size+lp4Size+lp5Size+lp6Size, Owner))==NULL) goto ErrJump;      \
    *(LPSTR*)&lp2=(LPSTR)lp1+lp1Size;   \
    *(LPSTR*)&lp3=(LPSTR)lp2+lp2Size;   \
    *(LPSTR*)&lp4=(LPSTR)lp3+lp3Size;   \
    *(LPSTR*)&lp5=(LPSTR)lp4+lp4Size;   \
    *(LPSTR*)&lp6=(LPSTR)lp5+lp5Size

#define ALLOCMEM7(lp1,lp1Size, lp2,lp2Size, lp3,lp3Size, lp4,lp4Size, lp5,lp5Size, lp6,lp6Size, lp7,lp7Size, Owner, ErrJump) \
    if ((*(LPSTR*)&lp1=(LPSTR)AllocMem(lp1Size+lp2Size+lp3Size+lp4Size+lp5Size+lp6Size+lp7Size, Owner))==NULL) goto ErrJump;      \
    *(LPSTR*)&lp2=(LPSTR)lp1+lp1Size;   \
    *(LPSTR*)&lp3=(LPSTR)lp2+lp2Size;   \
    *(LPSTR*)&lp4=(LPSTR)lp3+lp3Size;   \
    *(LPSTR*)&lp5=(LPSTR)lp4+lp4Size;   \
    *(LPSTR*)&lp6=(LPSTR)lp5+lp5Size;   \
    *(LPSTR*)&lp7=(LPSTR)lp6+lp6Size

#define ALLOCMEM8(lp1,lp1Size, lp2,lp2Size, lp3,lp3Size, lp4,lp4Size, lp5,lp5Size, lp6,lp6Size, lp7,lp7Size, lp8,lp8Size, Owner, ErrJump) \
    if ((*(LPSTR*)&lp1=(LPSTR)AllocMem(lp1Size+lp2Size+lp3Size+lp4Size+lp5Size+lp6Size+lp7Size+lp8Size, Owner))==NULL) goto ErrJump;      \
    *(LPSTR*)&lp2=(LPSTR)lp1+lp1Size;   \
    *(LPSTR*)&lp3=(LPSTR)lp2+lp2Size;   \
    *(LPSTR*)&lp4=(LPSTR)lp3+lp3Size;   \
    *(LPSTR*)&lp5=(LPSTR)lp4+lp4Size;   \
    *(LPSTR*)&lp6=(LPSTR)lp5+lp5Size;   \
    *(LPSTR*)&lp7=(LPSTR)lp6+lp6Size;   \
    *(LPSTR*)&lp8=(LPSTR)lp7+lp7Size

#define ALLOCMEM9(lp1,lp1Size, lp2,lp2Size, lp3,lp3Size, lp4,lp4Size, lp5,lp5Size, lp6,lp6Size, lp7,lp7Size, lp8,lp8Size, lp9,lp9Size, Owner, ErrJump) \
    if ((*(LPSTR*)&lp1=(LPSTR)AllocMem(lp1Size+lp2Size+lp3Size+lp4Size+lp5Size+lp6Size+lp7Size+lp8Size+lp9Size, Owner))==NULL) goto ErrJump;      \
    *(LPSTR*)&lp2=(LPSTR)lp1+lp1Size;   \
    *(LPSTR*)&lp3=(LPSTR)lp2+lp2Size;   \
    *(LPSTR*)&lp4=(LPSTR)lp3+lp3Size;   \
    *(LPSTR*)&lp5=(LPSTR)lp4+lp4Size;   \
    *(LPSTR*)&lp6=(LPSTR)lp5+lp5Size;   \
    *(LPSTR*)&lp7=(LPSTR)lp6+lp6Size;   \
    *(LPSTR*)&lp8=(LPSTR)lp7+lp7Size;   \
    *(LPSTR*)&lp9=(LPSTR)lp8+lp8Size

#define ALLOCMEM10(lp1,lp1Size, lp2,lp2Size, lp3,lp3Size, lp4,lp4Size, lp5,lp5Size, lp6,lp6Size, lp7,lp7Size, lp8,lp8Size, lp9,lp9Size, lp10,lp10Size, Owner, ErrJump) \
    if ((*(LPSTR*)&lp1=(LPSTR)AllocMem(lp1Size+lp2Size+lp3Size+lp4Size+lp5Size+lp6Size+lp7Size+lp8Size+lp9Size+lp10Size, Owner))==NULL) goto ErrJump;      \
    *(LPSTR*)&lp2=(LPSTR)lp1+lp1Size;   \
    *(LPSTR*)&lp3=(LPSTR)lp2+lp2Size;   \
    *(LPSTR*)&lp4=(LPSTR)lp3+lp3Size;   \
    *(LPSTR*)&lp5=(LPSTR)lp4+lp4Size;   \
    *(LPSTR*)&lp6=(LPSTR)lp5+lp5Size;   \
    *(LPSTR*)&lp7=(LPSTR)lp6+lp6Size;   \
    *(LPSTR*)&lp8=(LPSTR)lp7+lp7Size;   \
    *(LPSTR*)&lp9=(LPSTR)lp8+lp8Size;   \
    *(LPSTR*)&lp10=(LPSTR)lp9+lp9Size

#define SETBITBYTEARRAY(ByteArray, BitNo)   ByteArray[BitNo>>3]|=1<<(BitNo&7)
#define CLRBITBYTEARRAY(ByteArray, BitNo)   ByteArray[BitNo>>3]&=~(1<<(BitNo&7))
#define CHKBITBYTEARRAY(ByteArray, BitNo)   (ByteArray[BitNo>>3]&(1<<(BitNo&7)))


#define LongByte0(L)    (L&0xFF)
#define LongByte1(L)    ((L>>8)&0xFF)
#define LongByte2(L)    ((L>>16)&0xFF)
#define LongByte3(L)    (L>>24)

#define LoByte(W)       (W&0xFF)
#define HiByte(W)       (W>>8)

#define LoWord(DW)      (DW&0xFFFF)
#define HiWord(DW)      (DW>>16)

#define MAKELONG(L,H)   (((H)<<16)|(L))

/*
#define LongByte0(DW)   *(BYTE*)&DW
#define LongByte1(DW)   *((BYTE*)&DW+1)
#define LongByte2(DW)   *((BYTE*)&DW+2)
#define LongByte3(DW)   *((BYTE*)&DW+3)

#define LoByte(W)       *(BYTE*)&W
#define HiByte(W)       *((BYTE*)&W+1)
#define LoWord(DW)      *(WORD*)&DW
#define HiWord(DW)      *((WORD*)&DW+1)
*/

#define MAKEIP(IP1, IP2, IP3, IP4) (((DWORD)(IP1)<<24) | ((DWORD)(IP2)<<16) | ((DWORD)(IP3)<<8) | (IP4))
#define BROADCASTIP     MAKEIP(255,255,255,255)



#define MA_OK                   0
#define MA_BROKENMCB            7
#define MA_INSUFFICIENT         8
#define MA_INVALIDPTR           9


#ifdef __cplusplus
BOOL WINAPI MemAllocInit(UINT MemStart, UINT BlkSize);
LPVOID WINAPI AllocMem(DWORD ReqSize, UINT OwnerID=0);
int  WINAPI FreeMem(LPCVOID lpMem);
UINT WINAPI GetMemFree(UINT *lpLargestBlkSize=NULL, int *lpRslt=NULL, int *BlkQty=NULL);
#else
BOOL WINAPI MemAllocInit(UINT MemStart, UINT BlkSize);
LPVOID WINAPI AllocMem(DWORD ReqSize, UINT OwnerID);
int  WINAPI FreeMem(LPCVOID lpMem);
UINT WINAPI GetMemFree(UINT *lpLargestBlkSize, int *lpRslt, int *BlkQty);
#endif
VOID WINAPI DispMemBlock(BOOL DispBlkFg);


#ifdef __cplusplus
extern "C"
{
#endif
UINT WINAPI UMulDiv(UINT Multiplicand, UINT Multiplier, UINT Divisor);
BOOL WINAPI IsNumeric(int Cha);
BOOL WINAPI IsAscii(int Cha);
int WINAPI CatchAscii(int Cha);

#define GETMIN(A, B) ((A)<=(B) ? A:B)
#define GETMAX(A, B) ((A)>=(B) ? A:B)
int  WINAPI GetMin(int A, int B);
int  WINAPI GetMax(int A, int B);
int  WINAPI GetAbs(int A);
int  WINAPI GetDiff(int A, int B);
UINT WINAPI UGetDiff(UINT A, UINT B);
UINT WINAPI UGetMin(UINT A, UINT B);
UINT WINAPI UGetMax(UINT A, UINT B);
int  WINAPI Limit(int Value, int Min, int Max);
int  WINAPI DivRoundUp(int A, int B);
int  WINAPI UpCaseCha(int Cha);
LPCSTR WINAPI SkipSpace(LPCSTR Str);
VOID WINAPI DumpMem(LPCVOID lpMem, UINT ViewSize);
BYTE WINAPI GetXorChkSum(VOID *lpMem, UINT Size);
//int  WINAPI lstrlen(LPCSTR Str);
LPSTR WINAPI GetStrLast(LPSTR Str);
LPCSTR WINAPI GetToken(LPCSTR TokenList, int TokenNo);
VOID WINAPI AddCha(LPSTR Dest, int Cha);
VOID WINAPI CharUpper(LPSTR Str);
int  WINAPI CharLowerBuff(LPSTR Str, int Len);
LPSTR WINAPI lstrcpy(LPSTR Dest, LPCSTR Src);
LPSTR WINAPI lstrcpyn(LPSTR Dest, LPCSTR Src, UINT BuffSize);
int  WINAPI lstrcmpi(LPCSTR S1, LPCSTR S2);
//int  WINAPI CompMem(LPCVOID Mem1, LPCVOID Mem2, UINT CompBytes);
int  WINAPI CompMemI(LPCVOID Mem1, LPCVOID Mem2, UINT CompBytes);
int  WINAPI AtoIN(LPCSTR NumStr, int StrLen);
DWORD WINAPI AtoH(LPCSTR String, int *NonStrLoc);
DWORD WINAPI AtoHN(LPCSTR Str, int Len);
int  WINAPI CompMemStr(LPCSTR Src, LPCSTR Find);
int  WINAPI CompMemStrI(LPCSTR Src, LPCSTR Find);
BOOL WINAPI IsZeroMem(LPCVOID Mem, int ByteSize);
VOID WINAPI CleanupStr(LPSTR String);
int  WINAPI SearchMemByte(LPCVOID Mem, int MemSize, int FindByte);
int  WINAPI SearchCha(LPCSTR SourceStr, int SrchCha);
LPCSTR WINAPI NextWord(LPCSTR lp, int WordCnt);
LPCSTR WINAPI NextCommaWord(LPCSTR lp, int WordNo);
VOID WINAPI DelAllCha(LPSTR String, int DelCha);
VOID WINAPI DelCha(LPSTR String, int DelLoc);

VOID WINAPI Vsprintf(LPSTR DestBuff, LPCSTR FormatStr, va_list ArgList);
VOID Jsprintf(LPSTR DestBuff, LPCSTR FormStr, ...);
BOOL Jsscanf(LPCSTR SourceStr, LPCSTR FormatStr, ...);
VOID SysCtlDelay(DWORD Cnt);
int  WINAPI GetJ8ChkSum(LPCBYTE lpMem, UINT Size);

#ifdef __cplusplus
}
#endif



#ifdef __cplusplus              //c에서는 사용불가
int  WINAPI AtoI(LPCSTR NumStr, int *NextLoc=NULL);
#else
int  WINAPI AtoI(LPCSTR NumStr, int *NextLoc);
#endif  //__cplusplus


//STM32Cube_FW_F0_V1.4.0\Drivers\CMSIS\Include\core_cmFunc.h <- __disable_irq()
#ifdef USE_JOS
#include "JOS_CFG.H"
#else
#ifndef JOS_ENTER_CRITICAL
#define JOS_CRITICAL_VAR
#if defined(__CC_ARM) //KEIL
#define JOS_ENTER_CRITICAL      __disable_irq
#define JOS_EXIT_CRITICAL       __enable_irq
#elif defined(__GNUC__)
#define JOS_ENTER_CRITICAL()    __asm volatile ("cpsid i" : : : "memory")
#define JOS_EXIT_CRITICAL()     __asm volatile ("cpsie i" : : : "memory")
#endif
#endif //JOS_ENTER_CRITICAL
#endif //USE_JOS


UINT  WINAPI SetIntMask(UINT IntMask);          //이전 인터럽트 마스크 상태 리턴

int  WINAPI GetLastChar(LPCSTR Str);
VOID WINAPI StripQuoteSign(LPSTR Buff);
int   WINAPI SearchStr(LPCSTR SourceStr, LPCSTR SrchStr);
LPSTR WINAPI SeparatStr(LPSTR String, int SepCha);
LPSTR WINAPI SeparatStrStr(LPSTR Str, LPCSTR SepStr);
LPCSTR WINAPI CatchToken(LPCSTR Str, int SepCha, LPSTR Buff, int BuffLen);
#define CatchWord CatchToken
VOID  WINAPI SubStr(LPSTR Buff, int BuffSize, LPCSTR Src, int ReqLen);
BOOL  WINAPI GetUrlVarText(LPCSTR WebArgList, LPCSTR VarName, LPSTR DataBuff, int BuffSize);
int   WINAPI GetUrlVarInt(LPCSTR WebArgList, LPCSTR VarName);

VOID  WINAPI AddPortIfNoDef(LPSTR HostAdd, int ToAddPortNo, int DefPortNo);
LPSTR  WINAPI SeparateUrl(LPCSTR SrcUrl, LPSTR lpHostAdd, int *PortNo, int DefPortNo);
LPCSTR WINAPI SeparateUrlEx(LPCSTR SrcUrl, LPSTR lpHostAdd, int *PortNo, int DefPortNo);
DWORD WINAPI Hex2Int(LPCSTR StrBuff, int ChaQty);
int   WINAPI Check2byteCha(LPCSTR Str, int ChkLoc);

int   WINAPI GetMonthLastDay(int Year, int Month);
TDATE WINAPI GetTotalDays(int Year, int Month, int Day);
VOID  WINAPI CnvFromTotalDay(TDATE TotalDays, int *Year, int *Month, int *Day);
VOID  WINAPI SystemTimeToLocalTime(SYSTEMTIME *ST);
VOID  WINAPI DosFileTimeToSystemTime(UINT FatDate, UINT FatTime, SYSTEMTIME *ST);
LPSTR WINAPI MakeYMDHMS(LPSTR Buff, CONST SYSTEMTIME *ST);
BOOL  WINAPI GetAppCompileDate(SYSTEMTIME *ST);
BOOL  WINAPI GetAppCompileDateStr(LPSTR Buff);
JTIME WINAPI GetAppCompileDateTime(VOID);
BOOL  WINAPI AnalysisHttpTimeStr(LPCSTR TimeStr, SYSTEMTIME *ST);
LPSTR WINAPI Make10msTimeStr(LPSTR Buff, DWORD _10msTime, BOOL DetailFg);
int   WINAPI ChangeCha(LPSTR String, int from, int to);
LPCSTR WINAPI NextLine(LPCSTR SrcStr, int *LineLen);
LPCSTR WINAPI QueryStrOneLine(LPCSTR Str, int *lpLen);
BOOL  WINAPI IsExistLineII(LPCSTR Str, LPCSTR FindLine, LPSTR Buff, int BuffSize);


LPCSTR WINAPI CatchStrOneLine(LPCSTR SrcStr, LPSTR DestBuff, int BuffLen);
int  WINAPI GetIniStrInMem(LPCSTR SecName, LPCSTR VarName, LPSTR Buff, int BuffSize, LPCSTR IniMem);
int  WINAPI GetIniIntInMem(LPCSTR SecName, LPCSTR VarName, int DefValue, LPCSTR IniMem);
VOID WINAPI PutString(LPSTR *lplpStr, LPCSTR PutStr);
VOID WINAPI lstrcatn(LPSTR DestBuff, LPCSTR SrcBuff, int BuffSize);


int  WINAPI GetIniStr(LPCSTR szSection, LPCSTR szEntry, LPSTR szBuff, int BuffSize);
int  WINAPI GetIniStrEx(LPCSTR szSection, LPCSTR szEntry, LPSTR szBuff, int BuffSize, LPCSTR DefStr);
VOID WINAPI WriteIniStrN(LPCSTR Section, int EntryNo, LPCSTR Buff);
int  WINAPI GetIniInt(LPCSTR szSection, LPCSTR szEntry, int DefValue);
int  WINAPI GetIniStrN(LPCSTR Section, int EntryNo, LPSTR Buff, int BuffSize);
VOID WINAPI WriteIniStr(LPCSTR szSection, LPCSTR szEntry, LPCSTR szBuff);
VOID WINAPI WriteIniInt(LPCSTR szSection, LPCSTR szEntry, int Value);


int   WINAPI GetWeek(int Year, int Month, int Day);
INT32 WINAPI PackSecondExceptDate(CONST SYSTEMTIME *ST);
INT32 WINAPI PackMilliSecondExceptDate(CONST SYSTEMTIME *ST);
DWORD WINAPI SystemTimeToUnixTime(CONST SYSTEMTIME *ST);
JTIME WINAPI PackTotalSecond(CONST SYSTEMTIME *ST);
JTIME64 WINAPI JTimeToJTime64(JTIME JTime);
JTIME64 WINAPI PackTotalSecond64(CONST SYSTEMTIME *ST);
VOID  WINAPI UnpackTotalSecond(SYSTEMTIME *ST, JTIME JTime);
VOID  WINAPI UnpackTotalSecond64(SYSTEMTIME *ST, JTIME64 JTime);

VOID  WINAPI PokeW(LPPKVOID Ptr, UINT W);
VOID  WINAPI Poke(LPPKVOID Ptr, DWORD Dw);
VOID  WINAPI PokeBIW(LPPKVOID Ptr, UINT W);
VOID  WINAPI PokeBI(LPPKVOID Ptr, DWORD Dw);
DWORD WINAPI Peek(LPCPKVOID Ptr);
UINT  WINAPI PeekW(LPCPKVOID Ptr);
DWORD WINAPI PeekBI(LPCPKVOID Ptr);
UINT  WINAPI PeekBIW(LPCPKVOID Ptr);
DWORD WINAPI PeekCDAB(LPCPKVOID Ptr);
UINT  WINAPI SwapIndianW(UINT W);

VOID   WINAPI MakeHexStr(LPSTR Buff, LPCBYTE lpMem, int MemSize);
UINT   WINAPI htons(UINT W);
UINT   WINAPI UDiv(UINT Dividend, UINT Divisor, UINT *lpRemainder);
LPCSTR WINAPI ScanWord(LPCSTR Str, LPSTR Buff, int BuffLen);
LPCSTR WINAPI ScanInt(LPCSTR Str, int *lpValue);
int    WINAPI GetBitCnt(UINT Value);
DWORD  WINAPI CalculateCRC(LPCBYTE Buff, DWORD BuffSize, DWORD PreCRC);

VOID WINAPI EncryptDecrypt(LPBYTE Buff, int BuffSize, DWORD Crc, int Mode);
VOID WINAPI EncryptDecryptII(LPBYTE Buff, int BuffSize, DWORD Crc, int Mode);
//Mode인자
#define ED_ENCRYPT  0
#define ED_DECRYPT  1

int WINAPI FloatToInt(UINT Float, UINT Digit, UINT Max);
UINT WINAPI CalculateCrc16(LPCVOID Buff, UINT BuffSize, UINT Crc);
UINT WINAPI CalculateCrc16_8005(LPCVOID Buff, UINT BuffSize, UINT Crc);
VOID WINAPI InsCha(LPSTR SrcStr, int InsLoc, int Cha);
VOID WINAPI InsStr(LPSTR SrcStr, int InsLoc, LPCSTR ToInsStr);
int WINAPI BinSearchWord(CONST WORD *ArrayBase, UINT Elements, UINT SearchWord);
int WINAPI CompareUsingHysteresis(int State, int Value, int Target, int Tolerance);
VOID WINAPI ByteCopyMem(LPVOID Dest, LPCVOID Src, int CopyBytes);
DWORD WINAPI MyRand(DWORD InitData);
int WINAPI CalcAverageI16(INT16 *Buff, int MaxQty, int CurrValue);
DWORD WINAPI SqrtDw(DWORD Numb);
int   WINAPI MulDiv(int Multiplicand, int Multiplier, int Divisor);     //Startup_STM32F091xc.s
UINT  WINAPI UDivMod(UINT Dividend, UINT Divisor, UINT *lpRemain);
UINT64 WINAPI UDivMod64(UINT64 Dividend, UINT Divisor, UINT *lpRemain);

typedef struct _REMOVECHATTERING
    {
    BYTE RegularState;
    BYTE KeepTime;
    BYTE OldState;
    } REMOVECHATTERING;

BOOL WINAPI RemoveChattering(REMOVECHATTERING *RC, UINT CurrState, int KeepTime);

int  WINAPI DecodeBase64(LPCSTR InBuff, LPSTR OutBuff, int Inlen);
VOID WINAPI EncodeBase64(LPCSTR InBuff, int InDataLen, LPSTR OutBuff, int LineLen);
VOID WINAPI DecodeHexStr(LPBYTE OutBuff, LPCSTR InBuff, int Inlen);
VOID WINAPI EncodeHexStr(LPSTR OutBuff, LPCBYTE InBuff, int Inlen);
DWORD WINAPI SwapEndianDW(DWORD DwValue);
UINT  WINAPI SwapEndianW(UINT wValue);
int  WINAPI Bin2Bcd(int Value);
int  WINAPI Bcd2Bin(int Value);


typedef struct _STRING_HISTORY
    {
    DWORD EnteredTime;
    DWORD Crc;
    } STRING_HISTORY;


typedef struct _CHKDUPLICATEDSTRING
    {
    WORD HistoryQty;
    WORD LifeTime;
    STRING_HISTORY *SH;
    } CHKDUPLICATEDSTRING;


BOOL WINAPI IsDuplicatedString(CHKDUPLICATEDSTRING *CDS, LPCSTR Str, DWORD NowTime);






//-----------------------------------------------------------------------------
//      싱글 리스트를 정렬합니다
//
//      Key     : 정렬시작점, 하나 정렬후 다음으로 이동 FKey: Key의 앞노드
//      Search  : Key 다음부터 끝까지를 따라감  FSearch   : Search의 앞노드
//      Smallest: 가장 작은 노드                FSmallest : Smallest의 앞노드
//-----------------------------------------------------------------------------
#define SINGLELISTSORT(Type, List, CompareFnc)                                  \
    {                                                                           \
    Type *Key, *FKey, *Smallest, *FSmallest, *Search, *FSearch;                 \
                                                                                \
    Key=List;                                                                   \
    while (Key!=NULL)                                                           \
        {                                                                       \
        /*(1)가장 작은 것을 찾음*/                                              \
        Smallest=FSearch=Key; Search=Key->Next;                                 \
        while (Search!=NULL)                                                    \
            {                                                                   \
            if (CompareFnc(Search, Smallest)<0) {FSmallest=FSearch; Smallest=Search;} \
            FSearch=Search; Search=Search->Next;                                \
            }                                                                   \
                                                                                \
        /*(2)찾은 가장 작은 것을 맨앞에 놓음 찾음*/                             \
        if (Key==Smallest) {FKey=Key; Key=Key->Next;}   /*이미 정렬된 경우 다음으로 이동*/ \
        else{                                                                              \
            FSmallest->Next=Smallest->Next;             /*가장작은것을 떼어냄*/            \
            Smallest->Next=Key;                         /*가장작은것을 키의 앞에 놓음*/    \
            if (Key==List) List=Smallest; else FKey->Next=Smallest;             \
            FKey=Smallest;                                                      \
            }                                                                   \
        }                                                                       \
    }



//-----------------------------------------------------------------------------
//      싱글 리스트를 정렬합니다 (Next멤버를 임의로 줌)
//
//      Key     : 정렬시작점, 하나 정렬후 다음으로 이동 FKey: Key의 앞노드
//      Search  : Key 다음부터 끝까지를 따라감  FSearch   : Search의 앞노드
//      Smallest: 가장 작은 노드                FSmallest : Smallest의 앞노드
//-----------------------------------------------------------------------------
#define SINGLELISTSORTII(Type, List, Next, CompareFnc)                                  \
    {                                                                           \
    Type *Key, *FKey, *Smallest, *FSmallest, *Search, *FSearch;                 \
                                                                                \
    Key=List;                                                                   \
    while (Key!=NULL)                                                           \
        {                                                                       \
        /*(1)가장 작은 것을 찾음*/                                              \
        Smallest=FSearch=Key; Search=Key->Next;                                 \
        while (Search!=NULL)                                                    \
            {                                                                   \
            if (CompareFnc(Search, Smallest)<0) {FSmallest=FSearch; Smallest=Search;} \
            FSearch=Search; Search=Search->Next;                                \
            }                                                                   \
                                                                                \
        /*(2)찾은 가장 작은 것을 맨앞에 놓음 찾음*/                             \
        if (Key==Smallest) {FKey=Key; Key=Key->Next;}   /*이미 정렬된 경우 다음으로 이동*/ \
        else{                                                                              \
            FSmallest->Next=Smallest->Next;             /*가장작은것을 떼어냄*/            \
            Smallest->Next=Key;                         /*가장작은것을 키의 앞에 놓음*/    \
            if (Key==List) List=Smallest; else FKey->Next=Smallest;             \
            FKey=Smallest;                                                      \
            }                                                                   \
        }                                                                       \
    }



//-----------------------------------------------------------------------------
//      싱글 리스트를 추가합니다 (맨뒤에)
//-----------------------------------------------------------------------------
#define ADDSINGLELINKEDLIST(Struct, Root, New)          \
    {                                                   \
    Struct *Tmp;                                        \
    if ((Tmp=Root)==NULL) Root=New;                     \
    else{                                               \
        while (Tmp->Next!=NULL) Tmp=Tmp->Next;          \
        Tmp->Next=New;                                  \
        }                                               \
    }


//NoJLib
//-----------------------------------------------------------------------------
//      싱글 리스트를 추가합니다 (맨앞에)
//-----------------------------------------------------------------------------
#define ADDSINGLELINKEDLISTFRONT(Root, New) {New->Next=Root; Root=New;}



//-----------------------------------------------------------------------------
//      싱글 리스트를 하나를 제거합니다
//-----------------------------------------------------------------------------
#define DELSINGLELINKEDLIST(Struct, Root, Del)          \
    {                                                   \
    Struct *p, *Par=NULL;                               \
    for (p=Root; p!=NULL; p=p->Next)                    \
        {                                               \
        if (p==Del)                                     \
            {                                           \
            p=p->Next;                                  \
            if (Par==NULL) Root=p; else Par->Next=p;    \
            FreeMem(Del);                              \
            break;                                      \
            }                                           \
        Par=p;                                          \
        }                                               \
    }



//-----------------------------------------------------------------------------
//      싱글 리스트를 모두 제거합니다
//-----------------------------------------------------------------------------
#define RELEASESINGLELINKEDLIST(Struct, Root)           \
    while (Root!=NULL)                                  \
        {                                               \
        Struct *Tmp;                                    \
        Tmp=Root; Root=Root->Next;                      \
        FreeMem(Tmp);                                  \
        }



//-----------------------------------------------------------------------------
//      싱글 리스트에서 하나의 링크를 지웁니다
//      Del은 다음위치를 가리켜야 합니다
//-----------------------------------------------------------------------------
#define DELSINGLELINK(Struct, Root, Par, Del)           \
    {                                                   \
    Struct *Tmp;                                        \
    Tmp=Del;                                            \
    Del=Del->Next;                                      \
    if (Par==NULL) Root=Del; else Par->Next=Del;        \
    FreeMem(Tmp);                                      \
    }



//-----------------------------------------------------------------------------
//      싱글리스트에서 주어진노드의 Prev노드를 줍니다
//-----------------------------------------------------------------------------
#define GETPREVNODE(Struct, Root, Curr, Prev)           \
    {                                                   \
    Struct *p;                                          \
    Prev=NULL;                                          \
    if (Root!=Curr)                                     \
        for (p=Root; p!=NULL; p=p->Next)                \
            {                                           \
            if (p->Next==Curr) {Prev=p; break;}         \
            }                                           \
    }




#endif // __JLIB_H__

