//-----------------------------------------------------------------------------
//                      JOS - RTOS
//-----------------------------------------------------------------------------

#ifndef __JOS_H__
#define __JOS_H__


#define UART_RECV_BUFF_SIZE     400
#define UART_SEND_BUFF_SIZE     200


typedef int             JOS_RESULT;
#define JOS_TICKS_PER_SEC       100     //ʴ Ÿƽ  (층 )



//-----------------------------------------------------------------------------
//              ̺Ʈ 
//-----------------------------------------------------------------------------
#define  JOS_EVENT_TYPE_UNUSED  0
#define  JOS_EVENT_TYPE_Q       2
#define  JOS_EVENT_TYPE_SEM     3
#define  JOS_TMR_TYPE           100



//-----------------------------------------------------------------------------
//      JOS???Pend() ɼ 
//-----------------------------------------------------------------------------
#define  JOS_PEND_OPT_NONE      0
#define  JOS_PEND_OPT_BROADCAST 1



//-----------------------------------------------------------------------------
//      JOS???PostOpt() ɼ
//-----------------------------------------------------------------------------
#define  JOS_PJOST_OPT_NONE             0x00
#define  JOS_PJOST_OPT_BROADCAST        0x01
#define  JOS_PJOST_OPT_FRONT            0x02
#define  JOS_PJOST_OPT_NO_SCHED         0x04


//-----------------------------------------------------------------------------
//      ڵ
//-----------------------------------------------------------------------------
#define JOS_ERR_NONE                    0
#define JOS_ERR_NouseInISR              1
#define JOS_ERR_InsufficientMem         2
#define JOS_ERR_InvalidArg              3
#define JOS_ERR_INVALID_OPT             4
#define JOS_ERR_TIMEOUT                 5
#define JOS_ERR_PEND_LOCKED             6
#define JOS_ERR_PEND_ABORT              7
#define JOS_ERR_Q_FULL                  8
#define JOS_ERR_PRIO_EXIST              10
#define JOS_ERR_PRIO                    11

#define JOS_ERR_SEM_OVF                 20

#define JOS_ERR_TIME_NOT_DLY            40
#define JOS_ERR_TIME_ZERO_DLY           41

#define JOS_ERR_TMR_INVALID_PERIOD      42
#define JOS_ERR_TMR_INVALID_OPT         43
#define JOS_ERR_TMR_INVALID_TYPE        44
#define JOS_ERR_TMR_INVALID_STATE       45
#define JOS_ERR_TMR_STOPPED             46
#define JOS_ERR_TMR_NO_CALLBACK         47




//-----------------------------------------------------------------------------
//      ̺Ʈ ü
//-----------------------------------------------------------------------------
typedef struct _JOS_EVENT
    {
    BYTE   JOSEventType;                //̺Ʈ , , ؽ...
    UINT   JOSEventCnt;                 //, ؽ Ÿũ켱
    LPVOID JOSEventPtr;                 //̺Ʈ ŸԿ  ٸ, ޼, Ǵ ޼ť, ؽTCB
    #if JOS_EVENT_NAME_SIZE>1
    CHAR   JOSEventName[JOS_EVENT_NAME_SIZE];
    #endif
    } JOS_EVENT;


//Pend Time Ư
#define INFINITE        0
#define CHECKACCEPT     ((UINT)-1)

//-----------------------------------------------------------------------------
//      ޼ ť  ü
//-----------------------------------------------------------------------------
typedef struct _JOS_Q_ENTRY_B
    {
    LPBYTE JOSQStart;
    LPBYTE JOSQEnd;
    LPBYTE JOSQIn;
    LPBYTE JOSQOut;
    }JOS_Q_ENTRY_B;

typedef struct _JOS_Q_ENTRY_W
    {
    WORD *JOSQStart;
    WORD *JOSQEnd;
    WORD *JOSQIn;
    WORD *JOSQOut;
    } JOS_Q_ENTRY_W;

typedef struct _JOS_Q_ENTRY_D
    {
    DWORD *JOSQStart;
    DWORD *JOSQEnd;
    DWORD *JOSQIn;
    DWORD *JOSQOut;
    } JOS_Q_ENTRY_D;


typedef struct _JOS_Q
    {
    union
        {
        JOS_Q_ENTRY_B B;
        JOS_Q_ENTRY_W W;
        JOS_Q_ENTRY_D D;
        } Entry;
    UINT JOSQSize;
    UINT JOSQEntries;
    BYTE JOSQType;
    } JOS_Q;


//JOSQType
#define JOSQTYPE_BYTE   1
#define JOSQTYPE_WORD   2
#define JOSQTYPE_DWORD  4



JOS_EVENT* WINAPI JOSQCreate(UINT EntryQty, UINT QType);
JOS_RESULT WINAPI JOSQPost(JOS_EVENT *lpEv, DWORD Msg, UINT Opt);
DWORD WINAPI JOSQPend(JOS_EVENT *lpEv, UINT Timeout, JOS_RESULT *lpRslt);
int WINAPI JOSQEntries(JOS_EVENT *lpEv);




//-----------------------------------------------------------------------------
//              
//-----------------------------------------------------------------------------
JOS_EVENT* WINAPI JOSSemCreate(UINT Cnt);
JOS_RESULT WINAPI JOSSemPend(JOS_EVENT *lpEv, UINT Timeout);
JOS_RESULT WINAPI JOSSemPost(JOS_EVENT *lpEv);



//-----------------------------------------------------------------------------
//              Ÿ
//-----------------------------------------------------------------------------
VOID WINAPI JOSTimeDly(DWORD Ticks);
#define JOSInit()
#define Sleep       HAL_Delay
#define JOSIntEnterII()
#define JOSIntExitII()
extern volatile DWORD FineTickCnt;      //Ÿũ  ϱ 

DWORD WINAPI GetLastError(VOID);
VOID  WINAPI SetLastError(DWORD ErrCode);


UINT WINAPI GetSP(VOID);                //  Լ
BOOL WINAPI TestChangeReg(UINT Cnt);    //JOS   Լ



VOID WINAPI JOSIntEnter(LPVOID CtxPtr);
LPVOID WINAPI JOSIntExit(LPVOID Ctx);
LPVOID WINAPI JOSTaskSwitching(LPVOID OldCtx);

#endif //__JOS_H__

