///////////////////////////////////////////////////////////////////////////////
//                         JOS - RTOS
//
// ھ ARM Thumb 忡 ̳ʸ 7Kbyte 
//
// Cortex-M0  
// ----------------
//Before Program Size: Code=24060 RO-data=616 RW-data=664 ZI-data=15040
//After  Program Size: Code=26792 RO-data=616 RW-data=984 ZI-data=23104
///////////////////////////////////////////////////////////////////////////////


#include "JLIB.H"
#include "MAIN.H"
#include "JOS.H"

#define MEMOWNER_JOSQCreate             (MEMOWNER_JOS+1)
#define MEMOWNER_JOSQCreateQ            (MEMOWNER_JOS+2)
#define MEMOWNER_JOSQCreateQEntry       (MEMOWNER_JOS+3)
#define MEMOWNER_JOSSemCreate           (MEMOWNER_JOS+4)
#define MEMOWNER_JOS_TCBInit            (MEMOWNER_JOS+5)
#define MEMOWNER_JOSTaskCreateExt       (MEMOWNER_JOS+6)
#define MEMOWNER_JOSTmrCreate           (MEMOWNER_JOS+7)



///////////////////////////////////////////////////////////////////////////////
//                                  JOS_Q
///////////////////////////////////////////////////////////////////////////////



//-----------------------------------------------------------------------------
//      Q Ʈ 
//-----------------------------------------------------------------------------
JOS_EVENT* WINAPI JOSQCreate(UINT EntryQty, UINT QType)
    {
    int Size;
    JOS_EVENT  *lpEv=NULL;
    JOS_Q      *lpQ;

    if ((lpEv=AllocMemS(JOS_EVENT, MEMOWNER_JOSQCreate))!=NULL)
        {
        ZeroMem(lpEv, sizeof(JOS_EVENT));
        if ((lpQ=AllocMemS(JOS_Q, MEMOWNER_JOSQCreateQ))!=NULL)
            {
            if ((lpQ->Entry.B.JOSQStart=(LPBYTE)AllocMem(Size=EntryQty*QType, MEMOWNER_JOSQCreateQEntry))==NULL) {FreeMem(lpQ); goto FreeAndExit;}
            lpQ->Entry.B.JOSQEnd=lpQ->Entry.B.JOSQStart+Size;
            lpQ->Entry.B.JOSQIn=lpQ->Entry.B.JOSQOut=lpQ->Entry.B.JOSQStart;
            lpQ->JOSQSize=EntryQty;
            lpQ->JOSQEntries=0;
            lpQ->JOSQType=QType;

            lpEv->JOSEventType=JOS_EVENT_TYPE_Q;
            //lpEv->JOSEventCnt=0;
            lpEv->JOSEventPtr=lpQ;
            #if JOS_EVENT_NAME_SIZE>1
            lpEv->JOSEventName[0]='?';
            //lpEv->JOSEventName[1]=0;
            #endif
            //JOS_EventWaitListInit(lpEv);      // ZeroMem() ó
            }
        else{
            FreeAndExit:
            FreeMem(lpEv);
            lpEv=NULL;
            }
        }
    return lpEv;
    }



//-----------------------------------------------------------------------------
//      Q Data  ְ  
//      Timeout==INFINITE(0) ̸  
//      Timeout==CHECKACCEPT(-1)  ָ JOSQAccept()  ͷƮ ȣ ϰ
//      ȣ  JOS_ERR_NONE  JOS_ERR_TIMEOUT 
//-----------------------------------------------------------------------------
DWORD WINAPI JOSQPend(JOS_EVENT *lpEv, UINT Timeout, JOS_RESULT *lpRslt)
    {
    JOS_CRITICAL_VAR
    JOS_RESULT Rslt;
    JOS_Q      *lpQ;
    DWORD    Msg=0;

    JOS_ENTER_CRITICAL();
    lpQ=(JOS_Q*)lpEv->JOSEventPtr;
    if (lpQ->JOSQEntries>0)     //Q ִ 
        {
        switch (lpQ->JOSQType)
            {
            case JOSQTYPE_BYTE: Msg=*lpQ->Entry.B.JOSQOut++; break;
            case JOSQTYPE_WORD: Msg=*lpQ->Entry.W.JOSQOut++; break;
            case JOSQTYPE_DWORD: Msg=*lpQ->Entry.D.JOSQOut++; //break;
            }
        lpQ->JOSQEntries--;
        if (lpQ->Entry.B.JOSQOut==lpQ->Entry.B.JOSQEnd) lpQ->Entry.B.JOSQOut=lpQ->Entry.B.JOSQStart;
        JOS_EXIT_CRITICAL();
        Rslt=JOS_ERR_NONE;
        goto ProcExit;
        }

    JOS_EXIT_CRITICAL();
    Msg=0;
    Rslt=JOS_ERR_TIMEOUT;

    ProcExit:
    if (lpRslt) *lpRslt=Rslt;
    return Msg;
    }



//-----------------------------------------------------------------------------
//      ޼ Q 
//      ־ ̺Ʈ   Ÿũ  ٷ 
//-----------------------------------------------------------------------------
JOS_RESULT WINAPI JOSQPost(JOS_EVENT *lpEv, DWORD Msg, UINT Opt)
    {
    JOS_CRITICAL_VAR
    BYTE Rslt;
    JOS_Q *lpQ;

    if (lpEv->JOSEventType!=JOS_EVENT_TYPE_Q) {Rslt=JOS_ERR_InvalidArg; goto ProcExit;}

    JOS_ENTER_CRITICAL();

    lpQ=(JOS_Q*)lpEv->JOSEventPtr;
    if (lpQ->JOSQEntries>=lpQ->JOSQSize)
        {
        JOS_EXIT_CRITICAL();
        Rslt=JOS_ERR_Q_FULL; //Q 
        goto ProcExit;
        }

    if ((Opt & JOS_PJOST_OPT_FRONT)!=0)
        {       // տ 
        if (lpQ->Entry.B.JOSQOut==lpQ->Entry.B.JOSQStart) lpQ->Entry.B.JOSQOut=lpQ->Entry.B.JOSQEnd;
        switch (lpQ->JOSQType)
            {
            case JOSQTYPE_BYTE: lpQ->Entry.B.JOSQOut--; *lpQ->Entry.B.JOSQOut=Msg; break;
            case JOSQTYPE_WORD: lpQ->Entry.W.JOSQOut--; *lpQ->Entry.W.JOSQOut=Msg; break;
            case JOSQTYPE_DWORD: lpQ->Entry.D.JOSQOut--; *lpQ->Entry.D.JOSQOut=Msg; //break;
            }
        }
    else{       //ǵڿ 
        switch (lpQ->JOSQType)
            {
            case JOSQTYPE_BYTE: *lpQ->Entry.B.JOSQIn++=Msg; break;
            case JOSQTYPE_WORD: *lpQ->Entry.W.JOSQIn++=Msg; break;
            case JOSQTYPE_DWORD: *lpQ->Entry.D.JOSQIn++=Msg; //break;
            }
        if (lpQ->Entry.B.JOSQIn==lpQ->Entry.B.JOSQEnd) lpQ->Entry.B.JOSQIn=lpQ->Entry.B.JOSQStart;
        }
    lpQ->JOSQEntries++;
    JOS_EXIT_CRITICAL();
    Rslt=JOS_ERR_NONE;

    ProcExit:
    return Rslt;
    }



//-----------------------------------------------------------------------------
//      ޼Q ȿ   
//-----------------------------------------------------------------------------
int WINAPI JOSQEntries(JOS_EVENT *lpEv)
    {
    return ((JOS_Q*)lpEv->JOSEventPtr)->JOSQEntries;
    }




///////////////////////////////////////////////////////////////////////////////
//                                  JOS_SEM
///////////////////////////////////////////////////////////////////////////////


//-----------------------------------------------------------------------------
//       Ʈ 
//-----------------------------------------------------------------------------
JOS_EVENT* WINAPI JOSSemCreate(UINT Cnt)
    {
    JOS_EVENT  *lpEv=NULL;

    if ((lpEv=AllocMemS(JOS_EVENT, MEMOWNER_JOSSemCreate))!=NULL)
        {
        ZeroMem(lpEv, sizeof(JOS_EVENT));
        lpEv->JOSEventType=JOS_EVENT_TYPE_SEM;
        lpEv->JOSEventCnt=Cnt;
        lpEv->JOSEventPtr=NULL;
        #if JOS_EVENT_NAME_SIZE>1
        lpEv->JOSEventName[0]='?';
        //lpEv->JOSEventName[1]=0;
        #endif
        //JOS_EventWaitListInit(lpEv);          // ZeroMem() ó
        }
    return lpEv;
    }



//-----------------------------------------------------------------------------
//      ־  ȣ ִ   
//-----------------------------------------------------------------------------
JOS_RESULT WINAPI JOSSemPend(JOS_EVENT *lpEv, UINT Timeout)
    {
    return JOS_ERR_NONE;
    }



//-----------------------------------------------------------------------------
//       ȣ 
//      ־   Ÿũ  ٷ 
//-----------------------------------------------------------------------------
JOS_RESULT WINAPI JOSSemPost(JOS_EVENT *lpEv)
    {
    return JOS_ERR_NONE;
    }




//-----------------------------------------------------------------------------
//      ־ ƽ ŭ Ÿũ Ŵ
//-----------------------------------------------------------------------------
VOID WINAPI JOSTimeDly(DWORD Ticks)
    {
    if (Ticks>0)
        {
        DWORD Tick=FineTickCnt;
        Ticks*=10;
        while (FineTickCnt-Tick<Ticks);
        }
    }


VOID WINAPI JOSIntEnter(LPVOID CtxPtr) {}
LPVOID WINAPI JOSIntExit(LPVOID Ctx) {return Ctx;}
LPVOID WINAPI JOSTaskSwitching(LPVOID OldCtx) {return OldCtx;}


